/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.registry;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.registry.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;

public enum LinuxStyle {
    UNKNOWN(Messages.LinuxStyles_unknown, 100, 100, 100, 255, 0.33f),
    WAIT_UNKNOWN(Messages.LinuxStyles_wait, 200, 200, 200, 255, 0.5f),
    WAIT_BLOCKED(Messages.LinuxStyles_waitBlocked, 200, 200, 0, 255, 0.5f),
    WAIT_FOR_CPU(Messages.LinuxStyles_waitForCPU, 200, 100, 0, 255, 0.5f),
    IDLE(Messages.LinuxStyles_idle, 200, 200, 200, 255, 0.66f),
    USERMODE(Messages.LinuxStyles_usermode, 0, 200, 0, 255, 1.0f),
    SYSCALL(Messages.LinuxStyles_systemCall, 0, 0, 200, 255, 1.0f),
    INTERRUPTED(Messages.LinuxStyles_Interrupt, 200, 0, 100, 255, 0.75f),
    SOFT_IRQ_RAISED(Messages.LinuxStyles_softIrqRaised, 200, 200, 0, 255, 1.0f),
    SOFT_IRQ(Messages.LinuxStyles_softrq, 200, 150, 100, 255, 1.0f);

    private final Map<String, Object> fMap;

    private LinuxStyle(String label, int red, int green, int blue, int alpha, float heightFactor) {
        if (label == null) {
            throw new IllegalArgumentException("Label cannot be null");
        }
        if (red > 255 || red < 0) {
            throw new IllegalArgumentException("Red needs to be between 0 and 255");
        }
        if (green > 255 || green < 0) {
            throw new IllegalArgumentException("Green needs to be between 0 and 255");
        }
        if (blue > 255 || blue < 0) {
            throw new IllegalArgumentException("Blue needs to be between 0 and 255");
        }
        if (alpha > 255 || alpha < 0) {
            throw new IllegalArgumentException("alpha needs to be between 0 and 255");
        }
        if ((double)heightFactor > 1.0 || heightFactor < 0.0f) {
            throw new IllegalArgumentException("Height factor needs to be between 0 and 1.0, given hint : " + heightFactor);
        }
        this.fMap = ImmutableMap.of((Object)ITimeEventStyleStrings.label(), (Object)label, (Object)ITimeEventStyleStrings.fillStyle(), (Object)ITimeEventStyleStrings.solidColorFillStyle(), (Object)ITimeEventStyleStrings.fillColor(), (Object)(red << 24 | green << 16 | blue << 8 | alpha), (Object)ITimeEventStyleStrings.heightFactor(), (Object)Float.valueOf(heightFactor));
    }

    public String getLabel() {
        return (String)this.fMap.get(ITimeEventStyleStrings.label());
    }

    public Map<String, Object> toMap() {
        return this.fMap;
    }
}

