/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.component.ITmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;

public interface ITmfTrace
extends ITmfEventProvider {
    public static final int DEFAULT_TRACE_CACHE_SIZE = 1000;

    public void initTrace(IResource var1, String var2, Class<? extends ITmfEvent> var3) throws TmfTraceException;

    public void initTrace(IResource var1, String var2, Class<? extends ITmfEvent> var3, String var4, String var5) throws TmfTraceException;

    public IStatus validate(IProject var1, String var2);

    public IResource getResource();

    public @Nullable String getTraceTypeId();

    public String getPath();

    public int getCacheSize();

    public void indexTrace(boolean var1);

    public @Nullable IAnalysisModule getAnalysisModule(String var1);

    public @NonNull Iterable<@NonNull IAnalysisModule> getAnalysisModules();

    public @NonNull Iterable<@NonNull ITmfEventAspect<?>> getEventAspects();

    public long getNbEvents();

    public @NonNull TmfTimeRange getTimeRange();

    public @NonNull ITmfTimestamp getStartTime();

    public @NonNull ITmfTimestamp getEndTime();

    public long getStreamingInterval();

    public ITmfLocation getCurrentLocation();

    public double getLocationRatio(ITmfLocation var1);

    public ITmfContext seekEvent(ITmfLocation var1);

    public ITmfContext seekEvent(long var1);

    public ITmfContext seekEvent(ITmfTimestamp var1);

    public ITmfContext seekEvent(double var1);

    public ITmfTimestamp getInitialRangeOffset();

    public @NonNull String getHostId();

    public ITmfTimestampTransform getTimestampTransform();

    public void setTimestampTransform(ITmfTimestampTransform var1);

    public @NonNull ITmfTimestamp createTimestamp(long var1);

    default public @NonNull TmfTraceContext createTraceContext(@NonNull TmfTimeRange selection, @NonNull TmfTimeRange windowRange, @Nullable IFile editorFile, @Nullable ITmfFilter filter) {
        return new TmfTraceContext(selection, windowRange, editorFile, filter);
    }

    default public ITmfTimestamp readStart() {
        ITmfContext context = this.seekEvent(0L);
        ITmfEvent event = this.getNext(context);
        context.dispose();
        return event != null ? event.getTimestamp() : null;
    }

    default public ITmfTimestamp readEnd() {
        this.indexTrace(true);
        return this.getNbEvents() != 0L ? this.getEndTime() : null;
    }

    default public @Nullable UUID getUUID() {
        StringBuilder sb = new StringBuilder();
        File file = new File(this.getPath());
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                sb.append(childFile.getName());
                sb.append(childFile.length());
                sb.append(childFile.lastModified());
                ++n2;
            }
        } else if (file.exists()) {
            sb.append(file.getName());
            sb.append(file.length());
            sb.append(file.lastModified());
        }
        for (ITmfEventProvider child : this.getChildren()) {
            if (!(child instanceof ITmfTrace)) continue;
            sb.append(String.valueOf(((ITmfTrace)child).getUUID()));
        }
        return UUID.nameUUIDFromBytes(Objects.requireNonNull(sb.toString().getBytes(Charset.defaultCharset())));
    }
}

