/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.SelectTracesOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.TmfWorkspaceModifyOperation;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTracesFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenAsExperimentHandler
extends AbstractHandler {
    private static final String TYPE_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.type";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStatus status;
        TmfExperimentElement experimentElement;
        String experimentType = event.getParameter(TYPE_PARAMETER);
        final TraceTypeHelper traceTypeHelper = TmfTraceType.getTraceType((String)experimentType);
        if (traceTypeHelper == null) {
            return null;
        }
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        String experimentName = Messages.OpenAsExperimentHandler_DefaultExperimentName;
        final HashSet<@NonNull TmfTraceElement> traces = new HashSet<TmfTraceElement>();
        TmfProjectElement project = null;
        for (Object element : selection.toList()) {
            if (element instanceof TmfTracesFolder) {
                TmfTracesFolder tracesFolder = (TmfTracesFolder)element;
                traces.addAll(tracesFolder.getTraces());
                project = tracesFolder.getProject();
                continue;
            }
            if (element instanceof TmfTraceFolder) {
                TmfTraceFolder traceFolder = (TmfTraceFolder)element;
                traces.addAll(traceFolder.getTraces());
                project = traceFolder.getProject();
                if (selection.size() != 1) continue;
                experimentName = traceFolder.getName();
                continue;
            }
            if (!(element instanceof TmfTraceElement)) continue;
            TmfTraceElement traceElement = (TmfTraceElement)element;
            traces.add(traceElement);
            project = traceElement.getProject();
            if (selection.size() != 1) continue;
            experimentName = traceElement.getName();
        }
        if (project == null) {
            return null;
        }
        TmfExperimentFolder experimentsFolder = project.getExperimentsFolder();
        if (experimentsFolder == null) {
            return null;
        }
        final IFolder experimentFolder = OpenAsExperimentHandler.getExperimentFolder(experimentName, experimentsFolder, traces);
        final boolean exists = experimentFolder.exists();
        if (!exists) {
            try {
                experimentFolder.create(false, true, null);
            }
            catch (CoreException e) {
                TraceUtils.displayErrorMsg(e.toString(), e.toString());
                return null;
            }
        }
        if ((experimentElement = experimentsFolder.getExperiment((IResource)experimentFolder)) == null) {
            return null;
        }
        if (!exists) {
            TmfWorkspaceModifyOperation operation = new TmfWorkspaceModifyOperation(){

                @Override
                public void execute(IProgressMonitor monitor) throws CoreException {
                    SelectTracesOperation selectTracesOperation = new SelectTracesOperation(experimentElement, traces.toArray(new TmfTraceElement[traces.size()]), Collections.EMPTY_MAP);
                    selectTracesOperation.run(monitor);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                TraceUtils.displayErrorMsg(e.toString(), e.getTargetException().toString());
                return null;
            }
        }
        if (!(status = traceTypeHelper.validate(experimentFolder.getLocation().toOSString())).isOK()) {
            TraceUtils.displayErrorMsg(Messages.OpenAsExperimentHandler_ValidationErrorTitle, NLS.bind((String)Messages.OpenAsExperimentHandler_ValidationErrorMessage, (Object)status.getMessage()));
            return null;
        }
        if (!exists || !experimentElement.getTraceType().equals(traceTypeHelper.getTraceTypeId())) {
            if (exists) {
                experimentElement.closeEditors();
            }
            TmfWorkspaceModifyOperation operation = new TmfWorkspaceModifyOperation(){

                @Override
                public void execute(IProgressMonitor monitor) throws CoreException {
                    if (exists) {
                        experimentElement.deleteSupplementaryResources();
                    }
                    TmfTraceTypeUIUtils.setTraceType((IResource)experimentFolder, traceTypeHelper, false);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                TraceUtils.displayErrorMsg(e.toString(), e.getTargetException().toString());
                return null;
            }
        }
        TmfOpenTraceHelper.openTraceFromElement(experimentElement);
        return null;
    }

    private static IFolder getExperimentFolder(String experimentName, TmfExperimentFolder experimentsFolder, Set<@NonNull TmfTraceElement> traces) {
        IFolder folder = experimentsFolder.getResource().getFolder(experimentName);
        int i = 2;
        while (folder.exists()) {
            TmfExperimentElement experimentElement = experimentsFolder.getExperiment((IResource)folder);
            if (experimentElement != null) {
                HashSet<TmfTraceElement> existingTraces = new HashSet<TmfTraceElement>();
                for (TmfTraceElement trace : experimentElement.getTraces()) {
                    existingTraces.add(trace.getElementUnderTraceFolder());
                }
                if (existingTraces.equals(traces)) {
                    return folder;
                }
            }
            folder = experimentsFolder.getResource().getFolder(String.valueOf(experimentName) + '(' + Integer.toString(i++) + ')');
        }
        return folder;
    }
}

