/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IMessageBody;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPReader;
import org.eclipse.actf.util.internal.httpproxy.core.HeaderInBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.MessageBody;

public abstract class HTTPMessageReader
extends HTTPReader {
    private static final Logger LOGGER = Logger.getLogger(HTTPMessageReader.class);

    protected HTTPMessageReader(InputStream inputStream) {
        super(inputStream);
    }

    protected abstract void readFirstLine(HTTPMessage var1, long var2) throws IOException, TimeoutException;

    protected void processHeader(HTTPMessage hTTPMessage, IHTTPHeader iHTTPHeader) {
    }

    public void readMessage(HTTPMessage hTTPMessage, boolean bl) throws IOException {
        try {
            this.readMessage(hTTPMessage, 0L, bl);
        }
        catch (TimeoutException timeoutException) {
            LOGGER.fatal("Impossible exception", timeoutException);
            System.exit(1);
        }
    }

    public boolean readMessage(HTTPMessage hTTPMessage, long l, boolean bl) throws IOException, TimeoutException {
        Object object;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("read: isBodyEmpty=" + bl);
        }
        this.readFirstLine(hTTPMessage, l);
        int n = -1;
        while (this.fLastByte >= 0) {
            String string;
            object = this.readHeader(l, hTTPMessage.getBuffer());
            if (object == null) break;
            hTTPMessage.addHeader((HeaderInBuffer)object);
            if (LOGGER.isDebugEnabled()) {
                string = new String(((HeaderInBuffer)object).getName());
                String string2 = new String(((HeaderInBuffer)object).getValue());
                LOGGER.debug(String.valueOf(string) + ": " + string2);
            }
            if (((HeaderInBuffer)object).isFieldNameEqualsTo(IHTTPHeader.CONTENT_LENGTH_A)) {
                string = new String(((HeaderInBuffer)object).getValue());
                if (string.length() > 0) {
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warning("Illegal header fieald (CONTENT_LENGTH) ignored: " + string);
                    }
                }
            } else if (((HeaderInBuffer)object).isFieldNameEqualsTo(IHTTPHeader.TRANSFER_ENCODING_A) && ((HeaderInBuffer)object).isFieldValueEqualsTo(IHTTPHeader.CHUNKED_A)) {
                hTTPMessage.setChunkedEncoding(true);
            }
            this.processHeader(hTTPMessage, (IHTTPHeader)object);
        }
        if (bl |= hTTPMessage.isBodyEmpty()) {
            LOGGER.debug("The message body is empty.");
        } else {
            object = hTTPMessage.isChunkedEncoding() ? new MessageBody(this.getInputStream()) : new MessageBody(this.getInputStream(), n);
            hTTPMessage.setOriginalMessageBody((IMessageBody)object);
        }
        return true;
    }
}

