/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.impl.DataModelAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.AppContextPopulator;
import org.eclipse.birt.report.designer.data.ui.dataset.AppContextResourceReleaser;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetPreviewer;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.DummyEngineTask;
import org.eclipse.birt.report.designer.data.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportEngineFactory;
import org.eclipse.birt.report.engine.api.impl.ReportEngineHelper;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;

public class DistinctValueSelector {
    private DistinctValueSelector() {
    }

    public static List getSelectValueList(Expression expression, DataSetHandle dataSetHandle, boolean useDataSetFilter) throws BirtException {
        return DistinctValueSelector.getSelectValueList1(expression, dataSetHandle.getRoot(), dataSetHandle, useDataSetFilter);
    }

    private static List getSelectValueList1(Expression expression, ModuleHandle moduleHandle, DataSetHandle dataSetHandle, boolean useDataSetFilter) throws BirtException {
        ScriptExpression expr = null;
        DataSetHandle targetHandle = dataSetHandle;
        HashMap<String, ResourceIdentifiers> appContext = new HashMap<String, ResourceIdentifiers>();
        DataSetPreviewer previewer = null;
        try {
            ModuleHandle targetModuleHandle = moduleHandle;
            if (!useDataSetFilter) {
                targetModuleHandle = ((Module)moduleHandle.copy()).getModuleHandle();
                SlotHandle dataSets = targetModuleHandle.getDataSets();
                int i = 0;
                while (i < dataSets.getCount()) {
                    if (dataSetHandle.getName().equals(dataSets.get(i).getName())) {
                        targetHandle = (DataSetHandle)dataSets.get(i);
                        targetHandle.clearProperty("filter");
                        break;
                    }
                    ++i;
                }
            }
            previewer = new DataSetPreviewer(targetHandle, 0, DataSetPreviewer.PreviewType.RESULTSET);
            DataModelAdapter adapter = new DataModelAdapter(new DataSessionContext(3, targetModuleHandle));
            expr = adapter.adaptExpression(expression);
            boolean startsWithRow = ExpressionUtility.isColumnExpression(expr.getText(), true);
            boolean startsWithDataSetRow = ExpressionUtility.isColumnExpression(expr.getText(), false);
            if (!startsWithRow && !startsWithDataSetRow) {
                throw new DataException(Messages.getString((String)"SelectValueDialog.messages.info.invalidSelectVauleExpression"));
            }
            String dataSetColumnName = null;
            dataSetColumnName = startsWithDataSetRow ? ExpressionUtil.getColumnName((String)expr.getText()) : ExpressionUtil.getColumnBindingName((String)expr.getText());
            ResourceIdentifiers identifiers = new ResourceIdentifiers();
            String resouceIDs = "org.eclipse.datatools.connectivity.oda.util_consumerResourceIds";
            identifiers.setApplResourceBaseURI(DTPUtil.getInstance().getBIRTResourcePath());
            identifiers.setDesignResourceBaseURI(DTPUtil.getInstance().getReportDesignPath());
            appContext.put(resouceIDs, identifiers);
            AppContextPopulator.populateApplicationContext(targetHandle, appContext);
            previewer.open(appContext, DistinctValueSelector.getEngineConfig(targetHandle.getModuleHandle()));
            IResultIterator itr = previewer.preview();
            HashSet<Object> visitedValues = new HashSet<Object>();
            Object value = null;
            while (itr.next()) {
                if (visitedValues.size() > 10000) break;
                value = itr.getValue(dataSetColumnName);
                if (value == null || visitedValues.contains(value)) continue;
                visitedValues.add(value);
            }
            if (visitedValues.isEmpty()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayList arrayList = new ArrayList(visitedValues);
            return arrayList;
        }
        finally {
            AppContextResourceReleaser.release(appContext);
            if (previewer != null) {
                previewer.close();
            }
        }
    }

    public static List getSelectValueList(Expression expression, ModuleHandle moduleHandle, DataSetHandle dataSetHandle, boolean useDataSetFilter) throws BirtException {
        return DistinctValueSelector.getSelectValueList1(expression, moduleHandle, dataSetHandle, useDataSetFilter);
    }

    private static EngineConfig getEngineConfig(ModuleHandle handle) {
        EngineConfig ec = new EngineConfig();
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = handle.getClass().getClassLoader();
        }
        ClassLoader customClassLoader = DataSetProvider.getCustomScriptClassLoader((ClassLoader)parent, (ModuleHandle)handle);
        ec.getAppContext().put("PARENT_CLASSLOADER", customClassLoader);
        return ec;
    }

    public static List getSelectValueFromBinding(Expression expression, DataSetHandle dataSetHandle, Iterator binding, Iterator groupIterator, boolean useDataSetFilter) throws BirtException {
        return DistinctValueSelector.getSelectValueFromBinding1(expression, dataSetHandle, dataSetHandle.getModuleHandle(), binding, groupIterator, useDataSetFilter);
    }

    private static List getSelectValueFromBinding1(Expression expression, DataSetHandle dataSetHandle, ModuleHandle moduleHandle, Iterator binding, Iterator groupIterator, boolean useDataSetFilter) throws BirtException {
        String columnName = null;
        ArrayList bindingList = new ArrayList();
        if (binding != null && binding.hasNext()) {
            while (binding.hasNext()) {
                bindingList.add(binding.next());
            }
        }
        ComputedColumn handle = new ComputedColumn();
        columnName = "TEMP_" + expression.getStringExpression();
        handle.setExpressionProperty("expression", expression);
        handle.setName(columnName);
        bindingList.add(handle);
        Collection result = null;
        DataRequestSession session = null;
        if (dataSetHandle != null && moduleHandle instanceof ReportDesignHandle) {
            EngineConfig config = new EngineConfig();
            ReportDesignHandle copy = (ReportDesignHandle)moduleHandle.copy().getHandle(null);
            config.setProperty("PARENT_CLASSLOADER", (Object)DataSetProvider.getCustomScriptClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader(), (ModuleHandle)copy));
            if (groupIterator != null) {
                ArrayList<GroupHandle> clearedGroup = new ArrayList<GroupHandle>();
                while (groupIterator.hasNext()) {
                    GroupHandle groupHandle = (GroupHandle)groupIterator.next();
                    if (groupHandle.filtersIterator().hasNext()) {
                        GroupHandle copyHandle = (GroupHandle)groupHandle.copy().getHandle(copy.getModule());
                        copyHandle.setProperty("filter", (Object)Collections.EMPTY_LIST);
                        clearedGroup.add(copyHandle);
                        continue;
                    }
                    clearedGroup.add(groupHandle);
                }
                groupIterator = clearedGroup.iterator();
            }
            ReportEngine engine = (ReportEngine)new ReportEngineFactory().createReportEngine(config);
            DummyEngineTask engineTask = new DummyEngineTask(engine, new ReportEngineHelper(engine).openReportDesign(copy), (ModuleHandle)copy, dataSetHandle);
            AppContextPopulator.populateApplicationContext(dataSetHandle, engineTask.getAppContext());
            session = engineTask.getDataSession();
            engineTask.run();
            result = session.getColumnValueSet(dataSetHandle, dataSetHandle.getPropertyHandle("parameters").iterator(), bindingList.iterator(), groupIterator, columnName, useDataSetFilter, null);
            engineTask.close();
            engine.destroy();
        } else if (dataSetHandle != null) {
            session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, dataSetHandle.getModuleHandle()));
            AppContextPopulator.populateApplicationContext(dataSetHandle, session);
            result = session.getColumnValueSet(dataSetHandle, dataSetHandle.getPropertyHandle("parameters").iterator(), bindingList.iterator(), null, columnName, useDataSetFilter, null);
            session.shutdown();
        }
        assert (result != null);
        if (result == null) {
            throw new BirtException(Messages.getString((String)"SelectValueDialog.messages.error.selectValueNotSupported"));
        }
        if (result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Object resultProtoType = result.iterator().next();
        if (resultProtoType instanceof IBlob || resultProtoType instanceof byte[]) {
            return Collections.EMPTY_LIST;
        }
        result.remove(null);
        return new ArrayList(result);
    }

    public static List getSelectValueFromBinding(Expression expression, ModuleHandle moduleHandle, DataSetHandle dataSetHandle, Iterator binding, Iterator groupIterator, boolean useDataSetFilter) throws BirtException {
        return DistinctValueSelector.getSelectValueFromBinding1(expression, dataSetHandle, moduleHandle, binding, groupIterator, useDataSetFilter);
    }
}

