/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataSetBindingSelector;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataSetColumnBindingsFormPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ParameterBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.DataSetColumnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.LinkedDataSetAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class BindingPage
extends Composite
implements Listener {
    protected List input = new ArrayList();
    private ComboViewer datasetCombo;
    private Button bindingButton;
    private static final String CHOICE_DATASET_FROM_CONTAINER = Messages.getString((String)"ColumnBindingDialog.Choice.DatasetFromContainer");
    private static final String CHOICE_NONE = Messages.getString((String)"ColumnBindingDialog.NONE");
    private static final String CHOICE_REPORTITEM_FROM_CONTAINER = Messages.getString((String)"ColumnBindingDialog.Choice.ReportItemFromContainer");
    private BindingInfo NullDatasetChoice = new BindingInfo(0, null, true);
    private String NullReportItemChoice = null;
    private transient boolean enableAutoCommit = true;
    private static final String DATA_SET_LABEL = Messages.getString((String)"BindingPage.Dataset.Label");
    private static final String REPORT_ITEM__LABEL = Messages.getString((String)"BindingPage.ReportItem.Label");
    private static final String BUTTON_BINDING = Messages.getString((String)"parameterBinding.title");
    private DataSetColumnBindingsFormPage columnBindingsFormPage;
    private ModuleHandle model;
    private Button datasetButton;
    private Button reportItemButton;
    private CCombo reportItemCombo;
    private boolean canAggregation = true;
    protected Map<String, ReportItemHandle> referMap = new HashMap<String, ReportItemHandle>();
    private BindingInfo oldInfo;

    public BindingPage(Composite parent, int style) {
        super(parent, style);
        this.buildUI();
    }

    public BindingPage(Composite parent, int style, boolean canAggregation) {
        super(parent, style);
        this.canAggregation = canAggregation;
        this.buildUI();
    }

    protected void buildUI() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.spacing = 8;
        this.setLayout((Layout)layout);
        this.datasetButton = new Button((Composite)this, 16);
        this.datasetButton.setText(DATA_SET_LABEL);
        this.datasetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingPage.this.refreshBinding();
                if (BindingPage.this.datasetButton.getSelection() && BindingPage.this.getReportItemHandle().getDataBindingType() == 2 && (DEUtil.getBindingHolder((DesignElementHandle)BindingPage.this.getReportItemHandle(), (boolean)true) == null || DEUtil.getBindingHolder((DesignElementHandle)BindingPage.this.getReportItemHandle(), (boolean)true).getDataBindingType() != 2)) {
                    BindingPage.this.saveBinding();
                }
            }
        });
        this.datasetCombo = new ComboViewer(new CCombo((Composite)this, 2056));
        this.datasetCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                BindingInfo info = (BindingInfo)element;
                String datasetName = info.getBindingValue();
                if (!info.isDataSet() && info != BindingPage.this.NullDatasetChoice) {
                    datasetName = String.valueOf(datasetName) + Messages.getString((String)"BindingGroupDescriptorProvider.Flag.DataModel");
                }
                return datasetName;
            }
        });
        this.datasetCombo.setContentProvider((IContentProvider)new ContentProvider());
        this.datasetCombo.getCCombo().setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(25));
        this.datasetCombo.getCCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BindingPage.this.saveBinding();
            }
        });
        this.bindingButton = new Button((Composite)this, 8);
        this.bindingButton.setText(BUTTON_BINDING);
        this.bindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterBindingDialog dialog = new ParameterBindingDialog(UIUtil.getDefaultShell(), (DesignElementHandle)BindingPage.this.input.get(0));
                BindingPage.this.startTrans("Edit ParamBinding");
                if (dialog.open() == 0) {
                    BindingPage.this.commit();
                } else {
                    BindingPage.this.rollback();
                }
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.datasetCombo.getCCombo(), 0, 131072);
        data.top = new FormAttachment((Control)this.datasetButton, 0, 0x1000000);
        this.bindingButton.setLayoutData((Object)data);
        this.reportItemButton = new Button((Composite)this, 16);
        this.reportItemButton.setText(REPORT_ITEM__LABEL);
        data = new FormData();
        data.top = new FormAttachment((Control)this.datasetButton, 0, 1024);
        data.left = new FormAttachment((Control)this.datasetButton, 0, 16384);
        this.reportItemButton.setLayoutData((Object)data);
        this.reportItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingPage.this.refreshBinding();
                if (BindingPage.this.reportItemButton.getSelection() && BindingPage.this.getReportItemHandle().getDataBindingType() == 1 && (DEUtil.getBindingHolder((DesignElementHandle)BindingPage.this.getReportItemHandle(), (boolean)true) == null || DEUtil.getBindingHolder((DesignElementHandle)BindingPage.this.getReportItemHandle(), (boolean)true).getDataBindingType() == 2)) {
                    BindingPage.this.saveBinding();
                }
            }
        });
        data = new FormData();
        data.left = UIUtil.getStringWidth(this.datasetButton.getText(), (Control)this.datasetButton) > UIUtil.getStringWidth(this.reportItemButton.getText(), (Control)this.reportItemButton) ? new FormAttachment((Control)this.datasetButton, 0, 131072) : new FormAttachment((Control)this.reportItemButton, 0, 131072);
        data.top = new FormAttachment((Control)this.datasetButton, 0, 0x1000000);
        data.right = new FormAttachment(50);
        this.datasetCombo.getCCombo().setLayoutData((Object)data);
        this.reportItemCombo = new CCombo((Composite)this, 2056);
        this.reportItemCombo.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(25));
        data = new FormData();
        data.top = new FormAttachment((Control)this.reportItemButton, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.datasetCombo.getCCombo(), 0, 16384);
        data.right = new FormAttachment((Control)this.datasetCombo.getCCombo(), 0, 131072);
        this.reportItemCombo.setLayoutData((Object)data);
        this.reportItemCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingPage.this.saveBinding();
            }
        });
        try {
            this.columnBindingsFormPage = new DataSetColumnBindingsFormPage(this, new DataSetColumnBindingsFormHandleProvider(this.canAggregation));
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        data = new FormData();
        data.top = new FormAttachment((Control)this.reportItemCombo, 0, 1024);
        data.left = new FormAttachment((Control)this.reportItemButton, 0, 16384);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.columnBindingsFormPage.setLayoutData(data);
    }

    private void saveBinding() {
        BindingInfo info = new BindingInfo();
        if (this.datasetButton.getSelection()) {
            info = (BindingInfo)((StructuredSelection)this.datasetCombo.getSelection()).getFirstElement();
        } else {
            info.setBindingType(2);
            info.setBindingValue(this.reportItemCombo.getText());
        }
        try {
            this.oldInfo = info;
            this.save(info);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    private void refreshBinding() {
        if (this.datasetButton.getSelection()) {
            this.datasetButton.setSelection(true);
            this.datasetCombo.getCCombo().setEnabled(true);
            this.bindingButton.setEnabled(this.datasetCombo.getCCombo().getText().trim().length() != 0);
            this.reportItemButton.setSelection(false);
            this.reportItemCombo.setEnabled(false);
            if (this.datasetCombo.getCCombo().getSelectionIndex() == -1) {
                BindingInfo[] infos = this.getAvailableDatasetItems();
                this.datasetCombo.setInput((Object)infos);
                this.datasetCombo.setSelection((ISelection)new StructuredSelection((Object)infos[0]));
            }
        } else {
            this.datasetButton.setSelection(false);
            this.datasetCombo.getCCombo().setEnabled(false);
            this.bindingButton.setEnabled(false);
            this.reportItemButton.setSelection(true);
            this.reportItemCombo.setEnabled(true);
            if (this.reportItemCombo.getSelectionIndex() == -1) {
                this.reportItemCombo.setItems(this.getReferences());
                this.reportItemCombo.select(0);
            }
        }
    }

    public List<BindingInfo> getVisibleDataSetHandles(ModuleHandle handle) {
        ArrayList<BindingInfo> list = new ArrayList<BindingInfo>();
        for (DataSetHandle dataSetHandle : handle.getVisibleDataSets()) {
            BindingInfo info = new BindingInfo(1, dataSetHandle.getQualifiedName(), true);
            list.add(info);
        }
        LinkedDataSetAdapter adapter = new LinkedDataSetAdapter();
        for (DataSetHandle dataSetHandle : adapter.getVisibleLinkedDataSetsDataSetHandles(handle)) {
            BindingInfo info = new BindingInfo(1, dataSetHandle.getQualifiedName(), false);
            list.add(info);
        }
        return list;
    }

    protected BindingInfo[] getAvailableDatasetItems() {
        BindingInfo[] dataSets = this.getVisibleDataSetHandles(SessionHandleAdapter.getInstance().getModule()).toArray(new BindingInfo[0]);
        BindingInfo[] newList = new BindingInfo[dataSets.length + 1];
        newList[0] = this.NullDatasetChoice;
        System.arraycopy(dataSets, 0, newList, 1, dataSets.length);
        return newList;
    }

    protected List getAvailableDataBindingReferenceList(ReportItemHandle element) {
        ArrayList bindingRef = new ArrayList();
        bindingRef.addAll(element.getAvailableDataSetBindingReferenceList());
        if (ExtendedDataModelUIAdapterHelper.getInstance().getAdapter() != null) {
            List temp = ExtendedDataModelUIAdapterHelper.getInstance().getAdapter().getAvailableBindingReferenceList(element);
            bindingRef.removeAll(temp);
            bindingRef.addAll(temp);
        }
        return bindingRef;
    }

    protected String[] getReferences() {
        ReportItemHandle element = this.getReportItemHandle();
        List referenceList = this.getAvailableDataBindingReferenceList(element);
        Object[] references = new String[referenceList.size() + 1];
        references[0] = this.NullReportItemChoice;
        this.referMap.put(references[0], null);
        int j = 0;
        int i = 0;
        while (i < referenceList.size()) {
            ReportItemHandle item = (ReportItemHandle)referenceList.get(i);
            if (item.getName() != null) {
                references[++j] = item.getQualifiedName();
                this.referMap.put((String)references[j], item);
            }
            ++i;
        }
        int tmp = j + 1;
        Arrays.sort(references, 1, tmp);
        int i2 = 0;
        while (i2 < referenceList.size()) {
            ReportItemHandle item = (ReportItemHandle)referenceList.get(i2);
            if (item.getName() == null) {
                references[++j] = String.valueOf(item.getElement().getDefn().getDisplayName()) + " (ID " + item.getID() + ") - " + Messages.getString((String)"BindingPage.ReportItem.NoName");
                this.referMap.put((String)references[j], item);
            }
            ++i2;
        }
        Arrays.sort(references, tmp, referenceList.size() + 1);
        return references;
    }

    private ReportItemHandle getReportItemHandle() {
        return (ReportItemHandle)this.input.get(0);
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        ContentEvent ce;
        PropertyEvent event;
        String propertyName;
        if (this.isDisposed()) {
            return;
        }
        if (ev.getEventType() == 5 && ("paramBindings".equals(propertyName = (event = (PropertyEvent)ev).getPropertyName()) || "dataSet".equals(propertyName) || "dataBindingRef".equals(propertyName))) {
            this.load();
        }
        if (ev.getEventType() == 0 && ev instanceof ContentEvent && (ce = (ContentEvent)ev).getContent() instanceof DataSet) {
            this.load();
        }
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    private void startTrans(String name) {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().startTrans(name);
        }
    }

    private void commit() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().commit();
        }
    }

    private void rollback() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().rollback();
        }
    }

    public boolean isEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public void setEnableAutoCommit(boolean enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
    }

    public void setInput(List elements) {
        this.deRegisterListeners();
        this.input = elements;
        ReportItemHandle container = DEUtil.getBindingHolder((DesignElementHandle)((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.input)).getContainer());
        if (container != null && (container.getDataSet() != null || container.columnBindingsIterator().hasNext())) {
            this.NullDatasetChoice.bindingValue = BindingPage.CHOICE_DATASET_FROM_CONTAINER;
        } else {
            this.NullDatasetChoice.bindingValue = BindingPage.CHOICE_NONE;
        }
        this.NullReportItemChoice = container != null && container.getDataBindingReference() != null ? CHOICE_REPORTITEM_FROM_CONTAINER : CHOICE_NONE;
        this.load();
        this.registerListeners();
        this.columnBindingsFormPage.setInput(elements);
        this.model = SessionHandleAdapter.getInstance().getReportDesignHandle();
    }

    protected void registerListeners() {
        if (this.input == null) {
            return;
        }
        int i = 0;
        while (i < this.input.size()) {
            Object obj = this.input.get(i);
            if (obj instanceof DesignElementHandle) {
                DesignElementHandle element = (DesignElementHandle)obj;
                element.addListener((Listener)this);
            }
            ++i;
        }
        SessionHandleAdapter.getInstance().getReportDesignHandle().addListener((Listener)this);
    }

    protected void deRegisterListeners() {
        if (this.input == null) {
            return;
        }
        int i = 0;
        while (i < this.input.size()) {
            Object obj = this.input.get(i);
            if (obj instanceof DesignElementHandle) {
                DesignElementHandle element = (DesignElementHandle)obj;
                element.removeListener((Listener)this);
            }
            ++i;
        }
        if (this.model != null) {
            this.model.removeListener((Listener)this);
        }
    }

    public void dispose() {
        this.deRegisterListeners();
        super.dispose();
    }

    public void load() {
        this.datasetButton.setEnabled(true);
        this.reportItemButton.setEnabled(true);
        BindingInfo info = this.loadValue();
        if (info != null) {
            this.refreshBindingInfo(info);
        }
        this.columnBindingsFormPage.refresh();
    }

    private void refreshBindingInfo(BindingInfo info) {
        int type = info.getBindingType();
        String value = info.getBindingValue();
        this.datasetCombo.setInput((Object)this.getAvailableDatasetItems());
        this.reportItemCombo.setItems(this.getReferences());
        if (type == 0 && DEUtil.getBindingHolder((DesignElementHandle)this.getReportItemHandle(), (boolean)true) != null && DEUtil.getBindingHolder((DesignElementHandle)this.getReportItemHandle(), (boolean)true).getDataBindingType() == 2) {
            type = 2;
        }
        switch (type) {
            case 0: {
                if (this.oldInfo != null) {
                    if (this.oldInfo.getBindingType() == 1) {
                        this.selectDatasetType(info);
                        break;
                    }
                    if (this.oldInfo.getBindingType() == 2) {
                        this.selectReferenceType(value);
                        break;
                    }
                    this.datasetCombo.setSelection((ISelection)new StructuredSelection((Object)info));
                    break;
                }
            }
            case 1: {
                this.selectDatasetType(info);
                break;
            }
            case 2: {
                this.selectReferenceType(value);
            }
        }
    }

    private void selectReferenceType(Object value) {
        this.datasetButton.setSelection(false);
        this.datasetCombo.getCCombo().setEnabled(false);
        this.bindingButton.setEnabled(false);
        this.reportItemButton.setSelection(true);
        this.reportItemCombo.setEnabled(true);
        this.reportItemCombo.setText(value.toString());
    }

    private void selectDatasetType(BindingInfo value) {
        this.datasetButton.setSelection(true);
        this.datasetCombo.getCCombo().setEnabled(true);
        this.datasetCombo.setSelection((ISelection)new StructuredSelection((Object)value));
        this.bindingButton.setEnabled(!value.toString().equals(this.NullDatasetChoice));
        this.reportItemButton.setSelection(false);
        this.reportItemCombo.setEnabled(false);
    }

    public BindingInfo loadValue() {
        String value;
        ReportItemHandle element = this.getReportItemHandle();
        boolean isDataSet = false;
        int type = element.getDataBindingType();
        if (type == 0) {
            type = DEUtil.getBindingHolder((DesignElementHandle)element).getDataBindingType();
        }
        switch (type) {
            case 1: {
                DataSetHandle dataset = element.getDataSet();
                if (dataset == null) {
                    value = this.NullDatasetChoice.bindingValue;
                    type = this.NullDatasetChoice.bindingType;
                    isDataSet = true;
                    break;
                }
                List datasets = element.getModuleHandle().getAllDataSets();
                if (datasets != null) {
                    int i = 0;
                    while (i < datasets.size()) {
                        if (datasets.get(i) == dataset) {
                            isDataSet = true;
                            break;
                        }
                        ++i;
                    }
                }
                value = dataset.getQualifiedName();
                break;
            }
            case 2: {
                ReportItemHandle reference = element.getDataBindingReference();
                if (reference == null) {
                    value = this.NullReportItemChoice;
                    break;
                }
                value = reference.getQualifiedName();
                break;
            }
            default: {
                value = this.NullDatasetChoice.bindingValue;
                isDataSet = true;
            }
        }
        BindingInfo info = new BindingInfo(type, value, isDataSet);
        return info;
    }

    public void save(Object saveValue) throws SemanticException {
        if (saveValue instanceof BindingInfo) {
            BindingInfo info = (BindingInfo)saveValue;
            int type = info.getBindingType();
            BindingInfo oldValue = this.loadValue();
            block0 : switch (type) {
                case 0: 
                case 1: {
                    if (info.equals(this.NullDatasetChoice)) {
                        info = null;
                    }
                    int ret = 0;
                    if (!this.NullDatasetChoice.equals(info)) {
                        ret = 4;
                    }
                    if (!(this.NullDatasetChoice.equals(oldValue) && !this.getReportItemHandle().getColumnBindings().iterator().hasNext() || info != null && info.equals(oldValue))) {
                        MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeDataSet"), 3, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.No"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
                        ret = prefDialog.open();
                    }
                    switch (ret) {
                        case 0: {
                            this.resetDataSetReference(info, true);
                            break;
                        }
                        case 1: {
                            this.resetDataSetReference(info, false);
                            break;
                        }
                        case 2: {
                            this.load();
                            break;
                        }
                        case 4: {
                            this.updateDataSetReference(info);
                        }
                    }
                    break;
                }
                case 2: {
                    String value = info.getBindingValue().toString();
                    if (value.equals(this.NullReportItemChoice)) {
                        value = null;
                    } else if (this.referMap.get(value).getName() == null) {
                        MessageDialog dialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.haveNoName"), null, Messages.getString((String)"dataBinding.message.haveNoName"), 3, new String[]{Messages.getString((String)"dataBinding.button.OK")}, 0);
                        dialog.open();
                        this.load();
                        return;
                    }
                    int ret1 = 0;
                    if (!this.NullReportItemChoice.equals(this.loadValue().getBindingValue().toString()) || this.getReportItemHandle().getColumnBindings().iterator().hasNext()) {
                        MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeReference"), 3, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
                        ret1 = prefDialog.open();
                    }
                    switch (ret1) {
                        case 0: {
                            this.resetReference(value);
                            break block0;
                        }
                        case 1: {
                            this.load();
                        }
                    }
                }
            }
        }
    }

    private void resetDataSetReference(BindingInfo info, boolean clearHistory) {
        try {
            this.startTrans("Reset Reference");
            DataSetHandle dataSet = null;
            if (info != null && info.isDataSet()) {
                dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(info.getBindingValue());
            }
            if (this.getReportItemHandle().getDataBindingType() == 2) {
                this.getReportItemHandle().setDataBindingReference(null);
            }
            boolean isExtendedDataModel = false;
            if (dataSet == null && info != null) {
                isExtendedDataModel = new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), info.getBindingValue());
                this.getReportItemHandle().setDataSet(null);
            } else {
                new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), null);
                this.getReportItemHandle().setDataSet(dataSet);
            }
            if (clearHistory) {
                this.getReportItemHandle().getColumnBindings().clearValue();
                this.getReportItemHandle().getPropertyHandle("paramBindings").clearValue();
            }
            if (info != null) {
                DataSetBindingSelector selector = new DataSetBindingSelector(UIUtil.getDefaultShell(), isExtendedDataModel ? Messages.getString((String)"BindingPage.DataSetBindingSelector.Title.LinkModel") : Messages.getString((String)"BindingPage.DataSetBindingSelector.Title.DataSet"));
                selector.setDataSet(info.getBindingValue(), info.isDataSet());
                if (selector.open() == 0) {
                    Object[] columns = (Object[])((Object[])selector.getResult())[1];
                    this.columnBindingsFormPage.generateBindingColumns(columns);
                }
            }
            this.commit();
        }
        catch (SemanticException e) {
            this.rollback();
            ExceptionHandler.handle(e);
        }
        this.load();
    }

    private void updateDataSetReference(BindingInfo info) {
        try {
            this.startTrans("Reset Reference");
            DataSetHandle dataSet = null;
            if (info != null && info.isDataSet()) {
                dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(info.getBindingValue());
            }
            if (this.getReportItemHandle().getDataBindingType() == 2) {
                this.getReportItemHandle().setDataBindingReference(null);
            }
            boolean isExtendedDataModel = false;
            if (dataSet == null && info != null) {
                this.getReportItemHandle().setDataSet(null);
                isExtendedDataModel = new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), info.getBindingValue());
            } else {
                new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), null);
                this.getReportItemHandle().setDataSet(dataSet);
            }
            if (info != null) {
                DataSetBindingSelector selector = new DataSetBindingSelector(UIUtil.getDefaultShell(), isExtendedDataModel ? Messages.getString((String)"BindingPage.DataSetBindingSelector.Title.LinkModel") : Messages.getString((String)"BindingPage.DataSetBindingSelector.Title.DataSet"));
                selector.setDataSet(info.getBindingValue(), info.isDataSet());
                Iterator bindings = this.getReportItemHandle().getColumnBindings().iterator();
                ArrayList<String> columnNames = new ArrayList<String>();
                while (bindings.hasNext()) {
                    columnNames.add(((ComputedColumnHandle)bindings.next()).getName());
                }
                if (!columnNames.isEmpty()) {
                    selector.setColumns(columnNames.toArray(new String[0]));
                }
                if (selector.open() == 0) {
                    this.clearBinding(this.getReportItemHandle().getColumnBindings(), (Object[])((Object[])selector.getResult())[2]);
                    Object[] columns = (Object[])((Object[])selector.getResult())[1];
                    this.columnBindingsFormPage.generateBindingColumns(columns);
                }
            }
            this.commit();
        }
        catch (SemanticException e) {
            this.rollback();
            ExceptionHandler.handle(e);
        }
        this.load();
    }

    private void clearBinding(PropertyHandle columnBindings, Object[] objects) {
        if (objects != null && columnBindings.getItems() != null) {
            List<Object> list = Arrays.asList(objects);
            int i = columnBindings.getItems().size() - 1;
            while (i >= 0) {
                ComputedColumnHandle handle = (ComputedColumnHandle)columnBindings.getAt(i);
                String name = handle.getName();
                if (list.contains(name)) {
                    try {
                        columnBindings.removeItem(i);
                    }
                    catch (PropertyValueException e) {
                        ExceptionHandler.handle(e);
                    }
                }
                --i;
            }
        }
    }

    private void resetReference(Object value) {
        if (value == null && this.getReportItemHandle().getDataBindingType() == 1) {
            this.resetDataSetReference(null, true);
        } else {
            try {
                this.startTrans("Reset Reference");
                ReportItemHandle element = null;
                if (value != null) {
                    element = (ReportItemHandle)SessionHandleAdapter.getInstance().getReportDesignHandle().findElement(value.toString());
                }
                this.getReportItemHandle().setDataBindingReference(element);
                this.commit();
            }
            catch (SemanticException e) {
                this.rollback();
                ExceptionHandler.handle(e);
            }
            this.load();
        }
    }

    public static class BindingInfo {
        private int bindingType;
        private String bindingValue;
        private boolean isDataSet;

        public void setDataSet(boolean isDataSet) {
            this.isDataSet = isDataSet;
        }

        public boolean isDataSet() {
            return this.isDataSet;
        }

        public BindingInfo(int type, String value) {
            this.bindingType = type;
            this.bindingValue = value;
        }

        public BindingInfo(int type, String value, boolean isDataSet) {
            this.bindingType = type;
            this.bindingValue = value;
            this.isDataSet = isDataSet;
        }

        public BindingInfo() {
        }

        public int getBindingType() {
            return this.bindingType;
        }

        public String getBindingValue() {
            return this.bindingValue;
        }

        public void setBindingType(int bindingType) {
            this.bindingType = bindingType;
        }

        public void setBindingValue(String bindingValue) {
            this.bindingValue = bindingValue;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BindingInfo)) {
                return false;
            }
            BindingInfo info = (BindingInfo)obj;
            if (this.bindingValue == null && info.bindingValue != null || this.bindingValue != null && !this.bindingValue.equals(info.bindingValue)) {
                return false;
            }
            if (this.bindingType != info.bindingType) {
                return false;
            }
            return this.isDataSet == info.isDataSet;
        }

        public int hashCode() {
            int code = 13;
            if (this.bindingValue != null) {
                code += this.bindingValue.hashCode() * 7;
            }
            code += this.bindingType * 5;
            return code += Boolean.valueOf(this.isDataSet()).hashCode() * 3;
        }
    }

    public static class ContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

