/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ods;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.ods.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.ods.Data;
import org.eclipse.birt.report.engine.emitter.ods.IOdsWriter;
import org.eclipse.birt.report.engine.emitter.ods.MasterPageWriter;
import org.eclipse.birt.report.engine.emitter.ods.OdsUtil;
import org.eclipse.birt.report.engine.emitter.ods.OdsWriter;
import org.eclipse.birt.report.engine.emitter.ods.RowData;
import org.eclipse.birt.report.engine.emitter.ods.SheetData;
import org.eclipse.birt.report.engine.emitter.ods.layout.ColumnsInfo;
import org.eclipse.birt.report.engine.emitter.ods.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.ods.layout.LayoutUtil;
import org.eclipse.birt.report.engine.emitter.ods.layout.OdsContext;
import org.eclipse.birt.report.engine.emitter.ods.layout.OdsLayoutEngine;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.odf.AbstractOdfEmitter;
import org.eclipse.birt.report.engine.odf.AbstractOdfEmitterContext;
import org.eclipse.birt.report.engine.odf.MasterPageManager;
import org.eclipse.birt.report.engine.odf.OdfUtil;
import org.eclipse.birt.report.engine.odf.style.HyperlinkInfo;
import org.eclipse.birt.report.engine.odf.style.StyleBuilder;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class OdsEmitter
extends AbstractOdfEmitter {
    public static final String MIME_TYPE = "application/vnd.oasis.opendocument.spreadsheet";
    private boolean isAuto = true;
    protected static Logger logger = Logger.getLogger(OdsEmitter.class.getName());
    protected static final String DEFAULT_SHEET_NAME = "Report";
    protected OdsLayoutEngine engine;
    protected IOdsWriter writer;
    protected MasterPageWriter mpWriter;
    protected OdsContext context;
    private boolean outputInMasterPage = false;
    protected boolean isRTLSheet = false;
    protected int sheetIndex = 1;
    protected String sheetName;
    protected int pageWidth;
    protected int pageHeight;
    protected int contentwidth;
    protected int reportDpi;
    protected StyleEntry pageLayout;
    protected IReportContext reportContext;

    public String getOutputFormat() {
        return "ods";
    }

    public void initialize(IEmitterServices service) throws EngineException {
        super.initialize(service);
        IReportContext reportContext = service.getReportContext();
        if (reportContext != null) {
            Locale locale = reportContext.getLocale();
            if (locale != null) {
                this.context.setLocale(ULocale.forLocale((Locale)locale));
            } else {
                this.context.setLocale(ULocale.getDefault());
            }
        }
        this.reportContext = reportContext;
        this.tableCount = 0;
    }

    protected AbstractOdfEmitterContext createContext() {
        this.context = new OdsContext();
        return this.context;
    }

    public void start(IReportContent report) throws BirtException {
        super.start(report);
        this.setupRenderOptions();
        ReportDesignHandle designHandle = report.getDesign().getReportDesign();
        this.parseReportOrientation(designHandle);
        this.parseReportLayout(designHandle);
        this.parseSheetName(designHandle);
        this.parsePageSize(report);
        IStyle style = report.getRoot().getComputedStyle();
        this.engine = this.createLayoutEngine(this.context, this);
        this.engine.initalize(this.contentwidth, style, this.reportDpi, this.context.getStyleManager());
        this.createWriter();
        try {
            this.writeMetaProperties(this.reportContent);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
        }
        catch (BirtException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    private void parseSheetName(ReportDesignHandle designHandle) {
        String reportTitle = designHandle.getStringProperty("title");
        this.sheetName = reportTitle != null ? reportTitle : DEFAULT_SHEET_NAME;
        this.sheetName = OdsUtil.getValidSheetName(this.sheetName);
    }

    private void parseReportLayout(ReportDesignHandle designHandle) {
        String reportLayoutPreference = designHandle.getLayoutPreference();
        if ("fixed layout".equals(reportLayoutPreference)) {
            this.isAuto = false;
        }
    }

    private void parseReportOrientation(ReportDesignHandle designHandle) {
        String reportOrientation = designHandle.getBidiOrientation();
        if ("rtl".equalsIgnoreCase(reportOrientation)) {
            this.isRTLSheet = true;
        }
    }

    private void parsePageSize(IReportContent report) {
        Object dpi = report.getReportContext().getRenderOption().getOption("RenderDpi");
        int renderDpi = 0;
        if (dpi != null && dpi instanceof Integer) {
            renderDpi = (Integer)dpi;
        }
        this.reportDpi = PropertyUtil.getRenderDpi((IReportContent)report, (int)renderDpi);
        SimpleMasterPageDesign masterPage = (SimpleMasterPageDesign)report.getDesign().getPageSetup().getMasterPage(0);
        this.pageWidth = OdfUtil.convertDimensionType((DimensionType)masterPage.getPageWidth(), (float)0.0f, (float)this.reportDpi);
        int leftmargin = OdfUtil.convertDimensionType((DimensionType)masterPage.getLeftMargin(), (float)this.pageWidth, (float)this.reportDpi);
        int rightmargin = OdfUtil.convertDimensionType((DimensionType)masterPage.getRightMargin(), (float)this.pageWidth, (float)this.reportDpi);
        this.contentwidth = this.pageWidth - leftmargin - rightmargin;
        this.pageHeight = OdfUtil.convertDimensionType((DimensionType)masterPage.getPageHeight(), (float)0.0f, (float)this.reportDpi);
    }

    protected OdsLayoutEngine createLayoutEngine(OdsContext context, OdsEmitter emitter) {
        return new OdsLayoutEngine(context, emitter);
    }

    private void setupRenderOptions() {
        IRenderOption renderOptions = this.service.getRenderOption();
        Object textWrapping = renderOptions.getOption("excelRenderOption.wrappingText");
        if (textWrapping != null && textWrapping instanceof Boolean) {
            this.context.setWrappingText((Boolean)textWrapping);
        } else {
            this.context.setWrappingText(true);
        }
        Object hideGridlines = renderOptions.getOption("excelRenderOption.hideGridlines");
        if (hideGridlines != null && hideGridlines instanceof Boolean) {
            this.context.setHideGridlines((Boolean)hideGridlines);
        } else {
            this.context.setHideGridlines(false);
        }
    }

    public void startPage(IPageContent page) throws BirtException {
        if (this.pageLayout == null) {
            this.pageLayout = this.makePageLayoutStyle(page);
        }
        MasterPageManager mpManager = this.context.getMasterPageManager();
        mpManager.newPage("Standard");
        this.mpWriter.startMasterPage(this.pageLayout, mpManager.getCurrentMasterPage(), null);
        if (this.needOutputInMasterPage(page.getPageHeader()) && this.needOutputInMasterPage(page.getPageFooter())) {
            this.outputInMasterPage = true;
            IContent pageHeader = page.getPageHeader();
            IContent pageFooter = page.getPageFooter();
            if (pageHeader != null) {
                this.mpWriter.startHeader();
                this.mpWriter.writeHeaderFooter(pageHeader);
                this.mpWriter.endHeader();
            }
            if (pageFooter != null) {
                this.mpWriter.startFooter();
                this.mpWriter.writeHeaderFooter(pageFooter);
                this.mpWriter.endFooter();
            }
        }
        this.mpWriter.endMasterPage();
        if (!this.outputInMasterPage && page.getPageHeader() != null) {
            this.contentVisitor.visitChildren(page.getPageHeader(), null);
        }
    }

    public void endPage(IPageContent page) throws BirtException {
        if (!this.outputInMasterPage && page.getPageFooter() != null) {
            this.contentVisitor.visitChildren(page.getPageFooter(), null);
        }
    }

    public void startTable(ITableContent table) {
        ContainerSizeInfo sizeInfo = this.engine.getCurrentContainer().getSizeInfo();
        int width = sizeInfo.getWidth();
        ColumnsInfo info = null;
        boolean isAutoTable = true;
        if (isAutoTable) {
            info = LayoutUtil.createTable(table, width, this.reportDpi);
        } else {
            int[] columns = LayoutUtil.createFixedTable(table, LayoutUtil.getElementWidth((IContent)table, width, this.reportDpi), this.reportDpi);
            info = new ColumnsInfo(columns);
        }
        String caption = table.getCaption();
        if (caption != null) {
            this.engine.addCaption(caption, table.getComputedStyle());
        }
        this.engine.addTable((IContainerContent)table, info, sizeInfo);
    }

    public void startRow(IRowContent row) {
        this.engine.addRow(row.getComputedStyle());
    }

    public void endRow(IRowContent row) {
        DimensionType height = row.getHeight();
        float rowHeight = (float)OdfUtil.convertDimensionType((DimensionType)height, (float)0.0f, (float)this.reportDpi) / 1000.0f;
        this.engine.endRow(rowHeight);
    }

    public void startCell(ICellContent cell) {
        IStyle style = cell.getComputedStyle();
        this.engine.addCell(cell, cell.getColumn(), cell.getColSpan(), cell.getRowSpan(), style);
    }

    public void endCell(ICellContent cell) {
        this.engine.endCell(cell);
    }

    public void endTable(ITableContent table) {
        this.engine.endTable((IContent)table);
    }

    public void startList(IListContent list) {
        ContainerSizeInfo size = this.engine.getCurrentContainer().getSizeInfo();
        ColumnsInfo table = LayoutUtil.createTable(list, size.getWidth(), this.reportDpi);
        this.engine.addTable((IContainerContent)list, table, size);
        if (list.getChildren() == null) {
            HyperlinkInfo link = this.parseHyperLink((IContent)list);
            BookmarkDef bookmark = this.getBookmark((IContent)list);
            float height = this.getContentHeight((IContent)list);
            this.engine.addData("", list.getComputedStyle(), link, bookmark, height);
        }
    }

    public void startListBand(IListBandContent listBand) {
        this.engine.addCell(0, 1, 1, listBand.getComputedStyle());
    }

    public void endListBand(IListBandContent listBand) {
        this.engine.endContainer();
    }

    public void endList(IListContent list) {
        this.engine.endTable((IContent)list);
    }

    public void startForeign(IForeignContent foreign) throws BirtException {
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            HTML2Content.html2Content((IForeignContent)foreign);
            HyperlinkInfo link = this.parseHyperLink((IContent)foreign);
            this.engine.addContainer(foreign.getComputedStyle(), link);
            this.contentVisitor.visitChildren((IContent)foreign, null);
            this.engine.endContainer();
        }
    }

    public void startText(ITextContent text) {
        HyperlinkInfo url = this.parseHyperLink((IContent)text);
        BookmarkDef bookmark = this.getBookmark((IContent)text);
        float height = this.getContentHeight((IContent)text);
        this.engine.addData(text.getText(), text.getComputedStyle(), url, bookmark, height);
    }

    public void startData(IDataContent data) {
        this.addDataContent(data);
    }

    protected Data addDataContent(IDataContent data) {
        float height = this.getContentHeight((IContent)data);
        HyperlinkInfo url = this.parseHyperLink((IContent)data);
        BookmarkDef bookmark = this.getBookmark((IContent)data);
        Data outputData = null;
        Object generateBy = data.getGenerateBy();
        IStyle style = data.getComputedStyle();
        DataFormatValue dataformat = style.getDataFormat();
        MapDesign map = null;
        if (generateBy instanceof DataItemDesign) {
            DataItemDesign design = (DataItemDesign)generateBy;
            map = design.getMap();
        }
        if (map != null && map.getRuleCount() > 0 && data.getLabelText() != null) {
            outputData = this.engine.addData(data.getText(), style, url, bookmark, height);
        } else {
            String locale = null;
            int type = OdsUtil.getType(data.getValue());
            if (type == 2) {
                if (dataformat != null) {
                    locale = dataformat.getStringLocale();
                }
                outputData = this.engine.addData(data.getText(), style, url, bookmark, locale, height);
            } else if (type == 1) {
                if (dataformat != null) {
                    locale = dataformat.getNumberLocale();
                }
                outputData = this.engine.addData(data.getValue(), style, url, bookmark, locale, height);
            } else {
                if (dataformat != null) {
                    locale = dataformat.getDateTimeLocale();
                }
                outputData = this.engine.addDateTime(data, style, url, bookmark, locale, height);
            }
        }
        return outputData;
    }

    private float getContentHeight(IContent content) {
        return (float)OdfUtil.convertDimensionType((DimensionType)content.getHeight(), (float)0.0f, (float)this.reportDpi) / 1000.0f;
    }

    public void startImage(IImageContent image) {
        IStyle style = image.getComputedStyle();
        HyperlinkInfo url = this.parseHyperLink((IContent)image);
        BookmarkDef bookmark = this.getBookmark((IContent)image);
        this.engine.addImageData(image, style, url, bookmark);
    }

    public void startLabel(ILabelContent label) {
        Object design = label.getGenerateBy();
        ILabelContent container = label;
        while (design == null) {
            container = (IContent)container.getParent();
            design = container.getGenerateBy();
        }
        HyperlinkInfo url = this.parseHyperLink((IContent)label);
        BookmarkDef bookmark = this.getBookmark((IContent)label);
        if (!"\n".equalsIgnoreCase(label.getText()) || !(container instanceof IForeignContent)) {
            float height = this.getContentHeight((IContent)label);
            this.engine.addData(label.getText(), label.getComputedStyle(), url, bookmark, height);
        }
    }

    public void startAutoText(IAutoTextContent autoText) {
        HyperlinkInfo link = this.parseHyperLink((IContent)autoText);
        BookmarkDef bookmark = this.getBookmark((IContent)autoText);
        float height = this.getContentHeight((IContent)autoText);
        this.engine.addData(autoText.getText(), autoText.getComputedStyle(), link, bookmark, height);
    }

    public void outputSheet() {
        this.engine.cacheBookmarks(this.sheetName);
        this.engine.complete(this.isAuto);
        try {
            this.outputCacheData();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        ++this.sheetIndex;
    }

    public void end(IReportContent report) throws BirtException {
        this.engine.cacheBookmarks(this.sheetName);
        this.engine.complete(this.isAuto);
        try {
            this.writer.start(report, this.engine.getAllBookmarks());
            this.outputCacheData();
            this.writer.end();
            this.mpWriter.end();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        super.end(report);
    }

    protected void createWriter() {
        this.writer = new OdsWriter(this.bodyOut, this.context, this.isRTLSheet);
        this.mpWriter = new MasterPageWriter(this.masterPageOut, this.context.getGlobalStyleManager());
        this.mpWriter.start();
    }

    public void outputCacheData() throws IOException {
        Object pageLabelObj = this.reportContext.getPageVariable("__page_label");
        if (pageLabelObj instanceof String) {
            String pageLabel = (String)pageLabelObj;
            this.sheetName = pageLabel = OdsUtil.getValidSheetName(pageLabel);
        }
        MasterPageManager mpManager = this.context.getMasterPageManager();
        ++this.tableCount;
        StyleEntry tableStyle = StyleBuilder.createEmptyStyleEntry((int)2);
        tableStyle.setProperty(58, (Object)mpManager.getCurrentMasterPage());
        this.context.addStyle(this.getTableStylePrefix(), tableStyle);
        int[] cols = this.engine.getCoordinates();
        double[] colSizes = new double[cols.length];
        int i = 0;
        while (i < cols.length) {
            colSizes[i] = (float)cols[i] / 1000.0f / 72.0f;
            ++i;
        }
        StyleEntry[] colStyles = this.getColStyles(colSizes);
        this.writer.startSheet(tableStyle, colStyles, this.sheetName);
        this.sheetName = DEFAULT_SHEET_NAME + this.sheetIndex;
        OdsLayoutEngine.OdsLayoutEngineIterator it = this.engine.getIterator();
        while (it.hasNext()) {
            this.outputRowData((RowData)it.next());
        }
        this.writer.endSheet();
    }

    protected void outputRowData(RowData rowData) throws IOException {
        StyleEntry rowStyle = StyleBuilder.createEmptyStyleEntry((int)4);
        rowStyle.setProperty(36, (Object)(rowData.getHeight() / 72.0));
        this.context.addStyle(this.getTableStylePrefix(), rowStyle);
        this.writer.startRow(rowStyle);
        SheetData[] datas = rowData.getRowdata();
        int i = 0;
        while (i < datas.length) {
            SheetData data = datas[i];
            int start = this.engine.getStartColumn(data);
            int end = this.engine.getEndColumn(data);
            int span = Math.max(0, end - start - 1);
            this.writer.outputData(data, data.getStyleId(), start, span);
            ++i;
        }
        this.writer.endRow();
    }

    public HyperlinkInfo parseHyperLink(IContent content) {
        HyperlinkInfo hyperlink = null;
        IHyperlinkAction linkAction = content.getHyperlinkAction();
        if (linkAction != null) {
            String tooltip = linkAction.getTooltip();
            String bookmark = linkAction.getBookmark();
            switch (linkAction.getType()) {
                case 2: {
                    hyperlink = new HyperlinkInfo(2, bookmark, tooltip);
                    break;
                }
                case 1: {
                    String url = EmitterUtil.getHyperlinkUrl((IHyperlinkAction)linkAction, (IReportRunnable)this.reportRunnable, (IHTMLActionHandler)this.actionHandler, (IReportContext)this.reportContext);
                    hyperlink = new HyperlinkInfo(1, url, tooltip);
                    break;
                }
                case 3: {
                    String url = EmitterUtil.getHyperlinkUrl((IHyperlinkAction)linkAction, (IReportRunnable)this.reportRunnable, (IHTMLActionHandler)this.actionHandler, (IReportContext)this.reportContext);
                    hyperlink = new HyperlinkInfo(3, url, tooltip);
                }
            }
        }
        if (hyperlink != null) {
            StyleEntry style = StyleBuilder.createStyleEntry((IStyle)content.getStyle(), (int)1);
            this.context.addStyle(style);
            hyperlink.setStyle(style);
        }
        return hyperlink;
    }

    protected BookmarkDef getBookmark(IContent content) {
        String bookmarkName = content.getBookmark();
        if (bookmarkName == null) {
            return null;
        }
        BookmarkDef bookmark = new BookmarkDef(content.getBookmark());
        if (!OdsUtil.isValidBookmarkName(bookmarkName)) {
            bookmark.setGeneratedName(this.engine.getGenerateBookmark(bookmarkName));
        }
        return bookmark;
    }

    public String capitalize(String orientation) {
        if (orientation != null) {
            if (orientation.equalsIgnoreCase("landscape")) {
                return "Landscape";
            }
            if (orientation.equalsIgnoreCase("portrait")) {
                return "Portrait";
            }
        }
        return null;
    }

    public boolean needOutputInMasterPage(IContent headerFooter) {
        if (headerFooter != null) {
            Collection list = headerFooter.getChildren();
            for (Object child : list) {
                if (child instanceof ITableContent) {
                    int columncount = ((ITableContent)child).getColumnCount();
                    int rowcount = ((ITableContent)child).getChildren().size();
                    if (columncount > 3 || rowcount > 1) {
                        logger.log(Level.WARNING, "ODS page header or footer only accept a table no more than 1 row and 3 columns.");
                        return false;
                    }
                    if (this.isEmbededTable((ITableContent)child)) {
                        logger.log(Level.WARNING, "ODS page header and footer don't support embeded grid.");
                        return false;
                    }
                }
                if (!this.isHtmlText(child)) continue;
                logger.log(Level.WARNING, "ODS page header and footer don't support html text.");
                return false;
            }
        }
        return true;
    }

    private boolean isHtmlText(Object child) {
        return child instanceof IForeignContent && "text/html".equalsIgnoreCase(((IForeignContent)child).getRawType());
    }

    private boolean isEmbededTable(ITableContent table) {
        boolean isEmbeded = false;
        Collection list = table.getChildren();
        for (Object child : list) {
            Collection listCell = ((IRowContent)child).getChildren();
            for (Object cellChild : listCell) {
                Collection listCellChild = ((ICellContent)cellChild).getChildren();
                for (Object cellchild : listCellChild) {
                    if (!(cellchild instanceof ITableContent)) continue;
                    isEmbeded = true;
                }
            }
        }
        return isEmbeded;
    }

    public TimeZone getTimeZone() {
        IReportContext reportContext;
        if (this.service != null && (reportContext = this.service.getReportContext()) != null) {
            return reportContext.getTimeZone();
        }
        return TimeZone.getDefault();
    }

    public void endContainer(IContainerContent container) {
        this.engine.removeContainerStyle();
    }

    public void startContainer(IContainerContent container) {
        this.engine.addContainerStyle(container.getComputedStyle());
    }

    protected String getRootMime() {
        return MIME_TYPE;
    }
}

