/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.helpers;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.Messages;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMapping;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.impl.helpers.AbstractExpensiveOperation;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchOperation
extends AbstractExpensiveOperation {
    private final IMatchPolicy _policy;
    private final IComparison.Editable _comparison;
    protected final Map<Role, Set<Object>> _duplicateIDs;
    protected final Set<Object> _duplicateCandidatesRole1;
    protected final Set<Object> _duplicateCandidatesRole2;

    public MatchOperation(IComparison.Editable comparison_p, IMatchPolicy policy_p, Map<Role, Set<Object>> duplicateIDs_p) {
        this._comparison = comparison_p;
        this._policy = policy_p;
        this._duplicateIDs = duplicateIDs_p;
        this._duplicateCandidatesRole1 = new HashSet<Object>(0);
        this._duplicateCandidatesRole2 = new HashSet<Object>(0);
    }

    protected Map<Object, EObject> createMatchIDToElementMap() {
        Comparator<?> comparator = this.getMatchPolicy().getMatchIDComparator();
        AbstractMap result = comparator == null ? new HashMap() : new TreeMap(comparator);
        return result;
    }

    protected Map<Object, EObject> explore(Role role_p, boolean fillIDMap_p) {
        Map<Object, Object> result = fillIDMap_p ? this.createMatchIDToElementMap() : Collections.emptyMap();
        IEditableModelScope scope = this.getComparison().getScope(role_p);
        boolean rememberMatchIDs = this.getMatchPolicy().keepMatchIDs();
        if (scope != null) {
            TreeIterator<EObject> it = scope.getAllContents();
            IMapping.Editable mapping = this.getComparison().getMapping();
            while (it.hasNext()) {
                EObject squatter;
                Object matchID;
                this.checkProgress();
                EObject current = (EObject)it.next();
                IMatch.Editable match = mapping.map(current, role_p);
                if (!rememberMatchIDs && !fillIDMap_p || (matchID = this.getMatchPolicy().getMatchID(current, scope)) == null) continue;
                if (rememberMatchIDs) {
                    match.setMatchID(matchID);
                }
                if (!fillIDMap_p || (squatter = result.put(matchID, current)) == null || squatter == current || this._duplicateIDs == null) continue;
                this._duplicateCandidatesRole1.add(matchID);
            }
        }
        return result;
    }

    protected Map<Object, EObject> exploreAndMatch(Role role_p, Map<Object, EObject> idRegistry1_p, Role secondaryRole1_p, Map<Object, EObject> idRegistry2_p, Role secondaryRole2_p, boolean fillIDMap_p) {
        Map<Object, Object> result = fillIDMap_p ? this.createMatchIDToElementMap() : Collections.emptyMap();
        IEditableModelScope scope = this.getComparison().getScope(role_p);
        boolean rememberMatchIDs = this.getMatchPolicy().keepMatchIDs();
        if (scope != null) {
            TreeIterator<EObject> targetIt = scope.getAllContents();
            IMapping.Editable mapping = this.getComparison().getMapping();
            while (targetIt.hasNext()) {
                this.checkProgress();
                EObject current = (EObject)targetIt.next();
                EObject counterpart1 = null;
                EObject counterpart2 = null;
                Object matchID = this.getMatchPolicy().getMatchID(current, scope);
                if (matchID != null) {
                    EObject squatter;
                    if (fillIDMap_p && (squatter = result.put(matchID, current)) != null && squatter != current && this._duplicateIDs != null) {
                        this._duplicateCandidatesRole2.add(matchID);
                    }
                    counterpart1 = idRegistry1_p.get(matchID);
                    EObject eObject = counterpart2 = idRegistry2_p != null ? idRegistry2_p.get(matchID) : null;
                }
                if (counterpart1 == null && counterpart2 == null) {
                    IMatch.Editable match = mapping.map(current, role_p);
                    if (!rememberMatchIDs) continue;
                    match.setMatchID(matchID);
                    continue;
                }
                boolean contradiction = false;
                if (counterpart1 != null) {
                    if (this._duplicateCandidatesRole1.contains(matchID) && this._duplicateIDs != null) {
                        this._duplicateIDs.get((Object)secondaryRole1_p).add(matchID);
                    }
                    contradiction = mapping.mapIncrementally(current, role_p, counterpart1, secondaryRole1_p);
                }
                if (counterpart2 != null) {
                    if (this._duplicateCandidatesRole2.contains(matchID) && this._duplicateIDs != null) {
                        this._duplicateIDs.get((Object)secondaryRole2_p).add(matchID);
                    }
                    boolean bl = contradiction = contradiction || mapping.mapIncrementally(current, role_p, counterpart2, secondaryRole2_p);
                }
                if (!contradiction || this._duplicateIDs == null) continue;
                this._duplicateIDs.get((Object)role_p).add(matchID);
            }
        }
        return result;
    }

    protected IMatchPolicy getMatchPolicy() {
        return this._policy;
    }

    public IComparison.Editable getComparison() {
        return this._comparison;
    }

    @Override
    public String getOperationName() {
        return Messages.MatchBuilder_Task_Main;
    }

    @Override
    protected int getWorkAmount() {
        return this._comparison.isThreeWay() ? 5 : 6;
    }

    protected void match() {
        Role firstSide = this.getComparison().getMapping().getOrderingRole();
        Role secondSide = firstSide.opposite();
        boolean threeWay = this._comparison.isThreeWay();
        this.getMonitor().subTask(Messages.MatchBuilder_Task_RegisteringIDs);
        Map<Object, EObject> firstSideIDRegistry = this.explore(firstSide, true);
        this.getMonitor().worked(1);
        this.getMonitor().subTask(Messages.MatchBuilder_Task_MappingIDs);
        Map<Object, EObject> secondSideIDRegistry = this.exploreAndMatch(secondSide, firstSideIDRegistry, firstSide, null, null, threeWay);
        this.getMonitor().worked(1);
        if (threeWay) {
            this.exploreAndMatch(Role.ANCESTOR, firstSideIDRegistry, firstSide, secondSideIDRegistry, secondSide, false);
            this.getMonitor().worked(1);
        }
        this._duplicateCandidatesRole1.clear();
        this._duplicateCandidatesRole2.clear();
    }

    @Override
    public IStatus run() {
        this.getMonitor().worked(1);
        this.match();
        IMapping.Editable mapping = this._comparison.getMapping();
        mapping.crossReference(Role.TARGET);
        this.getMonitor().worked(1);
        mapping.crossReference(Role.REFERENCE);
        this.getMonitor().worked(1);
        return Status.OK_STATUS;
    }
}

