/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.ui.internal.misc.StringMatcher;

public class DataSetFilter
extends ViewerFilter {
    private static final String DOTSTAR = ".*";
    private String m_search = null;
    private StringMatcher m_matcher = null;
    private Matcher m_regMatcher;

    public void setSearchText(String origText) {
        if (origText != null) {
            this.m_search = DOTSTAR + origText + DOTSTAR;
            try {
                Pattern p = Pattern.compile(this.m_search);
                this.m_regMatcher = p.matcher("");
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.m_regMatcher = null;
            }
        }
        String text = origText == null ? "*" : "*" + origText + "*";
        this.m_matcher = new StringMatcher(text, true, false);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (StringUtils.isEmpty((String)this.m_search) || !(element instanceof IDataSetPO)) {
            return true;
        }
        for (String value : ((IDataSetPO)element).getColumnStringValues()) {
            if (value == null) continue;
            if (this.m_regMatcher != null) {
                this.m_regMatcher.reset(value);
                if (!this.m_regMatcher.matches()) continue;
                return true;
            }
            if (this.m_matcher == null || !this.m_matcher.match(value)) continue;
            return true;
        }
        return false;
    }
}

