/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.pages;

import java.awt.im.InputContext;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.utils.Languages;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.factory.ControlFactory;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedProjectNameText;
import org.eclipse.jubula.client.ui.rcp.wizards.ProjectWizard;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.client.ui.widgets.I18nEnumCombo;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.html.Browser;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ProjectSettingWizardPage
extends WizardPage {
    private static final String EMPTY = "";
    private static final int NUM_COLUMNS_2 = 2;
    private static final String DEFAULT_TOOLKIT = "com.bredexsw.guidancer.ConcreteToolkitPlugin";
    private Composite m_mainComp;
    private Composite m_topComposite;
    private String m_newProjectName = null;
    private DirectCombo<String> m_projectToolKitComboBox;
    private Text m_projectNameTF;
    private Composite m_autExecutable;
    private Text m_autExecutableTF;
    private Button m_autExecButton;
    private Composite m_autUrl;
    private Text m_autUrlTF;
    private Composite m_autToolkit;
    private DirectCombo<String> m_autToolKitComboBox;
    private Composite m_browser;
    private I18nEnumCombo<Browser> m_browserComboBox;
    private Composite m_browserPath;
    private Text m_browserPathTF;
    private Button m_browserPathButton;
    private final WidgetSelectionListener m_selectionListener = new WidgetSelectionListener();
    private final WidgetModifyListener m_modifyListener = new WidgetModifyListener();
    private IAUTMainPO m_autMain;
    private IAUTConfigPO m_autConfig;
    private Button m_projectTemplate;

    public ProjectSettingWizardPage(String pageName, IAUTMainPO autMain, IAUTConfigPO autConfig) {
        super(pageName);
        this.setPageComplete(false);
        this.m_autMain = autMain;
        this.m_autConfig = autConfig;
    }

    public void createControl(Composite parent) {
        this.m_mainComp = UIComponentHelper.createLayoutComposite((Composite)parent);
        ((GridLayout)this.m_mainComp.getLayout()).marginWidth = 10;
        this.m_topComposite = UIComponentHelper.createLayoutComposite((Composite)this.m_mainComp);
        Composite bottomComp = UIComponentHelper.createLayoutComposite((Composite)this.m_mainComp);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 3;
        bottomComp.setLayoutData((Object)data);
        this.setMargin((GridLayout)bottomComp.getLayout());
        UIComponentHelper.createSeparator((Composite)this.m_topComposite, (int)2);
        this.setMessage(Messages.ProjectWizardNewProject);
        this.createProjectNameField();
        this.createProjectToolKit();
        Plugin.getHelpSystem().setHelp((Control)this.m_mainComp, "org.eclipse.jubula.client.ua.help.projectWizardContextId");
        this.createAutToolKit();
        this.createExecutableCommandField();
        this.createBrowserCombo();
        this.createBrowserPathField();
        this.validation();
        this.createProjectTemplateCheckBox(bottomComp);
        this.createNextLabel(bottomComp);
        this.setControl((Control)this.m_mainComp);
        this.handleProjectToolkitCombo();
    }

    private void createProjectNameField() {
        Composite line = this.createLineComposite();
        this.createLeftComposite(line, Messages.ProjectSettingWizardPageProjectName);
        Composite rightComp = this.createRightComposite(line);
        this.m_projectNameTF = this.createTextField(rightComp, Messages.ProjectSettingWizardPageDefaultProjectName, true);
        this.m_projectNameTF.setSelection(0, this.m_projectNameTF.getText().length());
        this.m_projectNameTF.addModifyListener((ModifyListener)this.m_modifyListener);
        this.m_projectNameTF.setData("TEST_COMP_NAME", (Object)"NewProjectWizard.ProjectNameTextField");
    }

    private void createExecutableCommandField() {
        this.m_autExecutable = this.createLineComposite();
        this.createLeftComposite(this.m_autExecutable, Messages.ProjectSettingWizardAUTExecutableCommand);
        Composite rightComp = this.createRightComposite(this.m_autExecutable, 2);
        this.m_autExecutableTF = this.createTextField(rightComp, null, false);
        this.m_autExecutableTF.addModifyListener((ModifyListener)this.m_modifyListener);
        this.m_autExecutableTF.setData("TEST_COMP_NAME", (Object)"NewProjectWizard.ExecutablePathField");
        this.m_autExecButton = this.createBrowseButton(rightComp);
        this.refresh();
    }

    private void createUrlField() {
        this.m_autUrl = this.createLineComposite();
        this.createLeftComposite(this.m_autUrl, Messages.ProjectSettingWizardAUTUrl);
        Composite rightComp = this.createRightComposite(this.m_autUrl);
        this.m_autUrlTF = this.createTextField(rightComp, null, false);
        this.m_autUrlTF.addModifyListener((ModifyListener)this.m_modifyListener);
        this.m_autUrlTF.setData("TEST_COMP_NAME", (Object)"NewProjectWizard.BrowserURLField");
        this.refresh();
    }

    private void createProjectToolKit() {
        Composite line = this.createLineComposite();
        this.createLeftComposite(line, Messages.ProjectSettingWizardPageProjectToolKitLabel, I18n.getString((String)"ControlDecorator.NewProjectToolkit"));
        Composite rightComp = this.createRightComposite(line);
        this.m_projectToolKitComboBox = ControlFactory.createToolkitCombo(rightComp);
        GridData comboGridData = new GridData();
        comboGridData.grabExcessHorizontalSpace = true;
        LayoutUtil.addToolTipAndMaxWidth((GridData)comboGridData, this.m_projectToolKitComboBox);
        this.m_projectToolKitComboBox.setLayoutData((Object)comboGridData);
        this.m_projectToolKitComboBox.setSelectedObject((Object)DEFAULT_TOOLKIT);
        this.m_projectToolKitComboBox.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_projectToolKitComboBox.setData("TEST_COMP_NAME", (Object)"NewProjectWizard.ProjectToolkit");
    }

    private void createAutToolKit() {
        this.m_autToolkit = this.createLineComposite();
        this.createLeftComposite(this.m_autToolkit, Messages.ProjectSettingWizardPageAutToolKitLabel, I18n.getString((String)"ControlDecorator.NewProjectAUTToolkit"));
        Composite rightComp = this.createRightComposite(this.m_autToolkit);
        try {
            this.m_autToolKitComboBox = ControlFactory.createAutToolkitCombo(rightComp, null, null, true);
            GridData comboGridData = new GridData();
            comboGridData.grabExcessHorizontalSpace = true;
            LayoutUtil.addToolTipAndMaxWidth((GridData)comboGridData, this.m_autToolKitComboBox);
            this.m_autToolKitComboBox.setLayoutData((Object)comboGridData);
            this.m_autToolKitComboBox.addSelectionListener((SelectionListener)this.m_selectionListener);
            this.m_autToolKitComboBox.setData("TEST_COMP_NAME", (Object)"NewProjectWizard.AutToolkit");
        }
        catch (ToolkitPluginException e) {
            e.printStackTrace();
            this.removeAutToolKit();
        }
        this.refresh();
    }

    private void createBrowserCombo() {
        this.m_browser = this.createLineComposite();
        this.createLeftComposite(this.m_browser, I18n.getString((String)"WebAutConfigComponent.browser"));
        Composite rightComp = this.createRightComposite(this.m_browser);
        this.m_browserComboBox = UIComponentHelper.createEnumCombo((Composite)rightComp, (int)2, (String)"WebAutConfigComponent.Browser", Browser.class);
        GridData comboGridData = new GridData();
        comboGridData.grabExcessHorizontalSpace = true;
        LayoutUtil.addToolTipAndMaxWidth((GridData)comboGridData, this.m_browserComboBox);
        this.m_browserComboBox.setLayoutData((Object)comboGridData);
        this.m_browserComboBox.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_browserComboBox.setData("TEST_COMP_NAME", (Object)"NewProjectWizard.BrowserComboBox");
        this.refresh();
    }

    private void createBrowserPathField() {
        this.m_browserPath = this.createLineComposite();
        this.createLeftComposite(this.m_browserPath, I18n.getString((String)"WebAutConfigComponent.browserPath"));
        Composite rightComp = this.createRightComposite(this.m_browserPath, 2);
        this.m_browserPathTF = this.createTextField(rightComp, null, false);
        this.m_browserPathTF.addModifyListener((ModifyListener)this.m_modifyListener);
        this.m_browserPathButton = this.createBrowseButton(rightComp);
        this.m_browserPathTF.setData("TEST_COMP_NAME", (Object)"NewProjectWizard.BrowserPathField");
        this.refresh();
    }

    private void createProjectTemplateCheckBox(Composite parent) {
        this.m_projectTemplate = new Button(parent, 32);
        this.m_projectTemplate.setText(Messages.ProjectWizardProjectTemplate);
        this.m_projectTemplate.setSelection(true);
        this.m_projectTemplate.addSelectionListener((SelectionListener)this.m_selectionListener);
        ControlDecorator.createInfo((Control)this.m_projectTemplate, Messages.ProjectWizardProjectTemplateInfo, false);
        this.m_projectTemplate.setData("TEST_COMP_NAME", (Object)"NewProjectWizard.ProjectTemplateCheckBox");
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 3;
        this.m_projectTemplate.setLayoutData((Object)data);
        this.refresh();
        this.createLeftComposite(parent, null);
    }

    private void createNextLabel(Composite parent) {
        Label nextLabel = UIComponentHelper.createLabelWithText((Composite)parent, (String)Messages.ProjectSettingWizardPageClickFinish);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 3;
        nextLabel.setLayoutData((Object)data);
        this.refresh();
    }

    private Button createBrowseButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(Messages.AUTConfigComponentBrowse);
        button.addSelectionListener((SelectionListener)this.m_selectionListener);
        GridData buttonGridData = new GridData();
        buttonGridData.grabExcessHorizontalSpace = false;
        buttonGridData.horizontalAlignment = 131072;
        button.setLayoutData((Object)buttonGridData);
        return button;
    }

    private Composite createLineComposite() {
        return UIComponentHelper.createLayoutComposite((Composite)this.m_topComposite, (int)2);
    }

    private Composite createLeftComposite(Composite parent, String text) {
        return this.createLeftComposite(parent, text, null);
    }

    private Composite createLeftComposite(Composite parent, String text, String info) {
        Label label;
        Composite comp = UIComponentHelper.createLayoutComposite((Composite)parent);
        this.setMargin((GridLayout)comp.getLayout());
        GridData rightGridData = (GridData)comp.getLayoutData();
        rightGridData.grabExcessHorizontalSpace = true;
        rightGridData.widthHint = 120;
        Label label2 = label = text != null ? UIComponentHelper.createLabelWithText((Composite)comp, (String)text) : null;
        if (info != null && label != null) {
            ControlDecorator.createInfo((Control)label, info, false);
        }
        return comp;
    }

    private Composite createRightComposite(Composite parent) {
        return this.createRightComposite(parent, 1);
    }

    private Composite createRightComposite(Composite parent, int column) {
        Composite comp = UIComponentHelper.createLayoutComposite((Composite)parent, (int)column);
        this.setMargin((GridLayout)comp.getLayout());
        GridData rightGridData = (GridData)comp.getLayoutData();
        rightGridData.grabExcessHorizontalSpace = true;
        rightGridData.widthHint = 500;
        return comp;
    }

    private Text createTextField(Composite parent, String text, boolean checked) {
        CheckedProjectNameText textField = checked ? new CheckedProjectNameText(parent, 2048) : new Text(parent, 2048);
        GridData textGridData = new GridData();
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.horizontalAlignment = 4;
        textField.setLayoutData(textGridData);
        LayoutUtil.setMaxChar((Text)textField);
        if (text != null) {
            textField.setText(text);
        }
        return textField;
    }

    private void removeAutToolKit() {
        if (this.m_autToolkit != null) {
            this.m_autToolkit.dispose();
            this.m_autToolkit = null;
        }
        this.m_autToolKitComboBox = null;
        this.refresh();
    }

    private void removeAutExecutable() {
        if (this.m_autExecutable != null) {
            this.m_autExecutable.dispose();
            this.m_autExecutable = null;
        }
        this.m_autExecutableTF = null;
        this.putConfigValue("EXECUTABLE", EMPTY);
        this.putConfigValue("WORKING_DIR", EMPTY);
        this.refresh();
    }

    private void removeAutUrl() {
        if (this.m_autUrl != null) {
            this.m_autUrl.dispose();
            this.m_autUrl = null;
        }
        this.m_autUrlTF = null;
        this.putConfigValue("AUT_ARGUMENTS", EMPTY);
        this.refresh();
    }

    private void removeBrowserCombo() {
        if (this.m_browser != null) {
            this.m_browser.dispose();
            this.m_browser = null;
        }
        this.m_browserComboBox = null;
        this.putConfigValue("BROWSER", EMPTY);
        this.refresh();
    }

    private void removeBrowserPathField() {
        if (this.m_browserPath != null) {
            this.m_browserPath.dispose();
            this.m_browserPath = null;
        }
        this.m_browserPathTF = null;
        this.putConfigValue("BROWSER_PATH", EMPTY);
        this.refresh();
    }

    private void handleAutConfig() {
        String projectToolkit = (String)this.m_projectToolKitComboBox.getSelectedObject();
        String autToolkit = this.m_autToolKitComboBox == null ? null : (String)this.m_autToolKitComboBox.getSelectedObject();
        boolean isPTConcret = projectToolkit.equals(DEFAULT_TOOLKIT);
        if (!isPTConcret || isPTConcret && autToolkit != null) {
            this.fillAutConfig();
        } else {
            this.cleanAutConfig();
        }
    }

    private void cleanAutConfig() {
        this.m_autMain.setName(EMPTY);
        this.putConfigValue("CONFIG_NAME", EMPTY);
        this.putConfigValue("AUT_ID", EMPTY);
        this.putConfigValue("SERVER", EMPTY);
    }

    private void fillAutConfig() {
        this.m_autMain.setName(this.m_newProjectName);
        String localhost = "localhost";
        Object[] strings = new String[]{this.m_newProjectName, localhost};
        String configName = NLS.bind((String)Messages.AUTConfigComponentDefaultAUTConfigName, (Object[])strings);
        this.putConfigValue("CONFIG_NAME", configName);
        this.putConfigValue("AUT_ID", this.m_newProjectName);
        this.putConfigValue("SERVER", localhost);
    }

    private void modifyProjectNameField() throws DialogValidationException {
        boolean isCorrect = true;
        String projectName = this.m_projectNameTF.getText();
        int projectNameLength = projectName.length();
        if (projectNameLength == 0 || projectName.startsWith(" ") || projectName.charAt(projectNameLength - 1) == ' ') {
            isCorrect = false;
        }
        if (isCorrect) {
            if (ProjectPM.doesProjectNameExist((String)projectName)) {
                throw new DialogValidationException(Messages.ProjectSettingWizardPageDoubleProjectName);
            }
        } else {
            throw new DialogValidationException(projectNameLength == 0 ? Messages.ProjectWizardEmptyProject : Messages.ProjectWizardNotValidProject);
        }
        this.m_newProjectName = projectName;
        this.handleAutConfig();
    }

    private String fileBrowser(String title, Text text, String[] extension) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 81920);
        fileDialog.setText(title);
        String filterPath = Utils.getLastDirPath();
        try {
            File path = new File(text.getText());
            if (path.exists()) {
                filterPath = path.isDirectory() ? path.getCanonicalPath() : new File(path.getParent()).getCanonicalPath();
            }
        }
        catch (IOException iOException) {}
        fileDialog.setFilterExtensions(extension);
        fileDialog.setFilterPath(filterPath);
        String directory = fileDialog.open();
        if (directory != null) {
            Utils.storeLastDirPath(fileDialog.getFilterPath());
        }
        return directory;
    }

    private void handleExecButtonEvent() {
        String directory = this.fileBrowser(Messages.AUTConfigComponentSelectExecutable, this.m_autExecutableTF, null);
        if (directory != null) {
            this.m_autExecutableTF.setText(directory);
            this.setWorkingDirToExecFilePath(directory);
            this.validation();
        }
    }

    private void handleBrowserPathButtonEvent() {
        String directory = this.fileBrowser(I18n.getString((String)"WebAutConfigComponent.SelectBrowserPath"), this.m_browserPathTF, null);
        if (directory != null) {
            this.m_browserPathTF.setText(directory);
            this.validation();
        }
    }

    private void setWorkingDirToExecFilePath(String file) {
        String execPath = EMPTY;
        File wd = new File(file);
        if (wd.isAbsolute() && wd.getParentFile() != null) {
            execPath = wd.getParentFile().getAbsolutePath();
        }
        this.putConfigValue("WORKING_DIR", execPath);
    }

    private void modifyExecutableTextField() {
        File file;
        String executable = EMPTY;
        if (this.m_autExecutableTF != null && !this.m_autExecutableTF.getText().isEmpty() && !(file = new File(executable = this.m_autExecutableTF.getText())).exists()) {
            this.warningMessage(Messages.AUTConfigComponentFileNotFound);
        }
        this.putConfigValue("EXECUTABLE", executable);
        this.setWorkingDirToExecFilePath(executable);
    }

    private void modifyUrlTextField() throws DialogValidationException {
        String urlText = EMPTY;
        if (this.m_autUrlTF != null && !this.m_autUrlTF.getText().isEmpty()) {
            try {
                new URL(this.m_autUrlTF.getText());
                urlText = this.m_autUrlTF.getText();
            }
            catch (MalformedURLException e) {
                throw new DialogValidationException(String.valueOf(I18n.getString((String)"WebAutConfigComponent.wrongUrl")) + "\n" + e.getMessage());
            }
        }
        this.putConfigValue("AUT_ARGUMENTS", urlText);
    }

    private void modifyBrowser() {
        String browser = this.m_browserComboBox == null || this.m_browserComboBox.getSelectedObject() == null ? EMPTY : ((Browser)this.m_browserComboBox.getSelectedObject()).toString();
        this.putConfigValue("BROWSER", browser);
    }

    private void modifyBrowserPathTextField() {
        File file;
        String txt = EMPTY;
        if (this.m_browserPathTF != null && !this.m_browserPathTF.getText().isEmpty() && !(file = new File(txt = this.m_browserPathTF.getText())).exists()) {
            this.warningMessage(Messages.AUTConfigComponentFileNotFound);
        }
        this.putConfigValue("BROWSER_PATH", txt);
    }

    private void noMessage() {
        this.setMessage(Messages.ProjectWizardNewProject);
    }

    private void errorMessage(String errorMessage) {
        if (errorMessage == null || errorMessage.isEmpty()) {
            return;
        }
        this.setMessage(errorMessage, 3);
    }

    private void warningMessage(String warningMessage) {
        if (warningMessage == null || warningMessage.isEmpty()) {
            return;
        }
        this.setMessage(warningMessage, 2);
    }

    protected void validation() {
        this.noMessage();
        this.setPageComplete(false);
        try {
            this.modifyProjectNameField();
            this.modifyUrlTextField();
            this.modifyExecutableTextField();
            this.modifyBrowser();
            this.modifyBrowserPathTextField();
            this.setPageComplete(true);
        }
        catch (DialogValidationException e) {
            e.errorMessageHandling();
        }
    }

    private boolean putConfigValue(String key, String value) {
        boolean areBothEmpty;
        String previousValue = StringUtils.defaultString((String)this.m_autConfig.getConfigMap().put(key, value));
        boolean wasEmpty = previousValue.length() == 0;
        boolean isEmpty = StringUtils.defaultString((String)value).length() == 0;
        boolean bl = areBothEmpty = wasEmpty && isEmpty;
        if (isEmpty) {
            this.m_autConfig.getConfigMap().remove(key);
        }
        return !areBothEmpty || !value.equals(previousValue);
    }

    private void handleProjectToolkitCombo() {
        String toolkit = (String)this.m_projectToolKitComboBox.getSelectedObject();
        this.removeAutToolKit();
        this.putConfigValue("KEYBOARD_LAYOUT", EMPTY);
        this.handleAutToolkitCombo(toolkit);
    }

    private void handleAutToolkitCombo(String toolkit) {
        this.m_autMain.setToolkit(toolkit);
        this.removeAutExecutable();
        this.removeAutUrl();
        this.removeBrowserCombo();
        this.removeBrowserPathField();
        if (toolkit == null) {
            return;
        }
        switch (toolkit) {
            case "com.bredexsw.guidancer.RcpToolkitPlugin": 
            case "com.bredexsw.guidancer.SwtToolkitPlugin": {
                this.keyboardLayout();
            }
            case "org.eclipse.jubula.JavaFXToolkitPlugin": 
            case "com.bredexsw.guidancer.SwingToolkitPlugin": {
                this.createExecutableCommandField();
                break;
            }
            case "com.bredexsw.guidancer.HtmlToolkitPlugin": {
                this.createUrlField();
                this.createBrowserCombo();
                break;
            }
            default: {
                this.m_autMain.setToolkit(null);
                this.createAutToolKit();
            }
        }
        this.validation();
    }

    private void handleBrowserCombo() {
        Browser browser = (Browser)this.m_browserComboBox.getSelectedObject();
        this.removeBrowserPathField();
        if (!browser.equals((Object)Browser.InternetExplorer)) {
            this.createBrowserPathField();
        }
    }

    private void keyboardLayout() {
        String local = InputContext.getInstance().getLocale().toString();
        local = Arrays.asList(Languages.getInstance().getKeyboardLayouts()).contains(local) ? local : Locale.getDefault().toString();
        this.putConfigValue("KEYBOARD_LAYOUT", local);
    }

    public ProjectWizard getWizard() {
        return (ProjectWizard)super.getWizard();
    }

    private void setMargin(GridLayout layout) {
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 20;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.jubula.client.ua.help.projectWizardContextId");
    }

    public String getNewProjectName() {
        return this.m_newProjectName;
    }

    public String getProjectToolkit() {
        return (String)this.m_projectToolKitComboBox.getSelectedObject();
    }

    public String getAutToolkit() {
        return this.m_autMain.getToolkit();
    }

    public boolean needProjectTamplet() {
        return this.m_projectTemplate.getSelection();
    }

    private void refresh() {
        if (this.m_projectNameTF.isVisible()) {
            this.getShell().pack(true);
        }
    }

    protected class DialogValidationException
    extends Exception {
        public DialogValidationException(String message) {
            super(message);
        }

        public void errorMessageHandling() {
            ProjectSettingWizardPage.this.setPageComplete(false);
            ProjectSettingWizardPage.this.errorMessage(super.getMessage());
        }
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ProjectSettingWizardPage.this.validation();
        }
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(ProjectSettingWizardPage.this.m_autExecButton)) {
                ProjectSettingWizardPage.this.handleExecButtonEvent();
            } else if (o.equals(ProjectSettingWizardPage.this.m_browserPathButton)) {
                ProjectSettingWizardPage.this.handleBrowserPathButtonEvent();
            } else if (o.equals(ProjectSettingWizardPage.this.m_projectToolKitComboBox)) {
                ProjectSettingWizardPage.this.handleProjectToolkitCombo();
                ProjectSettingWizardPage.this.validation();
            } else if (o.equals(ProjectSettingWizardPage.this.m_autToolKitComboBox)) {
                ProjectSettingWizardPage.this.handleAutToolkitCombo((String)ProjectSettingWizardPage.this.m_autToolKitComboBox.getSelectedObject());
                ProjectSettingWizardPage.this.validation();
            } else if (o.equals(ProjectSettingWizardPage.this.m_browserComboBox)) {
                ProjectSettingWizardPage.this.handleBrowserCombo();
                ProjectSettingWizardPage.this.validation();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

