/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.listener;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.ObjectMappedMessage;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.exception.NoIdentifierForComponentException;
import org.eclipse.jubula.rc.common.util.PropertyUtil;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.jubula.rc.swt.listener.AbstractAutSwtEventListener;
import org.eclipse.jubula.rc.swt.listener.ComponentHandler;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingListener
extends AbstractAutSwtEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(MappingListener.class);

    protected Color getBorderColor() {
        return new Color(null, 20, 170, 140);
    }

    public void handleEvent(final Event event) {
        Display display = ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay();
        if (display != null) {
            display.syncExec(new Runnable(){

                public void run() {
                    if (event.equals(MappingListener.this.getLastEvent())) {
                        return;
                    }
                    MappingListener.this.setLastEvent(event);
                    switch (event.type) {
                        case 3: 
                        case 5: 
                        case 6: 
                        case 30: {
                            MappingListener.this.setCurrentWidget();
                            MappingListener.this.highlightComponent();
                            break;
                        }
                        case 1: 
                        case 4: {
                            MappingListener.this.handleKeyEvent(event);
                            break;
                        }
                    }
                }
            });
        }
    }

    protected void handleKeyEvent(Event event) {
        Widget currComp;
        if (LOG.isInfoEnabled()) {
            LOG.info("handleKeyEvent: event = " + event.type);
        }
        if ((currComp = this.getCurrentComponent()) != null && this.getAcceptor().accept(event) == 1) {
            try {
                Shell toolshell = this.getTooltipShell();
                ArrayList<IComponentIdentifier> list = new ArrayList<IComponentIdentifier>();
                if (toolshell != null) {
                    Control[] controlArray = toolshell.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        try {
                            list.add(ComponentHandler.getIdentifier((Widget)control));
                        }
                        catch (Exception exception) {
                            LOG.info("no identifier for: " + control);
                        }
                        ++n2;
                    }
                }
                IComponentIdentifier id = ComponentHandler.getIdentifier(currComp);
                list.add(id);
                Map componentProperties = PropertyUtil.getMapOfComponentProperties((Object)currComp);
                if (LOG.isInfoEnabled()) {
                    LOG.info("send a message with identifier for the component '" + id + "'");
                }
                id.setComponentPropertiesMap(componentProperties);
                ObjectMappedMessage message = new ObjectMappedMessage();
                message.setComponentIdentifiers(list.toArray(new IComponentIdentifier[list.size()]));
                AUTServer.getInstance().getCommunicator().send((Message)message);
            }
            catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                LOG.error("no identifier for '" + currComp);
            }
            catch (CommunicationException ce) {
                LOG.error(ce.getLocalizedMessage(), (Throwable)ce);
            }
        }
    }

    private Shell getTooltipShell() {
        Shell toolshell = null;
        Shell[] shellArray = Display.getCurrent().getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if ((shell.getStyle() & 0x84004) == 540676) {
                toolshell = shell;
            }
            ++n2;
        }
        return toolshell;
    }
}

