/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.git.ui.connector;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.reflect.MethodUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.git.core.GitRepository;
import org.eclipse.mylyn.internal.git.ui.GetChangeSetDialog;
import org.eclipse.mylyn.versions.core.ChangeSet;
import org.eclipse.mylyn.versions.core.ScmCore;
import org.eclipse.mylyn.versions.core.ScmRepository;
import org.eclipse.mylyn.versions.core.spi.ScmConnector;
import org.eclipse.mylyn.versions.ui.spi.ScmConnectorUi;

public class GitConnectorUi
extends ScmConnectorUi {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.git.ui";

    public ChangeSet getChangeSet(ScmRepository repository, IResource resource) {
        Assert.isNotNull((Object)resource);
        IProject project = resource.getProject();
        Assert.isNotNull((Object)project);
        ScmConnector scmConnector = ScmCore.getConnector((IResource)resource);
        Assert.isNotNull((Object)scmConnector);
        if (!GitProvider.class.getName().equals(scmConnector.getProviderId())) {
            throw new RuntimeException("No Git connector: " + scmConnector.getProviderId());
        }
        GetChangeSetDialog dialog = new GetChangeSetDialog(null, project);
        int result = dialog.open();
        if (result == 0) {
            return dialog.getChangeSet();
        }
        return null;
    }

    public void showChangeSetInView(ChangeSet cs) {
        String objectId = cs.getId();
        GitRepository repo = (GitRepository)cs.getRepository();
        Repository repository = repo.getRepository();
        CommitEditor.openQuiet((RepositoryCommit)new RepositoryCommit(repository, this.getCommit(repository, objectId)));
    }

    private RevCommit getCommit(Repository repository, String objectId) {
        RevWalk revWalk = null;
        try {
            revWalk = new RevWalk(repository);
            RevCommit revCommit = revWalk.parseCommit((AnyObjectId)ObjectId.fromString((String)objectId));
            return revCommit;
        }
        catch (Exception e) {
            return null;
        }
        finally {
            if (revWalk != null) {
                this.release(revWalk);
            }
        }
    }

    private void release(RevWalk revWalk) {
        try {
            MethodUtils.invokeMethod((Object)revWalk, (String)"release", null);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            try {
                MethodUtils.invokeMethod((Object)revWalk, (String)"close", null);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Failed to release revWalk " + revWalk, (Throwable)e1));
            }
        }
    }
}

