/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AnalysisVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.BoxingAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.FieldingAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.NameManager;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoolean;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstant;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElementId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorNavigationProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorShadowPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInteger;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInvalid;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNull;
import org.eclipse.ocl.examples.codegen.cgmodel.CGReal;
import org.eclipse.ocl.examples.codegen.cgmodel.CGString;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGUnlimited;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.utilities.CGUtil;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;

public class CodeGenAnalyzer {
    protected final @NonNull CodeGenerator codeGenerator;
    protected final @NonNull NameManager nameManager;
    private @NonNull Map<ElementId, CGElementId> cgElementIds = new HashMap<ElementId, CGElementId>();
    protected final @NonNull CGBoolean cgFalse;
    protected final @NonNull CGBoolean cgTrue;
    private CGUnlimited cgUnlimited = null;
    private CGInvalid cgInvalid = null;
    protected final @NonNull CGNull cgNull;
    private final @NonNull Map<Number, CGInteger> cgIntegers = new HashMap<Number, CGInteger>();
    private final @NonNull Map<Number, CGReal> cgReals = new HashMap<Number, CGReal>();
    private final @NonNull Map<String, CGString> cgStrings = new HashMap<String, CGString>();

    public CodeGenAnalyzer(@NonNull CodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
        this.nameManager = codeGenerator.getNameManager();
        this.cgFalse = this.createCGBoolean(false);
        this.cgTrue = this.createCGBoolean(true);
        this.cgNull = this.createCGNull();
    }

    public void analyze(@NonNull CGElement cgRoot) {
        AnalysisVisitor analysisVisitor = this.codeGenerator.createAnalysisVisitor();
        cgRoot.accept(analysisVisitor);
        BoxingAnalyzer boxingAnalyzer = this.codeGenerator.createBoxingAnalyzer();
        cgRoot.accept(boxingAnalyzer);
        FieldingAnalyzer fieldingAnalyzer = this.codeGenerator.createFieldingAnalyzer();
        fieldingAnalyzer.analyze(cgRoot, false);
    }

    public @NonNull CGValuedElement createCGConstantExp(@NonNull CGConstant cgConstant) {
        CGConstantExp cgConstantExp = CGModelFactory.eINSTANCE.createCGConstantExp();
        cgConstantExp.setAst(cgConstant.getAst());
        cgConstantExp.setReferredConstant(cgConstant);
        cgConstantExp.setTypeId(cgConstant.getTypeId());
        return cgConstantExp;
    }

    public @NonNull CGConstantExp createCGConstantExp(@NonNull OCLExpression element, @NonNull CGConstant cgConstant) {
        CGConstantExp cgConstantExp = CGModelFactory.eINSTANCE.createCGConstantExp();
        cgConstantExp.setAst((Element)element);
        cgConstantExp.setReferredConstant(cgConstant);
        cgConstantExp.setTypeId(this.getTypeId(element.getTypeId()));
        return cgConstantExp;
    }

    protected @NonNull CGBoolean createCGBoolean(boolean booleanValue) {
        CGBoolean cgBoolean = CGModelFactory.eINSTANCE.createCGBoolean();
        this.setExplicitNames(cgBoolean, booleanValue);
        cgBoolean.setBooleanValue(booleanValue);
        cgBoolean.setTypeId(this.getTypeId((TypeId)TypeId.BOOLEAN));
        return cgBoolean;
    }

    protected @NonNull CGNull createCGNull() {
        CGNull cgNull = CGModelFactory.eINSTANCE.createCGNull();
        this.setExplicitNames(cgNull, null);
        cgNull.setTypeId(this.getTypeId((TypeId)TypeId.OCL_VOID));
        return cgNull;
    }

    public @NonNull CGExecutorOperation createExecutorOperation(@NonNull Operation asOperation) {
        OperationId operationId = asOperation.getOperationId();
        CGExecutorOperation cgOperation = CGModelFactory.eINSTANCE.createCGExecutorOperation();
        CGElementId cgOperationId = this.getElementId((ElementId)operationId);
        cgOperation.setTypeId(this.getTypeId(asOperation.getTypeId()));
        cgOperation.setUnderlyingOperationId(cgOperationId);
        cgOperation.setAst((Element)asOperation);
        cgOperation.setName(this.nameManager.getGlobalSymbolName(asOperation, new String[0]));
        cgOperation.getDependsOn().add(cgOperationId);
        return cgOperation;
    }

    public @NonNull CGExecutorProperty createExecutorOppositeProperty(@NonNull Property asProperty) {
        PropertyId propertyId = asProperty.getPropertyId();
        CGExecutorProperty cgProperty = null;
        CGElementId cgPropertyId = this.getElementId((ElementId)propertyId);
        Property asOppositeProperty = (Property)ClassUtil.nonNullState((Object)asProperty.getOpposite());
        if (asOppositeProperty.isIsComposite()) {
            cgPropertyId = this.getElementId((ElementId)asOppositeProperty.getPropertyId());
            cgProperty = CGModelFactory.eINSTANCE.createCGExecutorCompositionProperty();
            cgProperty.setUnderlyingPropertyId(cgPropertyId);
            cgProperty.setAst((Element)asOppositeProperty);
            cgProperty.setName("IMPPROPid_" + asOppositeProperty.getName());
            cgProperty.getDependsOn().add(cgPropertyId);
        } else {
            cgPropertyId = this.getElementId((ElementId)asOppositeProperty.getPropertyId());
            cgProperty = CGModelFactory.eINSTANCE.createCGExecutorOppositeProperty();
            cgProperty.setUnderlyingPropertyId(cgPropertyId);
            cgProperty.setAst((Element)asProperty);
            cgProperty.setName("IMPPROPid_" + asProperty.getName());
            cgProperty.getDependsOn().add(cgPropertyId);
        }
        return cgProperty;
    }

    public @NonNull CGExecutorProperty createExecutorProperty(@NonNull Property asProperty) {
        PropertyId propertyId = asProperty.getPropertyId();
        CGElementId cgPropertyId = this.getElementId((ElementId)propertyId);
        CGExecutorNavigationProperty cgProperty = CGModelFactory.eINSTANCE.createCGExecutorNavigationProperty();
        cgProperty.setUnderlyingPropertyId(cgPropertyId);
        cgProperty.setAst((Element)asProperty);
        cgProperty.setName("IMPPROPid_" + asProperty.getName());
        cgProperty.getDependsOn().add(cgPropertyId);
        return cgProperty;
    }

    public @NonNull CGExecutorShadowPart createExecutorShadowPart(@NonNull Property asProperty) {
        PropertyId propertyId = asProperty.getPropertyId();
        CGExecutorShadowPart cgPart = CGModelFactory.eINSTANCE.createCGExecutorShadowPart();
        CGElementId cgPropertyId = this.getElementId((ElementId)propertyId);
        cgPart.setUnderlyingPropertyId(cgPropertyId);
        cgPart.setAst((Element)asProperty);
        cgPart.setName("CTORid_" + asProperty.getName());
        cgPart.getDependsOn().add(cgPropertyId);
        return cgPart;
    }

    public @NonNull CGExecutorType createExecutorType(@NonNull Type asType) {
        TypeId typeId = asType.getTypeId();
        CGExecutorType cgType = CGModelFactory.eINSTANCE.createCGExecutorType();
        CGTypeId cgTypeId = this.getTypeId(typeId);
        cgType.setUnderlyingTypeId(cgTypeId);
        cgType.setAst((Element)asType);
        cgType.setName(this.getNameManager().getGlobalSymbolName(asType, new String[0]));
        cgType.getDependsOn().add(cgTypeId);
        return cgType;
    }

    public @NonNull CGBoolean getBoolean(boolean aBoolean) {
        return aBoolean ? this.cgTrue : this.cgFalse;
    }

    public @NonNull CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    public @NonNull CGElementId getElementId(@NonNull ElementId elementId) {
        CGElementId cgElementId = this.cgElementIds.get(elementId);
        if (cgElementId == null) {
            if (elementId instanceof TypeId) {
                return this.getTypeId((TypeId)elementId);
            }
            cgElementId = CGModelFactory.eINSTANCE.createCGElementId();
            cgElementId.setElementId(elementId);
            this.setNames(cgElementId, elementId);
            this.cgElementIds.put(elementId, cgElementId);
        }
        return cgElementId;
    }

    public @NonNull CGValuedElement getExpression(@Nullable CGValuedElement cgExpression) {
        if (cgExpression == null) {
            CGConstantExp cgLiteralExp = CGModelFactory.eINSTANCE.createCGConstantExp();
            cgLiteralExp.setReferredConstant(this.getInvalid());
            cgLiteralExp.setTypeId(this.getTypeId((TypeId)TypeId.OCL_INVALID));
            cgExpression = cgLiteralExp;
        }
        return cgExpression;
    }

    public @NonNull CGInteger getInteger(@NonNull Number aNumber) {
        CGInteger cgInteger = this.cgIntegers.get(aNumber);
        if (cgInteger == null) {
            cgInteger = CGModelFactory.eINSTANCE.createCGInteger();
            this.setNames(cgInteger, aNumber);
            cgInteger.setNumericValue(aNumber);
            cgInteger.setTypeId(this.getTypeId((TypeId)TypeId.INTEGER));
            this.cgIntegers.put(aNumber, cgInteger);
        }
        return cgInteger;
    }

    public @NonNull CGInvalid getInvalid() {
        CGInvalid cgInvalid2 = this.cgInvalid;
        if (cgInvalid2 == null) {
            this.cgInvalid = cgInvalid2 = CGModelFactory.eINSTANCE.createCGInvalid();
            this.setNames(cgInvalid2, ValueUtil.INVALID_VALUE);
            cgInvalid2.setTypeId(this.getTypeId((TypeId)TypeId.OCL_INVALID));
        }
        return cgInvalid2;
    }

    public @NonNull CGInvalid getInvalid(String messageTemplate, Object ... bindings) {
        CGInvalid cgInvalid = CGModelFactory.eINSTANCE.createCGInvalid();
        this.setNames(cgInvalid, ValueUtil.INVALID_VALUE);
        cgInvalid.setTypeId(this.getTypeId((TypeId)TypeId.OCL_INVALID));
        cgInvalid.setMessageTemplate(messageTemplate);
        Object[] objectArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            Object binding = objectArray[n2];
            cgInvalid.getBindings().add(binding);
            ++n2;
        }
        return cgInvalid;
    }

    public @NonNull CGNull getNull() {
        return this.cgNull;
    }

    public @NonNull CGReal getReal(@NonNull Number aNumber) {
        CGReal cgReal = this.cgReals.get(aNumber);
        if (cgReal == null) {
            cgReal = CGModelFactory.eINSTANCE.createCGReal();
            this.setNames(cgReal, aNumber);
            cgReal.setNumericValue(aNumber);
            cgReal.setTypeId(this.getTypeId((TypeId)TypeId.REAL));
            this.cgReals.put(aNumber, cgReal);
        }
        return cgReal;
    }

    public @NonNull CGString getString(@NonNull String aString) {
        CGString cgString = this.cgStrings.get(aString);
        if (cgString == null) {
            cgString = CGModelFactory.eINSTANCE.createCGString();
            this.setNames(cgString, aString);
            cgString.setStringValue(aString);
            cgString.setTypeId(this.getTypeId((TypeId)TypeId.STRING));
            this.cgStrings.put(aString, cgString);
        }
        return cgString;
    }

    public @NonNull NameManager getNameManager() {
        return (NameManager)ClassUtil.nonNullState((Object)this.nameManager);
    }

    public @NonNull CGTypeId getTypeId(@NonNull TypeId typeId) {
        CGElementId cgElementId = this.cgElementIds.get(typeId);
        CGTypeId cgTypeId = (CGTypeId)cgElementId;
        if (cgTypeId == null) {
            cgTypeId = CGModelFactory.eINSTANCE.createCGTypeId();
            cgTypeId.setElementId((ElementId)typeId);
            cgTypeId.setName(this.nameManager.getGlobalSymbolName(typeId, new String[0]));
            cgTypeId.setValueName((String)ClassUtil.nonNullState((Object)cgTypeId.getName()));
            this.cgElementIds.put((ElementId)typeId, cgTypeId);
        }
        return cgTypeId;
    }

    public @NonNull CGUnlimited getUnlimited() {
        CGUnlimited cgUnlimited2 = this.cgUnlimited;
        if (cgUnlimited2 == null) {
            this.cgUnlimited = cgUnlimited2 = CGModelFactory.eINSTANCE.createCGUnlimited();
            this.setNames(cgUnlimited2, ValueUtil.UNLIMITED_VALUE);
            cgUnlimited2.setTypeId(this.getTypeId((TypeId)TypeId.UNLIMITED_NATURAL));
        }
        return cgUnlimited2;
    }

    public @NonNull CGValuedElement replace(@NonNull CGValuedElement oldElement, @NonNull CGValuedElement newElement, String messageTemplate, Object ... bindings) {
        if (oldElement.isRequired() && newElement.isNull()) {
            newElement = this.getInvalid(messageTemplate, bindings);
        }
        return CGUtil.replace(oldElement, newElement);
    }

    public void setConstant(@NonNull CGValuedElement oldElement, @NonNull CGValuedElement aConstant) {
        CGConstantExp newElement = CGModelFactory.eINSTANCE.createCGConstantExp();
        newElement.setReferredConstant(aConstant);
        newElement.setTypeId(oldElement.getTypeId());
        newElement.setAst(oldElement.getAst());
        CGUtil.replace(oldElement, newElement);
    }

    public void setExplicitNames(@NonNull CGValuedElement cgValue, @Nullable Object anObject) {
        String name = this.nameManager.getExplicitName(anObject);
        cgValue.setName(name);
        cgValue.setValueName(name);
    }

    public void setNames(@NonNull CGValuedElement cgValue, @NonNull Object anObject) {
        String name = this.nameManager.getGlobalSymbolName(anObject, new String[0]);
        cgValue.setName(name);
        cgValue.setValueName(name);
    }
}

