/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.export.engine;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.core.editor.ModelSetServiceFactory;
import org.eclipse.papyrus.infra.core.resource.EditingDomainServiceFactory;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelsReader;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.DiSashModelManager;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.ILocalPageService;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceStartKind;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.gmfdiag.css.service.CssMarkerEventManagerService;
import org.eclipse.papyrus.infra.gmfdiag.css.service.MarkerToPseudoSelectorMappingService;
import org.eclipse.papyrus.infra.gmfdiag.export.Activator;
import org.eclipse.papyrus.infra.gmfdiag.export.DialogDisplayUtils;
import org.eclipse.papyrus.infra.gmfdiag.export.actions.ExportAllDiagramsParameter;
import org.eclipse.papyrus.infra.gmfdiag.export.engine.DiagramNameProvider;
import org.eclipse.papyrus.infra.gmfdiag.export.engine.ExportDiagramLocalPageService;
import org.eclipse.papyrus.infra.gmfdiag.export.messages.Messages;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.markerlistener.MarkersMonitorService;
import org.eclipse.papyrus.infra.services.semantic.service.SemanticService;
import org.eclipse.papyrus.infra.services.validation.IValidationMarkersService;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ExportAllDiagramsEngine {
    private IWorkbenchWindow workbenchWindow;
    private boolean displayRenamingInformation;
    private static boolean useDisplayRunnable = true;
    private BasicDiagnostic diagnostic = null;
    private boolean hasDuplicates = false;
    private ExportAllDiagramsParameter exportParameter = null;
    private DiagramNameProvider diagramNameProvider;

    public ExportAllDiagramsEngine() {
        try {
            this.workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        catch (IllegalStateException e) {
            this.workbenchWindow = null;
        }
    }

    public void initialise(ExportAllDiagramsParameter parameter) {
        this.diagnostic = new BasicDiagnostic(0, "", 0, Messages.ExportAllDiagrams_18, null);
        this.displayRenamingInformation = true;
        this.exportParameter = parameter;
    }

    public void exportDiagramsToImages() {
        WorkspaceJob job = new WorkspaceJob(Messages.ExportAllDiagrams_0){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                IProgressMonitor newMonitor = monitor;
                return ExportAllDiagramsEngine.this.export(newMonitor);
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private IStatus export(IProgressMonitor newMonitor) {
        IStatus status = Status.OK_STATUS;
        newMonitor.beginTask(Messages.ExportAllDiagrams_1, 10);
        newMonitor.subTask(Messages.ExportAllDiagrams_2);
        if (this.exportParameter != null) {
            ModelSet modelSet = this.exportParameter.getModelSet();
            try {
                SemanticService semanticService;
                IPageManager pageManager;
                if (modelSet == null) {
                    modelSet = this.initialiseModelSet();
                    if (this.diagnostic.getSeverity() != 0 || newMonitor.isCanceled()) {
                        IStatus iStatus = this.handleDiagnosticStatus();
                        return iStatus;
                    }
                    this.initialiseServiceRegistry(modelSet);
                    if (this.diagnostic.getSeverity() != 0 || newMonitor.isCanceled()) {
                        IStatus iStatus = this.handleDiagnosticStatus();
                        return iStatus;
                    }
                }
                try {
                    pageManager = (IPageManager)ServiceUtilsForResourceSet.getInstance().getService(IPageManager.class, (Object)modelSet);
                    semanticService = (SemanticService)ServiceUtilsForResourceSet.getInstance().getService(SemanticService.class, (Object)modelSet);
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                    Status status2 = new Status(4, "org.eclipse.papyrus.infra.gmfdiag.export", "Failed to obtain required services.", (Throwable)e);
                    if (this.exportParameter.getModelSet() == null) {
                        modelSet.unload();
                    }
                    return status2;
                }
                if (this.diagnostic.getSeverity() != 0 || newMonitor.isCanceled()) {
                    IStatus iStatus = this.handleDiagnosticStatus();
                    return iStatus;
                }
                List<Diagram> diagrams = Stream.of(semanticService.getSemanticRoots()).map(ExportDiagramLocalPageService::new).flatMap(service -> pageManager.allLocalPages((ILocalPageService)service).stream()).filter(Diagram.class::isInstance).map(Diagram.class::cast).distinct().collect(Collectors.toList());
                if (newMonitor.isCanceled()) {
                    IStatus iStatus = this.handleDiagnosticStatus();
                    return iStatus;
                }
                newMonitor.worked(1);
                this.export((IProgressMonitor)new SubProgressMonitor(newMonitor, 9), diagrams);
            }
            finally {
                if (this.exportParameter.getModelSet() == null) {
                    modelSet.unload();
                }
            }
        }
        status = new Status(4, "org.eclipse.papyrus.infra.gmfdiag.export", Messages.ExportAllDiagrams_17);
        return status;
    }

    private IStatus handleDiagnosticStatus() {
        this.diagnostic.recomputeSeverity();
        return BasicDiagnostic.toIStatus((Diagnostic)this.diagnostic);
    }

    private ModelSet initialiseModelSet() {
        ExtensionServicesRegistry service = null;
        try {
            service = new ExtensionServicesRegistry();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            service = new ServicesRegistry();
        }
        ServiceDescriptor descriptor = new ServiceDescriptor(ModelSet.class, ModelSetServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10);
        descriptor.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        service.add(descriptor);
        descriptor = new ServiceDescriptor(TransactionalEditingDomain.class, EditingDomainServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10, Collections.singletonList(ModelSet.class.getName()));
        descriptor.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        service.add(descriptor);
        try {
            service.startServicesByClassKeys(new Class[]{ModelSet.class, TransactionalEditingDomain.class});
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        ModelSet modelSet = null;
        try {
            modelSet = ServiceUtils.getInstance().getModelSet((Object)service);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (modelSet == null) {
            modelSet = new ModelSet();
            try {
                ModelSetServiceFactory.setServiceRegistry((ResourceSet)modelSet, (ServicesRegistry)service);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        ModelsReader modelsReader = new ModelsReader();
        modelsReader.readModel(modelSet);
        try {
            modelSet.loadModels(this.exportParameter.getDiFileUri());
        }
        catch (ModelMultiException e) {
            this.diagnostic = new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.export", 0, Messages.ExportAllDiagrams_3, new Object[]{e});
        }
        modelSet.getTransactionalEditingDomain();
        return modelSet;
    }

    private void initialiseServiceRegistry(ModelSet modelSet) {
        ServicesRegistry service = ModelSetServiceFactory.getServiceRegistry((ResourceSet)modelSet);
        try {
            if (service == null) {
                service = new ExtensionServicesRegistry();
                this.startModelSetServices(modelSet, service);
            }
            this.startCSSServices(service);
            this.startModelerServices(service);
        }
        catch (ServiceException e) {
            this.diagnostic = new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.export", 0, "Failed to load models", new Object[]{e});
        }
    }

    private void startModelSetServices(ModelSet modelSet, ServicesRegistry service) throws ServiceException {
        service.add(ModelSet.class, 10, (Object)modelSet);
        service.startServicesByClassKeys(new Class[]{ModelSet.class});
    }

    private void startModelerServices(ServicesRegistry service) throws ServiceException {
        service.startServicesByClassKeys(new Class[]{DiSashModelManager.class, IPageManager.class, SemanticService.class});
    }

    private void startCSSServices(ServicesRegistry service) throws ServiceException {
        service.startServicesByClassKeys(new Class[]{MarkersMonitorService.class, CssMarkerEventManagerService.class, MarkerToPseudoSelectorMappingService.class, IValidationMarkersService.class, DecorationService.class});
    }

    public void export(IProgressMonitor newMonitor, List<Diagram> diagrams) {
        int tasksAmount = 9;
        if (this.exportParameter.getModelSet() == null) {
            ++tasksAmount;
        }
        newMonitor.beginTask(Messages.ExportAllDiagrams_4, tasksAmount);
        this.diagramNameProvider = new DiagramNameProvider(diagrams, this.exportParameter.isQualifiedName());
        this.diagramNameProvider.getDiagnostic().forEach(arg_0 -> ((BasicDiagnostic)this.diagnostic).addAll(arg_0));
        this.createDiagramFiles((IProgressMonitor)new SubProgressMonitor(newMonitor, 9), diagrams);
        if (this.exportParameter.getModelSet() == null) {
            this.unloadResources((IProgressMonitor)new SubProgressMonitor(newMonitor, 1), diagrams);
        }
        if (this.displayRenamingInformation && diagrams.stream().anyMatch(this.diagramNameProvider::hasDuplicates)) {
            String message = Messages.ExportAllDiagrams_5;
            if (this.workbenchWindow != null && this.workbenchWindow.getShell() != null) {
                BasicDiagnostic newDiagnostic = new BasicDiagnostic(2, "", 0, message, null);
                this.diagnostic.add((Diagnostic)newDiagnostic);
            } else {
                Activator.log.info(message);
            }
        }
        this.handleExportDiagnostic();
    }

    private void handleExportDiagnostic() {
        int severity = this.diagnostic.recomputeSeverity();
        if (severity == 4) {
            BasicDiagnostic oldDiagnostic = this.diagnostic;
            this.diagnostic = new BasicDiagnostic(4, "", 0, Messages.ExportAllDiagrams_22, null);
            this.diagnostic.addAll((Diagnostic)oldDiagnostic);
        } else if (severity == 2) {
            BasicDiagnostic oldDiagnostic = this.diagnostic;
            this.diagnostic = new BasicDiagnostic(2, "", 0, Messages.ExportAllDiagrams_24, null);
            this.diagnostic.addAll((Diagnostic)oldDiagnostic);
        }
        if (this.workbenchWindow != null && this.workbenchWindow.getShell() != null && this.exportParameter.isDisplayStatus()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (ExportAllDiagramsEngine.this.diagnostic.getSeverity() == 0) {
                        MessageDialog.openInformation((Shell)DialogDisplayUtils.getActiveWorkbenchShell(), (String)Messages.ExportAllDiagrams_25, (String)(String.valueOf(Messages.ExportAllDiagrams_26) + ExportAllDiagramsEngine.this.exportParameter.getOutputDirectoryPath()));
                    } else {
                        DiagnosticDialog.open((Shell)DialogDisplayUtils.getActiveWorkbenchShell(), (String)Messages.ExportAllDiagrams_27, (String)"", (Diagnostic)ExportAllDiagramsEngine.this.diagnostic);
                    }
                }
            });
        }
    }

    private void createDiagramFiles(final IProgressMonitor newMonitor, List<Diagram> diagrams) {
        try {
            final Map<Diagram, String> diagramNames = this.diagramNameProvider.getDiagramNames();
            try {
                newMonitor.beginTask(Messages.ExportAllDiagrams_7, diagrams.size());
                for (final Diagram diagram : diagrams) {
                    if (!newMonitor.isCanceled()) {
                        String uniqueFileName;
                        final String finalUniqueFileName = uniqueFileName = diagramNames.get(diagram);
                        newMonitor.subTask(uniqueFileName);
                        if (useDisplayRunnable) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ExportAllDiagramsEngine.this.exportDiagram(finalUniqueFileName, diagram, newMonitor, diagramNames);
                                }
                            });
                        } else {
                            this.exportDiagram(uniqueFileName, diagram, newMonitor, diagramNames);
                        }
                        newMonitor.worked(1);
                        continue;
                    }
                    break;
                }
            }
            catch (SWTError e) {
                String message = Messages.ExportAllDiagrams_9;
                Activator.log.error(message, (Throwable)new Exception(message, e));
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    private void exportDiagram(String uniqueFileName, Diagram diagram, IProgressMonitor newMonitor, Map<Diagram, String> diagramNames) {
        CopyToImageUtil copyImageUtil = new CopyToImageUtil();
        Path imagePath = new Path(String.valueOf(this.exportParameter.getOutputDirectoryPath()) + File.separator + uniqueFileName);
        imagePath = imagePath.addFileExtension(this.exportParameter.getExportFormat().getName());
        try {
            copyImageUtil.copyToImage(diagram, (IPath)imagePath, this.exportParameter.getExportFormat(), (IProgressMonitor)new SubProgressMonitor(newMonitor, 1), PreferencesHint.USE_DEFAULTS);
        }
        catch (Throwable e) {
            BasicDiagnostic newDiagnostic = new BasicDiagnostic(4, "", 0, String.format(Messages.ExportAllDiagrams_11, uniqueFileName, diagram.eResource().getURI().toString()), null);
            this.diagnostic.add((Diagnostic)newDiagnostic);
            String errorMessage = String.format(Messages.ExportAllDiagrams_11, uniqueFileName, diagram.eResource().getURI().toString());
            Activator.log.error(errorMessage, e);
        }
    }

    public void unloadResources(IProgressMonitor newMonitor, List<Diagram> diagrams) {
        if (newMonitor == null) {
            newMonitor = new NullProgressMonitor();
        }
        newMonitor.subTask(Messages.ExportAllDiagrams_12);
        if (diagrams != null && !diagrams.isEmpty()) {
            ResourceSet diagramResourceSet = diagrams.get(0).eResource().getResourceSet();
            newMonitor.beginTask(Messages.ExportAllDiagrams_13, diagramResourceSet.getResources().size());
            int i = diagramResourceSet.getResources().size() - 1;
            while (i >= 0) {
                try {
                    Resource resource = (Resource)diagramResourceSet.getResources().get(i);
                    if (resource.isLoaded()) {
                        resource.unload();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                newMonitor.worked(1);
                --i;
            }
        }
    }
}

