/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.BorderedBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.XYLayoutWithConstrainedResizedEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetMoveAllLineAtSamePositionCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CLifeLineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionUseEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.BoundForEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.DisplayEvent;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GridManagementEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.IGrillingEditpolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.ExecutionSpecificationUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.papyrus.uml.service.types.element.UMLDIElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;

public class LifeLineXYLayoutEditPolicy
extends XYLayoutWithConstrainedResizedEditPolicy
implements IGrillingEditpolicy {
    protected DisplayEvent displayEvent;

    public void setHost(EditPart host) {
        super.setHost(host);
        this.displayEvent = new DisplayEvent(this.getHost());
    }

    protected Command getChangeConstraintCommand(ChangeBoundsRequest request) {
        request.setConstrainedResize(false);
        return super.getChangeConstraintCommand(request);
    }

    protected Object getConstraintFor(CreateRequest request) {
        CreateViewAndElementRequest req;
        CreateViewAndElementRequest.ViewAndElementDescriptor descriptor;
        IElementType elementType;
        Object constraint = super.getConstraintFor(request);
        if (request instanceof CreateViewAndElementRequest && (ElementUtil.isTypeOf((IElementType)(elementType = (IElementType)(descriptor = (req = (CreateViewAndElementRequest)request).getViewAndElementDescriptor()).getElementAdapter().getAdapter(IElementType.class)), (IElementType)UMLDIElementTypes.ACTION_EXECUTION_SPECIFICATION_SHAPE) || ElementUtil.isTypeOf((IElementType)elementType, (IElementType)UMLDIElementTypes.BEHAVIOR_EXECUTION_SPECIFICATION_SHAPE))) {
            Rectangle parentBound = this.getHostFigure().getBounds();
            if (constraint instanceof Rectangle) {
                Rectangle constraintRect = (Rectangle)constraint;
                RootEditPart drep = this.getHost().getRoot();
                if (drep instanceof DiagramRootEditPart) {
                    double spacing = ((DiagramRootEditPart)drep).getGridSpacing();
                    if (constraintRect.height == -1) {
                        constraintRect.height = AbstractExecutionSpecificationEditPart.DEFAUT_HEIGHT;
                    }
                    constraintRect.width = AbstractExecutionSpecificationEditPart.DEFAUT_WIDTH;
                    constraintRect.x = parentBound.width / 2 - constraintRect.width / 2;
                    constraintRect = ExecutionSpecificationUtil.calculateExecutionSpecificationCorrectLocation((CLifeLineEditPart)this.getHost(), constraintRect, null);
                    if (DiagramEditPartsUtil.isSnapToGridActive((EditPart)this.getHost())) {
                        int modulo = AbstractExecutionSpecificationEditPart.DEFAUT_HEIGHT / (int)spacing;
                        constraintRect.height = modulo * (int)spacing;
                    }
                    constraint = constraintRect;
                }
            }
        }
        return constraint;
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        if (child instanceof BorderedBorderItemEditPart) {
            Rectangle constraint = new Rectangle(child.getFigure().getBounds());
            return constraint;
        }
        return super.getConstraintFor(request, child);
    }

    protected void showLayoutTargetFeedback(Request request) {
        RootEditPart drep = this.getHost().getRoot();
        Rectangle parentBound = this.getHostFigure().getBounds().getCopy();
        this.getHostFigure().getParent().translateToAbsolute((Translatable)parentBound);
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "LifeLineBounds On Screen:" + parentBound);
        if (drep instanceof DiagramRootEditPart) {
            IElementType elementType;
            double spacing = ((DiagramRootEditPart)drep).getGridSpacing();
            if (request instanceof AspectUnspecifiedTypeCreationTool.CreateAspectUnspecifiedTypeRequest && (ElementUtil.isTypeOf((IElementType)(elementType = (IElementType)((AspectUnspecifiedTypeCreationTool.CreateAspectUnspecifiedTypeRequest)request).getElementTypes().get(0)), (IElementType)UMLDIElementTypes.ACTION_EXECUTION_SPECIFICATION_SHAPE) || ElementUtil.isTypeOf((IElementType)elementType, (IElementType)UMLDIElementTypes.BEHAVIOR_EXECUTION_SPECIFICATION_SHAPE))) {
                ((CreateRequest)request).setLocation(new Point(parentBound.x + parentBound.width / 2 - AbstractExecutionSpecificationEditPart.DEFAUT_WIDTH / 2, ((CreateRequest)request).getLocation().y));
                int modulo = AbstractExecutionSpecificationEditPart.DEFAUT_HEIGHT / (int)spacing;
                ((CreateRequest)request).setSize(new Dimension(AbstractExecutionSpecificationEditPart.DEFAUT_WIDTH, modulo * (int)spacing));
                this.displayEvent.addFigureEvent(this.getHostFigure().getParent().getParent(), ((CreateRequest)request).getLocation());
            }
            if (request instanceof ChangeBoundsRequest) {
                ((ChangeBoundsRequest)request).setMoveDelta(new Point(0, ((ChangeBoundsRequest)request).getMoveDelta().y));
            }
        }
        super.showLayoutTargetFeedback(request);
    }

    protected void addFeedback(IFigure figure) {
        super.addFeedback(figure);
    }

    protected void removeFeedback(IFigure figure) {
        this.displayEvent.removeFigureEvent(this.getHostFigure().getParent().getParent());
        super.removeFeedback(figure);
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        RootEditPart drep;
        Rectangle newBounds = (Rectangle)constraint;
        View shapeView = (View)child.getModel();
        CompoundCommand subCommand = new CompoundCommand("Edit Execution Specification positions");
        if (child instanceof AbstractExecutionSpecificationEditPart && (drep = this.getHost().getRoot()) instanceof DiagramRootEditPart) {
            Rectangle initialRectangle = null;
            Object view = ((AbstractExecutionSpecificationEditPart)child).getModel();
            if (view instanceof Node) {
                Bounds bounds = BoundForEditPart.getBounds((Node)view);
                initialRectangle = new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            }
            double spacing = ((DiagramRootEditPart)drep).getGridSpacing();
            Rectangle parentBound = this.getHostFigure().getBounds();
            newBounds.setLocation(new Point(parentBound.width / 2 - AbstractExecutionSpecificationEditPart.DEFAUT_WIDTH / 2, newBounds.getLocation().y));
            CLifeLineEditPart lifeLineEditPart = (CLifeLineEditPart)this.getHost();
            Map<AbstractExecutionSpecificationEditPart, Rectangle> executionSpecificationRectangles = ExecutionSpecificationUtil.getRectangles(lifeLineEditPart);
            Rectangle boundsToRectangle = null;
            CompoundCommand compoundCommand = null;
            do {
                boundsToRectangle = ExecutionSpecificationUtil.calculateExecutionSpecificationCorrectLocation(lifeLineEditPart, executionSpecificationRectangles, new Rectangle(newBounds.x, newBounds.y, newBounds.width, newBounds.height), child);
                if (boundsToRectangle.height == -1) {
                    boundsToRectangle.height = AbstractExecutionSpecificationEditPart.DEFAUT_HEIGHT;
                }
                if (DiagramEditPartsUtil.isSnapToGridActive((EditPart)this.getHost())) {
                    int modulo = boundsToRectangle.height / (int)spacing;
                    boundsToRectangle.setSize(new Dimension(AbstractExecutionSpecificationEditPart.DEFAUT_WIDTH, modulo * (int)spacing));
                }
                if ((compoundCommand = ExecutionSpecificationUtil.getExecutionSpecificationToMove(lifeLineEditPart, executionSpecificationRectangles, initialRectangle, boundsToRectangle, child)) == null || compoundCommand.isEmpty()) continue;
                subCommand.add((Command)compoundCommand);
            } while (compoundCommand != null && !compoundCommand.isEmpty());
            newBounds.setBounds(boundsToRectangle);
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        SetBoundsCommand boundsCommand = new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)shapeView), newBounds);
        CompoundCommand compoundCommand = new CompoundCommand();
        compoundCommand.add((Command)new ICommandProxy((ICommand)boundsCommand));
        if (!subCommand.isEmpty()) {
            compoundCommand.add((Command)subCommand);
        }
        return compoundCommand;
    }

    protected Command getCreateCommand(CreateRequest request) {
        request.setLocation(this.displayEvent.getRealEventLocation(request.getLocation()));
        DiagramEditPart diagramEditPart = this.getDiagramEditPart(this.getHost());
        GridManagementEditPolicy grid = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
        if (grid != null) {
            CompoundCommand cmd = new CompoundCommand();
            SetMoveAllLineAtSamePositionCommand setMoveAllLineAtSamePositionCommand = new SetMoveAllLineAtSamePositionCommand(grid, false);
            cmd.add((Command)setMoveAllLineAtSamePositionCommand);
            cmd.add(super.getCreateCommand(request));
            setMoveAllLineAtSamePositionCommand = new SetMoveAllLineAtSamePositionCommand(grid, true);
            cmd.add((Command)setMoveAllLineAtSamePositionCommand);
            return cmd;
        }
        return super.getCreateCommand(request);
    }

    public Command getCommand(Request request) {
        CompoundCommand cmd = new CompoundCommand();
        Command superCmd = super.getCommand(request);
        if (superCmd != null && superCmd.canExecute()) {
            cmd.add(superCmd);
        }
        if ("resize".equals(request.getType()) && request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest boundsReq = (ChangeBoundsRequest)request;
            Dimension sizeDelta = boundsReq.getSizeDelta();
            List children = this.getHost().getChildren();
            for (EditPart child : children) {
                Command moveChildrenCmd = null;
                if (child instanceof AbstractExecutionSpecificationEditPart) {
                    AbstractExecutionSpecificationEditPart ES = (AbstractExecutionSpecificationEditPart)child;
                    ChangeBoundsRequest moveESRequest = new ChangeBoundsRequest((Object)"resize");
                    moveESRequest.setEditParts((EditPart)ES);
                    moveESRequest.setResizeDirection(boundsReq.getResizeDirection());
                    moveESRequest.setMoveDelta(new Point(sizeDelta.width() / 2, 0));
                    moveChildrenCmd = ES.getCommand((Request)moveESRequest);
                }
                if (moveChildrenCmd == null || !moveChildrenCmd.canExecute()) continue;
                cmd.add(moveChildrenCmd);
            }
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    protected Command createAddCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (child instanceof LifelineEditPart || child instanceof CombinedFragmentEditPart || child instanceof InteractionUseEditPart) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.createAddCommand(request, child, constraint);
    }

    public void showTargetFeedback(Request request) {
        ChangeBoundsRequest changeBoundsRequest;
        if (request instanceof ChangeBoundsRequest && (changeBoundsRequest = (ChangeBoundsRequest)request).getEditParts().get(0) instanceof LifelineEditPart) {
            changeBoundsRequest.setMoveDelta(new Point(changeBoundsRequest.getMoveDelta().x, 0));
        }
        super.showTargetFeedback(request);
    }
}

