/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.UMLPackage;

public class ComponentEditHelper
extends ElementEditHelper {
    public ComponentEditHelper() {
        this.getDefaultContainmentFeatures().put(UMLPackage.eINSTANCE.getClassifier(), UMLPackage.eINSTANCE.getComponent_PackagedElement());
    }

    protected ICommand getCreateCommand(CreateElementRequest req) {
        EObject owner = req.getContainer();
        EReference eref = req.getContainmentFeature();
        if (owner instanceof Component && eref == UMLPackage.eINSTANCE.getClass_NestedClassifier() && req.getElementType().getEClass() == UMLPackage.eINSTANCE.getComponent()) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCreateCommand(req);
    }

    protected ICommand getMoveCommand(MoveRequest req) {
        for (Object elementToMove : req.getElementsToMove().keySet()) {
            EReference ref = req.getTargetFeature((EObject)elementToMove);
            if (ref == null) {
                ref = this.computeContainmentFeature((EObject)elementToMove, req);
            }
            if (!(elementToMove instanceof Component) || !UMLPackage.eINSTANCE.getClass_NestedClassifier().equals(req.getTargetFeature((EObject)elementToMove))) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return super.getMoveCommand(req);
    }

    private EReference computeContainmentFeature(EObject elementToMove, MoveRequest req) {
        if (!(req.getTargetContainer() instanceof Component)) {
            return null;
        }
        if (!(elementToMove instanceof Component)) {
            return null;
        }
        IHintedType type = UMLElementTypes.COMPONENT;
        EReference containmentFeature = this.computeContainmentFeature((IElementType)type, req.getTargetContainer(), req.getEditHelperContext());
        req.setTargetFeature(elementToMove, containmentFeature);
        return req.getTargetFeature(elementToMove);
    }

    protected ICommand getSetCommand(SetRequest req) {
        EObject eobject = req.getElementToEdit();
        if (eobject instanceof Component && UMLPackage.eINSTANCE.getComponent_PackagedElement().equals(req.getFeature())) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getSetCommand(req);
    }
}

