/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.pde.api.tools.internal.builder.AbstractTypeLeakDetector;
import org.eclipse.pde.api.tools.internal.model.MethodKey;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;

public class LeakExtendsProblemDetector
extends AbstractTypeLeakDetector {
    int problemFlags = 1;

    public LeakExtendsProblemDetector(Set<String> nonApiPackageNames) {
        super(nonApiPackageNames);
    }

    @Override
    public int getReferenceKinds() {
        return 1;
    }

    @Override
    protected String getSeverityKey() {
        return "LEAK_EXTEND";
    }

    @Override
    protected int getProblemFlags(IReference reference) {
        return this.problemFlags;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isProblem(IReference reference) {
        boolean isProb = super.isProblem(reference);
        this.problemFlags = 1;
        if (!isProb) {
            IApiMember member = reference.getResolvedReference();
            IApiMember sourceMember = reference.getMember();
            try {
                IApiAnnotations annotations = member.getApiComponent().getApiDescription().resolveAnnotations(member.getHandle());
                if (annotations != null) {
                    IApiAnnotations annotationsSource;
                    if (RestrictionModifiers.isExtendRestriction(annotations.getRestrictions()) && (annotationsSource = member.getApiComponent().getApiDescription().resolveAnnotations(sourceMember.getHandle())) != null && !RestrictionModifiers.isExtendRestriction(annotationsSource.getRestrictions()) && !Flags.isFinal((int)sourceMember.getModifiers())) {
                        this.problemFlags = 15;
                        return true;
                    }
                    if (RestrictionModifiers.isImplementRestriction(annotations.getRestrictions()) && (annotationsSource = member.getApiComponent().getApiDescription().resolveAnnotations(sourceMember.getHandle())) != null && !RestrictionModifiers.isImplementRestriction(annotationsSource.getRestrictions())) {
                        return true;
                    }
                }
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
        if (!isProb) return false;
        IApiType type = (IApiType)reference.getMember();
        IApiComponent component = type.getApiComponent();
        try {
            if (!type.isClass()) return true;
            int modifiers = 0;
            IApiAnnotations annotations = component.getApiDescription().resolveAnnotations(type.getHandle());
            if (annotations == null) return false;
            modifiers = RestrictionModifiers.isExtendRestriction(annotations.getRestrictions()) ? 1 : (Flags.isFinal((int)type.getModifiers()) ? 1 : 5);
            IApiType nonApiSuper = type.getSuperclass();
            HashSet<MethodKey> methods = new HashSet<MethodKey>();
            while (!this.isAPIType(nonApiSuper)) {
                if (this.hasVisibleField(nonApiSuper, modifiers)) {
                    return true;
                }
                this.gatherVisibleMethods(nonApiSuper, methods, modifiers);
                nonApiSuper = nonApiSuper.getSuperclass();
            }
            if (methods.size() <= 0) return false;
            LinkedList<IApiType> apiTypes = new LinkedList<IApiType>();
            apiTypes.add(type);
            this.gatherAPISuperTypes(apiTypes, type);
            for (IApiType t2 : apiTypes) {
                HashSet<MethodKey> apiMembers = new HashSet<MethodKey>();
                this.gatherVisibleMethods(t2, apiMembers, modifiers);
                methods.removeAll(apiMembers);
                if (methods.size() != 0) continue;
                return false;
            }
            if (methods.size() <= 0) return false;
            return true;
        }
        catch (CoreException ce) {
            if (!ApiPlugin.DEBUG_PROBLEM_DETECTOR) return true;
            ApiPlugin.log(ce);
            return true;
        }
    }

    private void gatherVisibleMethods(IApiType type, Set<MethodKey> members, int modifiers) {
        IApiMethod[] methods;
        IApiMethod[] iApiMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IApiMethod method = iApiMethodArray[n2];
            if ((method.getModifiers() & modifiers) > 0 && !method.isConstructor() && !method.isSynthetic()) {
                members.add(new MethodKey(type.getName(), method.getName(), method.getSignature(), false));
            }
            ++n2;
        }
    }

    private boolean hasVisibleField(IApiType type, int modifiers) {
        IApiField[] fields;
        IApiField[] iApiFieldArray = fields = type.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IApiField field = iApiFieldArray[n2];
            if ((field.getModifiers() & modifiers) > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void gatherAPISuperTypes(List<IApiType> superTypes, IApiType type) throws CoreException {
        if (type != null) {
            if (this.isAPIType(type)) {
                superTypes.add(0, type);
            }
            this.gatherAPISuperTypes(superTypes, type.getSuperclass());
            IApiType[] interfaces = type.getSuperInterfaces();
            if (interfaces != null) {
                IApiType[] iApiTypeArray = interfaces;
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    IApiType i = iApiTypeArray[n2];
                    if (this.isAPIType(i)) {
                        superTypes.add(i);
                        this.gatherAPISuperTypes(superTypes, i);
                    }
                    ++n2;
                }
            }
        }
    }

    private boolean isAPIType(IApiType type) throws CoreException {
        IApiDescription description = type.getApiComponent().getApiDescription();
        IApiAnnotations annotations = description.resolveAnnotations(type.getHandle());
        if (annotations == null) {
            return false;
        }
        return VisibilityModifiers.isAPI(annotations.getVisibility());
    }
}

