/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.phpIni.PHPINIUtil;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandlersManager;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.IDBGpSessionListener;
import org.eclipse.php.internal.debug.core.zend.debugger.ProcessCrashDetector;
import org.eclipse.php.phpunit.ui.launch.PHPUnitBasicLauncher;
import org.eclipse.php.phpunit.ui.launch.PHPUnitOptionsList;

public class PHPUnitXDLauncher
extends PHPUnitBasicLauncher {
    public PHPUnitXDLauncher(ILaunchConfiguration configuration, ILaunch launch, PHPUnitOptionsList optionsList) {
        super(configuration, launch, optionsList);
    }

    @Override
    protected void launchRunMode(String fileName, File workingDir, String phpExeString, IProject project, Map<String, String> envVariables, IProgressMonitor monitor) throws CoreException {
        this.doLaunch(this.configuration, "run", project, workingDir, this.launch, envVariables, monitor);
    }

    @Override
    protected void launchDebugMode(String fileName, File workingDir, String phpExeString, IProject project, Map<String, String> envVariables, IProgressMonitor monitor) throws CoreException {
        this.doLaunch(this.configuration, "debug", project, workingDir, this.launch, envVariables, monitor);
    }

    @Override
    protected void launchProfileMode(String fileName, File workingDir, String phpExeString, IProject project, Map<String, String> envVariables, IProgressMonitor monitor) throws CoreException {
        this.doLaunch(this.configuration, "profile", project, workingDir, this.launch, envVariables, monitor);
    }

    private void doLaunch(ILaunchConfiguration configuration, String mode, IProject project, File workingDirectory, ILaunch launch, Map<String, String> envVariables, IProgressMonitor monitor) throws CoreException {
        PHPexeItem[] items;
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        String phpExeString = configuration.getAttribute("ATTR_LOCATION", null);
        String phpIniString = configuration.getAttribute("ATTR_INI_LOCATION", null);
        String phpScriptString = configuration.getAttribute("ATTR_FILE", null);
        if (phpScriptString == null || phpScriptString.trim().length() == 0) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            this.displayErrorMessage(PHPDebugCoreMessages.XDebug_ExeLaunchConfigurationDelegate_0);
            return;
        }
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        Path filePath = new Path(phpScriptString);
        Path phpExe = new Path(phpExeString);
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        wc.setAttribute("org.eclipse.php.debug.core.PHP_Project", project.getFullPath().toString());
        wc.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding((IProject)project));
        wc.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding((IProject)project));
        wc.doSave();
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        IPath projectLocation = project.getRawLocation();
        if (projectLocation == null) {
            projectLocation = project.getLocation();
        }
        Path phpFile = filePath;
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        File phpIni = phpIniString != null && new File(phpIniString).exists() ? new File(phpIniString) : PHPINIUtil.findPHPIni((String)phpExeString);
        File tempIni = PHPINIUtil.prepareBeforeLaunch((File)phpIni, (String)phpExeString, (IProject)project);
        launch.setAttribute("PHPIniLocation", tempIni.getAbsolutePath());
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        String programName = phpExe.lastSegment();
        String extension = phpExe.getFileExtension();
        if (extension != null) {
            programName = programName.substring(0, programName.length() - (extension.length() + 1));
        }
        programName = programName.toLowerCase();
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
        processAttributes.put(IProcess.ATTR_CMDLINE, phpScriptString);
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        String[] envVarString = null;
        DBGpTarget target = null;
        if (mode.equals("debug")) {
            boolean stopAtFirstLine = PHPProjectPreferences.getStopAtFirstLine((IProject)project);
            stopAtFirstLine = configuration.getAttribute("firstLineBreakpoint", stopAtFirstLine);
            String sessionID = DBGpSessionHandler.getInstance().generateSessionId();
            String ideKey = String.valueOf(null);
            PHPexeItem phpExeItem = PHPLaunchUtilities.getPHPExe((ILaunchConfiguration)configuration);
            int debugPort = this.getDebugPort(phpExeItem);
            if (!PHPLaunchUtilities.isDebugDaemonActive((int)debugPort, (String)"org.eclipse.php.debug.core.xdebugDebugger")) {
                PHPLaunchUtilities.showLaunchErrorMessage((String)NLS.bind((String)PHPDebugCoreMessages.ExeLaunchConfigurationDelegate_PortInUse, (Object)debugPort, (Object)phpExeItem.getName()));
                monitor.setCanceled(true);
                monitor.done();
                return;
            }
            if (phpExeItem != null) {
                DBGpProxyHandler proxyHandler = DBGpProxyHandlersManager.INSTANCE.getHandler(phpExeItem.getUniqueId());
                if (proxyHandler.useProxy()) {
                    ideKey = proxyHandler.getCurrentIdeKey();
                    if (!proxyHandler.registerWithProxy()) {
                        this.displayErrorMessage(String.valueOf(PHPDebugCoreMessages.XDebug_ExeLaunchConfigurationDelegate_2) + proxyHandler.getErrorMsg());
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                        return;
                    }
                }
            } else {
                ideKey = DBGpSessionHandler.getInstance().getIDEKey();
            }
            target = new DBGpTarget(launch, phpFile.lastSegment(), ideKey, sessionID, stopAtFirstLine);
            target.setPathMapper(PathMapperRegistry.getByLaunchConfiguration((ILaunchConfiguration)configuration));
            DBGpSessionHandler.getInstance().addSessionListener((IDBGpSessionListener)target);
            envVarString = this.createDebugLaunchEnvironment(configuration, sessionID, ideKey, (IPath)phpExe);
        } else {
            envVarString = PHPLaunchUtilities.getEnvironment((ILaunchConfiguration)configuration, (String[])new String[]{this.getLibraryPath((IPath)phpExe)});
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 30);
        subMonitor.beginTask(PHPDebugCoreMessages.XDebug_ExeLaunchConfigurationDelegate_3, 10);
        File phpExeFile = new File(phpExeString);
        String sapiType = null;
        String phpV = null;
        PHPexeItem[] pHPexeItemArray = items = PHPexes.getInstance().getAllItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem item = pHPexeItemArray[n2];
            if (item.getExecutable().equals(phpExeFile)) {
                sapiType = item.getSapiType();
                phpV = item.getVersion();
                break;
            }
            ++n2;
        }
        String[] args = null;
        if ("CLI".equals(sapiType)) {
            args = PHPLaunchUtilities.getProgramArguments((ILaunchConfiguration)launch.getLaunchConfiguration());
        }
        String[] cmdLine = this.getCommandLine(project, phpExe.toOSString(), tempIni.toString(), phpFile.toOSString(), args);
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.addAll(Arrays.asList(cmdLine));
        allArgs.addAll(this.optionsList.getList());
        cmdLine = allArgs.toArray(new String[0]);
        Process phpExeProcess = DebugPlugin.exec((String[])cmdLine, (File)workingDirectory, (String[])envVarString);
        new Thread((Runnable)new ProcessCrashDetector(launch, phpExeProcess)).start();
        IProcess eclipseProcessWrapper = null;
        if (phpExeProcess != null) {
            subMonitor.worked(10);
            eclipseProcessWrapper = DebugPlugin.newProcess((ILaunch)launch, (Process)phpExeProcess, (String)phpExe.toOSString(), processAttributes);
            if (eclipseProcessWrapper == null) {
                phpExeProcess.destroy();
                subMonitor.done();
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.core", 0, null, null));
            }
            if (mode.equals("debug") && target != null) {
                target.setProcess(eclipseProcessWrapper);
                launch.addDebugTarget((IDebugTarget)target);
                subMonitor.subTask(PHPDebugCoreMessages.XDebug_ExeLaunchConfigurationDelegate_4);
                target.waitForInitialSession((DBGpBreakpointFacade)IDELayerFactory.getIDELayer(), XDebugPreferenceMgr.createSessionPreferences(), monitor);
            }
        } else {
            if (mode.equals("debug")) {
                DBGpSessionHandler.getInstance().removeSessionListener((IDBGpSessionListener)target);
            }
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
        subMonitor.done();
    }

    public String[] createDebugLaunchEnvironment(ILaunchConfiguration configuration, String sessionID, String ideKey, IPath phpExe) throws CoreException {
        String configEnv = "XDEBUG_CONFIG=remote_enable=1 idekey=" + ideKey;
        String extraDBGpEnv = "DBGP_IDEKEY=" + ideKey;
        String sessEnv = "DBGP_COOKIE=" + sessionID;
        Logger.debugMSG((String)("env=" + configEnv + ", Cookie=" + sessEnv));
        return PHPLaunchUtilities.getEnvironment((ILaunchConfiguration)configuration, (String[])new String[]{configEnv, extraDBGpEnv, sessEnv, this.getLibraryPath(phpExe)});
    }

    protected int getDebugPort(PHPexeItem phpExe) throws CoreException {
        int customRequestPort = XDebugDebuggerSettingsUtil.getDebugPort((String)phpExe.getUniqueId());
        if (customRequestPort != -1) {
            return customRequestPort;
        }
        return PHPDebugPlugin.getDebugPort((String)"org.eclipse.php.debug.core.xdebugDebugger");
    }

    private String getLibraryPath(IPath exePath) {
        return PHPLaunchUtilities.getLibrarySearchPathEnv((File)new File(exePath.removeLastSegments(1).toOSString()));
    }
}

