/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.mylyn.rcp;

import java.text.MessageFormat;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContextManager;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.completion.rcp.processable.SimpleProposalProcessor;
import org.eclipse.recommenders.internal.mylyn.rcp.l10n.Messages;

public class MylynSessionProcessor
extends SessionProcessor {
    public boolean startSession(IRecommendersCompletionContext crContext) {
        return ContextCore.getContextManager().isContextActive();
    }

    public void process(IProcessableProposal p) throws Exception {
        if (!(p instanceof AbstractJavaCompletionProposal)) {
            return;
        }
        AbstractJavaCompletionProposal proposal = (AbstractJavaCompletionProposal)p;
        IJavaElement javaElement = proposal.getJavaElement();
        if (javaElement == null) {
            return;
        }
        String handle = javaElement.getHandleIdentifier();
        IInteractionContextManager mgr = ContextCore.getContextManager();
        IInteractionElement interactionElement = mgr.getElement(handle);
        float interest = interactionElement.getInterest().getValue();
        if (interest > ContextCore.getCommonContextScaling().getInteresting()) {
            String label = MessageFormat.format(Messages.PROPOSAL_LABEL_MYLYN_INTEREST, Float.valueOf(interest));
            ProposalProcessorManager proposalMgr = p.getProposalProcessorManager();
            SimpleProposalProcessor processor = new SimpleProposalProcessor(Math.round(interest), label);
            proposalMgr.addProcessor((ProposalProcessor)processor);
        }
    }
}

