/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.recommenders.news.api.NewsItem;
import org.eclipse.recommenders.news.api.poll.PollingResult;

public final class PollingResults {
    private PollingResults() {
        throw new AssertionError();
    }

    public static List<NewsItem> getAllNewsItems(PollingResult result, int limit) {
        List allNewsItems = result.getAllNewsItems();
        ArrayList<NewsItem> limitedNewsItems = new ArrayList<NewsItem>(Math.min(allNewsItems.size(), limit));
        for (NewsItem item : allNewsItems) {
            if (limitedNewsItems.size() >= limit) break;
            limitedNewsItems.add(item);
        }
        return limitedNewsItems;
    }

    public static List<NewsItem> getNewNewsItems(PollingResult result, int limit) {
        List<NewsItem> allNewsItems = PollingResults.getAllNewsItems(result, limit);
        List newNewsItems = result.getNewNewsItems();
        ArrayList<NewsItem> limitedNewsItems = new ArrayList<NewsItem>(Math.min(newNewsItems.size(), limit));
        for (NewsItem item : allNewsItems) {
            if (!newNewsItems.contains(item)) continue;
            limitedNewsItems.add(item);
        }
        return limitedNewsItems;
    }
}

