/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace.internal;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.services.RelativePathService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.sapphire.workspace.WorkspaceRelativePath;

public final class WorkspaceRelativePathService
extends RelativePathService {
    public List<Path> roots() {
        ListFactory paths = ListFactory.start();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                paths.add((Object)new Path(project.getLocation().toPortableString()));
            }
            ++n2;
        }
        return paths.result();
    }

    public Path convertToRelative(Path path) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Path location;
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && (location = new Path(project.getLocation().toPortableString())).isPrefixOf(path)) {
                return new Path(project.getName()).append(path.makeRelativeTo(location));
            }
            ++n2;
        }
        return null;
    }

    public Path convertToAbsolute(Path path) {
        if (path.segmentCount() > 0) {
            String projectName = path.segment(0);
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && projectName.equals(project.getName())) {
                    return new Path(project.getLocation().toPortableString()).append(path.removeFirstSegments(1));
                }
                ++n2;
            }
        }
        return null;
    }

    public static final class Condition
    extends ServiceCondition {
        public boolean applicable(ServiceContext context) {
            ValueProperty property = (ValueProperty)context.find(ValueProperty.class);
            return property != null && Path.class.isAssignableFrom(property.getTypeClass()) && property.hasAnnotation(WorkspaceRelativePath.class);
        }
    }
}

