/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.classid;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipError;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.AbstractJob;
import org.eclipse.scout.sdk.s2e.job.ResourceBlockingOperationJob;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public final class ClassIdValidationJob
extends AbstractJob {
    public static final String CLASS_ID_VALIDATION_JOB_FAMILY = "CLASS_ID_VALIDATION_JOB_FAMILY";
    public static final String CLASS_ID_DUPLICATE_MARKER_ID = "org.eclipse.scout.sdk.classid.duplicate";
    public static final String CLASS_ID_ATTR_ANNOTATION = "SCOUT_CLASS_ID_ATTR_ANNOTATION";
    private static IElementChangedListener listener;
    private final Set<IType> m_classIdTypes;

    private ClassIdValidationJob(Set<IType> classIdTypes) {
        super(ClassIdValidationJob.class.getName());
        this.setSystem(true);
        this.setUser(false);
        this.setRule(new P_SchedulingRule());
        this.setPriority(40);
        this.m_classIdTypes = classIdTypes;
    }

    private Set<IAnnotation> getAllClassIdAnnotationsInWorkspace(final IProgressMonitor monitor) {
        final HashSet<IAnnotation> result = new HashSet<IAnnotation>();
        try {
            SearchEngine e = new SearchEngine();
            IJavaSearchScope workspaceScope = SearchEngine.createWorkspaceScope();
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    IType ownerType;
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException("ClassId annotation search canceled by monitor.");
                    }
                    Object owner = match.getElement();
                    if (owner instanceof IType && S2eUtils.exists((IJavaElement)(ownerType = (IType)owner))) {
                        IJavaElement element = ((TypeReferenceMatch)match).getLocalElement();
                        if (element == null) {
                            element = S2eUtils.getAnnotation((IAnnotatable)ownerType, "org.eclipse.scout.rt.platform.classid.ClassId");
                        }
                        if (element instanceof IAnnotation && S2eUtils.exists(element)) {
                            result.add((IAnnotation)element);
                        }
                    }
                }
            };
            for (IType classIdType : this.m_classIdTypes) {
                if (monitor.isCanceled()) {
                    return result;
                }
                if (!S2eUtils.exists((IJavaElement)classIdType)) continue;
                SearchPattern pattern = SearchPattern.createPattern((IJavaElement)classIdType, (int)65536, (int)0);
                e.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, workspaceScope, requestor, monitor);
            }
        }
        catch (IllegalStateException ise) {
            SdkLog.debug((String)"@ClassId Validation Job canceled because workspace is closing.", (Object[])new Object[]{ise});
        }
        catch (OperationCanceledException oce) {
            SdkLog.debug((String)"@ClassId Validation Job canceled because monitor was canceled.", (Object[])new Object[]{oce});
        }
        catch (ZipError ze) {
            SdkLog.warning((String)"unable to find @ClassId annotation references in workspace.", (Object[])new Object[]{ze});
        }
        catch (CoreException ex) {
            SdkLog.error((String)"unable to find @ClassId annotation references in workspace.", (Object[])new Object[]{ex});
        }
        catch (IllegalArgumentException iae) {
            SdkLog.info((String)"@ClassId validation job canceled.", (Object[])new Object[]{iae});
        }
        catch (Exception e) {
            SdkLog.error((String)"unable to find @ClassId annotation references in workspace.", (Object[])new Object[]{e});
        }
        return result;
    }

    public boolean belongsTo(Object family) {
        return CLASS_ID_VALIDATION_JOB_FAMILY.equals(family);
    }

    public static synchronized void install() {
        if (listener == null) {
            listener = new P_ResourceChangeListener();
            JavaCore.addElementChangedListener((IElementChangedListener)listener);
        }
    }

    public static synchronized void uninstall() {
        if (listener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)listener);
            listener = null;
        }
        Job.getJobManager().cancel((Object)CLASS_ID_VALIDATION_JOB_FAMILY);
    }

    private Map<String, List<IAnnotation>> getClassIdOccurrences(IProgressMonitor monitor) throws CoreException {
        HashMap<String, List<IAnnotation>> ids = new HashMap<String, List<IAnnotation>>();
        Set<IAnnotation> allClassIdAnnotationsInWorkspace = this.getAllClassIdAnnotationsInWorkspace(monitor);
        if (monitor.isCanceled()) {
            return null;
        }
        for (IAnnotation r : allClassIdAnnotationsInWorkspace) {
            String id;
            if (monitor.isCanceled()) {
                return null;
            }
            if (!S2eUtils.exists((IJavaElement)r) || !StringUtils.isNotEmpty((CharSequence)(id = S2eUtils.getAnnotationValueString(r, "value")))) continue;
            LinkedList<IAnnotation> files = (LinkedList<IAnnotation>)ids.get(id);
            if (files == null) {
                files = new LinkedList<IAnnotation>();
                ids.put(id, files);
            }
            files.add(r);
        }
        return ids;
    }

    private static IAnnotation getVisibleDuplicate(IJavaElement current, Iterable<IAnnotation> matchesById) {
        IJavaProject jp = current.getJavaProject();
        for (IAnnotation m : matchesById) {
            if (m == current || !S2eUtils.isOnClasspath((IJavaElement)m, jp)) continue;
            return m;
        }
        return null;
    }

    private static void createDuplicateMarkers(Map<String, List<IAnnotation>> annotations) throws CoreException {
        for (Map.Entry<String, List<IAnnotation>> matches : annotations.entrySet()) {
            List<IAnnotation> matchesById = matches.getValue();
            if (matchesById.size() <= 1) continue;
            for (IAnnotation duplicate : matchesById) {
                IAnnotation other = ClassIdValidationJob.getVisibleDuplicate((IJavaElement)duplicate, matchesById);
                IType parent = (IType)duplicate.getAncestor(7);
                if (!S2eUtils.exists((IJavaElement)parent) || !S2eUtils.exists((IJavaElement)other)) continue;
                IType otherParent = (IType)other.getAncestor(7);
                ISourceRange sourceRange = duplicate.getSourceRange();
                if (!S2eUtils.exists((IJavaElement)otherParent) || !SourceRange.isAvailable((ISourceRange)sourceRange)) continue;
                IMarker marker = duplicate.getResource().createMarker(CLASS_ID_DUPLICATE_MARKER_ID);
                marker.setAttribute("message", (Object)("Duplicate @ClassId. Value '" + matches.getKey() + "' of type '" + parent.getFullyQualifiedName() + "' is the same as of type '" + otherParent.getFullyQualifiedName() + "'."));
                marker.setAttribute("priority", 2);
                marker.setAttribute("charStart", sourceRange.getOffset());
                marker.setAttribute("charEnd", sourceRange.getOffset() + sourceRange.getLength());
                marker.setAttribute("severity", 2);
                try {
                    Document doc = new Document(parent.getCompilationUnit().getSource());
                    marker.setAttribute("lineNumber", doc.getLineOfOffset(sourceRange.getOffset()) + 1);
                }
                catch (BadLocationException e) {
                    throw new SdkException((Throwable)e);
                }
                marker.setAttribute(CLASS_ID_ATTR_ANNOTATION, (Object)duplicate);
            }
        }
    }

    private static void deleteDuplicateMarkers() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().deleteMarkers(CLASS_ID_DUPLICATE_MARKER_ID, true, 2);
        }
        catch (CoreException e) {
            SdkLog.error((String)"unable to remove old class id duplicate markers", (Object[])new Object[]{e});
        }
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws CoreException {
        Map<String, List<IAnnotation>> classIdOccurrences = this.getClassIdOccurrences(monitor);
        if (monitor.isCanceled()) {
            return;
        }
        ClassIdValidationJob.deleteDuplicateMarkers();
        ClassIdValidationJob.createDuplicateMarkers(classIdOccurrences);
    }

    public static synchronized void executeAsync(final long startDelay) {
        Job currentJob = Job.getJobManager().currentJob();
        if (currentJob instanceof ResourceBlockingOperationJob) {
            return;
        }
        AbstractJob j = new AbstractJob("schedule classid validation"){

            @Override
            protected void execute(IProgressMonitor monitor) {
                try {
                    S2eUtils.waitForJdt();
                    Set<IType> classIds = S2eUtils.resolveJdtTypes("org.eclipse.scout.rt.platform.classid.ClassId");
                    if (classIds.isEmpty()) {
                        return;
                    }
                    Job.getJobManager().cancel((Object)ClassIdValidationJob.CLASS_ID_VALIDATION_JOB_FAMILY);
                    new ClassIdValidationJob(classIds, null).schedule(startDelay);
                }
                catch (IllegalStateException e) {
                    SdkLog.info((String)"Could not schedule class id validation.", (Object[])new Object[]{e});
                }
                catch (Exception e) {
                    SdkLog.error((String)"Error while preparing to search for duplicate @ClassIds.", (Object[])new Object[]{e});
                }
            }
        };
        j.setSystem(true);
        j.setUser(false);
        j.schedule();
    }

    /* synthetic */ ClassIdValidationJob(Set set, ClassIdValidationJob classIdValidationJob) {
        this(set);
    }

    private static final class P_ResourceChangeListener
    implements IElementChangedListener {
        private P_ResourceChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            IJavaElementDelta delta = event.getDelta();
            this.visitDeltas(delta);
        }

        private boolean visitDeltas(IJavaElementDelta delta) {
            boolean processed;
            IJavaElementDelta d;
            if (delta == null) {
                return false;
            }
            IJavaElement element = delta.getElement();
            if (element == null) {
                return false;
            }
            if (element.getElementType() == 16) {
                IAnnotation annotation = (IAnnotation)element;
                if (S2eUtils.exists((IJavaElement)annotation) && annotation.getElementName().endsWith(Signature.getSimpleName((String)"org.eclipse.scout.rt.platform.classid.ClassId"))) {
                    ClassIdValidationJob.executeAsync(4000L);
                }
                return true;
            }
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                d = iJavaElementDeltaArray[n2];
                processed = this.visitDeltas(d);
                if (processed) {
                    return true;
                }
                ++n2;
            }
            iJavaElementDeltaArray = delta.getAnnotationDeltas();
            n = iJavaElementDeltaArray.length;
            n2 = 0;
            while (n2 < n) {
                d = iJavaElementDeltaArray[n2];
                processed = this.visitDeltas(d);
                if (processed) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static final class P_SchedulingRule
    implements ISchedulingRule {
        private P_SchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof P_SchedulingRule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof P_SchedulingRule;
        }
    }
}

