/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.counters.ui;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.counters.ui.CounterChartViewer;
import org.eclipse.tracecompass.analysis.counters.ui.CounterTreeViewer;
import org.eclipse.tracecompass.internal.analysis.counters.ui.CounterTreePatternFilter;
import org.eclipse.tracecompass.internal.analysis.counters.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.counters.ui.TriStateFilteredCheckboxTree;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CounterView
extends TmfChartView {
    public static final String VIEW_TITLE = "Counters";

    public CounterView() {
        super(VIEW_TITLE);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TmfViewer tree = this.getLeftChildViewer();
        TmfXYChartViewer chart = this.getChartViewer();
        if (tree instanceof CounterTreeViewer && chart instanceof CounterChartViewer) {
            ((CounterTreeViewer)tree).setTreeListener((CounterChartViewer)chart);
        }
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.getCumulativeAction());
    }

    protected TmfXYChartViewer createChartViewer(Composite parent) {
        return new CounterChartViewer(parent);
    }

    protected @NonNull TmfViewer createLeftChildViewer(Composite parent) {
        int treeStyle = 65794;
        CounterTreePatternFilter filter = new CounterTreePatternFilter();
        TriStateFilteredCheckboxTree triStateFilteredCheckboxTree = new TriStateFilteredCheckboxTree(parent, treeStyle, (PatternFilter)filter, true);
        CounterTreeViewer treeViewer = new CounterTreeViewer(parent, triStateFilteredCheckboxTree);
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            TmfTraceSelectedSignal signal = new TmfTraceSelectedSignal((Object)this, trace);
            treeViewer.traceSelected(signal);
        }
        return treeViewer;
    }

    private Action getCumulativeAction() {
        Action action = new Action(Messages.CounterView_CumulativeAction_Text, 2){
            private boolean isCumulative;
            {
                this.isCumulative = false;
            }

            public void run() {
                this.isCumulative ^= true;
                this.setToolTipText(this.isCumulative ? Messages.CounterView_CumulativeAction_DifferentialTooltipText : Messages.CounterView_CumulativeAction_CumulativeTooltipText);
                TmfXYChartViewer chart = CounterView.this.getChartViewer();
                if (chart instanceof CounterChartViewer) {
                    ((CounterChartViewer)chart).toggleCumulative();
                }
            }
        };
        action.setToolTipText(Messages.CounterView_CumulativeAction_CumulativeTooltipText);
        action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tracecompass.tmf.ui", (String)"icons/elcl16/sigma.gif"));
        return action;
    }
}

