/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.callgraph;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.Messages;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public final class SymbolAspect
implements ISegmentAspect {
    public static final ISegmentAspect SYMBOL_ASPECT = new SymbolAspect();

    public @NonNull String getName() {
        return NonNullUtils.nullToEmptyString((Object)Messages.CallStack_FunctionName);
    }

    public @NonNull String getHelpText() {
        return NonNullUtils.nullToEmptyString((Object)Messages.CallStack_FunctionName);
    }

    public @Nullable Comparator<?> getComparator() {
        return new Comparator<ISegment>(){

            @Override
            public int compare(@Nullable ISegment o1, @Nullable ISegment o2) {
                if (o1 == null || o2 == null) {
                    throw new IllegalArgumentException();
                }
                return Long.compare(o1.getLength(), o2.getLength());
            }
        };
    }

    public @Nullable Object resolve(@NonNull ISegment segment) {
        if (segment instanceof ICalledFunction) {
            ICalledFunction calledFunction = (ICalledFunction)segment;
            ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
            if (trace != null) {
                String symbolText = null;
                Object symbol = calledFunction.getSymbol();
                if (symbol instanceof Long) {
                    Long longAddress = (Long)symbol;
                    Collection providers = SymbolProviderManager.getInstance().getSymbolProviders(trace);
                    for (ISymbolProvider provider : providers) {
                        symbolText = provider.getSymbolText(longAddress.longValue());
                        if (symbolText != null) break;
                    }
                    if (symbolText == null) {
                        return "0x" + Long.toHexString(longAddress);
                    }
                    long time = segment.getStart();
                    int pid = calledFunction.getProcessId();
                    if (pid > 0) {
                        for (ISymbolProvider provider : providers) {
                            String text = provider.getSymbolText(pid, time, longAddress.longValue());
                            if (text == null) continue;
                            return text;
                        }
                    }
                    return symbolText;
                }
                return String.valueOf(symbol);
            }
        }
        return null;
    }
}

