/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.module;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.Activator;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.model.IVirtualMachineModel;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.model.VirtualCPU;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.model.VirtualMachine;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.model.qemukvm.QemuKvmVmModel;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.LttngEventLayout;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperimentUtils;

public class VirtualMachineStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 1;
    private static final int SCHED_SWITCH_INDEX = 0;
    private IVirtualMachineModel fModel;
    private final Table<ITmfTrace, String, @Nullable Integer> fEventNames;
    private final Map<ITmfTrace, IKernelAnalysisEventLayout> fLayouts;

    public VirtualMachineStateProvider(TmfExperiment experiment) {
        super((ITmfTrace)experiment, "Virtual Machine State Provider");
        HashBasedTable table;
        this.fModel = new QemuKvmVmModel(experiment);
        this.fEventNames = table = HashBasedTable.create();
        this.fLayouts = new HashMap<ITmfTrace, IKernelAnalysisEventLayout>();
    }

    private void buildEventNames(ITmfTrace trace) {
        IKernelAnalysisEventLayout layout = trace instanceof LttngKernelTrace ? ((LttngKernelTrace)trace).getKernelEventLayout() : LttngEventLayout.getInstance();
        this.fLayouts.put(trace, layout);
        this.fEventNames.put((Object)trace, (Object)layout.eventSchedSwitch(), (Object)0);
    }

    public TmfExperiment getTrace() {
        ITmfTrace trace = super.getTrace();
        if (trace instanceof TmfExperiment) {
            return (TmfExperiment)trace;
        }
        throw new IllegalStateException("VirtualMachineStateProvider: The associated trace should be an experiment");
    }

    public int getVersion() {
        return 1;
    }

    public VirtualMachineStateProvider getNewInstance() {
        TmfExperiment trace = this.getTrace();
        return new VirtualMachineStateProvider(trace);
    }

    protected void eventHandle(@Nullable ITmfEvent event) {
        if (event == null) {
            return;
        }
        String eventName = event.getName();
        IKernelAnalysisEventLayout eventLayout = this.fLayouts.get(event.getTrace());
        if (eventLayout == null) {
            this.buildEventNames(event.getTrace());
            eventLayout = this.fLayouts.get(event.getTrace());
            if (eventLayout == null) {
                return;
            }
        }
        if (!eventName.equals(eventLayout.eventSchedSwitch()) && !this.fModel.getRequiredEvents(eventLayout).contains(eventName)) {
            return;
        }
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        ITmfEventField content = event.getContent();
        long ts = event.getTimestamp().getValue();
        String hostId = event.getTrace().getHostId();
        try {
            VirtualMachine host = this.fModel.getCurrentMachine(event);
            if (host == null) {
                return;
            }
            if (host.isGuest()) {
                int vmQuark = -1;
                try {
                    vmQuark = ss.getQuarkRelative(this.getNodeVirtualMachines(), new String[]{host.getHostId()});
                }
                catch (AttributeNotFoundException e) {
                    vmQuark = ss.getQuarkRelativeAndAdd(this.getNodeVirtualMachines(), new String[]{host.getHostId()});
                    TmfStateValue machineName = TmfStateValue.newValueString((String)event.getTrace().getName());
                    ss.modifyAttribute(ts, (ITmfStateValue)machineName, vmQuark);
                }
            }
            this.fModel.handleEvent(event);
            Integer idx = (Integer)this.fEventNames.get((Object)event.getTrace(), (Object)eventName);
            int intval = idx == null ? -1 : idx;
            switch (intval) {
                case 0: {
                    int newVal;
                    ITmfStateValue value;
                    int curStatusQuark;
                    VirtualMachine vm;
                    int prevTid = ((Long)content.getField(new String[]{eventLayout.fieldPrevTid()}).getValue()).intValue();
                    int nextTid = ((Long)content.getField(new String[]{eventLayout.fieldNextTid()}).getValue()).intValue();
                    if (host.isGuest()) {
                        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
                        if (cpu == null) break;
                        int curStatusQuark2 = ss.getQuarkRelativeAndAdd(this.getNodeVirtualMachines(), new String[]{host.getHostId(), cpu.toString(), "Status"});
                        TmfStateValue value2 = TmfStateValue.newValueInt((int)1);
                        if (nextTid > 0) {
                            value2 = TmfStateValue.newValueInt((int)2);
                        }
                        ss.modifyAttribute(ts, (ITmfStateValue)value2, curStatusQuark2);
                        break;
                    }
                    HostThread ht = new HostThread(hostId, Integer.valueOf(prevTid));
                    VirtualCPU vcpu = this.fModel.getVirtualCpu(ht);
                    if (vcpu != null) {
                        vm = vcpu.getVm();
                        curStatusQuark = ss.getQuarkRelativeAndAdd(this.getNodeVirtualMachines(), new String[]{vm.getHostId(), vcpu.getCpuId().toString(), "Status"});
                        value = ss.queryOngoingState(curStatusQuark);
                        if ((value.unboxInt() & 1) == 0) {
                            newVal = Math.max(0, value.unboxInt());
                            value = TmfStateValue.newValueInt((int)(newVal | 0x100));
                            ss.modifyAttribute(ts, value, curStatusQuark);
                        }
                    }
                    if ((vcpu = this.fModel.getVirtualCpu(ht = new HostThread(hostId, Integer.valueOf(nextTid)))) != null) {
                        vm = vcpu.getVm();
                        curStatusQuark = ss.getQuarkRelativeAndAdd(this.getNodeVirtualMachines(), new String[]{vm.getHostId(), vcpu.getCpuId().toString(), "Status"});
                        value = ss.queryOngoingState(curStatusQuark);
                        newVal = Math.max(0, value.unboxInt());
                        value = TmfStateValue.newValueInt((int)(newVal & 0xFFFFFEFF));
                        ss.modifyAttribute(ts, value, curStatusQuark);
                    }
                    break;
                }
                default: {
                    int newVal;
                    ITmfStateValue value;
                    int curStatusQuark;
                    VirtualMachine vm;
                    HostThread ht = this.getCurrentHostThread(event, ts);
                    if (ht == null) break;
                    VirtualCPU virtualCpu = this.fModel.getVCpuEnteringHypervisorMode(event, ht, eventLayout);
                    if (virtualCpu != null) {
                        vm = virtualCpu.getVm();
                        curStatusQuark = ss.getQuarkRelativeAndAdd(this.getNodeVirtualMachines(), new String[]{vm.getHostId(), Long.toString(virtualCpu.getCpuId()), "Status"});
                        value = ss.queryOngoingState(curStatusQuark);
                        if ((value.unboxInt() & 1) == 0) {
                            newVal = Math.max(0, value.unboxInt());
                            value = TmfStateValue.newValueInt((int)(newVal | 0x80));
                            ss.modifyAttribute(ts, value, curStatusQuark);
                        }
                    }
                    if ((virtualCpu = this.fModel.getVCpuExitingHypervisorMode(event, ht, eventLayout)) != null) {
                        vm = virtualCpu.getVm();
                        curStatusQuark = ss.getQuarkRelativeAndAdd(this.getNodeVirtualMachines(), new String[]{vm.getHostId(), Long.toString(virtualCpu.getCpuId()), "Status"});
                        value = ss.queryOngoingState(curStatusQuark);
                        newVal = Math.max(0, value.unboxInt());
                        value = TmfStateValue.newValueInt((int)(newVal & 0xFFFFFF7F));
                        ss.modifyAttribute(ts, value, curStatusQuark);
                    }
                    break;
                }
            }
        }
        catch (StateValueTypeException | TimeRangeException e) {
            Activator.getDefault().logError("Error handling event in VirtualMachineStateProvider", e);
        }
    }

    private int getNodeVirtualMachines() {
        return ((ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder())).getQuarkAbsoluteAndAdd(new String[]{"Virtual Machines"});
    }

    private @Nullable HostThread getCurrentHostThread(ITmfEvent event, long ts) {
        String hostId = event.getTrace().getHostId();
        KernelAnalysisModule module = (KernelAnalysisModule)TmfExperimentUtils.getAnalysisModuleOfClassForHost((TmfExperiment)this.getTrace(), (String)hostId, KernelAnalysisModule.class);
        if (module == null) {
            return null;
        }
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpu == null) {
            return null;
        }
        Integer currentTid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)cpu.intValue(), (long)ts);
        if (currentTid == null) {
            return null;
        }
        return new HostThread(hostId, currentTid);
    }
}

