/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlTransitionValidator;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;

public class TmfXmlBasicTransition {
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("\\*");
    private final List<String> fCond;
    private final List<Pattern> fAcceptedEvents;

    public TmfXmlBasicTransition(Element element) {
        String conditions;
        @NonNull String events = element.getAttribute("event");
        this.fAcceptedEvents = new ArrayList<Pattern>();
        if (!events.isEmpty()) {
            for (String eventName : Arrays.asList(events.split("\\|"))) {
                String name = WILDCARD_PATTERN.matcher(eventName).replaceAll(".*");
                this.fAcceptedEvents.add(Pattern.compile(name));
            }
        }
        this.fCond = (conditions = element.getAttribute("cond")).isEmpty() ? new ArrayList() : Arrays.asList(conditions.split(":"));
    }

    public boolean test(ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo, Map<String, TmfXmlTransitionValidator> tests) {
        if (!this.validateEvent(event)) {
            return false;
        }
        for (String cond : this.fCond) {
            TmfXmlTransitionValidator test = tests.get(cond);
            if (test == null) {
                throw new IllegalStateException("Failed to find cond " + cond);
            }
            if (test.test(event, scenarioInfo)) continue;
            return false;
        }
        return true;
    }

    private boolean validateEvent(ITmfEvent event) {
        String eventName = event.getName();
        if (this.fAcceptedEvents.isEmpty()) {
            return true;
        }
        for (Pattern nameRegex : this.fAcceptedEvents) {
            if (!nameRegex.matcher(eventName).matches()) continue;
            return true;
        }
        return false;
    }
}

