/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.preferences;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.tmf.remote.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.remote.ui.messages.RemoteMessages;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.ExtractRemoteProfilesOperation;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportConnectionNodeElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfileElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfilesWriter;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportTraceGroupElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageContentProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class RemoteProfilesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.linuxtools.tmf.remote.ui.preferences.remoteprofiles";
    private static final String REMOTE_PROFILES_XML_FILE_NAME = "remote_profiles.xml";
    private static final String REMOTE_PROFILES_XML_FILE_PATH;
    private static final String REMOTE_PROFILES_LOCATION_PREF = "REMOTE_PROFILES_LOCATION";
    private static final String REMOTE_PROFILES_LOCATION_DIR_DEF = "";
    private static final String DEFAULT_ROOT_IMPORT_PATH = "/rootpath";
    private static final String DEFAULT_IMPORT_NAME = "";
    private static final String DEFAULT_FILE_PATTERN = ".*";
    private static final String TRACE_TYPE_AUTO_DETECT;
    private static final String SSH_SCHEME = "ssh";
    private TreeViewer fTreeViewer;
    private List<RemoteImportProfileElement> fProfiles;
    private String fSelectedProfileName;
    private DetailsPanel fDetailsPanel;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fImportButton;
    private Button fExportButton;
    private Button fMoveUpButton;
    private Button fMoveDownButton;
    private Action fDeleteAction;
    private Action fCutAction;
    private Action fCopyAction;
    private Action fPasteAction;
    private static final String PROFILE_FILE_PATH;

    static {
        IPath profileFolderPath;
        File profileFolder;
        REMOTE_PROFILES_XML_FILE_PATH = Activator.getDefault().getStateLocation().addTrailingSeparator().append(REMOTE_PROFILES_XML_FILE_NAME).toOSString();
        TRACE_TYPE_AUTO_DETECT = Messages.ImportTraceWizard_AutoDetection;
        String profileFilePath = REMOTE_PROFILES_XML_FILE_PATH;
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.remote.ui");
        String plugin = prefs.get(REMOTE_PROFILES_LOCATION_PREF, "");
        if (!plugin.isEmpty() && ((profileFolder = (profileFolderPath = Activator.getDefault().getStateLocation().removeLastSegments(1).append(plugin)).toFile()).exists() || profileFolder.mkdir())) {
            profileFilePath = profileFolderPath.append(REMOTE_PROFILES_XML_FILE_NAME).toString();
        }
        PROFILE_FILE_PATH = profileFilePath;
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        TreeViewer treeViewer;
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        PatternFilter patternFilter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                TreeViewer treeViewer = (TreeViewer)viewer;
                TracePackageContentProvider contentProvider = (TracePackageContentProvider)treeViewer.getContentProvider();
                Object parentElement = element;
                while (!(parentElement instanceof RemoteImportProfileElement)) {
                    if (!((parentElement = contentProvider.getParent(parentElement)) instanceof TracePackageTraceElement)) continue;
                    return false;
                }
                RemoteImportProfileElement profile = (RemoteImportProfileElement)((Object)parentElement);
                if (super.isLeafMatch(viewer, (Object)profile)) {
                    return true;
                }
                Object[] objectArray = contentProvider.getChildren((Object)profile);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (child instanceof RemoteImportConnectionNodeElement && super.isLeafMatch(viewer, child)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
        FilteredTree filteredTree = new FilteredTree(composite, 68354, patternFilter, true);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 0;
        filteredTree.setLayoutData((Object)gd);
        this.fTreeViewer = treeViewer = filteredTree.getViewer();
        treeViewer.setContentProvider((IContentProvider)new TracePackageContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ArrayList) {
                    return ((ArrayList)inputElement).toArray();
                }
                return super.getElements(inputElement);
            }

            public boolean hasChildren(Object element) {
                if (element instanceof TracePackageTraceElement) {
                    return false;
                }
                return super.hasChildren(element);
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TracePackageTraceElement) {
                    TracePackageElement[] tracePackageElementArray = ((TracePackageTraceElement)element).getChildren();
                    int n = tracePackageElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TracePackageElement files = tracePackageElementArray[n2];
                        if (files instanceof TracePackageFilesElement) {
                            return ((TracePackageFilesElement)files).getFileName();
                        }
                        ++n2;
                    }
                } else if (element instanceof TracePackageElement) {
                    return ((TracePackageElement)element).getText();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof TracePackageTraceElement) {
                    TracePackageElement[] tracePackageElementArray = ((TracePackageTraceElement)element).getChildren();
                    if (tracePackageElementArray.length != 0) {
                        TracePackageElement files = tracePackageElementArray[0];
                        return files.getImage();
                    }
                } else if (element instanceof TracePackageElement) {
                    return ((TracePackageElement)element).getImage();
                }
                return super.getImage(element);
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                TracePackageElement element = (TracePackageElement)(selection.size() == 1 ? selection.getFirstElement() : null);
                RemoteProfilesPreferencePage.this.fDetailsPanel.refreshDetailsPanel(element);
                RemoteProfilesPreferencePage.this.enableButtons(selection);
                RemoteProfilesPreferencePage.this.fSelectedProfileName = null;
                while (element != null) {
                    if (element instanceof RemoteImportProfileElement) {
                        RemoteProfilesPreferencePage.this.fSelectedProfileName = ((RemoteImportProfileElement)element).getProfileName();
                    }
                    element = element.getParent();
                }
            }
        });
        this.createGlobalActions();
        this.createContextMenu();
        this.fProfiles = RemoteProfilesPreferencePage.readProfiles(PROFILE_FILE_PATH, (IProgressMonitor)new NullProgressMonitor());
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.setInput(this.fProfiles);
        treeViewer.expandAll();
        Composite buttonBar = this.createVerticalButtonBar(composite);
        gd = new GridData(0x1000000, 1, false, false);
        gd.verticalIndent = filteredTree.getFilterControl().computeSize((int)-1, (int)-1).y + gl.verticalSpacing;
        buttonBar.setLayoutData((Object)gd);
        this.enableButtons((IStructuredSelection)treeViewer.getSelection());
        Composite details = new Composite(composite, 0);
        gd = new GridData(4, 0x1000000, false, false, 2, 1);
        details.setLayoutData((Object)gd);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        details.setLayout((Layout)gl);
        Label label = new Label(details, 0);
        label.setText(RemoteMessages.RemoteProfilesPreferencePage_DetailsPanelLabel);
        gd = new GridData(1, 0x1000000, false, false, 2, 1);
        label.setLayoutData((Object)gd);
        this.fDetailsPanel = new DetailsPanel(details);
        this.validate();
        for (RemoteImportProfileElement profile : this.fProfiles) {
            if (!profile.getProfileName().equals(this.fSelectedProfileName)) continue;
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)profile));
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public static List<RemoteImportProfileElement> getRemoteProfiles(IProgressMonitor monitor) {
        return RemoteProfilesPreferencePage.readProfiles(PROFILE_FILE_PATH, monitor);
    }

    private static List<RemoteImportProfileElement> readProfiles(String path, IProgressMonitor monitor) {
        ExtractRemoteProfilesOperation op = new ExtractRemoteProfilesOperation(path);
        op.run(monitor);
        ArrayList<RemoteImportProfileElement> profiles = new ArrayList<RemoteImportProfileElement>();
        if (!op.getStatus().isOK()) {
            return profiles;
        }
        TracePackageElement[] resultElements = op.getResultElements();
        if (resultElements != null) {
            TracePackageElement[] tracePackageElementArray = resultElements;
            int n = resultElements.length;
            int n2 = 0;
            while (n2 < n) {
                TracePackageElement element = tracePackageElementArray[n2];
                if (element instanceof RemoteImportProfileElement) {
                    profiles.add((RemoteImportProfileElement)element);
                }
                ++n2;
            }
        }
        return profiles;
    }

    private boolean writeProfiles(List<RemoteImportProfileElement> profiles, String path) {
        block14: {
            String contents = RemoteImportProfilesWriter.writeProfilesToXML(profiles.toArray(new TracePackageElement[0]));
            File file = new File(path);
            Throwable throwable = null;
            Object var6_8 = null;
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            try {
                writer.write(contents);
                if (writer == null) break block14;
            }
            catch (Throwable throwable2) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException | ParserConfigurationException | TransformerException e) {
                        MessageDialog.openError((Shell)this.getShell(), (String)RemoteMessages.RemoteProfilesPreferencePage_ErrorWritingProfile, (String)e.getMessage());
                        return false;
                    }
                }
            }
            writer.close();
        }
        return true;
    }

    private void createGlobalActions() {
        this.fDeleteAction = new Action(RemoteMessages.RemoteProfilesPreferencePage_DeleteAction){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)RemoteProfilesPreferencePage.this.fTreeViewer.getSelection();
                if (selection.size() == 0) {
                    return;
                }
                for (Object item : selection.toList()) {
                    RemoteProfilesPreferencePage.this.removeElement(item);
                }
            }
        };
        this.fDeleteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.fDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.fDeleteAction.setAccelerator(127);
        this.fCutAction = new Action(RemoteMessages.RemoteProfilesPreferencePage_CutAction){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)RemoteProfilesPreferencePage.this.fTreeViewer.getSelection();
                if (selection.size() != 1) {
                    return;
                }
                RemoteProfilesPreferencePage.setClipboardContents(selection);
                Object item = selection.getFirstElement();
                RemoteProfilesPreferencePage.this.removeElement(item);
            }
        };
        this.fCutAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
        this.fCutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.fCutAction.setAccelerator(262232);
        this.fCopyAction = new Action(RemoteMessages.RemoteProfilesPreferencePage_CopyAction){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)RemoteProfilesPreferencePage.this.fTreeViewer.getSelection();
                if (selection.size() != 1) {
                    return;
                }
                RemoteProfilesPreferencePage.setClipboardContents((IStructuredSelection)new StructuredSelection((Object)RemoteProfilesPreferencePage.this.copyElement(null, (TracePackageElement)selection.getFirstElement())));
            }
        };
        this.fCopyAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.fCopyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.fCopyAction.setAccelerator(262211);
        this.fPasteAction = new Action(RemoteMessages.RemoteProfilesPreferencePage_PasteAction){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)RemoteProfilesPreferencePage.this.fTreeViewer.getSelection();
                if (selection.size() > 1) {
                    return;
                }
                if (!RemoteProfilesPreferencePage.validatePaste(selection.getFirstElement())) {
                    return;
                }
                IStructuredSelection data = RemoteProfilesPreferencePage.getClipboardContents();
                data = RemoteProfilesPreferencePage.getClipboardContents();
                if (data == null) {
                    return;
                }
                Object[] objectArray = data.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TracePackageElement target;
                    TracePackageElement element;
                    Object object = objectArray[n2];
                    if (object instanceof RemoteImportProfileElement) {
                        element = RemoteProfilesPreferencePage.this.copyElement(null, (TracePackageElement)object);
                        target = (TracePackageElement)selection.getFirstElement();
                        if (target == null) {
                            RemoteProfilesPreferencePage.this.fProfiles.add((RemoteImportProfileElement)element);
                        } else {
                            int index = RemoteProfilesPreferencePage.this.fProfiles.indexOf(target);
                            RemoteProfilesPreferencePage.this.fProfiles.add(index + 1, (RemoteImportProfileElement)element);
                        }
                        Object[] expanded = RemoteProfilesPreferencePage.this.fTreeViewer.getExpandedElements();
                        RemoteProfilesPreferencePage.this.fTreeViewer.refresh();
                        RemoteProfilesPreferencePage.this.fTreeViewer.setExpandedElements(expanded);
                        RemoteProfilesPreferencePage.this.fTreeViewer.expandToLevel((Object)element, -1);
                        RemoteProfilesPreferencePage.this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
                        RemoteProfilesPreferencePage.this.validate();
                    } else if (object instanceof TracePackageElement && selection.getFirstElement() instanceof TracePackageElement) {
                        element = RemoteProfilesPreferencePage.this.copyElement(null, (TracePackageElement)object);
                        target = (TracePackageElement)selection.getFirstElement();
                        if (target.getClass().equals(element.getClass())) {
                            int index = target.getParent().indexOf(target);
                            target.getParent().addChild(index + 1, element);
                            RemoteProfilesPreferencePage.this.fTreeViewer.refresh((Object)target.getParent());
                        } else {
                            target.addChild(0, element);
                            RemoteProfilesPreferencePage.this.fTreeViewer.refresh((Object)target);
                        }
                        RemoteProfilesPreferencePage.this.fTreeViewer.expandToLevel((Object)element, -1);
                        RemoteProfilesPreferencePage.this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
                        RemoteProfilesPreferencePage.this.validate();
                    }
                    ++n2;
                }
            }
        };
        this.fPasteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this.fPasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.fPasteAction.setAccelerator(262230);
        this.fTreeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 127) {
                    RemoteProfilesPreferencePage.this.fDeleteAction.run();
                }
                if ((e.stateMask & 0x40000) == 262144) {
                    if (e.keyCode == 120) {
                        RemoteProfilesPreferencePage.this.fCutAction.run();
                    } else if (e.keyCode == 99) {
                        RemoteProfilesPreferencePage.this.fCopyAction.run();
                    } else if (e.keyCode == 118) {
                        RemoteProfilesPreferencePage.this.fPasteAction.run();
                    }
                }
            }
        });
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RemoteProfilesPreferencePage.this.fillContextMenu(manager);
            }
        });
        Menu contextMenu = menuManager.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(contextMenu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        List items = selection.toList();
        if (items.size() == 1) {
            Object item = items.get(0);
            if (item instanceof RemoteImportProfileElement) {
                final RemoteImportProfileElement profile = (RemoteImportProfileElement)((Object)item);
                manager.add((IAction)new Action(RemoteMessages.RemoteProfilesPreferencePage_NewConnectionNode){

                    public void run() {
                        RemoteProfilesPreferencePage.this.newConnectionNode(profile, null);
                    }
                });
            } else if (item instanceof RemoteImportConnectionNodeElement) {
                final RemoteImportConnectionNodeElement node = (RemoteImportConnectionNodeElement)((Object)item);
                manager.add((IAction)new Action(RemoteMessages.RemoteProfilesPreferencePage_NewTraceGroupAction){

                    public void run() {
                        RemoteProfilesPreferencePage.this.newTraceGroup(node, null);
                    }
                });
            } else if (item instanceof RemoteImportTraceGroupElement) {
                final RemoteImportTraceGroupElement traceGroup = (RemoteImportTraceGroupElement)((Object)item);
                manager.add((IAction)new Action(RemoteMessages.RemoteProfilesPreferencePage_NewTraceAction){

                    public void run() {
                        RemoteProfilesPreferencePage.this.newTrace(traceGroup, null);
                    }
                });
            }
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fDeleteAction);
        this.fDeleteAction.setEnabled(items.size() > 0);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fCutAction);
        this.fCutAction.setEnabled(items.size() == 1);
        manager.add((IAction)this.fCopyAction);
        this.fCopyAction.setEnabled(items.size() == 1);
        manager.add((IAction)this.fPasteAction);
        this.fPasteAction.setEnabled(items.size() <= 1 && RemoteProfilesPreferencePage.validatePaste(selection.getFirstElement()));
    }

    private Composite createVerticalButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.fAddButton = RemoteProfilesPreferencePage.createVerticalButton(composite, RemoteMessages.RemoteProfilesPreferencePage_AddButton);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)RemoteProfilesPreferencePage.this.fTreeViewer.getSelection();
                if (selection.isEmpty()) {
                    RemoteProfilesPreferencePage.this.newProfile(null);
                } else if (selection.getFirstElement() instanceof TracePackageElement) {
                    TracePackageElement previous = (TracePackageElement)selection.getFirstElement();
                    if (previous instanceof RemoteImportProfileElement) {
                        RemoteProfilesPreferencePage.this.newProfile(previous);
                    } else if (previous instanceof RemoteImportConnectionNodeElement) {
                        RemoteProfilesPreferencePage.this.newConnectionNode(previous.getParent(), previous);
                    } else if (previous instanceof RemoteImportTraceGroupElement) {
                        RemoteProfilesPreferencePage.this.newTraceGroup(previous.getParent(), previous);
                    } else if (previous instanceof TracePackageTraceElement) {
                        RemoteProfilesPreferencePage.this.newTrace(previous.getParent(), previous);
                    }
                }
            }
        });
        this.fRemoveButton = RemoteProfilesPreferencePage.createVerticalButton(composite, RemoteMessages.RemoteProfilesPreferencePage_RemoveButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)RemoteProfilesPreferencePage.this.fTreeViewer.getSelection();
                for (Object item : selection.toList()) {
                    if (item instanceof RemoteImportProfileElement) {
                        RemoteProfilesPreferencePage.this.fProfiles.remove(item);
                        continue;
                    }
                    if (!(item instanceof TracePackageElement)) continue;
                    TracePackageElement element = (TracePackageElement)item;
                    element.getParent().removeChild(element);
                }
                RemoteProfilesPreferencePage.this.fTreeViewer.refresh();
                RemoteProfilesPreferencePage.this.validate();
            }
        });
        new Label(composite, 0);
        this.fImportButton = RemoteProfilesPreferencePage.createVerticalButton(composite, RemoteMessages.RemoteProfilesPreferencePage_ImportButton);
        this.fImportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = TmfFileDialogFactory.create((Shell)Display.getCurrent().getActiveShell(), (int)4096);
                dialog.setText(RemoteMessages.RemoteProfilesPreferencePage_ImportFileDialogTitle);
                dialog.setFilterExtensions(new String[]{"*.xml", "*"});
                String path = dialog.open();
                if (path != null) {
                    List profiles = RemoteProfilesPreferencePage.readProfiles(path, (IProgressMonitor)new NullProgressMonitor());
                    RemoteProfilesPreferencePage.this.fProfiles.addAll(profiles);
                    RemoteProfilesPreferencePage.this.fTreeViewer.refresh();
                    for (RemoteImportProfileElement profile : profiles) {
                        RemoteProfilesPreferencePage.this.fTreeViewer.expandToLevel((Object)profile, -1);
                    }
                    RemoteProfilesPreferencePage.this.fTreeViewer.setSelection((ISelection)new StructuredSelection(profiles));
                    RemoteProfilesPreferencePage.this.validate();
                }
            }
        });
        this.fExportButton = RemoteProfilesPreferencePage.createVerticalButton(composite, RemoteMessages.RemoteProfilesPreferencePage_ExportButton);
        this.fExportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = TmfFileDialogFactory.create((Shell)Display.getCurrent().getActiveShell(), (int)8192);
                dialog.setText(RemoteMessages.RemoteProfilesPreferencePage_ExportFileDialogTitle);
                dialog.setFilterExtensions(new String[]{"*.xml", "*"});
                String path = dialog.open();
                if (path != null) {
                    IStructuredSelection selection = (IStructuredSelection)RemoteProfilesPreferencePage.this.fTreeViewer.getSelection();
                    ArrayList<RemoteImportProfileElement> profiles = new ArrayList<RemoteImportProfileElement>();
                    for (Object element : selection.toList()) {
                        if (!(element instanceof RemoteImportProfileElement)) continue;
                        profiles.add((RemoteImportProfileElement)((Object)element));
                    }
                    RemoteProfilesPreferencePage.this.writeProfiles(profiles, path);
                }
            }
        });
        new Label(composite, 0);
        this.fMoveUpButton = RemoteProfilesPreferencePage.createVerticalButton(composite, RemoteMessages.RemoteProfilesPreferencePage_MoveUpButton);
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracePackageElement child;
                TracePackageElement parentElement;
                int index;
                IStructuredSelection selection = (IStructuredSelection)RemoteProfilesPreferencePage.this.fTreeViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof RemoteImportProfileElement) {
                    int index2 = RemoteProfilesPreferencePage.this.fProfiles.indexOf(element);
                    if (index2 > 0) {
                        RemoteImportProfileElement profile = (RemoteImportProfileElement)((Object)RemoteProfilesPreferencePage.this.fProfiles.remove(index2));
                        RemoteProfilesPreferencePage.this.fProfiles.add(index2 - 1, profile);
                        Object[] expanded = RemoteProfilesPreferencePage.this.fTreeViewer.getExpandedElements();
                        RemoteProfilesPreferencePage.this.fTreeViewer.refresh();
                        RemoteProfilesPreferencePage.this.fTreeViewer.setExpandedElements(expanded);
                        RemoteProfilesPreferencePage.this.enableButtons(selection);
                    }
                } else if (element instanceof TracePackageElement && (index = (parentElement = (child = (TracePackageElement)element).getParent()).indexOf(child)) > 0) {
                    parentElement.removeChild(child);
                    parentElement.addChild(index - 1, child);
                    Object[] expanded = RemoteProfilesPreferencePage.this.fTreeViewer.getExpandedElements();
                    RemoteProfilesPreferencePage.this.fTreeViewer.refresh((Object)parentElement);
                    RemoteProfilesPreferencePage.this.fTreeViewer.setExpandedElements(expanded);
                    RemoteProfilesPreferencePage.this.enableButtons(selection);
                }
            }
        });
        this.fMoveDownButton = RemoteProfilesPreferencePage.createVerticalButton(composite, RemoteMessages.RemoteProfilesPreferencePage_MoveDownButton);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracePackageElement child;
                TracePackageElement parentElement;
                int index;
                IStructuredSelection selection = (IStructuredSelection)RemoteProfilesPreferencePage.this.fTreeViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof RemoteImportProfileElement) {
                    int index2 = RemoteProfilesPreferencePage.this.fProfiles.indexOf(selection.getFirstElement());
                    if (index2 >= 0 && index2 < RemoteProfilesPreferencePage.this.fProfiles.size() - 1) {
                        RemoteImportProfileElement profile = (RemoteImportProfileElement)((Object)RemoteProfilesPreferencePage.this.fProfiles.remove(index2));
                        RemoteProfilesPreferencePage.this.fProfiles.add(index2 + 1, profile);
                        Object[] expanded = RemoteProfilesPreferencePage.this.fTreeViewer.getExpandedElements();
                        RemoteProfilesPreferencePage.this.fTreeViewer.refresh();
                        RemoteProfilesPreferencePage.this.fTreeViewer.setExpandedElements(expanded);
                        RemoteProfilesPreferencePage.this.enableButtons(selection);
                    }
                } else if (element instanceof TracePackageElement && (index = (parentElement = (child = (TracePackageElement)element).getParent()).indexOf(child)) >= 0 && index < parentElement.getChildren().length - 1) {
                    parentElement.removeChild(child);
                    parentElement.addChild(index + 1, child);
                    Object[] expanded = RemoteProfilesPreferencePage.this.fTreeViewer.getExpandedElements();
                    RemoteProfilesPreferencePage.this.fTreeViewer.refresh((Object)parentElement);
                    RemoteProfilesPreferencePage.this.fTreeViewer.setExpandedElements(expanded);
                    RemoteProfilesPreferencePage.this.enableButtons(selection);
                }
            }
        });
        return composite;
    }

    private static Button createVerticalButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(256));
        button.setText(text);
        return button;
    }

    private void enableButtons(IStructuredSelection selection) {
        boolean allProfiles = false;
        for (Object element : selection.toList()) {
            if (element instanceof RemoteImportProfileElement) {
                allProfiles = true;
                continue;
            }
            allProfiles = false;
            break;
        }
        this.fAddButton.setEnabled(selection.size() <= 1);
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        this.fExportButton.setEnabled(allProfiles);
        int index = 0;
        int length = 0;
        if (selection.size() == 1) {
            Object item = selection.getFirstElement();
            if (item instanceof RemoteImportProfileElement) {
                index = this.fProfiles.indexOf(item);
                length = this.fProfiles.size();
            } else if (item instanceof TracePackageElement) {
                TracePackageElement element = (TracePackageElement)item;
                TracePackageElement parent = element.getParent();
                index = parent.indexOf(element);
                length = parent.getChildren().length;
            }
        }
        this.fMoveUpButton.setEnabled(index > 0);
        this.fMoveDownButton.setEnabled(index < length - 1);
    }

    private RemoteImportProfileElement newProfile(TracePackageElement previous) {
        RemoteImportProfileElement profile = new RemoteImportProfileElement(null, RemoteMessages.RemoteProfilesPreferencePage_DefaultProfileName);
        RemoteImportConnectionNodeElement node = new RemoteImportConnectionNodeElement(profile, RemoteMessages.RemoteProfilesPreferencePage_DefaultConnectionNodeName, RemoteMessages.RemoteProfilesPreferencePage_DefaultConnectionNodeURI);
        RemoteImportTraceGroupElement traceGroup = new RemoteImportTraceGroupElement(node, DEFAULT_ROOT_IMPORT_PATH);
        TracePackageTraceElement trace = new TracePackageTraceElement((TracePackageElement)traceGroup, "", null);
        new TracePackageFilesElement((TracePackageElement)trace, DEFAULT_FILE_PATTERN);
        int index = previous == null ? this.fProfiles.size() : this.fProfiles.indexOf(previous) + 1;
        this.fProfiles.add(index, profile);
        this.newElementAdded(profile);
        return profile;
    }

    private RemoteImportConnectionNodeElement newConnectionNode(TracePackageElement parent, TracePackageElement previous) {
        RemoteImportConnectionNodeElement node = new RemoteImportConnectionNodeElement(null, RemoteMessages.RemoteProfilesPreferencePage_DefaultConnectionNodeName, RemoteMessages.RemoteProfilesPreferencePage_DefaultConnectionNodeURI);
        RemoteImportTraceGroupElement traceGroup = new RemoteImportTraceGroupElement(node, DEFAULT_ROOT_IMPORT_PATH);
        TracePackageTraceElement trace = new TracePackageTraceElement((TracePackageElement)traceGroup, "", null);
        new TracePackageFilesElement((TracePackageElement)trace, DEFAULT_FILE_PATTERN);
        int index = previous == null ? parent.getChildren().length : parent.indexOf(previous) + 1;
        parent.addChild(index, (TracePackageElement)node);
        this.newElementAdded(node);
        return node;
    }

    private RemoteImportTraceGroupElement newTraceGroup(TracePackageElement parent, TracePackageElement previous) {
        RemoteImportTraceGroupElement traceGroup = new RemoteImportTraceGroupElement(null, DEFAULT_ROOT_IMPORT_PATH);
        TracePackageTraceElement trace = new TracePackageTraceElement((TracePackageElement)traceGroup, "", null);
        new TracePackageFilesElement((TracePackageElement)trace, DEFAULT_FILE_PATTERN);
        int index = previous == null ? parent.getChildren().length : parent.indexOf(previous) + 1;
        parent.addChild(index, (TracePackageElement)traceGroup);
        this.newElementAdded(traceGroup);
        return traceGroup;
    }

    private TracePackageTraceElement newTrace(TracePackageElement parent, TracePackageElement previous) {
        TracePackageTraceElement trace = new TracePackageTraceElement(null, "", null);
        new TracePackageFilesElement((TracePackageElement)trace, DEFAULT_FILE_PATTERN);
        int index = previous == null ? parent.getChildren().length : parent.indexOf(previous) + 1;
        parent.addChild(index, (TracePackageElement)trace);
        this.newElementAdded((TracePackageElement)trace);
        return trace;
    }

    private void newElementAdded(TracePackageElement element) {
        if (element.getParent() != null) {
            this.fTreeViewer.refresh((Object)element.getParent());
        } else {
            this.fTreeViewer.refresh();
        }
        this.fTreeViewer.expandToLevel((Object)element, -1);
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
        this.validate();
    }

    private void removeElement(Object item) {
        if (item instanceof RemoteImportProfileElement) {
            this.fProfiles.remove(item);
            this.fTreeViewer.refresh();
            this.validate();
        } else if (item instanceof TracePackageElement) {
            TracePackageElement element = (TracePackageElement)item;
            TracePackageElement parent = element.getParent();
            parent.removeChild(element);
            this.fTreeViewer.refresh((Object)parent);
            this.validate();
        }
    }

    private TracePackageElement copyElement(TracePackageElement parent, TracePackageElement element) {
        TracePackageElement source;
        TracePackageElement copy = null;
        if (element instanceof RemoteImportProfileElement) {
            source = (RemoteImportProfileElement)element;
            copy = new RemoteImportProfileElement(parent, source.getProfileName());
        } else if (element instanceof RemoteImportConnectionNodeElement) {
            source = (RemoteImportConnectionNodeElement)element;
            copy = new RemoteImportConnectionNodeElement(parent, source.getName(), source.getURI());
        } else if (element instanceof RemoteImportTraceGroupElement) {
            source = (RemoteImportTraceGroupElement)element;
            copy = new RemoteImportTraceGroupElement(parent, source.getRootImportPath());
            ((RemoteImportTraceGroupElement)copy).setRecursive(source.isRecursive());
        } else if (element instanceof TracePackageTraceElement) {
            source = (TracePackageTraceElement)element;
            copy = new TracePackageTraceElement(parent, source.getImportName(), source.getTraceType());
        } else if (element instanceof TracePackageFilesElement) {
            source = (TracePackageFilesElement)element;
            copy = new TracePackageFilesElement(parent, source.getFileName());
        }
        TracePackageElement[] tracePackageElementArray = element.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement child = tracePackageElementArray[n2];
            this.copyElement(copy, child);
            ++n2;
        }
        return copy;
    }

    private static boolean validatePaste(Object target) {
        IStructuredSelection data = RemoteProfilesPreferencePage.getClipboardContents();
        if (data == null || data.isEmpty()) {
            return false;
        }
        Object[] objectArray = data.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof RemoteImportConnectionNodeElement) {
                if (!(target instanceof RemoteImportConnectionNodeElement) && !(target instanceof RemoteImportProfileElement)) {
                    return false;
                }
            } else if (item instanceof RemoteImportTraceGroupElement) {
                if (!(target instanceof RemoteImportTraceGroupElement) && !(target instanceof RemoteImportConnectionNodeElement)) {
                    return false;
                }
            } else if (item instanceof TracePackageTraceElement) {
                if (!(target instanceof TracePackageTraceElement) && !(target instanceof RemoteImportTraceGroupElement)) {
                    return false;
                }
            } else if (item instanceof RemoteImportProfileElement) {
                if (!(target instanceof RemoteImportProfileElement) && target != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static void setClipboardContents(IStructuredSelection data) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        transfer.setSelection((ISelection)data);
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        clipboard.setContents(new Object[]{new Object()}, new Transfer[]{transfer});
        clipboard.dispose();
    }

    private static IStructuredSelection getClipboardContents() {
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        IStructuredSelection data = (IStructuredSelection)clipboard.getContents((Transfer)LocalSelectionTransfer.getTransfer());
        clipboard.dispose();
        return data;
    }

    private void validate() {
        this.setValid(false);
        HashSet<String> profileNames = new HashSet<String>();
        for (RemoteImportProfileElement profile : this.fProfiles) {
            if (profile.getProfileName().length() == 0) {
                this.setErrorMessage(RemoteMessages.RemoteProfilesPreferencePage_EmptyProfileNameError);
                return;
            }
            String prefix = String.valueOf(profile.getProfileName()) + ": ";
            if (!profileNames.add(profile.getProfileName())) {
                this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_DuplicateProfileNameError);
                return;
            }
            HashSet<String> nodeNames = new HashSet<String>();
            int nodeCount = 0;
            TracePackageElement[] tracePackageElementArray = profile.getChildren();
            int n = tracePackageElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                TracePackageElement profileChild = tracePackageElementArray[n2];
                if (profileChild instanceof RemoteImportConnectionNodeElement) {
                    ++nodeCount;
                    RemoteImportConnectionNodeElement node = (RemoteImportConnectionNodeElement)profileChild;
                    if (node.getName().length() == 0) {
                        this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_EmptyNodeNameError);
                        return;
                    }
                    if (!ResourcesPlugin.getWorkspace().validateName(node.getName(), 2).isOK()) {
                        this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_InvalidNodeName);
                        return;
                    }
                    if (!nodeNames.add(node.getName())) {
                        this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_DuplicateConnectionNodeNameError);
                        return;
                    }
                    if (node.getURI().length() == 0) {
                        this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_EmptyNodeURIError);
                        return;
                    }
                    try {
                        URI uri = URIUtil.fromString((String)node.getURI());
                        IRemoteServicesManager manager = (IRemoteServicesManager)TmfRemoteConnectionFactory.getService(IRemoteServicesManager.class);
                        if (manager == null || manager.getConnectionType(uri) == null) {
                            this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_UnsupportedURISchemeError);
                            return;
                        }
                        if (uri.getScheme().equals(SSH_SCHEME)) {
                            if (uri.getHost() == null) {
                                this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_InvalidHostOrPortError);
                                return;
                            }
                            if (uri.getUserInfo() == null) {
                                this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_MissingUserInfoError);
                                return;
                            }
                        }
                    }
                    catch (URISyntaxException e) {
                        this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_InvalidNodeURIError);
                        return;
                    }
                    int traceGroupCount = 0;
                    TracePackageElement[] tracePackageElementArray2 = node.getChildren();
                    int n3 = tracePackageElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TracePackageElement nodeChild = tracePackageElementArray2[n4];
                        if (nodeChild instanceof RemoteImportTraceGroupElement) {
                            ++traceGroupCount;
                            RemoteImportTraceGroupElement traceGroup = (RemoteImportTraceGroupElement)nodeChild;
                            if (traceGroup.getRootImportPath().length() == 0) {
                                this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_EmptyRootPathError);
                                return;
                            }
                            int traceCount = 0;
                            TracePackageElement[] tracePackageElementArray3 = traceGroup.getChildren();
                            int n5 = tracePackageElementArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                TracePackageElement traceGroupChild = tracePackageElementArray3[n6];
                                if (traceGroupChild instanceof TracePackageTraceElement) {
                                    ++traceCount;
                                    TracePackageTraceElement trace = (TracePackageTraceElement)traceGroupChild;
                                    TracePackageElement[] tracePackageElementArray4 = trace.getChildren();
                                    int n7 = tracePackageElementArray4.length;
                                    int n8 = 0;
                                    while (n8 < n7) {
                                        TracePackageElement traceChild = tracePackageElementArray4[n8];
                                        if (traceChild instanceof TracePackageFilesElement) {
                                            TracePackageFilesElement files = (TracePackageFilesElement)traceChild;
                                            if (files.getFileName().length() == 0) {
                                                this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_EmptyFilePatternError);
                                                return;
                                            }
                                            try {
                                                Pattern.compile(files.getFileName());
                                            }
                                            catch (PatternSyntaxException e) {
                                                this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_InvalidFilePatternError);
                                                return;
                                            }
                                        }
                                        ++n8;
                                    }
                                }
                                ++n6;
                            }
                            if (traceCount == 0) {
                                this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_MissingTraceError);
                                return;
                            }
                        }
                        ++n4;
                    }
                    if (traceGroupCount == 0) {
                        this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_MissingTraceGroupError);
                        return;
                    }
                }
                ++n2;
            }
            if (nodeCount != 0) continue;
            this.setErrorMessage(String.valueOf(prefix) + RemoteMessages.RemoteProfilesPreferencePage_MissingConnectionNodeError);
            return;
        }
        this.setValid(true);
        this.setErrorMessage(null);
    }

    public boolean performOk() {
        return this.writeProfiles(this.fProfiles, PROFILE_FILE_PATH);
    }

    public void setSelectedProfile(String profileName) {
        this.fSelectedProfileName = profileName;
        if (this.fTreeViewer != null && !this.fTreeViewer.getTree().isDisposed()) {
            for (RemoteImportProfileElement profile : this.fProfiles) {
                if (!profile.getProfileName().equals(profileName)) continue;
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)profile));
            }
        }
    }

    public String getSelectedProfile() {
        return this.fSelectedProfileName;
    }

    private class DetailsPanel {
        private Composite fComposite;

        public DetailsPanel(Composite parent) {
            this.fComposite = new Composite(parent, 2048);
            GridLayout gl = new GridLayout(2, false);
            this.fComposite.setLayout((Layout)gl);
            GridData gd = new GridData(4, 1, true, false);
            Combo combo = new Combo(this.fComposite, 2048);
            combo.setText("*");
            gd.heightHint = 2 * gl.marginHeight + gl.verticalSpacing + 2 * combo.computeSize((int)-1, (int)-1).y;
            this.fComposite.setLayoutData((Object)gd);
            combo.dispose();
        }

        public void refreshDetailsPanel(TracePackageElement selection) {
            GridData gd;
            TracePackageElement element;
            Control[] controlArray = this.fComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            if (selection instanceof RemoteImportProfileElement) {
                element = (RemoteImportProfileElement)selection;
                Label label = new Label(this.fComposite, 0);
                label.setText(RemoteMessages.RemoteProfilesPreferencePage_ProfileNameLabel);
                Text profileNameText = new Text(this.fComposite, 2048);
                gd = new GridData(4, 0x1000000, true, false);
                profileNameText.setLayoutData((Object)gd);
                profileNameText.setText(element.getProfileName());
                profileNameText.addModifyListener(new ModifyListener((RemoteImportProfileElement)element, profileNameText){
                    private final /* synthetic */ RemoteImportProfileElement val$element;
                    private final /* synthetic */ Text val$profileNameText;
                    {
                        this.val$element = remoteImportProfileElement;
                        this.val$profileNameText = text;
                    }

                    public void modifyText(ModifyEvent e) {
                        this.val$element.setProfileName(this.val$profileNameText.getText().trim());
                        RemoteProfilesPreferencePage.this.fTreeViewer.refresh((Object)this.val$element, true);
                        RemoteProfilesPreferencePage.this.validate();
                        RemoteProfilesPreferencePage.this.fSelectedProfileName = this.val$element.getProfileName();
                    }
                });
            } else if (selection instanceof RemoteImportConnectionNodeElement) {
                element = (RemoteImportConnectionNodeElement)selection;
                Label label = new Label(this.fComposite, 0);
                label.setText(RemoteMessages.RemoteProfilesPreferencePage_ConnectionNodeNameLabel);
                Text nameText = new Text(this.fComposite, 2048);
                nameText.setText(element.getName());
                gd = new GridData(4, 0x1000000, true, false);
                nameText.setLayoutData((Object)gd);
                nameText.addModifyListener(new ModifyListener((RemoteImportConnectionNodeElement)element, nameText){
                    private final /* synthetic */ RemoteImportConnectionNodeElement val$element;
                    private final /* synthetic */ Text val$nameText;
                    {
                        this.val$element = remoteImportConnectionNodeElement;
                        this.val$nameText = text;
                    }

                    public void modifyText(ModifyEvent e) {
                        this.val$element.setName(this.val$nameText.getText().trim());
                        RemoteProfilesPreferencePage.this.fTreeViewer.refresh((Object)this.val$element, true);
                        RemoteProfilesPreferencePage.this.validate();
                    }
                });
                label = new Label(this.fComposite, 0);
                label.setText(RemoteMessages.RemoteProfilesPreferencePage_ConnectionNodeURILabel);
                Text uriText = new Text(this.fComposite, 2048);
                uriText.setText(element.getURI());
                gd = new GridData(4, 0x1000000, true, false);
                uriText.setLayoutData((Object)gd);
                uriText.addModifyListener(new ModifyListener((RemoteImportConnectionNodeElement)element, uriText){
                    private final /* synthetic */ RemoteImportConnectionNodeElement val$element;
                    private final /* synthetic */ Text val$uriText;
                    {
                        this.val$element = remoteImportConnectionNodeElement;
                        this.val$uriText = text;
                    }

                    public void modifyText(ModifyEvent e) {
                        this.val$element.setURI(this.val$uriText.getText().trim());
                        RemoteProfilesPreferencePage.this.fTreeViewer.refresh((Object)this.val$element, true);
                        RemoteProfilesPreferencePage.this.validate();
                    }
                });
            } else if (selection instanceof RemoteImportTraceGroupElement) {
                element = (RemoteImportTraceGroupElement)selection;
                Label label = new Label(this.fComposite, 0);
                label.setText(RemoteMessages.RemoteProfilesPreferencePage_RootPathLabel);
                Text rootText = new Text(this.fComposite, 2048);
                gd = new GridData(4, 0x1000000, true, false);
                rootText.setLayoutData((Object)gd);
                rootText.setText(element.getRootImportPath());
                rootText.addModifyListener(new ModifyListener((RemoteImportTraceGroupElement)element, rootText){
                    private final /* synthetic */ RemoteImportTraceGroupElement val$element;
                    private final /* synthetic */ Text val$rootText;
                    {
                        this.val$element = remoteImportTraceGroupElement;
                        this.val$rootText = text;
                    }

                    public void modifyText(ModifyEvent e) {
                        this.val$element.setRootImportPath(this.val$rootText.getText().trim());
                        RemoteProfilesPreferencePage.this.fTreeViewer.refresh((Object)this.val$element, true);
                        RemoteProfilesPreferencePage.this.validate();
                    }
                });
                new Label(this.fComposite, 0);
                Button recursiveButton = new Button(this.fComposite, 32);
                gd = new GridData(4, 0x1000000, true, false);
                recursiveButton.setLayoutData((Object)gd);
                recursiveButton.setText(RemoteMessages.RemoteProfilesPreferencePage_RecursiveButton);
                recursiveButton.setSelection(element.isRecursive());
                recursiveButton.addSelectionListener((SelectionListener)new SelectionAdapter((RemoteImportTraceGroupElement)element, recursiveButton){
                    private final /* synthetic */ RemoteImportTraceGroupElement val$element;
                    private final /* synthetic */ Button val$recursiveButton;
                    {
                        this.val$element = remoteImportTraceGroupElement;
                        this.val$recursiveButton = button;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.val$element.setRecursive(this.val$recursiveButton.getSelection());
                        RemoteProfilesPreferencePage.this.fTreeViewer.refresh((Object)this.val$element, true);
                    }
                });
            } else if (selection instanceof TracePackageTraceElement) {
                element = (TracePackageTraceElement)selection;
                Label label = new Label(this.fComposite, 0);
                label.setText(RemoteMessages.RemoteProfilesPreferencePage_FilePatternLabel);
                Text fileNameText = new Text(this.fComposite, 2048);
                TracePackageElement[] tracePackageElementArray = element.getChildren();
                int n3 = tracePackageElementArray.length;
                int recursiveButton = 0;
                while (recursiveButton < n3) {
                    TracePackageElement child = tracePackageElementArray[recursiveButton];
                    if (child instanceof TracePackageFilesElement) {
                        TracePackageFilesElement files = (TracePackageFilesElement)child;
                        fileNameText.setText(files.getFileName());
                    }
                    ++recursiveButton;
                }
                gd = new GridData(4, 0x1000000, true, false);
                fileNameText.setLayoutData((Object)gd);
                fileNameText.addModifyListener(new ModifyListener((TracePackageTraceElement)element, fileNameText){
                    private final /* synthetic */ TracePackageTraceElement val$element;
                    private final /* synthetic */ Text val$fileNameText;
                    {
                        this.val$element = tracePackageTraceElement;
                        this.val$fileNameText = text;
                    }

                    public void modifyText(ModifyEvent e) {
                        TracePackageElement[] tracePackageElementArray = this.val$element.getChildren();
                        int n = tracePackageElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TracePackageElement child = tracePackageElementArray[n2];
                            if (child instanceof TracePackageFilesElement) {
                                TracePackageFilesElement files = (TracePackageFilesElement)child;
                                files.setFileName(this.val$fileNameText.getText().trim());
                            }
                            ++n2;
                        }
                        RemoteProfilesPreferencePage.this.fTreeViewer.refresh((Object)this.val$element, true);
                        RemoteProfilesPreferencePage.this.validate();
                    }
                });
                label = new Label(this.fComposite, 0);
                label.setText(RemoteMessages.RemoteProfilesPreferencePage_TraceTypeLabel);
                final Combo combo = new Combo(this.fComposite, 2056);
                String[] availableTraceTypes = TmfTraceType.getAvailableTraceTypes();
                String[] traceTypeList = new String[availableTraceTypes.length + 1];
                traceTypeList[0] = TRACE_TYPE_AUTO_DETECT;
                System.arraycopy(availableTraceTypes, 0, traceTypeList, 1, availableTraceTypes.length);
                combo.setItems(traceTypeList);
                combo.select(0);
                int i = 1;
                while (i < traceTypeList.length) {
                    String traceType = traceTypeList[i];
                    String traceTypeId = TmfTraceType.getTraceTypeId((String)traceType);
                    if (traceTypeId.equals(element.getTraceType())) {
                        combo.select(i);
                        break;
                    }
                    ++i;
                }
                gd = new GridData(4, 0x1000000, true, false);
                combo.setLayoutData((Object)gd);
                combo.addSelectionListener((SelectionListener)new SelectionAdapter((TracePackageTraceElement)element){
                    private final /* synthetic */ TracePackageTraceElement val$element;
                    {
                        this.val$element = tracePackageTraceElement;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        if (combo.getSelectionIndex() == 0) {
                            this.val$element.setTraceType(null);
                        } else {
                            String traceType = combo.getText();
                            String traceTypeId = TmfTraceType.getTraceTypeId((String)traceType);
                            this.val$element.setTraceType(traceTypeId);
                        }
                    }
                });
            }
            this.fComposite.layout();
        }
    }
}

