/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.single;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.single.DiscriminatorBucketNode;
import org.eclipse.viatra.query.runtime.rete.single.SingleInputNode;

public class DiscriminatorDispatcherNode
extends SingleInputNode {
    private int discriminationColumnIndex;
    private Map<Object, DiscriminatorBucketNode> buckets = new HashMap<Object, DiscriminatorBucketNode>();

    public DiscriminatorDispatcherNode(ReteContainer reteContainer, int discriminationColumnIndex) {
        super(reteContainer);
        this.discriminationColumnIndex = discriminationColumnIndex;
    }

    @Override
    public void update(Direction direction, Tuple updateElement) {
        Object dispatchKey = updateElement.get(this.discriminationColumnIndex);
        DiscriminatorBucketNode bucket = this.buckets.get(dispatchKey);
        if (bucket != null) {
            this.reteContainer.sendUpdateInternal(bucket, direction, updateElement);
        }
    }

    public int getDiscriminationColumnIndex() {
        return this.discriminationColumnIndex;
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        this.propagatePullInto(collector);
    }

    public void pullIntoFiltered(Collection<Tuple> collector, Object bucketKey) {
        ArrayList<Tuple> unfiltered = new ArrayList<Tuple>();
        this.propagatePullInto(unfiltered);
        for (Tuple tuple : unfiltered) {
            if (!bucketKey.equals(tuple.get(this.discriminationColumnIndex))) continue;
            collector.add(tuple);
        }
    }

    @Override
    public void appendChild(Receiver receiver) {
        DiscriminatorBucketNode bucket;
        DiscriminatorBucketNode old;
        super.appendChild(receiver);
        if (receiver instanceof DiscriminatorBucketNode && (old = this.buckets.put((bucket = (DiscriminatorBucketNode)receiver).getBucketKey(), bucket)) != null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeChild(Receiver receiver) {
        DiscriminatorBucketNode bucket;
        DiscriminatorBucketNode old;
        super.removeChild(receiver);
        if (receiver instanceof DiscriminatorBucketNode && (old = this.buckets.remove((bucket = (DiscriminatorBucketNode)receiver).getBucketKey())) != bucket) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected String toStringCore() {
        return String.valueOf(super.toStringCore()) + '<' + this.discriminationColumnIndex + '>';
    }
}

