/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.extensibility;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQueryGroup;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.PackageBasedQueryGroup;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.viatra.query.runtime.extensibility.SingletonQuerySpecificationProvider;
import org.eclipse.viatra.query.runtime.registry.IDefaultRegistryView;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.connector.SpecificationMapSourceConnector;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public final class QuerySpecificationRegistry {
    private static final String DYNAMIC_CONNECTOR_ID = "org.eclipse.viatra.query.runtime.registy.dynamic.connector";
    private static final String DUPLICATE_FQN_MESSAGE = "[QuerySpecificationRegistry] Trying to register duplicate FQN (%s). Check your plug-in configuration!";
    private static final QuerySpecificationRegistry INSTANCE = new QuerySpecificationRegistry();
    private final SpecificationMapSourceConnector dynamicSpecificationsConnector;

    private static QuerySpecificationRegistry getInstance() {
        return INSTANCE;
    }

    private QuerySpecificationRegistry() {
        IQuerySpecificationRegistry internalRegistry = org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry.getInstance();
        this.dynamicSpecificationsConnector = new SpecificationMapSourceConnector(DYNAMIC_CONNECTOR_ID, true);
        internalRegistry.addSource(this.dynamicSpecificationsConnector);
    }

    private IQuerySpecificationRegistry getInternalRegistry() {
        IQuerySpecificationRegistry internalRegistry = org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry.getInstance();
        return internalRegistry;
    }

    private SpecificationMapSourceConnector getDynamicSpecificationsConnector() {
        this.getInternalRegistry();
        return this.dynamicSpecificationsConnector;
    }

    private IDefaultRegistryView getDefaultView() {
        IQuerySpecificationRegistry registry = this.getInternalRegistry();
        return registry.getDefaultView();
    }

    public static void registerQuerySpecification(IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> specification) {
        QuerySpecificationRegistry querySpecificationRegistry = QuerySpecificationRegistry.getInstance();
        querySpecificationRegistry.addQuerySpecification(new SingletonQuerySpecificationProvider(specification));
    }

    private void addQuerySpecificationInternal(IQuerySpecificationProvider specificationProvider) {
        String qualifiedName = specificationProvider.getFullyQualifiedName();
        SpecificationMapSourceConnector connector = this.getDynamicSpecificationsConnector();
        if (!connector.hasQuerySpecificationFQN(qualifiedName)) {
            connector.addQuerySpecificationProvider(specificationProvider);
        } else {
            ViatraQueryLoggingUtil.getLogger(QuerySpecificationRegistry.class).warn((Object)String.format(DUPLICATE_FQN_MESSAGE, qualifiedName));
        }
    }

    private void addQuerySpecification(IQuerySpecificationProvider specificationProvider) {
        this.addQuerySpecificationInternal(specificationProvider);
    }

    public static void unregisterQuerySpecification(String patternFQN) {
        QuerySpecificationRegistry.getInstance().removeQuerySpecification(patternFQN);
    }

    private void removeQuerySpecification(String patternFQN) {
        SpecificationMapSourceConnector connector = this.getDynamicSpecificationsConnector();
        if (connector.hasQuerySpecificationFQN(patternFQN)) {
            connector.removeQuerySpecificationProvider(patternFQN);
        }
    }

    public static Set<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>> getContributedQuerySpecifications() {
        IQueryGroup queryGroup = QuerySpecificationRegistry.getInstance().getDefaultView().getQueryGroup();
        Set<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>> specifications = queryGroup.getSpecifications();
        return specifications;
    }

    private boolean hasQueryRegisteredWithFQN(String queryFQN) {
        return this.getDefaultView().hasQuerySpecificationFQN(queryFQN);
    }

    public static IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> getQuerySpecification(String patternFQN) {
        if (patternFQN != null && QuerySpecificationRegistry.getInstance().hasQueryRegisteredWithFQN(patternFQN)) {
            return QuerySpecificationRegistry.getInstance().getRegisteredSpecification(patternFQN);
        }
        return null;
    }

    private IQuerySpecification<?> getRegisteredSpecification(String queryFQN) {
        Preconditions.checkArgument((queryFQN != null ? 1 : 0) != 0, (Object)"Query FQN must not be null!");
        IQuerySpecificationRegistryEntry registryEntry = this.getDefaultView().getEntry(queryFQN);
        return (IQuerySpecification)registryEntry.get();
    }

    public static Set<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>> getPatternGroup(String packageFQN) {
        return new PackageBasedQueryGroup(packageFQN).getSpecifications();
    }

    public static Set<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>> getPatternSubTree(String packageFQN) {
        return new PackageBasedQueryGroup(packageFQN, true).getSpecifications();
    }
}

