/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sshd.client.kex;

import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.kex.DH;
import org.apache.sshd.common.kex.DHGroupData;

/**
 * DHG14 does not work with the default JCE implementation provided by Sun
 * because it does not support 2048 bits encryption.
 * It requires BouncyCastle to be used.
 *
 * @author <a href="mailto:dev@mina.apache.org">Apache MINA SSHD Project</a>
 */
public class DHG14 extends AbstractDHGClient {

    /**
     * Named factory for DHG14 key exchange
     */
    public static class Factory implements NamedFactory<KeyExchange> {

        public String getName() {
            return "diffie-hellman-group14-sha1";
        }

        public KeyExchange create() {
            return new DHG14();
        }

    }

    protected void initDH(DH dh) {
        dh.setG(DHGroupData.getG());
        dh.setP(DHGroupData.getP14());
    }

}
