/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui;

import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public final class ImageUtils {
    public static ImageData rotateLeft(ImageData source) {
        ImageData result = new ImageData(source.height, source.width, source.depth, source.palette);
        result.transparentPixel = source.transparentPixel;
        int x = 0;
        while (x < source.width) {
            int y = 0;
            while (y < source.height) {
                int newX = y;
                int newY = result.height - x - 1;
                result.setPixel(newX, newY, source.getPixel(x, y));
                result.setAlpha(newX, newY, source.getAlpha(x, y));
                ++y;
            }
            ++x;
        }
        return result;
    }

    public static ImageData flip(ImageData source) {
        ImageData result = (ImageData)source.clone();
        result.transparentPixel = source.transparentPixel;
        int y = 0;
        while (y < source.height) {
            int x = 0;
            while (x < source.width) {
                int newX = source.width - x - 1;
                result.setPixel(newX, y, source.getPixel(x, y));
                result.setAlpha(newX, y, source.getAlpha(x, y));
                ++x;
            }
            ++y;
        }
        return result;
    }

    public static Image createTransparentImage(int width, int height, Color transparent) {
        Image tmp = new Image(null, width, height);
        ImageData data = tmp.getImageData();
        tmp.dispose();
        data.transparentPixel = data.palette.getPixel(transparent.getRGB());
        int i = 0;
        while (i < data.width) {
            int j = 0;
            while (j < data.height) {
                data.setPixel(i, j, data.transparentPixel);
                ++j;
            }
            ++i;
        }
        return new Image(null, data);
    }

    public static Image getImage(IMarker marker) {
        switch (marker.getAttribute("severity", -1)) {
            case 2: {
                return CommonUIPlugin.getDefault().getImageRegistry().get("ovr/error.gif");
            }
            case 1: {
                return CommonUIPlugin.getDefault().getImageRegistry().get("ovr/warning.gif");
            }
            case 0: {
                return CommonUIPlugin.getDefault().getImageRegistry().get("ovr/info.gif");
            }
        }
        return null;
    }
}

