/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.GitLabelProvider;
import org.eclipse.egit.ui.internal.PreferenceBasedDateFormatter;
import org.eclipse.egit.ui.internal.SWTUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.decorators.DecoratableResource;
import org.eclipse.egit.ui.internal.decorators.DecorationResult;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.resources.IResourceState;
import org.eclipse.egit.ui.internal.synchronize.mapping.GitChangeSetLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class GitDecoratorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private GeneralTab generalTab;
    private TextDecorationTab textDecorationTab;
    private IconDecorationTab iconDecorationTab;
    private OtherDecorationTab otherDecorationTab;
    private Preview navigatorPreview;
    private Preview changeSetPreview;
    private boolean tabsInitialized;
    private static final String SAMPLE_COMMIT_MESSAGE = "Commit message text";
    private static final Collection PREVIEW_FILESYSTEM_ROOT;
    private static final Map<String, String> FILE_AND_FOLDER_BINDINGS;
    private static final Map<String, String> PROJECT_BINDINGS;
    private static final Map<String, String> CHANGESET_LABEL_BINDINGS;
    private IPropertyChangeListener themeListener;
    private IPropertyChangeListener uiPrefsListener;

    static {
        PreviewResource project = new PreviewResource("Project", 4, "repository|" + RepositoryState.MERGING.getDescription(), "master", "\u21912 \u21931", true, false, true, IResourceState.StagingState.NOT_STAGED, false, false);
        ArrayList<PreviewResource> children = new ArrayList<PreviewResource>();
        children.add(new PreviewResource("folder", 2, "repository", null, null, true, false, true, IResourceState.StagingState.NOT_STAGED, false, false));
        children.add(new PreviewResource("submodule", 2, "submodule", "master 5bef90d", null, true, false, true, IResourceState.StagingState.NOT_STAGED, false, false));
        children.add(new PreviewResource("tracked.txt", 1, "repository", null, null, true, false, false, IResourceState.StagingState.NOT_STAGED, false, false));
        children.add(new PreviewResource("untracked.txt", 1, "repository", null, null, false, false, false, IResourceState.StagingState.NOT_STAGED, false, false));
        children.add(new PreviewResource("ignored.txt", 1, "repository", null, null, false, true, false, IResourceState.StagingState.NOT_STAGED, false, false));
        children.add(new PreviewResource("dirty.txt", 1, "repository", null, null, true, false, true, IResourceState.StagingState.NOT_STAGED, false, false));
        children.add(new PreviewResource("staged.txt", 1, "repository", null, null, true, false, false, IResourceState.StagingState.MODIFIED, false, false));
        children.add(new PreviewResource("partially-staged.txt", 1, "repository", null, null, true, false, true, IResourceState.StagingState.MODIFIED, false, false));
        children.add(new PreviewResource("added.txt", 1, "repository", null, null, true, false, false, IResourceState.StagingState.ADDED, false, false));
        children.add(new PreviewResource("removed.txt", 1, "repository", null, null, true, false, false, IResourceState.StagingState.REMOVED, false, false));
        children.add(new PreviewResource("conflict.txt", 1, "repository", null, null, true, false, true, IResourceState.StagingState.NOT_STAGED, true, false));
        children.add(new PreviewResource("assume-unchanged.txt", 1, "repository", null, null, true, false, false, IResourceState.StagingState.NOT_STAGED, false, true));
        project.children = children;
        PREVIEW_FILESYSTEM_ROOT = Collections.singleton(project);
        FILE_AND_FOLDER_BINDINGS = new HashMap<String, String>();
        FILE_AND_FOLDER_BINDINGS.put("name", UIText.DecoratorPreferencesPage_bindingResourceName);
        FILE_AND_FOLDER_BINDINGS.put("dirty", UIText.DecoratorPreferencesPage_bindingDirtyFlag);
        FILE_AND_FOLDER_BINDINGS.put("staged", UIText.DecoratorPreferencesPage_bindingStagedFlag);
        PROJECT_BINDINGS = new HashMap<String, String>();
        PROJECT_BINDINGS.put("name", UIText.DecoratorPreferencesPage_bindingResourceName);
        PROJECT_BINDINGS.put("dirty", UIText.DecoratorPreferencesPage_bindingDirtyFlag);
        PROJECT_BINDINGS.put("staged", UIText.DecoratorPreferencesPage_bindingStagedFlag);
        PROJECT_BINDINGS.put("repository", UIText.GitDecoratorPreferencePage_bindingRepositoryNameFlag);
        PROJECT_BINDINGS.put("branch", UIText.DecoratorPreferencesPage_bindingBranchName);
        PROJECT_BINDINGS.put("branch_status", UIText.DecoratorPreferencesPage_bindingBranchStatus);
        PROJECT_BINDINGS.put("short_message", UIText.DecoratorPreferencesPage_bindingCommitMessage);
        CHANGESET_LABEL_BINDINGS = new HashMap<String, String>();
        CHANGESET_LABEL_BINDINGS.put(GitDecoratorPreferencePage.removeBraces("{author}"), UIText.DecoratorPreferencesPage_bindingChangeSetAuthor);
        CHANGESET_LABEL_BINDINGS.put(GitDecoratorPreferencePage.removeBraces("{date}"), UIText.DecoratorPreferencesPage_bindingChangeSetDate);
        CHANGESET_LABEL_BINDINGS.put(GitDecoratorPreferencePage.removeBraces("{committer}"), UIText.DecoratorPreferencesPage_bindingChangeSetCommitter);
        CHANGESET_LABEL_BINDINGS.put(GitDecoratorPreferencePage.removeBraces("{short_message}"), UIText.DecoratorPreferencesPage_bindingChangeSetShortMessage);
    }

    private static String removeBraces(String string) {
        return string.replaceAll("[}{]", "");
    }

    protected Control createContents(Composite parent) {
        Composite composite = SWTUtils.createHVFillComposite(parent, 0);
        SWTUtils.createLabel(composite, UIText.DecoratorPreferencesPage_description);
        Composite folderComposite = SWTUtils.createHFillComposite(composite, 0);
        TabFolder tabFolder = new TabFolder(folderComposite, 0);
        tabFolder.setLayoutData((Object)SWTUtils.createHVFillGridData());
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GitDecoratorPreferencePage.this.navigatorPreview != null && GitDecoratorPreferencePage.this.changeSetPreview != null) {
                    if (UIText.DecoratorPreferencesPage_otherDecorations.equals(e.item.getData())) {
                        GitDecoratorPreferencePage.this.navigatorPreview.hide();
                        GitDecoratorPreferencePage.this.changeSetPreview.show();
                    } else {
                        GitDecoratorPreferencePage.this.changeSetPreview.hide();
                        GitDecoratorPreferencePage.this.navigatorPreview.show();
                    }
                }
            }
        });
        this.changeSetPreview = new ChangeSetPreview(composite);
        this.navigatorPreview = new NavigatorPreview(composite);
        this.generalTab = new GeneralTab(tabFolder);
        this.textDecorationTab = new TextDecorationTab(tabFolder);
        this.iconDecorationTab = new IconDecorationTab(tabFolder);
        this.otherDecorationTab = new OtherDecorationTab(tabFolder);
        this.initializeValues();
        this.changeSetPreview.hide();
        this.changeSetPreview.refresh();
        this.navigatorPreview.refresh();
        this.generalTab.addObserver(this.navigatorPreview);
        this.textDecorationTab.addObserver(this.navigatorPreview);
        this.iconDecorationTab.addObserver(this.navigatorPreview);
        this.otherDecorationTab.addObserver(this.changeSetPreview);
        this.themeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                GitDecoratorPreferencePage.this.navigatorPreview.refresh();
                GitDecoratorPreferencePage.this.changeSetPreview.refresh();
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeListener);
        this.uiPrefsListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("date_format".equals(property) || "date_format_choice".equals(property)) {
                    GitDecoratorPreferencePage.this.changeSetPreview.refresh();
                }
            }
        };
        this.getPreferenceStore().addPropertyChangeListener(this.uiPrefsListener);
        Dialog.applyDialogFont((Control)parent);
        return tabFolder;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.generalTab.initializeValues(store);
        this.textDecorationTab.initializeValues(store);
        this.iconDecorationTab.initializeValues(store);
        this.otherDecorationTab.initializeValues(store);
        this.setValid(true);
        this.tabsInitialized = true;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean okToClose = this.performOk(store);
        if (store.needsSaving()) {
            try {
                ((IPersistentPreferenceStore)store).save();
                Activator.broadcastPropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.egit.ui.DECORATORS_CHANGED", null, null));
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        return okToClose;
    }

    private boolean performOk(IPreferenceStore store) {
        this.generalTab.performOk(store);
        this.textDecorationTab.performOk(store);
        this.iconDecorationTab.performOk(store);
        this.otherDecorationTab.performOk(store);
        return true;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.generalTab.performDefaults(store);
        this.textDecorationTab.performDefaults(store);
        this.iconDecorationTab.performDefaults(store);
        this.otherDecorationTab.performDefaults(store);
        super.performDefaults();
        this.navigatorPreview.refresh();
        this.changeSetPreview.refresh();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void dispose() {
        if (this.themeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.themeListener);
        }
        if (this.uiPrefsListener != null) {
            this.getPreferenceStore().removePropertyChangeListener(this.uiPrefsListener);
        }
        super.dispose();
    }

    private class ChangeSetPreview
    extends Preview
    implements ITreeContentProvider {
        public ChangeSetPreview(Composite composite) {
            super(composite);
            this.fViewer.setContentProvider((IContentProvider)this);
            this.fViewer.setLabelProvider((IBaseLabelProvider)new GitLabelProvider(){

                @Override
                public Image getImage(Object element) {
                    if (element instanceof GitModelCommitMockup) {
                        return this.getChangesetIcon();
                    }
                    return super.getImage(element);
                }

                @Override
                public String getText(Object element) {
                    if (element instanceof GitModelCommitMockup) {
                        String format = ChangeSetPreview.this.store.getString("sync_view_changeset_pattern");
                        return ((GitModelCommitMockup)element).getMokeupText(format);
                    }
                    return super.getText(element);
                }
            });
            this.fViewer.setContentProvider((IContentProvider)this);
            this.fViewer.setInput((Object)new GitModelCommitMockup());
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{inputElement};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        @Override
        public void refresh() {
            this.store = new PreferenceStore();
            GitDecoratorPreferencePage.this.performOk((IPreferenceStore)this.store);
            this.fViewer.refresh(true);
        }
    }

    private static final class FormatEditor
    extends SelectionAdapter {
        private final Text text;
        private final Map bindings;
        private final String key;

        public FormatEditor(Composite composite, String title, String buttonText, Map bindings, String key) {
            this.key = key;
            this.bindings = bindings;
            Label label = SWTUtils.createLabel(composite, title);
            label.setLayoutData((Object)SWTUtils.createGridData(-1, -1, false, false));
            this.text = SWTUtils.createText(composite);
            Button button = new Button(composite, 0);
            button.setText(buttonText);
            button.setLayoutData((Object)new GridData());
            button.addSelectionListener((SelectionListener)this);
        }

        public void addModifyListener(ModifyListener listener) {
            this.text.addModifyListener(listener);
        }

        public void widgetSelected(SelectionEvent e) {
            LabelProvider labelProvider = new LabelProvider(){

                public String getText(Object element) {
                    return ((Map.Entry)element).getKey() + " - " + ((Map.Entry)element).getValue();
                }
            };
            ArrayContentProvider contentsProvider = ArrayContentProvider.getInstance();
            ListSelectionDialog dialog = new ListSelectionDialog(this.text.getShell(), this.bindings.entrySet(), (IStructuredContentProvider)contentsProvider, (ILabelProvider)labelProvider, UIText.DecoratorPreferencesPage_selectVariablesToAdd);
            dialog.setHelpAvailable(false);
            dialog.setTitle(UIText.DecoratorPreferencesPage_addVariablesTitle);
            if (dialog.open() != 0) {
                return;
            }
            Object[] result = dialog.getResult();
            int i = 0;
            while (i < result.length) {
                this.text.insert("{" + ((Map.Entry)result[i]).getKey() + "}");
                ++i;
            }
        }

        public void performOk(IPreferenceStore store) {
            store.setValue(this.key, this.text.getText());
        }

        public void performDefaults(IPreferenceStore store) {
            store.setToDefault(this.key);
            this.text.setText(store.getDefaultString(this.key));
        }

        public void initializeValue(IPreferenceStore store) {
            this.text.setText(store.getString(this.key));
        }
    }

    private class GeneralTab
    extends Tab
    implements SelectionListener {
        private Button recomputeAncestorDecorations;

        public GeneralTab(TabFolder parent) {
            Composite composite = SWTUtils.createHVFillComposite((Composite)parent, -1, 1);
            this.recomputeAncestorDecorations = SWTUtils.createCheckBox(composite, UIText.DecoratorPreferencesPage_recomputeAncestorDecorations);
            this.recomputeAncestorDecorations.setToolTipText(UIText.DecoratorPreferencesPage_recomputeAncestorDecorationsTooltip);
            SWTUtils.createPreferenceLink((IWorkbenchPreferenceContainer)GitDecoratorPreferencePage.this.getContainer(), composite, "org.eclipse.ui.preferencePages.Decorators", UIText.DecoratorPreferencesPage_labelDecorationsLink);
            SWTUtils.createPreferenceLink((IWorkbenchPreferenceContainer)GitDecoratorPreferencePage.this.getContainer(), composite, "org.eclipse.ui.preferencePages.ColorsAndFonts", UIText.DecoratorPreferencesPage_colorsAndFontsLink);
            this.recomputeAncestorDecorations.addSelectionListener((SelectionListener)this);
            TabItem tabItem = new TabItem(parent, 0);
            tabItem.setText(UIText.DecoratorPreferencesPage_generalTabFolder);
            tabItem.setControl((Control)composite);
        }

        @Override
        public void initializeValues(IPreferenceStore store) {
            this.recomputeAncestorDecorations.setSelection(store.getBoolean("decorator_recompute_ancestors"));
        }

        @Override
        public void performDefaults(IPreferenceStore store) {
            this.recomputeAncestorDecorations.setSelection(store.getDefaultBoolean("decorator_recompute_ancestors"));
        }

        @Override
        public void performOk(IPreferenceStore store) {
            store.setValue("decorator_recompute_ancestors", this.recomputeAncestorDecorations.getSelection());
        }

        public void widgetSelected(SelectionEvent e) {
            this.setChanged();
            this.notifyObservers();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private static class GitModelCommitMockup {
        private static final String author = "Author Name";
        private static final Date date = new Date();
        private static final String committer = "Committer Name";

        private GitModelCommitMockup() {
        }

        public String getMokeupText(String format) {
            PreferenceBasedDateFormatter formatter = PreferenceBasedDateFormatter.create();
            HashMap<String, String> bindings = new HashMap<String, String>();
            bindings.put("{date}", formatter.formatDate(date));
            bindings.put("{author}", author);
            bindings.put("{committer}", committer);
            bindings.put("{short_message}", GitDecoratorPreferencePage.SAMPLE_COMMIT_MESSAGE);
            return GitChangeSetLabelProvider.formatName(format, bindings);
        }
    }

    private class IconDecorationTab
    extends Tab
    implements SelectionListener {
        private Button showTracked;
        private Button showUntracked;
        private Button showStaged;
        private Button showConflicts;
        private Button showAssumeUnchanged;
        private Button showDirty;

        public IconDecorationTab(TabFolder parent) {
            Composite composite = SWTUtils.createHVFillComposite((Composite)parent, -1, 2);
            this.showTracked = SWTUtils.createCheckBox(composite, UIText.DecoratorPreferencesPage_iconsShowTracked);
            this.showUntracked = SWTUtils.createCheckBox(composite, UIText.DecoratorPreferencesPage_iconsShowUntracked);
            this.showStaged = SWTUtils.createCheckBox(composite, UIText.DecoratorPreferencesPage_iconsShowStaged);
            this.showConflicts = SWTUtils.createCheckBox(composite, UIText.DecoratorPreferencesPage_iconsShowConflicts);
            this.showAssumeUnchanged = SWTUtils.createCheckBox(composite, UIText.DecoratorPreferencesPage_iconsShowAssumeUnchanged);
            this.showDirty = SWTUtils.createCheckBox(composite, UIText.GitDecoratorPreferencePage_iconsShowDirty);
            this.showTracked.addSelectionListener((SelectionListener)this);
            this.showUntracked.addSelectionListener((SelectionListener)this);
            this.showStaged.addSelectionListener((SelectionListener)this);
            this.showConflicts.addSelectionListener((SelectionListener)this);
            this.showAssumeUnchanged.addSelectionListener((SelectionListener)this);
            this.showDirty.addSelectionListener((SelectionListener)this);
            TabItem tabItem = new TabItem(parent, 0);
            tabItem.setText(UIText.DecoratorPreferencesPage_iconLabel);
            tabItem.setControl((Control)composite);
        }

        @Override
        public void initializeValues(IPreferenceStore store) {
            this.showTracked.setSelection(store.getBoolean("decorator_show_tracked_icon"));
            this.showUntracked.setSelection(store.getBoolean("decorator_show_untracked_icon"));
            this.showStaged.setSelection(store.getBoolean("decorator_show_staged_icon"));
            this.showConflicts.setSelection(store.getBoolean("decorator_show_conflicts_icon"));
            this.showAssumeUnchanged.setSelection(store.getBoolean("decorator_show_assume_valid_icon"));
            this.showDirty.setSelection(store.getBoolean("decorator_show_dirty_icon"));
        }

        @Override
        public void performDefaults(IPreferenceStore store) {
            this.showTracked.setSelection(store.getDefaultBoolean("decorator_show_tracked_icon"));
            this.showUntracked.setSelection(store.getDefaultBoolean("decorator_show_untracked_icon"));
            this.showStaged.setSelection(store.getDefaultBoolean("decorator_show_staged_icon"));
            this.showConflicts.setSelection(store.getDefaultBoolean("decorator_show_conflicts_icon"));
            this.showAssumeUnchanged.setSelection(store.getDefaultBoolean("decorator_show_assume_valid_icon"));
            this.showDirty.setSelection(store.getDefaultBoolean("decorator_show_dirty_icon"));
        }

        @Override
        public void performOk(IPreferenceStore store) {
            store.setValue("decorator_show_tracked_icon", this.showTracked.getSelection());
            store.setValue("decorator_show_untracked_icon", this.showUntracked.getSelection());
            store.setValue("decorator_show_staged_icon", this.showStaged.getSelection());
            store.setValue("decorator_show_conflicts_icon", this.showConflicts.getSelection());
            store.setValue("decorator_show_assume_valid_icon", this.showAssumeUnchanged.getSelection());
            store.setValue("decorator_show_dirty_icon", this.showDirty.getSelection());
        }

        public void widgetSelected(SelectionEvent e) {
            this.setChanged();
            this.notifyObservers();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class NavigatorPreview
    extends Preview
    implements ITreeContentProvider {
        private GitLightweightDecorator.DecorationHelper fHelper;

        public NavigatorPreview(Composite composite) {
            super(composite);
            this.reloadDecorationHelper();
            this.fViewer.setContentProvider((IContentProvider)this);
            this.fViewer.setLabelProvider((IBaseLabelProvider)new ResLabelProvider());
            this.fViewer.setInput((Object)PREVIEW_FILESYSTEM_ROOT);
            this.fViewer.expandAll();
            this.fHelper = new GitLightweightDecorator.DecorationHelper((IPreferenceStore)new PreferenceStore());
        }

        private void reloadDecorationHelper() {
            this.store = new PreferenceStore();
            if (GitDecoratorPreferencePage.this.tabsInitialized) {
                GitDecoratorPreferencePage.this.performOk((IPreferenceStore)this.store);
            }
            this.fHelper = new GitLightweightDecorator.DecorationHelper((IPreferenceStore)this.store);
        }

        @Override
        public void refresh() {
            this.reloadDecorationHelper();
            this.fViewer.refresh(true);
            this.setColorsAndFonts(this.fViewer.getTree().getItems());
        }

        private void setColorsAndFonts(TreeItem[] items) {
            int i = 0;
            while (i < items.length) {
                DecorationResult decoration = this.getDecoration(items[i].getData());
                items[i].setBackground(decoration.getBackgroundColor());
                items[i].setForeground(decoration.getForegroundColor());
                items[i].setFont(decoration.getFont());
                this.setColorsAndFonts(items[i].getItems());
                ++i;
            }
        }

        public Object[] getChildren(Object parentElement) {
            return ((PreviewResource)parentElement).children.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return !((PreviewResource)element).children.isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private DecorationResult getDecoration(Object element) {
            DecorationResult decoration = new DecorationResult();
            this.fHelper.decorate(decoration, (PreviewResource)element);
            return decoration;
        }

        private class ResLabelProvider
        extends LabelProvider {
            private ResLabelProvider() {
            }

            public String getText(Object element) {
                DecorationResult decoration = NavigatorPreview.this.getDecoration(element);
                StringBuilder buffer = new StringBuilder();
                String prefix = decoration.getPrefix();
                if (prefix != null) {
                    buffer.append(prefix);
                }
                buffer.append(((PreviewResource)element).getName());
                String suffix = decoration.getSuffix();
                if (suffix != null) {
                    buffer.append(suffix);
                }
                return buffer.toString();
            }

            public Image getImage(Object element) {
                String s;
                switch (((PreviewResource)element).type) {
                    case 4: {
                        s = "IMG_OBJ_PROJECT";
                        break;
                    }
                    case 2: {
                        s = "IMG_OBJ_FOLDER";
                        break;
                    }
                    default: {
                        s = "IMG_OBJ_FILE";
                    }
                }
                Image baseImage = PlatformUI.getWorkbench().getSharedImages().getImage(s);
                ImageDescriptor overlay = NavigatorPreview.this.getDecoration(element).getOverlay();
                if (overlay == null) {
                    return baseImage;
                }
                try {
                    return NavigatorPreview.this.fImageCache.createImage((ImageDescriptor)new DecorationOverlayIcon(baseImage, overlay, 3));
                }
                catch (Exception e) {
                    Activator.logError(e.getMessage(), e);
                    return null;
                }
            }
        }
    }

    private class OtherDecorationTab
    extends Tab
    implements ModifyListener {
        private final FormatEditor changeSetLabelFormat;

        public OtherDecorationTab(TabFolder parent) {
            Composite composite = SWTUtils.createHVFillComposite((Composite)parent, -1, 3);
            this.changeSetLabelFormat = new FormatEditor(composite, UIText.DecoratorPreferencesPage_changeSetLabelFormat, UIText.DecoratorPreferencesPage_addVariablesAction3, CHANGESET_LABEL_BINDINGS, "sync_view_changeset_pattern");
            TabItem tabItem = new TabItem(parent, 0);
            tabItem.setText(UIText.DecoratorPreferencesPage_otherDecorations);
            tabItem.setControl((Control)composite);
            tabItem.setData((Object)UIText.DecoratorPreferencesPage_otherDecorations);
            this.changeSetLabelFormat.addModifyListener(this);
        }

        @Override
        public void initializeValues(IPreferenceStore store) {
            this.changeSetLabelFormat.initializeValue(store);
        }

        @Override
        public void performDefaults(IPreferenceStore store) {
            this.changeSetLabelFormat.performDefaults(store);
        }

        @Override
        public void performOk(IPreferenceStore store) {
            this.changeSetLabelFormat.performOk(store);
        }

        public void modifyText(ModifyEvent e) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    private abstract class Preview
    implements Observer {
        protected PreferenceStore store = new PreferenceStore();
        protected final TreeViewer fViewer;
        private Composite composite;
        private Composite parent;
        protected final ResourceManager fImageCache = new LocalResourceManager(JFaceResources.getResources());

        public Preview(Composite parent) {
            this.parent = parent;
            this.composite = SWTUtils.createHVFillComposite(parent, 0);
            SWTUtils.createLabel(this.composite, UIText.DecoratorPreferencesPage_preview);
            this.fViewer = new TreeViewer(this.composite);
            this.fViewer.getControl().setLayoutData((Object)SWTUtils.createHVFillGridData());
        }

        @Override
        public void update(Observable o, Object arg) {
            this.refresh();
        }

        public abstract void refresh();

        public void dispose() {
            this.fImageCache.dispose();
        }

        public void hide() {
            ((GridData)this.composite.getLayoutData()).exclude = true;
            this.composite.setVisible(false);
            this.composite.layout();
            this.parent.layout();
        }

        public void show() {
            ((GridData)this.composite.getLayoutData()).exclude = false;
            this.composite.setVisible(true);
            this.composite.layout();
            this.parent.layout();
        }
    }

    private static class PreviewResource
    extends DecoratableResource {
        private final String name;
        private final int type;
        private Collection children;

        public PreviewResource(String name, int type, String repositoryName, String branch, String branchStatus, boolean tracked, boolean ignored, boolean dirty, @NonNull IResourceState.StagingState staged, boolean conflicts, boolean assumeUnchanged) {
            super(null);
            this.name = name;
            this.repositoryName = repositoryName;
            this.commitMessage = GitDecoratorPreferencePage.SAMPLE_COMMIT_MESSAGE;
            this.branch = branch;
            this.branchStatus = branchStatus;
            this.type = type;
            this.children = Collections.EMPTY_LIST;
            this.setTracked(tracked);
            this.setIgnored(ignored);
            this.setDirty(dirty);
            this.setStagingState(staged);
            this.setConflicts(conflicts);
            this.setAssumeUnchanged(assumeUnchanged);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getType() {
            return this.type;
        }
    }

    private abstract class Tab
    extends Observable {
        private Tab() {
        }

        public abstract void initializeValues(IPreferenceStore var1);

        public abstract void performDefaults(IPreferenceStore var1);

        public abstract void performOk(IPreferenceStore var1);
    }

    private class TextDecorationTab
    extends Tab
    implements ModifyListener {
        private final FormatEditor fileTextFormat;
        private final FormatEditor folderTextFormat;
        private final FormatEditor projectTextFormat;
        private final FormatEditor submoduleTextFormat;

        public TextDecorationTab(TabFolder parent) {
            Composite composite = SWTUtils.createHVFillComposite((Composite)parent, -1, 3);
            this.fileTextFormat = new FormatEditor(composite, UIText.DecoratorPreferencesPage_fileFormatLabel, UIText.DecoratorPreferencesPage_addVariablesAction, FILE_AND_FOLDER_BINDINGS, "decorator_filetext_decoration");
            this.folderTextFormat = new FormatEditor(composite, UIText.DecoratorPreferencesPage_folderFormatLabel, UIText.DecoratorPreferencesPage_addVariablesAction2, FILE_AND_FOLDER_BINDINGS, "decorator_foldertext_decoration");
            this.projectTextFormat = new FormatEditor(composite, UIText.DecoratorPreferencesPage_projectFormatLabel, UIText.DecoratorPreferencesPage_addVariablesAction3, PROJECT_BINDINGS, "decorator_projecttext_decoration");
            this.submoduleTextFormat = new FormatEditor(composite, UIText.DecoratorPreferencesPage_submoduleFormatLabel, UIText.DecoratorPreferencesPage_addVariablesAction3, PROJECT_BINDINGS, "decorator_submoduletext_decoration");
            this.fileTextFormat.addModifyListener(this);
            this.folderTextFormat.addModifyListener(this);
            this.projectTextFormat.addModifyListener(this);
            this.submoduleTextFormat.addModifyListener(this);
            TabItem tabItem = new TabItem(parent, 0);
            tabItem.setText(UIText.DecoratorPreferencesPage_textLabel);
            tabItem.setControl((Control)composite);
        }

        @Override
        public void initializeValues(IPreferenceStore store) {
            this.fileTextFormat.initializeValue(store);
            this.folderTextFormat.initializeValue(store);
            this.projectTextFormat.initializeValue(store);
            this.submoduleTextFormat.initializeValue(store);
        }

        @Override
        public void performDefaults(IPreferenceStore store) {
            this.fileTextFormat.performDefaults(store);
            this.folderTextFormat.performDefaults(store);
            this.projectTextFormat.performDefaults(store);
            this.submoduleTextFormat.performDefaults(store);
        }

        @Override
        public void performOk(IPreferenceStore store) {
            this.fileTextFormat.performOk(store);
            this.folderTextFormat.performOk(store);
            this.projectTextFormat.performOk(store);
            this.submoduleTextFormat.performOk(store);
        }

        public void modifyText(ModifyEvent e) {
            this.setChanged();
            this.notifyObservers();
        }
    }
}

