/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.handlers;

import static com.google.common.base.Preconditions.checkNotNull;

import java.util.List;

import javax.inject.Named;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ide.IDEWorkflow;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.ReviewDialog;
import org.eclipse.jface.resource.ImageRegistry;

@Creatable
public class OpenReviewDialogHandler {

    @Execute
    public void execute(@Named(IDEWorkflow.CTX_LOG_EVENT_LAST) ILogEventGroup latest, IEclipseContext context,
            @Named(IDEWorkflow.CTX_SERVERS) List<IServerDescriptor> servers, final IEventBroker broker) {
        IEclipseContext child = context.createChild("review-dialog"); //$NON-NLS-1$
        ImageRegistry imageRegistry = child.get(ImageRegistry.class);
        checkNotNull(imageRegistry);
        child.set(ILogEventGroup.class, latest);
        ReviewDialog dialog = child.get(ReviewDialog.class);
        dialog.open();
    }
}
