/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.gui.decoration;

import java.util.Set;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.teststyle.TeststyleHandler;
import org.eclipse.jubula.client.teststyle.checks.BaseCheck;
import org.eclipse.jubula.client.teststyle.checks.CheckCont;
import org.eclipse.jubula.client.teststyle.checks.DecoratingCheck;
import org.eclipse.jubula.client.teststyle.checks.Severity;
import org.eclipse.jubula.client.teststyle.checks.contexts.BaseContext;
import org.eclipse.jubula.client.teststyle.problems.ProblemCont;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.GeneralLabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratorHandler
extends GeneralLabelProvider
implements ILightweightLabelDecorator {
    private static final String ID = "org.eclipse.jubula.client.teststyle.tsTestresultDecorator";

    public void decorate(Object element, IDecoration decoration) {
        INodePO node;
        IProblem worstProblem;
        if (element == null || !TeststyleHandler.getInstance().isEnabled()) {
            return;
        }
        Severity severity = this.getWorstSeverity(this.getViolatingBaseChecks(element));
        if (element instanceof INodePO && severity != null && (worstProblem = ProblemFactory.getWorstProblem((Set)(node = (INodePO)element).getProblems())) != null && severity.ordinal() * 2 <= worstProblem.getStatus().getSeverity()) {
            severity = null;
        }
        if (severity != null) {
            switch (severity) {
                case WARNING: {
                    decoration.addOverlay(IconConstants.WARNING_IMAGE_DESCRIPTOR, 3);
                    break;
                }
                case ERROR: {
                    decoration.addOverlay(IconConstants.ERROR_IMAGE_DESCRIPTOR, 3);
                    break;
                }
            }
        }
        for (BaseCheck chk : this.getViolatingBaseChecks(element)) {
            decoration.addPrefix(chk.getPrefix(element));
            decoration.addSuffix(chk.getSuffix(element));
        }
        BaseContext cont = BaseContext.getFor(element.getClass());
        for (DecoratingCheck chk : CheckCont.getDecChecksFor(cont)) {
            if (!chk.isActive(cont) || !chk.decorate(element)) continue;
            decoration.addPrefix(chk.getPrefix(element));
            decoration.addSuffix(chk.getSuffix(element));
        }
    }

    private Set<BaseCheck> getViolatingBaseChecks(Object obj) {
        ProblemCont pCont = ProblemCont.instance;
        return pCont.getChecksFor(obj);
    }

    private Severity getWorstSeverity(Set<BaseCheck> checks) {
        Enum severity = null;
        for (BaseCheck check : checks) {
            if (severity == null) {
                severity = check.getSeverity();
                continue;
            }
            if (severity.ordinal() >= check.getSeverity().ordinal()) continue;
            severity = check.getSeverity();
        }
        return severity;
    }

    public static void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getDecoratorManager().update(DecoratorHandler.ID);
            }
        });
    }
}

