/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ImportFileBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.DialogUtils;

public class DropFileOperation {
    private DropFileOperation() {
    }

    public static void dropFiles(String[] files) {
        Object result;
        if (Persistor.instance() == null && !Status.OK_STATUS.equals(result = CommandHelper.executeCommand((String)"org.eclipse.jubula.client.ui.commands.SelectDatabase"))) {
            return;
        }
        if (!Plugin.getDefault().showSaveEditorDialog(null)) {
            return;
        }
        ArrayList<URL> fileURLs = new ArrayList<URL>();
        int i = 0;
        while (i < files.length) {
            if (files[i].toLowerCase().endsWith(".jub")) {
                try {
                    fileURLs.add(new File(files[i]).toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++i;
        }
        if (fileURLs.isEmpty()) {
            return;
        }
        if (DropFileOperation.canProceed(fileURLs)) {
            boolean open = fileURLs.size() == 1;
            ImportFileBP.getInstance().importProject(fileURLs, open);
        }
    }

    private static boolean canProceed(List<URL> files) {
        StringBuilder builder = new StringBuilder();
        builder.append(Messages.ConfirmImportDialogText);
        for (URL url : files) {
            builder.append(" ");
            builder.append(" ");
            try {
                URI uri = url.toURI();
                builder.append(Paths.get(uri).getFileName().toString());
                File f = new File(uri);
                builder.append(" ");
                builder.append("(");
                builder.append(f.length());
                builder.append(" ");
                builder.append(Messages.Bytes);
                builder.append(")");
                builder.append("\n");
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        MessageDialog dialog = new MessageDialog(null, Messages.ConfirmImportDialogTitle, null, builder.toString(), 3, new String[]{Messages.DialogMessageButton_YES, Messages.DialogMessageButton_NO}, 0);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        return dialog.getReturnCode() == 0;
    }
}

