/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.core;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.docker.core.IDockerConnectionStorageManager;
import org.eclipse.linuxtools.internal.docker.core.DefaultDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.internal.docker.core.DefaultDockerConnectionStorageManager;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerRefreshManager;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;

public class DockerConnectionManager {
    private static DockerConnectionManager instance;
    private List<IDockerConnection> connections;
    private ListenerList<IDockerConnectionManagerListener> connectionManagerListeners;
    private IDockerConnectionSettingsFinder connectionSettingsFinder = new DefaultDockerConnectionSettingsFinder();
    private IDockerConnectionStorageManager connectionStorageManager = new DefaultDockerConnectionStorageManager();

    public static DockerConnectionManager getInstance() {
        if (instance == null) {
            instance = new DockerConnectionManager();
        }
        return instance;
    }

    private DockerConnectionManager() {
        this.reloadConnections();
    }

    public void reloadConnections() {
        this.connections = this.connectionStorageManager.loadConnections();
        for (IDockerConnection connection : this.connections) {
            this.notifyListeners(connection, 0);
        }
        List<IDockerConnectionSettings> settings = this.connectionSettingsFinder.getKnownConnectionSettings();
        for (IDockerConnectionSettings setting : settings) {
            DockerConnection conn;
            if (setting == null) continue;
            if (setting.getType().equals((Object)IDockerConnectionSettings.BindingType.UNIX_SOCKET_CONNECTION)) {
                UnixSocketConnectionSettings usetting = (UnixSocketConnectionSettings)setting;
                conn = new DockerConnection.Builder().name(usetting.getName()).unixSocketConnection(usetting);
            } else {
                TCPConnectionSettings tsetting = (TCPConnectionSettings)setting;
                conn = new DockerConnection.Builder().name(tsetting.getName()).tcpConnection(tsetting);
            }
            this.addConnection(conn, false);
        }
    }

    public void setConnectionSettingsFinder(IDockerConnectionSettingsFinder connectionSettingsFinder) {
        this.connectionSettingsFinder = connectionSettingsFinder;
    }

    public void setConnectionStorageManager(IDockerConnectionStorageManager connectionStorageManager) {
        this.connectionStorageManager = connectionStorageManager;
    }

    public void saveConnections() {
        this.connectionStorageManager.saveConnections(this.connections);
    }

    public IDockerConnection[] getConnections() {
        if (this.connections == null) {
            return new IDockerConnection[0];
        }
        return this.connections.toArray(new IDockerConnection[this.connections.size()]);
    }

    public List<IDockerConnection> getAllConnections() {
        if (this.connections == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.connections);
    }

    public IDockerConnection getFirstConnection() {
        if (!this.hasConnections()) {
            return null;
        }
        return this.connections.get(0);
    }

    public boolean hasConnections() {
        return this.connections != null && !this.connections.isEmpty();
    }

    public IDockerConnection getConnectionByName(String connectionName) {
        return this.connections.stream().filter(connection -> connection.getName().equals(connectionName)).findFirst().orElse(null);
    }

    public IDockerConnection getConnectionByUri(String connectionUri) {
        return DockerConnectionManager.getInstance().getAllConnections().stream().filter(c -> c.getUri().equals(connectionUri)).findFirst().orElse(null);
    }

    public List<String> getConnectionNames() {
        return Collections.unmodifiableList(this.getAllConnections().stream().map(c -> c.getName()).filter(n -> n != null).collect(Collectors.toList()));
    }

    public IDockerConnection findConnection(String name) {
        if (name != null) {
            for (IDockerConnection connection : this.connections) {
                if (connection.getName() == null || !connection.getName().equals(name)) continue;
                return connection;
            }
        }
        return null;
    }

    public void addConnection(IDockerConnection dockerConnection) {
        this.addConnection(dockerConnection, true);
    }

    public void addConnection(IDockerConnection dockerConnection, boolean notifyListeners) {
        if (!this.connections.contains(dockerConnection)) {
            this.connections.add(dockerConnection);
            this.saveConnections();
            if (notifyListeners) {
                this.notifyListeners(dockerConnection, 0);
            }
        }
    }

    public void removeConnection(IDockerConnection connection) {
        this.connections.remove(connection);
        this.saveConnections();
        this.notifyListeners(connection, 1);
        DockerContainerRefreshManager.getInstance().removeContainerRefreshThread(connection);
    }

    public void addConnectionManagerListener(IDockerConnectionManagerListener listener) {
        if (this.connectionManagerListeners == null) {
            this.connectionManagerListeners = new ListenerList(1);
        }
        this.connectionManagerListeners.add((Object)listener);
    }

    public void removeConnectionManagerListener(IDockerConnectionManagerListener listener) {
        if (this.connectionManagerListeners != null) {
            this.connectionManagerListeners.remove((Object)listener);
        }
    }

    public void notifyListeners(IDockerConnection connection, int type) {
        if (this.connectionManagerListeners != null) {
            for (IDockerConnectionManagerListener listener : this.connectionManagerListeners) {
                listener.changeEvent(connection, type);
            }
        }
    }

    public IDockerConnectionSettings findDefaultConnectionSettings() {
        return this.connectionSettingsFinder.findDefaultConnectionSettings();
    }

    public String resolveConnectionName(IDockerConnectionSettings connectionSettings) {
        return this.connectionSettingsFinder.resolveConnectionName(connectionSettings);
    }

    public boolean updateConnection(IDockerConnection connection, String name, IDockerConnectionSettings connectionSettings) {
        boolean nameChanged = connection.setName(name);
        boolean settingsChanged = connection.setSettings(connectionSettings);
        if (nameChanged) {
            this.notifyListeners(connection, 2);
        }
        if (settingsChanged) {
            this.notifyListeners(connection, 3);
        }
        if (nameChanged || settingsChanged) {
            this.saveConnections();
            return true;
        }
        return false;
    }
}

