/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerCertificates;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.messages.AuthConfig;
import java.io.File;
import java.net.URI;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;

public class DockerClientFactory {
    public DockerClient getClient(IDockerConnectionSettings connectionSettings) throws DockerCertificateException {
        return this.getClient(connectionSettings, null);
    }

    public DockerClient getClient(IDockerConnectionSettings connectionSettings, IRegistryAccount registryAccount) throws DockerCertificateException {
        DefaultDockerClient.Builder builder = DefaultDockerClient.builder();
        if (connectionSettings.getType() == IDockerConnectionSettings.BindingType.UNIX_SOCKET_CONNECTION) {
            UnixSocketConnectionSettings unixSocketConnectionSettings = (UnixSocketConnectionSettings)connectionSettings;
            if (unixSocketConnectionSettings.hasPath()) {
                builder.uri(unixSocketConnectionSettings.getPath());
            }
        } else {
            TCPConnectionSettings tcpConnectionSettings = (TCPConnectionSettings)connectionSettings;
            if (tcpConnectionSettings.hasHost()) {
                builder.uri(URI.create(tcpConnectionSettings.getHost()));
                if (tcpConnectionSettings.getPathToCertificates() != null && !tcpConnectionSettings.getPathToCertificates().isEmpty()) {
                    builder.dockerCertificates(new DockerCertificates(new File(tcpConnectionSettings.getPathToCertificates()).toPath()));
                }
            }
        }
        if (builder.uri() == null) {
            return null;
        }
        if (registryAccount != null) {
            builder.authConfig(this.buildAuthentication(registryAccount));
        }
        return builder.build();
    }

    private AuthConfig buildAuthentication(IRegistryAccount info) {
        if (info.getUsername() != null && !info.getUsername().isEmpty()) {
            AuthConfig authAccount = AuthConfig.builder().serverAddress(info.getServerAddress()).username(info.getUsername()).email(info.getEmail()).password(info.getPassword() != null ? new String(info.getPassword()) : null).build();
            return authAccount;
        }
        return null;
    }
}

