/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.ui.view;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.sessions.SessionManager;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSession;

public class OprofileViewDeleteSessionAction
extends Action {
    private TreeViewer treeViewer;

    public OprofileViewDeleteSessionAction(TreeViewer tree) {
        super("Delete Session");
        this.treeViewer = tree;
        this.setEnabled(false);
    }

    public void run() {
        TreeSelection tsl = (TreeSelection)this.treeViewer.getSelection();
        if (tsl.getFirstElement() instanceof UiModelSession) {
            UiModelSession sess = (UiModelSession)tsl.getFirstElement();
            this.deleteSession(sess);
        }
        OprofileUiPlugin.getDefault().getOprofileView().refreshView();
    }

    private void deleteSession(UiModelSession sess) {
        String sessionName = sess.getLabelText();
        IUiModelElement[] modelEvents = sess.getChildren();
        int i = 0;
        while (i < modelEvents.length) {
            SessionManager.deleteSession((String)sessionName, (String)modelEvents[i].getLabelText());
            ++i;
        }
        if (Oprofile.OprofileProject.getProfilingBinary().equals("operf")) {
            OprofileViewDeleteSessionAction.deleteOperfDataFolder(Oprofile.OprofileProject.getProject().getFolder("oprofile_data"));
        }
    }

    public static void deleteOperfDataFolder(IFolder operfData) {
        if (operfData.exists()) {
            try {
                operfData.delete(true, null);
            }
            catch (CoreException e) {
                OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)e);
            }
        }
    }
}

