/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.objectteams.internal.osgi.weaving.OTWeavingHook;
import org.eclipse.objectteams.internal.osgi.weaving.Util;
import org.eclipse.objectteams.otre.jplis.ObjectTeamsTransformer;
import org.eclipse.objectteams.otredyn.bytecode.IRedefineStrategy;
import org.eclipse.objectteams.otredyn.bytecode.RedefineStrategyFactory;
import org.eclipse.objectteams.otredyn.transformer.IWeavingContext;
import org.eclipse.objectteams.runtime.DebugHooks;
import org.eclipse.objectteams.runtime.IReweavingTask;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public abstract class DelegatingTransformer {
    @NonNull
    static DelegatingTransformer newTransformer(OTWeavingHook.WeavingScheme weavingScheme, OTWeavingHook hook, BundleWiring wiring) {
        switch (weavingScheme) {
            case OTDRE: {
                return new OTDRETransformer(DelegatingTransformer.getWeavingContext(hook, wiring));
            }
            case OTRE: {
                return new OTRETransformer();
            }
        }
        throw new NullPointerException("WeavingScheme must be defined");
    }

    static ClassLoader getBundleLoader(final Bundle bundle) {
        return new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return bundle.loadClass(name);
            }

            @Override
            public URL getResource(String name) {
                return bundle.getResource(name);
            }
        };
    }

    static IWeavingContext getWeavingContext(final OTWeavingHook hook, final BundleWiring bundleWiring) {
        return new IWeavingContext(){

            public boolean isWeavable(String className) {
                return className != null && hook.requiresWeaving(bundleWiring, className, null) != OTWeavingHook.WeavingReason.None;
            }

            public boolean scheduleReweaving(String className, IReweavingTask task) {
                return hook.scheduleReweaving(className, task);
            }
        };
    }

    public abstract void readOTAttributes(String var1, InputStream var2, String var3, Bundle var4) throws ClassFormatError, IOException;

    public abstract byte[] transform(Bundle var1, String var2, Class<?> var3, ProtectionDomain var4, byte[] var5) throws IllegalClassFormatException;

    public abstract Collection<String> fetchAdaptedBases();

    private static class OTDRETransformer
    extends DelegatingTransformer {
        org.eclipse.objectteams.otredyn.transformer.jplis.ObjectTeamsTransformer transformer;

        public OTDRETransformer(IWeavingContext weavingContext) {
            RedefineStrategyFactory.setRedefineStrategy((IRedefineStrategy)new OTEquinoxRedefineStrategy());
            this.transformer = new org.eclipse.objectteams.otredyn.transformer.jplis.ObjectTeamsTransformer(weavingContext);
        }

        @Override
        public void readOTAttributes(String className, InputStream inputStream, String fileName, Bundle bundle) throws ClassFormatError, IOException {
            this.transformer.readOTAttributes(className, className.replace('.', '/'), inputStream, OTDRETransformer.getBundleLoader(bundle));
        }

        @Override
        public Collection<String> fetchAdaptedBases() {
            return this.transformer.fetchAdaptedBases();
        }

        @Override
        public byte[] transform(Bundle bundle, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
            return this.transformer.transform(OTDRETransformer.getBundleLoader(bundle), className, className.replace('.', '/'), classBeingRedefined, bytes);
        }
    }

    private static class OTEquinoxRedefineStrategy
    implements IRedefineStrategy {
        private static final String OT_EQUINOX_DEBUG_AGENT = "org.eclipse.objectteams.otequinox.OTEquinoxAgent";

        private OTEquinoxRedefineStrategy() {
        }

        public void redefine(Class<?> clazz, byte[] bytecode) throws ClassNotFoundException, UnmodifiableClassException {
            ClassDefinition[] arr_cd = new ClassDefinition[]{new ClassDefinition(clazz, bytecode)};
            try {
                long start = System.nanoTime();
                OTEquinoxRedefineStrategy.reflectivelyInvoke(arr_cd);
                if (Util.PROFILE) {
                    Util.profile(start, Util.ProfileKind.RedefineClasses, clazz.getName());
                }
                DebugHooks.afterRedefineClasses((String)clazz.getName());
            }
            catch (ClassFormatError | UnmodifiableClassException e) {
                System.err.println("Error redefining " + clazz.getName());
                e.printStackTrace();
                throw e;
            }
        }

        static void reflectivelyInvoke(ClassDefinition[] definitions) throws ClassNotFoundException, ClassFormatError, UnmodifiableClassException {
            try {
                Class<?> agentClass = ClassLoader.getSystemClassLoader().loadClass(OT_EQUINOX_DEBUG_AGENT);
                Method redefine = agentClass.getMethod("redefine", ClassDefinition[].class);
                redefine.invoke(null, new Object[]{definitions});
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof ClassFormatError) {
                    throw (ClassFormatError)cause;
                }
                if (cause instanceof UnmodifiableClassException) {
                    throw (UnmodifiableClassException)cause;
                }
                throw new UnmodifiableClassException(String.valueOf(cause.getClass().getName()) + ": " + cause.getMessage());
            }
            catch (ClassNotFoundException cnfe) {
                throw cnfe;
            }
            catch (Throwable t) {
                throw new UnmodifiableClassException(String.valueOf(t.getClass().getName()) + ": " + t.getMessage());
            }
        }
    }

    private static class OTRETransformer
    extends DelegatingTransformer {
        ObjectTeamsTransformer transformer = new ObjectTeamsTransformer();

        private OTRETransformer() {
        }

        @Override
        public void readOTAttributes(String className, InputStream inputStream, String fileName, Bundle bundle) throws ClassFormatError, IOException {
            this.transformer.readOTAttributes(inputStream, fileName, (Object)bundle);
        }

        @Override
        public Collection<String> fetchAdaptedBases() {
            return this.transformer.fetchAdaptedBases();
        }

        @Override
        public byte[] transform(Bundle bundle, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
            return this.transformer.transform((Object)bundle, className, classBeingRedefined, protectionDomain, bytes);
        }
    }
}

