/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGAssertNonNullExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoolean;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBuiltInIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCachedOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCachedOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCastExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCatchExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstraint;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreDataTypeShadowExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcorePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElementId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorCompositionProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorNavigationProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOppositeProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOppositePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorShadowPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGGuardExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInteger;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInvalid;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsEqual2Exp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsEqualExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsInvalidExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsKindOfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsUndefinedExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLetExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterateCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGMapExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGMapPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNativeOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNativeOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNativeProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNativePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNull;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGReal;
import org.eclipse.ocl.examples.codegen.cgmodel.CGShadowExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGShadowPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGString;
import org.eclipse.ocl.examples.codegen.cgmodel.CGText;
import org.eclipse.ocl.examples.codegen.cgmodel.CGThrowExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTupleExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTuplePart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTuplePartCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGUnboxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGUnlimited;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.cgmodel.util.AbstractExtendingCGModelVisitor;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.generator.LocalContext;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.Id2JavaExpressionVisitor;
import org.eclipse.ocl.examples.codegen.java.Id2JavaInterfaceVisitor;
import org.eclipse.ocl.examples.codegen.java.Iteration2Java;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.JavaGlobalContext;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.types.BoxedDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDescriptor;
import org.eclipse.ocl.examples.codegen.utilities.CGUtil;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.IterationManager;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.EnumerationId;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.NestedTypeId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.library.executor.AbstractDispatchOperation;
import org.eclipse.ocl.pivot.internal.library.executor.AbstractEvaluationOperation;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorDoubleIterationManager;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorSingleIterationManager;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.values.IntIntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.LongIntegerValueImpl;
import org.eclipse.ocl.pivot.library.LibraryIteration;
import org.eclipse.ocl.pivot.library.LibraryOperation;
import org.eclipse.ocl.pivot.library.LibraryProperty;
import org.eclipse.ocl.pivot.library.LibrarySimpleOperation;
import org.eclipse.ocl.pivot.library.LibraryUntypedOperation;
import org.eclipse.ocl.pivot.library.oclany.OclElementOclContainerProperty;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibPackage;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;
import org.eclipse.ocl.pivot.values.TupleValue;

public abstract class CG2JavaVisitor<@NonNull CG extends JavaCodeGenerator>
extends AbstractExtendingCGModelVisitor<Boolean, CG> {
    protected final @NonNull JavaGlobalContext<@NonNull ?> globalContext;
    protected final @NonNull GenModelHelper genModelHelper;
    protected final @NonNull CodeGenAnalyzer analyzer;
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull Id2JavaInterfaceVisitor id2JavaInterfaceVisitor;
    protected final @NonNull JavaStream js;
    protected JavaLocalContext<@NonNull ?> localContext;

    public CG2JavaVisitor(@NonNull CG codeGenerator) {
        super(codeGenerator);
        this.globalContext = ((JavaCodeGenerator)codeGenerator).getGlobalContext();
        this.genModelHelper = ((JavaCodeGenerator)this.context).getGenModelHelper();
        this.analyzer = ((JavaCodeGenerator)this.context).getAnalyzer();
        this.id2JavaInterfaceVisitor = this.createId2JavaClassVisitor();
        this.environmentFactory = this.analyzer.getCodeGenerator().getEnvironmentFactory();
        this.js = new JavaStream((JavaCodeGenerator)codeGenerator, this);
    }

    protected void addImport(@NonNull String className) {
        this.globalContext.addImport(className);
    }

    protected @NonNull Boolean appendCGEcorePropertyCallExp(@NonNull CGEcorePropertyCallExp cgPropertyCallExp, @Nullable CGValuedElement source) {
        Property asProperty = (Property)ClassUtil.nonNullState((Object)cgPropertyCallExp.getReferredProperty());
        assert (this.getESObject(asProperty) == ClassUtil.nonNullState((Object)cgPropertyCallExp.getEStructuralFeature()));
        if (source == null && !this.js.appendLocalStatements(source = this.getExpression(cgPropertyCallExp.getSource()))) {
            return false;
        }
        Boolean ecoreIsRequired = ((JavaCodeGenerator)this.context).isNonNull(asProperty);
        boolean isPrimitive = this.js.isPrimitive(cgPropertyCallExp);
        if (!isPrimitive) {
            this.appendSuppressWarningsNull(cgPropertyCallExp, ecoreIsRequired);
        }
        this.js.appendDeclaration(cgPropertyCallExp);
        this.js.append(" = ");
        this.appendEcoreGet(source, asProperty);
        this.js.append(";\n");
        return true;
    }

    protected void appendEcoreGet(@NonNull CGValuedElement cgSource, @NonNull Property asProperty) {
        CGTypeId cgTypeId = this.analyzer.getTypeId(asProperty.getOwningClass().getTypeId());
        ElementId elementId = (ElementId)ClassUtil.nonNullState((Object)cgTypeId.getElementId());
        UnboxedDescriptor requiredTypeDescriptor = ((JavaCodeGenerator)this.context).getUnboxedDescriptor(elementId);
        EStructuralFeature eStructuralFeature = (EStructuralFeature)ClassUtil.nonNullState((Object)this.getESObject(asProperty));
        String getAccessor = eStructuralFeature == OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER ? "eContainer" : this.genModelHelper.getGetAccessor(eStructuralFeature);
        java.lang.Class<?> requiredJavaClass = requiredTypeDescriptor.hasJavaClass();
        Method leastDerivedMethod = requiredJavaClass != null ? ((JavaCodeGenerator)this.context).getLeastDerivedMethod(requiredJavaClass, getAccessor) : null;
        java.lang.Class<?> unboxedSourceClass = leastDerivedMethod != null ? leastDerivedMethod.getDeclaringClass() : requiredJavaClass;
        if (unboxedSourceClass != null && unboxedSourceClass != Object.class) {
            this.js.appendAtomicReferenceTo(unboxedSourceClass, cgSource);
        } else {
            this.js.appendAtomicReferenceTo(cgSource);
        }
        this.js.append(".");
        this.js.append(getAccessor);
        this.js.append("()");
    }

    protected void appendGlobalPrefix() {
    }

    protected void appendGuardFailure(@NonNull CGGuardExp cgGuardExp) {
        this.js.append("throw new ");
        this.js.appendClassReference(InvalidValueException.class);
        this.js.append("(");
        this.js.appendString("Null " + cgGuardExp.getMessage());
        this.js.append(");\n");
    }

    protected @NonNull Boolean appendLoopCall(@NonNull CGLibraryIterationCallExp cgIterationCallExp, @Nullable CGIterator iterateResult) {
        String accumulatorName;
        CGValuedElement source = this.getExpression(cgIterationCallExp.getSource());
        List<CGIterator> iterators = cgIterationCallExp.getIterators();
        CGValuedElement body = this.getExpression(cgIterationCallExp.getBody());
        CGTypeId resultType = cgIterationCallExp.getTypeId();
        Iteration referredOperation = ((LoopExp)cgIterationCallExp.getAst()).getReferredIteration();
        java.lang.Class<?> operationClass = this.genModelHelper.getAbstractOperationClass(iterators.size());
        int arity = iterators.size();
        java.lang.Class managerClass = arity == 1 ? ExecutorSingleIterationManager.class : ExecutorDoubleIterationManager.class;
        LibraryIteration libraryIteration = (LibraryIteration)ClassUtil.nonNullState((Object)cgIterationCallExp.getLibraryIteration());
        Method actualMethod = this.getJavaMethod(libraryIteration);
        java.lang.Class<?> actualReturnClass = actualMethod != null ? actualMethod.getReturnType() : null;
        boolean actualIsNonNull = actualMethod != null && ((JavaCodeGenerator)this.context).getIsNonNull(actualMethod) == Boolean.TRUE;
        boolean expectedIsNonNull = cgIterationCallExp.isNonNull();
        String astName = this.getSymbolName(null, cgIterationCallExp.getValueName());
        String bodyName = this.getSymbolName(null, "BODY_" + astName);
        String implementationName = this.getSymbolName(null, "IMPL_" + astName);
        String managerName = this.getSymbolName(null, "MGR_" + astName);
        String staticTypeName = this.getSymbolName(null, "TYPE_" + astName);
        if (!this.js.appendLocalStatements(source)) {
            return false;
        }
        this.js.append("final ");
        this.js.appendClassReference((Boolean)true, Class.class);
        this.js.append(" " + staticTypeName + " = ");
        this.js.append("executor");
        this.js.append(".getStaticTypeOf(");
        this.js.appendValueName(source);
        this.js.append(");\n");
        this.js.append("final ");
        this.js.appendClassReference((Boolean)true, LibraryIteration.LibraryIterationExtension.class);
        this.js.append(" " + implementationName + " = (");
        this.js.appendClassReference((Boolean)null, (java.lang.Class<?>)LibraryIteration.LibraryIterationExtension.class);
        this.js.append(")" + staticTypeName + ".lookupImplementation(");
        this.js.appendReferenceTo(this.localContext.getStandardLibraryVariable(cgIterationCallExp));
        this.js.append(", ");
        this.js.appendQualifiedLiteralName((Operation)ClassUtil.nonNullState((Object)referredOperation));
        this.js.append(");\n");
        if (iterateResult != null) {
            CGValuedElement cGValuedElement = iterateResult.getInit();
            accumulatorName = this.getSymbolName(null, cGValuedElement.getValueName());
            if (!this.js.appendLocalStatements(cGValuedElement)) {
                return false;
            }
            this.js.appendDeclaration(iterateResult);
            this.js.append(" = ");
            this.js.appendValueName(cGValuedElement);
            this.js.append(";\n");
        } else {
            accumulatorName = "ACC_" + astName;
            this.js.append("final ");
            this.js.appendIsRequired(true);
            this.js.append(" Object " + accumulatorName + " = " + implementationName + ".createAccumulatorValue(");
            this.js.append("executor");
            this.js.append(", ");
            this.js.appendValueName(resultType);
            this.js.append(", ");
            this.js.appendValueName(body.getTypeId());
            this.js.append(");\n");
        }
        this.js.append("/**\n");
        this.js.append(" * Implementation of the iterator body.\n");
        this.js.append(" */\n");
        this.js.append("final ");
        this.js.appendIsRequired(true);
        this.js.append(" ");
        this.js.appendClassReference(operationClass);
        this.js.append(" " + bodyName + " = new ");
        this.js.appendClassReference(operationClass);
        this.js.append("()");
        this.js.pushClassBody(String.valueOf(operationClass));
        this.js.appendCommentWithOCL(null, body.getAst());
        this.js.append("@Override\n");
        this.js.append("public ");
        this.js.appendIsRequired(false);
        this.js.append(" Object evaluate(");
        this.js.append("final ");
        this.js.appendIsRequired(true);
        this.js.append(" ");
        this.js.appendClassReference(Executor.class);
        this.js.append(" ");
        this.js.append("executor");
        this.js.append(", ");
        this.js.append("final ");
        this.js.appendIsRequired(true);
        this.js.append(" ");
        this.js.appendClassReference(TypeId.class);
        this.js.append(" ");
        this.js.append("typeId");
        if (iterateResult != null) {
            this.js.append(", ");
            this.js.appendDeclaration(iterateResult);
        } else {
            this.js.append(", final ");
            this.js.appendIsRequired(false);
            this.js.append(" Object ");
            this.js.appendValueName(source);
        }
        for (CGParameter cGParameter : iterators) {
            this.js.append(", final ");
            this.js.appendDeclaration(cGParameter);
        }
        this.js.append(") {\n");
        this.js.pushIndentation(null);
        JavaLocalContext<@NonNull ?> javaLocalContext = this.localContext;
        try {
            this.localContext = this.globalContext.getLocalContext(cgIterationCallExp);
            this.appendReturn(body);
        }
        finally {
            this.localContext = javaLocalContext;
        }
        this.js.popIndentation();
        this.js.append("}\n");
        this.js.popClassBody(true);
        this.js.append("final ");
        this.js.appendIsRequired(true);
        this.js.append("  ");
        this.js.appendClassReference(managerClass);
        this.js.append(" " + managerName + " = new ");
        this.js.appendClassReference(managerClass);
        this.js.append("(");
        this.js.append("executor");
        this.js.append(", ");
        this.js.appendValueName(resultType);
        this.js.append(", " + bodyName + ", ");
        this.js.appendReferenceTo(CollectionValue.class, source);
        this.js.append(", " + accumulatorName + ");\n");
        this.js.appendDeclaration(cgIterationCallExp);
        this.js.append(" = ");
        if (expectedIsNonNull && !actualIsNonNull) {
            this.js.appendClassReference(ClassUtil.class);
            this.js.append(".nonNullState(");
        }
        this.js.appendClassCast(cgIterationCallExp, actualReturnClass);
        this.js.append(String.valueOf(implementationName) + ".evaluateIteration(" + managerName + ")");
        if (expectedIsNonNull && !actualIsNonNull) {
            this.js.append(")");
        }
        this.js.append(";\n");
        return true;
    }

    protected void appendReturn(@NonNull CGValuedElement body) {
        if (this.js.appendLocalStatements(body)) {
            if (body instanceof CGThrowExp) {
                body.accept(this);
            } else {
                CGInvalid cgInvalidValue = body.getInvalidValue();
                if (cgInvalidValue != null) {
                    this.js.append("throw ");
                    this.js.appendValueName(cgInvalidValue);
                } else {
                    this.js.append("return ");
                    this.js.appendValueName(body);
                }
                this.js.append(";\n");
            }
        }
    }

    protected void appendSuppressWarningsNull(@NonNull CGValuedElement cgActual, Boolean isNonNull) {
        boolean isRequired = cgActual.isNonNull();
        boolean isPrimitive = this.js.isPrimitive(cgActual);
        if (!isPrimitive && isRequired && isNonNull != Boolean.TRUE) {
            this.js.appendSuppressWarningsNull(true);
        }
    }

    protected @NonNull Id2JavaInterfaceVisitor createId2JavaClassVisitor() {
        return new Id2JavaInterfaceVisitor();
    }

    protected @NonNull Id2JavaExpressionVisitor createId2JavaExpressionVisitor(@NonNull JavaStream javaStream) {
        return new Id2JavaExpressionVisitor(javaStream);
    }

    protected boolean doClassFields(@NonNull CGClass cgClass, boolean needsBlankLine) {
        if (cgClass.getProperties().size() > 0) {
            if (needsBlankLine) {
                this.js.append("\n");
            }
            for (CGProperty cgProperty : cgClass.getProperties()) {
                cgProperty.accept(this);
            }
            needsBlankLine = true;
        }
        return needsBlankLine;
    }

    protected void doCachedOperationDispatchInstaller(@NonNull CGCachedOperation cgOperation) {
        this.js.append("private ");
        this.js.append(this.getNativeOperationClassName(cgOperation));
        this.js.append("() {\n");
        this.js.pushIndentation(null);
        for (CGCachedOperation cgFinalOperation : ClassUtil.nullFree(cgOperation.getFinalOperations())) {
            Operation asFinalOperation = (Operation)cgFinalOperation.getAst();
            assert (asFinalOperation != null);
            this.js.append("install(");
            this.js.appendClassReference(null, cgFinalOperation.getParameters().get(0));
            this.js.append(".class, ");
            this.js.append(this.getNativeOperationDirectInstanceName(asFinalOperation));
            this.js.append(");\n");
        }
        this.js.popIndentation();
        this.js.append("}\n");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void doCachedOperationBasicEvaluate(@NonNull CGOperation cgOperation) {
        @NonNull List cgParameters = ClassUtil.nullFree(cgOperation.getParameters());
        CGValuedElement body = this.getExpression(cgOperation.getBody());
        this.js.append("@Override\n");
        this.js.append("public ");
        this.js.appendIsRequired(false);
        this.js.append(" ");
        this.js.appendClassReference(Object.class);
        this.js.append(" basicEvaluate(");
        this.js.appendIsRequired(true);
        this.js.append(" ");
        this.js.appendClassReference(Executor.class);
        this.js.append(" ");
        this.js.append("executor");
        this.js.append(", ");
        this.js.appendIsRequired(true);
        this.js.append(" ");
        this.js.appendClassReference(TypedElement.class);
        this.js.append(" ");
        this.js.append("caller");
        this.js.append(", ");
        this.js.appendIsRequired(false);
        this.js.append(" ");
        this.js.appendClassReference(Object.class);
        this.js.append(" ");
        this.js.appendIsRequired(true);
        this.js.append(" [] ");
        this.js.append("sourceAndArgumentValues");
        this.js.append(") {\n");
        this.js.pushIndentation(null);
        int i = 0;
        for (CGParameter cgParameter : cgParameters) {
            if (cgParameter.getASTypeId() instanceof CollectionTypeId) {
                this.js.append("@SuppressWarnings(\"unchecked\") ");
            } else if (cgParameter.isRequired() && this.js.appendSuppressWarningsNull(false)) {
                this.js.append(" ");
            }
            this.js.appendDeclaration(cgParameter);
            this.js.append(" = (");
            this.js.appendTypeDeclaration(cgParameter);
            this.js.append(")");
            this.js.append("sourceAndArgumentValues");
            this.js.append("[" + i++ + "];\n");
        }
        this.appendReturn(body);
        this.js.popIndentation();
        this.js.append("}\n");
    }

    protected void doCachedOperationClassDirectInstance(@NonNull CGOperation cgOperation) {
        Operation asOperation = (Operation)cgOperation.getAst();
        assert (asOperation != null);
        String name = this.getNativeOperationClassName(cgOperation);
        this.js.append("protected final ");
        this.js.appendIsRequired(true);
        this.js.append(" ");
        this.js.append(name);
        this.js.append(" ");
        this.js.append(this.getNativeOperationDirectInstanceName(asOperation));
        this.js.append(" = new ");
        this.js.append(name);
        this.js.append("();\n");
    }

    protected void doCachedOperationClassInstance(@NonNull CGOperation cgOperation) {
        Operation asOperation = (Operation)cgOperation.getAst();
        assert (asOperation != null);
        String name = this.getNativeOperationClassName(cgOperation);
        this.js.append("protected final ");
        this.js.appendIsRequired(true);
        this.js.append(" ");
        this.js.append(name);
        this.js.append(" ");
        this.js.append(this.getNativeOperationInstanceName(asOperation));
        this.js.append(" = new ");
        this.js.append(name);
        this.js.append("();\n");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void doCachedOperationEvaluate(@NonNull CGOperation cgOperation) {
        Boolean isRequiredReturn;
        @NonNull List cgParameters = ClassUtil.nullFree(cgOperation.getParameters());
        Boolean bl = isRequiredReturn = cgOperation.isRequired() ? Boolean.valueOf(true) : null;
        if (cgOperation.isEcore() && cgOperation.getASTypeId() instanceof CollectionTypeId) {
            this.js.append("@SuppressWarnings(\"unchecked\")\n");
        } else if (isRequiredReturn == Boolean.TRUE) {
            this.js.appendSuppressWarningsNull(true);
        }
        this.js.append("public ");
        this.js.appendClassReference(isRequiredReturn, cgOperation);
        this.js.append(" evaluate(");
        boolean isFirst = true;
        for (CGParameter cgParameter : cgParameters) {
            if (!isFirst) {
                this.js.append(", ");
            }
            this.js.appendDeclaration(cgParameter);
            isFirst = false;
        }
        this.js.append(") {\n");
        this.js.pushIndentation(null);
        this.js.append("return (");
        this.js.appendClassReference(isRequiredReturn, cgOperation);
        this.js.append(")");
        this.js.append("evaluationCache");
        this.js.append(".getCachedEvaluationResult(this, caller, new ");
        this.js.appendIsRequired(false);
        this.js.append(" ");
        this.js.appendClassReference(Object.class);
        this.js.append("[]{");
        isFirst = true;
        for (CGParameter cgParameter : cgParameters) {
            if (!isFirst) {
                this.js.append(", ");
            }
            this.js.appendValueName(cgParameter);
            isFirst = false;
        }
        this.js.append("});\n");
        this.js.popIndentation();
        this.js.append("}\n");
    }

    protected boolean doClassMethods(@NonNull CGClass cgClass, boolean needsBlankLine) {
        for (CGOperation cgOperation : cgClass.getOperations()) {
            if (needsBlankLine) {
                this.js.append("\n");
            }
            cgOperation.accept(this);
            needsBlankLine = true;
        }
        return needsBlankLine;
    }

    protected boolean doClassStatics(@NonNull CGClass cgClass, boolean needsBlankLine) {
        return needsBlankLine;
    }

    protected boolean doNestedClasses(@NonNull CGClass cgClass, boolean needsBlankLine) {
        for (CGClass cgNestedClass : cgClass.getClasses()) {
            if (needsBlankLine) {
                this.js.append("\n");
            }
            cgNestedClass.accept(this);
            needsBlankLine = true;
        }
        return needsBlankLine;
    }

    public void generateGlobals(@NonNull Iterable<@NonNull ? extends CGValuedElement> sortedElements) {
        for (CGValuedElement cGValuedElement : sortedElements) {
            cGValuedElement.accept(this);
        }
    }

    public @NonNull Set<String> getAllImports() {
        return this.globalContext.getImports();
    }

    public @NonNull CodeGenAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public @NonNull CG getCodeGenerator() {
        return (CG)((JavaCodeGenerator)this.context);
    }

    protected @Nullable EStructuralFeature getESObject(@NonNull Property asProperty) {
        LibraryProperty libraryProperty;
        EObject esObject = asProperty.getESObject();
        if (esObject instanceof EStructuralFeature) {
            return (EStructuralFeature)esObject;
        }
        Property oppositeProperty = asProperty.getOpposite();
        if (oppositeProperty == null) {
            return null;
        }
        if (!oppositeProperty.isIsComposite() && !((libraryProperty = this.environmentFactory.getMetamodelManager().getImplementation(null, null, asProperty)) instanceof OclElementOclContainerProperty)) {
            return null;
        }
        return OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER;
    }

    protected @NonNull CGValuedElement getExpression(@Nullable CGValuedElement cgExpression) {
        return this.analyzer.getExpression(cgExpression);
    }

    public @NonNull GenModelHelper getGenModelHelper() {
        return this.genModelHelper;
    }

    private Method getJavaMethod(@NonNull LibraryIteration libraryIteration) {
        try {
            java.lang.Class<?> implementationClass = libraryIteration.getClass();
            Method method = implementationClass.getMethod("evaluateIteration", IterationManager.class);
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Method getJavaMethod(@NonNull LibraryOperation libraryOperation, int argumentSize) {
        try {
            java.lang.Class[] arguments;
            java.lang.Class<?> implementationClass = libraryOperation.getClass();
            int i = 0;
            if (libraryOperation instanceof LibrarySimpleOperation) {
                arguments = new java.lang.Class[argumentSize + 1];
            } else if (libraryOperation instanceof LibraryUntypedOperation) {
                arguments = new java.lang.Class[argumentSize + 2];
                arguments[i++] = Executor.class;
            } else {
                arguments = new java.lang.Class[argumentSize + 3];
                arguments[i++] = Executor.class;
                arguments[i++] = TypeId.class;
            }
            while (i < arguments.length) {
                arguments[i++] = Object.class;
            }
            Method method = implementationClass.getMethod("evaluate", arguments);
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Method getJavaMethod(@NonNull LibraryProperty libraryProperty) {
        try {
            java.lang.Class<?> implementationClass = libraryProperty.getClass();
            java.lang.Class @NonNull [] arguments = new java.lang.Class[]{Executor.class, TypeId.class, Object.class};
            Method method = implementationClass.getMethod("evaluate", arguments);
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected @Nullable java.lang.Class<?> getLeastDerivedClass(java.lang.Class<?> requiredClass, @NonNull String getAccessor) {
        java.lang.Class<?> superClass = requiredClass.getSuperclass();
        if (superClass != null) {
            try {
                java.lang.Class<?> lessDerivedSuperClass = this.getLeastDerivedClass(superClass, getAccessor);
                if (lessDerivedSuperClass != null) {
                    return lessDerivedSuperClass;
                }
                Method method = superClass.getMethod(getAccessor, new java.lang.Class[0]);
                if (method != null) {
                    return superClass;
                }
            }
            catch (Exception lessDerivedSuperClass) {
                // empty catch block
            }
        }
        java.lang.Class<?>[] classArray = requiredClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            java.lang.Class<?> superInterface = classArray[n2];
            java.lang.Class<?> lessDerivedSuperInterface = this.getLeastDerivedClass(superInterface, getAccessor);
            if (lessDerivedSuperInterface != null) {
                return lessDerivedSuperInterface;
            }
            try {
                Method method = superInterface.getMethod(getAccessor, new java.lang.Class[0]);
                if (method != null) {
                    return superInterface;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    protected @NonNull String getNativeOperationClassName(@NonNull CGOperation cgOperation) {
        Operation asOperation = (Operation)cgOperation.getAst();
        assert (asOperation != null);
        if (this.isVirtualDispatcher(cgOperation)) {
            return "VCACHE_" + this.getNativeOperationName(asOperation);
        }
        return "CACHE_" + this.getNativeOperationName(asOperation);
    }

    protected @NonNull String getNativeOperationDirectInstanceName(@NonNull Operation asOperation) {
        return "INST_" + this.getNativeOperationName(asOperation);
    }

    protected @NonNull String getNativeOperationInstanceName(@NonNull Operation asOperation) {
        return "INSTANCE_" + this.getNativeOperationName(asOperation);
    }

    protected @NonNull String getNativeOperationName(@NonNull Operation asOperation) {
        return String.valueOf(((Class)ClassUtil.nonNullState((Object)asOperation.getOwningClass())).getName()) + "_" + asOperation.getName();
    }

    protected @NonNull String getSymbolName(@Nullable Object anObject, String ... nameHints) {
        return this.localContext.getNameManagerContext().getSymbolName(anObject, nameHints);
    }

    protected @NonNull String getThisName(@NonNull CGElement cgElement) {
        CGElement eObject = cgElement;
        while (eObject != null) {
            if (eObject instanceof CGClass) {
                return (String)ClassUtil.nonNullState((Object)((CGClass)eObject).getName());
            }
            eObject = eObject.eContainer();
        }
        assert (false);
        return "";
    }

    protected String getValueName(@NonNull CGValuedElement cgElement) {
        String valueName = this.localContext != null ? this.localContext.getValueName(cgElement) : this.globalContext.getValueName(cgElement);
        return valueName;
    }

    protected boolean isBoxedElement(@NonNull CGValuedElement cgValue) {
        TypeId typeId = cgValue.getASTypeId();
        if (typeId instanceof EnumerationLiteralId) {
            return true;
        }
        if (typeId instanceof EnumerationId) {
            return true;
        }
        return typeId instanceof ClassId;
    }

    protected boolean isBoxedType2(@NonNull CGValuedElement cgValue) {
        TypeId typeId = cgValue.getASTypeId();
        return typeId instanceof NestedTypeId;
    }

    protected boolean isBoxedType(@NonNull CGValuedElement cgValue) {
        Element ast = cgValue.getAst();
        if (!(ast instanceof TypedElement)) {
            return false;
        }
        Type type = ((TypedElement)ast).getType();
        if (type == null) {
            return false;
        }
        if (type instanceof Enumeration) {
            return false;
        }
        PivotMetamodelManager metamodelManager = ((JavaCodeGenerator)this.context).getEnvironmentFactory().getMetamodelManager();
        Class oclTypeType = this.environmentFactory.getStandardLibrary().getOclTypeType();
        return metamodelManager.conformsTo(type, TemplateParameterSubstitutions.EMPTY, (Type)oclTypeType, TemplateParameterSubstitutions.EMPTY);
    }

    protected boolean isEnumerationLiteral(@NonNull CGValuedElement cgValue) {
        Element ast = cgValue.getAst();
        if (!(ast instanceof TypedElement)) {
            return false;
        }
        Type type = ((TypedElement)ast).getType();
        return type instanceof Enumeration;
    }

    protected boolean isVirtualDispatcher(@NonNull CGOperation cgOperation) {
        return cgOperation instanceof CGCachedOperation && ((CGCachedOperation)cgOperation).getFinalOperations().size() > 0;
    }

    public @NonNull String toString() {
        String string = this.js.toString();
        return string;
    }

    @Override
    public @NonNull Boolean visiting(@NonNull CGElement visitable) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    @Override
    public @NonNull Boolean visitCGAssertNonNullExp(@NonNull CGAssertNonNullExp cgAssertNonNullExp) {
        CGValuedElement cgSource = this.getExpression(cgAssertNonNullExp.getSource());
        if (cgSource.isNull()) {
            this.js.append("throw new ");
            this.js.appendClassReference(InvalidValueException.class);
            this.js.append("();\n");
        } else {
            if (!this.js.appendLocalStatements(cgSource)) {
                return false;
            }
            if (!cgSource.isNonNull()) {
                this.js.append("assert ");
                this.js.appendValueName(cgSource);
                this.js.append(" != null;\n");
            }
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGBoolean(@NonNull CGBoolean cgBoolean) {
        boolean booleanValue = cgBoolean.isBooleanValue();
        if (booleanValue) {
            this.js.appendTrue();
        } else {
            this.js.appendFalse();
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGBoxExp(@NonNull CGBoxExp cgBoxExp) {
        CGValuedElement unboxedValue = this.getExpression(cgBoxExp.getSource());
        TypeDescriptor unboxedTypeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(unboxedValue);
        JavaLocalContext<@NonNull ?> localContext2 = this.localContext;
        assert (localContext2 != null);
        if (!this.js.appendLocalStatements(unboxedValue)) {
            return false;
        }
        return unboxedTypeDescriptor.appendBox(this.js, localContext2, cgBoxExp, unboxedValue);
    }

    @Override
    public @NonNull Boolean visitCGBuiltInIterationCallExp(@NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        CGValuedElement cgSource = this.getExpression(cgIterationCallExp.getSource());
        CGValuedElement cgBody = this.getExpression(cgIterationCallExp.getBody());
        CGIterator cgAccumulator = cgIterationCallExp.getAccumulator();
        CGIterator cgIterator = cgIterationCallExp.getIterators().get(0);
        String iteratorName = this.getSymbolName(null, "ITERATOR_" + cgIterator.getValueName());
        Iteration2Java iterationHelper = ((JavaCodeGenerator)this.context).getIterationHelper((Iteration)ClassUtil.nonNullState((Object)cgIterationCallExp.getReferredIteration()));
        assert (iterationHelper != null);
        boolean flowContinues = false;
        if (!this.js.appendLocalStatements(cgSource)) {
            return false;
        }
        if (cgAccumulator != null) {
            CGValuedElement cgInit = cgAccumulator.getInit();
            if (cgInit != null && !this.js.appendLocalStatements(cgInit)) {
                return false;
            }
            this.js.appendDeclaration(cgAccumulator);
            this.js.append(" = ");
            iterationHelper.appendAccumulatorInit(this.js, cgIterationCallExp);
            this.js.append(";\n");
        }
        this.js.appendIsRequired(cgIterator.isRequired());
        this.js.append(" ");
        this.js.appendClassReference(Iterator.class, false, Object.class);
        this.js.append(" " + iteratorName + " = ");
        this.js.appendAtomicReferenceTo(cgSource);
        this.js.append(".iterator();\n");
        this.js.appendDeclaration(cgIterationCallExp);
        this.js.append(";\n");
        this.js.append("while (true) {\n");
        this.js.pushIndentation(null);
        this.js.append("if (!" + iteratorName + ".hasNext()) {\n");
        this.js.pushIndentation(null);
        if (iterationHelper.appendFinalValue(this.js, cgIterationCallExp)) {
            this.js.append("break;\n");
            flowContinues = true;
        }
        this.js.popIndentation();
        this.js.append("}\n");
        this.appendSuppressWarningsNull(cgIterator, Boolean.FALSE);
        this.js.appendDeclaration(cgIterator);
        this.js.append(" = ");
        this.js.appendClassCast(cgIterator);
        this.js.append(String.valueOf(iteratorName) + ".next();\n");
        this.js.appendCommentWithOCL(null, cgBody.getAst());
        if (this.js.appendLocalStatements(cgBody)) {
            this.js.append("//\n");
            if (iterationHelper.appendUpdate(this.js, cgIterationCallExp)) {
                flowContinues = true;
            }
        }
        this.js.popIndentation();
        this.js.append("}\n");
        return flowContinues;
    }

    @Override
    public @NonNull Boolean visitCGCastExp(@NonNull CGCastExp cgCastExp) {
        CGValuedElement cgSource = this.getExpression(cgCastExp.getSource());
        CGExecutorType cgType = cgCastExp.getExecutorType();
        if (cgType != null) {
            TypeDescriptor typeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(cgCastExp);
            this.js.appendDeclaration(cgCastExp);
            this.js.append(" = ");
            typeDescriptor.appendCastTerm(this.js, cgSource);
            this.js.append(";\n");
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Boolean visitCGCachedOperation(@NonNull CGCachedOperation cgOperation) {
        Operation asOperation = (Operation)cgOperation.getAst();
        assert (asOperation != null);
        @NonNull LocalContext localContext2 = this.globalContext.getLocalContext(cgOperation);
        if (localContext2 != null) {
            this.localContext = localContext2;
            boolean isVirtualDispatcher = this.isVirtualDispatcher(cgOperation);
            try {
                String operationClassName = this.getNativeOperationClassName(cgOperation);
                if (isVirtualDispatcher) {
                    this.js.append("protected class ");
                    this.js.append(operationClassName);
                    this.js.append(" extends ");
                    this.js.appendClassReference(AbstractDispatchOperation.class);
                    this.js.pushClassBody(operationClassName);
                    this.doCachedOperationDispatchInstaller(cgOperation);
                    this.js.append("\n");
                    this.doCachedOperationEvaluate(cgOperation);
                    this.js.popClassBody(false);
                    this.js.append("\n");
                    this.doCachedOperationClassInstance(cgOperation);
                } else {
                    LanguageExpression expressionInOCL = asOperation.getBodyExpression();
                    String title = PrettyPrinter.printName((Element)asOperation);
                    this.js.appendCommentWithOCL(String.valueOf(title) + "\n", (Element)expressionInOCL);
                    this.js.append("public class ");
                    this.js.append(operationClassName);
                    this.js.append(" extends ");
                    this.js.appendClassReference(AbstractEvaluationOperation.class);
                    this.js.pushClassBody(operationClassName);
                    this.doCachedOperationBasicEvaluate(cgOperation);
                    this.js.append("\n");
                    this.doCachedOperationEvaluate(cgOperation);
                    this.js.popClassBody(false);
                    if (cgOperation.getVirtualOperations().size() <= 0) {
                        this.js.append("\n");
                        this.doCachedOperationClassInstance(cgOperation);
                    } else {
                        this.js.append("\n");
                        this.doCachedOperationClassDirectInstance(cgOperation);
                    }
                }
            }
            finally {
                this.localContext = null;
            }
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGCachedOperationCallExp(@NonNull CGCachedOperationCallExp cgOperationCallExp) {
        Operation pOperation = cgOperationCallExp.getReferredOperation();
        boolean thisIsSelf = cgOperationCallExp.isThisIsSelf();
        CGValuedElement source = this.getExpression(cgOperationCallExp.getSource());
        List<CGValuedElement> cgArguments = cgOperationCallExp.getArguments();
        List pParameters = pOperation.getOwnedParameters();
        if (!this.js.appendLocalStatements(source)) {
            return false;
        }
        for (CGValuedElement cgArgument : cgArguments) {
            CGValuedElement argument = this.getExpression(cgArgument);
            if (this.js.appendLocalStatements(argument)) continue;
            return false;
        }
        this.js.appendDeclaration(cgOperationCallExp);
        this.js.append(" = ");
        this.js.append(this.getNativeOperationInstanceName(pOperation));
        this.js.append(".evaluate");
        this.js.append("(");
        if (!thisIsSelf) {
            this.js.appendValueName(source);
        }
        int iMax = Math.min(pParameters.size(), cgArguments.size());
        int i = 0;
        while (i < iMax) {
            if (i > 0 || !thisIsSelf) {
                this.js.append(", ");
            }
            CGValuedElement cgArgument = cgArguments.get(i);
            Parameter pParameter = (Parameter)pParameters.get(i);
            CGTypeId cgTypeId = this.analyzer.getTypeId(pParameter.getTypeId());
            BoxedDescriptor parameterTypeDescriptor = ((JavaCodeGenerator)this.context).getBoxedDescriptor((ElementId)ClassUtil.nonNullState((Object)cgTypeId.getElementId()));
            CGValuedElement argument = this.getExpression(cgArgument);
            this.js.appendReferenceTo(parameterTypeDescriptor, argument);
            ++i;
        }
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGCatchExp(@NonNull CGCatchExp cgCatchExp) {
        String eName = this.globalContext.getEName();
        CGValuedElement cgSource = this.getExpression(cgCatchExp.getSource());
        if (cgSource.isNonInvalid()) {
            if (!this.js.appendLocalStatements(cgSource)) {
                return false;
            }
            this.js.appendDeclaration(cgCatchExp);
            this.js.append(" = ");
            this.js.appendValueName(cgSource);
            this.js.append(";\n");
        } else {
            this.js.appendDeclaration(cgCatchExp);
            this.js.append(";\n");
            this.js.append("try {\n");
            this.js.pushIndentation(null);
            if (!this.js.appendLocalStatements(cgSource)) {
                return false;
            }
            this.js.appendValueName(cgCatchExp);
            this.js.append(" = ");
            this.js.appendValueName(cgSource);
            this.js.append(";\n");
            this.js.popIndentation();
            this.js.append("}\n");
            this.js.append("catch (");
            this.js.appendClassReference(Exception.class);
            this.js.append(" " + eName + ") {\n");
            this.js.pushIndentation(null);
            this.js.appendValueName(cgCatchExp);
            this.js.append(" = ");
            this.js.appendClassReference(ValueUtil.class);
            this.js.append(".createInvalidValue(" + eName + ");\n");
            this.js.popIndentation();
            this.js.append("}\n");
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGClass(@NonNull CGClass cgClass) {
        CGPackage containingPackage = cgClass.getContainingPackage();
        if (containingPackage != null) {
            this.js.appendClassHeader(containingPackage);
        }
        String className = cgClass.getName();
        this.js.append("public");
        if (containingPackage == null) {
            this.js.append(" static");
        }
        this.js.append(" class " + className);
        List<CGClass> cgSuperTypes = cgClass.getSuperTypes();
        boolean isFirst = true;
        for (CGClass cgSuperType : cgSuperTypes) {
            if (cgSuperType.isInterface()) continue;
            if (isFirst) {
                this.js.append("\n\textends ");
            } else {
                this.js.append(", ");
            }
            this.js.appendClassReference(cgSuperType);
            isFirst = false;
        }
        isFirst = true;
        for (CGClass cgSuperType : cgSuperTypes) {
            if (!cgSuperType.isInterface()) continue;
            if (isFirst) {
                this.js.append("\n\timplements ");
            } else {
                this.js.append(", ");
            }
            this.js.appendClassReference(cgSuperType);
            isFirst = false;
        }
        this.js.append("\n");
        this.js.append("{\n");
        this.js.pushIndentation(null);
        boolean needsBlankLine = false;
        needsBlankLine = this.doClassStatics(cgClass, needsBlankLine);
        needsBlankLine = this.doClassFields(cgClass, needsBlankLine);
        needsBlankLine = this.doClassMethods(cgClass, needsBlankLine);
        needsBlankLine = this.doNestedClasses(cgClass, needsBlankLine);
        this.js.popIndentation();
        this.js.append("}\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGCollectionExp(@NonNull CGCollectionExp cgCollectionExp) {
        int ranges = 0;
        for (CGCollectionPart cgPart : cgCollectionExp.getParts()) {
            if (cgPart.isRange()) {
                ++ranges;
            }
            if (this.js.appendLocalStatements(cgPart)) continue;
            return false;
        }
        this.js.appendDeclaration(cgCollectionExp);
        this.js.append(" = ");
        this.js.appendClassReference(ValueUtil.class);
        String kind = ((CollectionLiteralExp)cgCollectionExp.getAst()).getKind().getName();
        if (ranges > 0) {
            this.js.append(".create" + kind + "Range(");
            this.js.appendIdReference(cgCollectionExp.getTypeId().getElementId());
            for (CGCollectionPart cgPart : cgCollectionExp.getParts()) {
                this.js.append(", ");
                this.js.appendValueName(cgPart);
            }
        } else {
            this.js.append(".create" + kind + "OfEach(");
            this.js.appendIdReference(cgCollectionExp.getTypeId().getElementId());
            for (CGCollectionPart cgPart : cgCollectionExp.getParts()) {
                this.js.append(", ");
                if (cgPart.isNull() && cgCollectionExp.getParts().size() == 1) {
                    this.js.append("(Object)");
                }
                this.js.appendValueName(cgPart);
            }
        }
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGCollectionPart(@NonNull CGCollectionPart cgCollectionPart) {
        CGValuedElement first = this.getExpression(cgCollectionPart.getFirst());
        CGValuedElement last = cgCollectionPart.getLast();
        if (last != null) {
            if (!this.js.appendLocalStatements(first)) {
                return false;
            }
            if (!this.js.appendLocalStatements(last)) {
                return false;
            }
            this.js.appendDeclaration(cgCollectionPart);
            this.js.append(" = ");
            this.js.appendClassReference(ValueUtil.class);
            this.js.append(".createRange(");
            this.js.appendValueName(first);
            this.js.append(", ");
            this.js.appendValueName(last);
            this.js.append(");\n");
        } else if (first.isInlined()) {
            this.js.appendValueName(first);
        } else if (!this.js.appendLocalStatements(first)) {
            return false;
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGConstantExp(@NonNull CGConstantExp cgConstantExp) {
        CGValuedElement referredConstant = cgConstantExp.getReferredConstant();
        if (referredConstant != null && referredConstant.isInlined()) {
            referredConstant.accept(this);
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGConstraint(@NonNull CGConstraint cgConstraint) {
        this.localContext = this.globalContext.getLocalContext(cgConstraint);
        try {
            Boolean flowContinues = (Boolean)super.visitCGConstraint(cgConstraint);
            assert (flowContinues != null);
            Boolean bl = flowContinues;
            return bl;
        }
        finally {
            this.localContext = null;
        }
    }

    @Override
    public @NonNull Boolean visitCGEcoreDataTypeShadowExp(@NonNull CGEcoreDataTypeShadowExp cgShadowExp) {
        java.lang.Class<?> packageClass;
        java.lang.Class<?> factoryClass;
        EDataType eDataType = cgShadowExp.getEDataType();
        java.lang.Class javaClass = eDataType.getInstanceClass();
        if (javaClass == null) {
            throw new IllegalStateException("No Java class for " + cgShadowExp + " in CG2JavaVisitor.visitCGEcoreDataTypeShadowExp()");
        }
        EPackage ePackage = eDataType.getEPackage();
        String nsURI = ePackage.getNsURI();
        if (nsURI == null) {
            throw new IllegalStateException("No EPackage NsURI for " + cgShadowExp + " in CG2JavaVisitor.visitCGEcoreDataTypeShadowExp()");
        }
        GenPackage genPackage = this.environmentFactory.getMetamodelManager().getGenPackage(nsURI);
        if (genPackage == null) {
            throw new IllegalStateException("No GenPackage for " + cgShadowExp + " in CG2JavaVisitor.visitCGEcoreDataTypeShadowExp()");
        }
        String eFactoryName = genPackage.getQualifiedFactoryInterfaceName();
        String ePackageName = genPackage.getQualifiedPackageInterfaceName();
        String dataTypeName = CodeGenUtil.upperName((String)eDataType.getName());
        ClassLoader classLoader = eDataType.getClass().getClassLoader();
        try {
            factoryClass = classLoader.loadClass(eFactoryName);
            packageClass = eDataType.getClass().getClassLoader().loadClass(ePackageName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Load class failure for " + cgShadowExp + " in CG2JavaVisitor.visitCGEcoreDataTypeShadowExp()", e);
        }
        CGValuedElement init = (CGValuedElement)ClassUtil.nonNullState((Object)cgShadowExp.getParts().get(0).getInit());
        if (!this.js.appendLocalStatements(init)) {
            return false;
        }
        this.js.appendDeclaration(cgShadowExp);
        this.js.append(" = ");
        this.js.append("(");
        this.js.appendClassReference(javaClass);
        this.js.append(")");
        this.js.appendClassReference(factoryClass);
        this.js.append(".eINSTANCE.createFromString(");
        this.js.appendClassReference(packageClass);
        this.js.append(".Literals." + dataTypeName + ", ");
        this.js.appendValueName(init);
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGEcoreExp(@NonNull CGEcoreExp cgEcoreExp) {
        java.lang.Class ecoreClass;
        CGValuedElement boxedValue = this.getExpression(cgEcoreExp.getSource());
        TypeDescriptor boxedTypeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(boxedValue);
        JavaLocalContext<@NonNull ?> localContext2 = this.localContext;
        assert (localContext2 != null);
        if (!this.js.appendLocalStatements(boxedValue)) {
            return false;
        }
        EClassifier eClassifier = cgEcoreExp.getEClassifier();
        if (eClassifier != null && (ecoreClass = eClassifier.getInstanceClass()) != null) {
            String functionName = null;
            if (ecoreClass == BigDecimal.class) {
                functionName = "bigDecimalValueOf";
            } else if (ecoreClass == BigInteger.class) {
                functionName = "bigIntegerValueOf";
            } else if (ecoreClass == Byte.class || ecoreClass == Byte.TYPE) {
                functionName = "byteValueOf";
            } else if (ecoreClass == Character.class || ecoreClass == Character.TYPE) {
                functionName = "characterValueOf";
            } else if (ecoreClass == Double.class || ecoreClass == Double.TYPE) {
                functionName = "doubleValueOf";
            } else if (ecoreClass == Float.class || ecoreClass == Float.TYPE) {
                functionName = "floatValueOf";
            } else if (ecoreClass == Integer.class || ecoreClass == Integer.TYPE) {
                functionName = "intValueOf";
            } else if (ecoreClass == Long.class || ecoreClass == Long.TYPE) {
                functionName = "longValueOf";
            } else if (ecoreClass == Short.class || ecoreClass == Short.TYPE) {
                functionName = "shortValueOf";
            }
            if (functionName != null) {
                this.js.append("final ");
                this.js.appendClassReference(ecoreClass);
                this.js.append(" ");
                this.js.appendValueName(cgEcoreExp);
                this.js.append(" = ");
                this.js.appendClassReference(ValueUtil.class);
                this.js.append(".");
                this.js.append(functionName);
                this.js.append("(");
                this.js.appendValueName(cgEcoreExp.getSource());
                this.js.append(");\n");
                return true;
            }
        }
        return boxedTypeDescriptor.appendEcoreStatements(this.js, localContext2, cgEcoreExp, boxedValue);
    }

    @Override
    public @NonNull Boolean visitCGEcoreOperationCallExp(@NonNull CGEcoreOperationCallExp cgOperationCallExp) {
        Operation pOperation = cgOperationCallExp.getReferredOperation();
        CGTypeId cgTypeId = this.analyzer.getTypeId(pOperation.getOwningClass().getTypeId());
        UnboxedDescriptor requiredTypeDescriptor = ((JavaCodeGenerator)this.context).getUnboxedDescriptor((ElementId)ClassUtil.nonNullState((Object)cgTypeId.getElementId()));
        CGValuedElement source = this.getExpression(cgOperationCallExp.getSource());
        List<CGValuedElement> cgArguments = cgOperationCallExp.getArguments();
        List pParameters = pOperation.getOwnedParameters();
        if (!this.js.appendLocalStatements(source)) {
            return false;
        }
        for (CGValuedElement cgArgument : cgArguments) {
            CGValuedElement argument = this.getExpression(cgArgument);
            if (this.js.appendLocalStatements(argument)) continue;
            return false;
        }
        String operationAccessor = this.genModelHelper.getOperationAccessor(pOperation);
        Element asOperationCallExp = cgOperationCallExp.getAst();
        Boolean ecoreIsRequired = asOperationCallExp instanceof OperationCallExp ? ((JavaCodeGenerator)this.context).isNonNull((OperationCallExp)asOperationCallExp) : null;
        this.appendSuppressWarningsNull(cgOperationCallExp, ecoreIsRequired);
        this.js.appendDeclaration(cgOperationCallExp);
        this.js.append(" = ");
        this.js.appendAtomicReferenceTo(requiredTypeDescriptor, source);
        this.js.append(".");
        this.js.append(operationAccessor);
        this.js.append("(");
        int iMax = Math.min(pParameters.size(), cgArguments.size());
        int i = 0;
        while (i < iMax) {
            if (i > 0) {
                this.js.append(", ");
            }
            CGValuedElement cgArgument = cgArguments.get(i);
            CGValuedElement argument = this.getExpression(cgArgument);
            Parameter pParameter = (Parameter)ClassUtil.nonNullState((Object)((Parameter)pParameters.get(i)));
            GenParameter genParameter = ((JavaCodeGenerator)this.context).getGenModelHelper().getGenParameter(pParameter);
            if (genParameter != null) {
                String rawBoundType = (String)ClassUtil.nonNullState((Object)genParameter.getRawBoundType());
                TypeDescriptor typeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(argument);
                typeDescriptor.appendEcoreValue(this.js, rawBoundType, argument);
            } else {
                CGTypeId cgParameterTypeId = this.analyzer.getTypeId(pParameter.getTypeId());
                UnboxedDescriptor parameterTypeDescriptor = ((JavaCodeGenerator)this.context).getUnboxedDescriptor((ElementId)ClassUtil.nonNullState((Object)cgParameterTypeId.getElementId()));
                this.js.appendReferenceTo(parameterTypeDescriptor, argument);
            }
            ++i;
        }
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGEcorePropertyCallExp(@NonNull CGEcorePropertyCallExp cgPropertyCallExp) {
        return this.appendCGEcorePropertyCallExp(cgPropertyCallExp, null);
    }

    @Override
    public @NonNull Boolean visitCGElementId(@NonNull CGElementId cgElementId) {
        ElementId elementId = cgElementId.getElementId();
        if (elementId != null && !CGUtil.isInlinedId(elementId)) {
            this.js.append("public static final ");
            this.js.appendIsCaught(true, false);
            this.js.append(" ");
            this.js.appendClassReference((Boolean)true, (java.lang.Class)elementId.accept((IdVisitor)this.id2JavaInterfaceVisitor));
            this.js.append(" ");
            this.js.append(this.globalContext.getValueName(cgElementId));
            this.js.append(" = ");
            this.js.appendIdReference2(elementId);
            this.js.append(";\n");
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGExecutorCompositionProperty(@NonNull CGExecutorCompositionProperty cgExecutorProperty) {
        this.js.appendDeclaration(cgExecutorProperty);
        this.js.append(" = new ");
        this.js.appendClassReference(null, cgExecutorProperty);
        this.js.append("(");
        this.js.appendIdReference(cgExecutorProperty.getUnderlyingPropertyId().getElementId());
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGExecutorShadowPart(@NonNull CGExecutorShadowPart cgExecutorShadowPart) {
        this.js.appendDeclaration(cgExecutorShadowPart);
        this.js.append(" = ");
        this.js.appendValueName(this.localContext.getIdResolverVariable(cgExecutorShadowPart));
        this.js.append(".getProperty(");
        this.js.appendIdReference(cgExecutorShadowPart.getUnderlyingPropertyId().getElementId());
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGExecutorNavigationProperty(@NonNull CGExecutorNavigationProperty cgExecutorProperty) {
        this.js.appendDeclaration(cgExecutorProperty);
        this.js.append(" = new ");
        this.js.appendClassReference(null, cgExecutorProperty);
        this.js.append("(");
        this.js.appendIdReference(cgExecutorProperty.getUnderlyingPropertyId().getElementId());
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGExecutorOppositeProperty(@NonNull CGExecutorOppositeProperty cgExecutorProperty) {
        Property asProperty = (Property)cgExecutorProperty.getAst();
        Property asOppositeProperty = asProperty.getOpposite();
        this.js.appendDeclaration(cgExecutorProperty);
        this.js.append(" = new ");
        this.js.appendClassReference(null, cgExecutorProperty);
        this.js.append("(");
        this.js.appendIdReference((ElementId)asOppositeProperty.getPropertyId());
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGExecutorOperation(@NonNull CGExecutorOperation cgExecutorOperation) {
        this.js.appendDeclaration(cgExecutorOperation);
        this.js.append(" = ");
        try {
            this.js.appendValueName(this.localContext.getIdResolverVariable(cgExecutorOperation));
        }
        catch (Exception e) {
            this.js.appendString(String.valueOf(e));
        }
        this.js.append(".getOperation(");
        this.js.appendIdReference(cgExecutorOperation.getUnderlyingOperationId().getElementId());
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGExecutorOperationCallExp(@NonNull CGExecutorOperationCallExp cgOperationCallExp) {
        Operation pOperation = cgOperationCallExp.getReferredOperation();
        CGValuedElement source = this.getExpression(cgOperationCallExp.getSource());
        List<CGValuedElement> cgArguments = cgOperationCallExp.getArguments();
        List pParameters = pOperation.getOwnedParameters();
        if (!this.js.appendLocalStatements(source)) {
            return false;
        }
        for (CGValuedElement cgArgument : cgArguments) {
            CGValuedElement argument = this.getExpression(cgArgument);
            if (this.js.appendLocalStatements(argument)) continue;
            return false;
        }
        this.js.appendDeclaration(cgOperationCallExp);
        this.js.append(" = ");
        this.js.appendClassCast(cgOperationCallExp);
        this.js.appendReferenceTo(cgOperationCallExp.getExecutorOperation());
        this.js.append(".evaluate(");
        this.js.append("executor");
        this.js.append(", ");
        this.js.appendIdReference((ElementId)cgOperationCallExp.getASTypeId());
        this.js.append(", ");
        this.js.appendValueName(source);
        int iMax = Math.min(pParameters.size(), cgArguments.size());
        int i = 0;
        while (i < iMax) {
            this.js.append(", ");
            CGValuedElement cgArgument = cgArguments.get(i);
            Parameter pParameter = (Parameter)pParameters.get(i);
            CGTypeId cgTypeId = this.analyzer.getTypeId(pParameter.getTypeId());
            UnboxedDescriptor parameterTypeDescriptor = ((JavaCodeGenerator)this.context).getUnboxedDescriptor((ElementId)ClassUtil.nonNullState((Object)cgTypeId.getElementId()));
            CGValuedElement argument = this.getExpression(cgArgument);
            this.js.appendReferenceTo(parameterTypeDescriptor, argument);
            ++i;
        }
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGExecutorOppositePropertyCallExp(@NonNull CGExecutorOppositePropertyCallExp cgPropertyCallExp) {
        CGValuedElement source = this.getExpression(cgPropertyCallExp.getSource());
        if (!this.js.appendLocalStatements(source)) {
            return false;
        }
        this.js.appendDeclaration(cgPropertyCallExp);
        this.js.append(" = ");
        this.js.appendClassCast(cgPropertyCallExp);
        this.js.appendReferenceTo(cgPropertyCallExp.getExecutorProperty());
        this.js.append(".evaluate(");
        this.js.append("executor");
        this.js.append(", ");
        this.js.appendIdReference((ElementId)cgPropertyCallExp.getASTypeId());
        this.js.append(", ");
        this.js.appendValueName(source);
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGExecutorPropertyCallExp(@NonNull CGExecutorPropertyCallExp cgPropertyCallExp) {
        CGValuedElement source = this.getExpression(cgPropertyCallExp.getSource());
        if (!this.js.appendLocalStatements(source)) {
            return false;
        }
        this.js.appendDeclaration(cgPropertyCallExp);
        this.js.append(" = ");
        this.js.appendClassCast(cgPropertyCallExp);
        this.js.appendReferenceTo(cgPropertyCallExp.getExecutorProperty());
        this.js.append(".evaluate(");
        this.js.append("executor");
        this.js.append(", ");
        this.js.appendIdReference((ElementId)cgPropertyCallExp.getASTypeId());
        this.js.append(", ");
        this.js.appendValueName(source);
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGExecutorType(@NonNull CGExecutorType cgExecutorType) {
        this.js.appendDeclaration(cgExecutorType);
        this.js.append(" = ");
        this.js.appendValueName(this.localContext.getIdResolverVariable(cgExecutorType));
        this.js.append(".getClass(");
        this.js.appendIdReference(cgExecutorType.getUnderlyingTypeId().getElementId());
        this.js.append(", null);\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGGuardExp(@NonNull CGGuardExp cgGuardExp) {
        CGValuedElement cgSource = this.getExpression(cgGuardExp.getSource());
        if (cgSource.isNull()) {
            this.js.append("throw new ");
            this.js.appendClassReference(InvalidValueException.class);
            this.js.append("();\n");
        } else {
            if (!this.js.appendLocalStatements(cgSource)) {
                return false;
            }
            if (cgGuardExp.isSafe()) {
                this.js.append("assert ");
                this.js.appendValueName(cgSource);
                this.js.append(" != null;\n");
            } else if (!cgSource.isNonNull()) {
                this.js.append("if (");
                this.js.appendValueName(cgSource);
                this.js.append(" == null) {\n");
                this.js.pushIndentation(null);
                this.appendGuardFailure(cgGuardExp);
                this.js.popIndentation();
                this.js.append("}\n");
            }
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGIfExp(@NonNull CGIfExp cgIfExp) {
        CGValuedElement condition = this.getExpression(cgIfExp.getCondition());
        CGValuedElement thenExpression = this.getExpression(cgIfExp.getThenExpression());
        CGValuedElement elseExpression = this.getExpression(cgIfExp.getElseExpression());
        boolean flowContinues = false;
        if (!this.js.appendLocalStatements(condition)) {
            return flowContinues;
        }
        this.js.appendDeclaration(cgIfExp);
        this.js.append(";\n");
        this.js.append("if (");
        this.js.appendBooleanValueName(condition, true);
        this.js.append(") {\n");
        try {
            this.js.pushIndentation(null);
            if (this.js.appendAssignment(cgIfExp, thenExpression)) {
                flowContinues = true;
            }
        }
        finally {
            this.js.popIndentation();
        }
        this.js.append("}\n");
        this.js.append("else {\n");
        try {
            this.js.pushIndentation(null);
            if (this.js.appendAssignment(cgIfExp, elseExpression)) {
                flowContinues = true;
            }
        }
        finally {
            this.js.popIndentation();
        }
        this.js.append("}\n");
        return flowContinues;
    }

    @Override
    public @NonNull Boolean visitCGInteger(@NonNull CGInteger object) {
        this.js.appendDeclaration(object);
        this.js.append(" = ");
        this.js.appendClassReference(ValueUtil.class);
        this.js.append(".integerValueOf(");
        Number integerValue = object.getNumericValue();
        String valueString = integerValue.toString();
        assert (valueString != null);
        if (integerValue instanceof IntIntegerValueImpl) {
            this.js.append(valueString);
        } else if (integerValue instanceof LongIntegerValueImpl) {
            this.js.append(String.valueOf(valueString) + "L");
        } else {
            this.js.append("\"" + valueString + "\"");
        }
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGInvalid(@NonNull CGInvalid object) {
        String message = object.getMessageTemplate();
        if (message != null) {
            this.js.append("new ");
            this.js.appendClassReference(InvalidValueException.class);
            this.js.append("(");
            this.js.appendString(message);
            for (Object binding : object.getBindings()) {
                this.js.append(", ");
                this.js.appendString((String)ClassUtil.nonNullState((Object)String.valueOf(binding)));
            }
            this.js.append(")");
        } else {
            this.js.appendClassReference(ValueUtil.class);
            this.js.append(".INVALID_VALUE");
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGIsEqualExp(@NonNull CGIsEqualExp cgIsEqualExp) {
        if (cgIsEqualExp.isTrue()) {
            this.js.appendDeclaration(cgIsEqualExp);
            this.js.append(" = ");
            this.js.appendTrue();
            this.js.append(";\n");
        } else if (cgIsEqualExp.isFalse()) {
            this.js.appendDeclaration(cgIsEqualExp);
            this.js.append(" = ");
            this.js.appendFalse();
            this.js.append(";\n");
        } else {
            CGValuedElement cgSource = this.getExpression(cgIsEqualExp.getSource());
            CGValuedElement cgArgument = this.getExpression(cgIsEqualExp.getArgument());
            if (!this.js.appendLocalStatements(cgSource)) {
                return false;
            }
            if (!this.js.appendLocalStatements(cgArgument)) {
                return false;
            }
            boolean notEquals = cgIsEqualExp.isNotEquals();
            this.js.appendDeclaration(cgIsEqualExp);
            this.js.append(" = ");
            if (cgSource.isNull()) {
                if (cgArgument.isNull()) {
                    this.js.appendBooleanString(true ^ notEquals);
                } else if (cgArgument.isNonNull()) {
                    this.js.appendBooleanString(notEquals);
                } else {
                    this.js.appendValueName(cgArgument);
                    this.js.append(notEquals ? " != " : " == ");
                    this.js.append("null");
                }
            } else if (cgArgument.isNull()) {
                if (cgSource.isNonNull()) {
                    this.js.appendBooleanString(notEquals);
                } else {
                    this.js.appendValueName(cgSource);
                    this.js.append(notEquals ? " != " : " == ");
                    this.js.append("null");
                }
            } else if (cgSource.isTrue()) {
                if (cgArgument.isTrue()) {
                    this.js.appendBooleanString(true ^ notEquals);
                } else if (cgArgument.isFalse()) {
                    this.js.appendBooleanString(notEquals);
                } else {
                    this.js.appendBooleanValueName(cgArgument, true ^ notEquals);
                }
            } else if (cgSource.isFalse()) {
                if (cgArgument.isFalse()) {
                    this.js.appendBooleanString(true ^ notEquals);
                } else if (cgArgument.isTrue()) {
                    this.js.appendBooleanString(notEquals);
                } else {
                    this.js.appendBooleanValueName(cgArgument, notEquals);
                }
            } else if (cgArgument.isTrue()) {
                this.js.appendBooleanValueName(cgSource, true ^ notEquals);
            } else if (cgArgument.isFalse()) {
                this.js.appendBooleanValueName(cgSource, notEquals);
            } else {
                TypeDescriptor sourceTypeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(cgSource);
                sourceTypeDescriptor.appendEqualsValue(this.js, cgSource, cgArgument, notEquals);
            }
            this.js.append(";\n");
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGIsEqual2Exp(@NonNull CGIsEqual2Exp cgIsEqualExp) {
        if (cgIsEqualExp.isTrue()) {
            this.js.appendDeclaration(cgIsEqualExp);
            this.js.append(" = ");
            this.js.appendTrue();
            this.js.append(";\n");
        } else if (cgIsEqualExp.isFalse()) {
            this.js.appendDeclaration(cgIsEqualExp);
            this.js.append(" = ");
            this.js.appendFalse();
            this.js.append(";\n");
        } else {
            CGValuedElement cgSource = this.getExpression(cgIsEqualExp.getSource());
            CGValuedElement cgArgument = this.getExpression(cgIsEqualExp.getArgument());
            if (!this.js.appendLocalStatements(cgSource)) {
                return false;
            }
            if (!this.js.appendLocalStatements(cgArgument)) {
                return false;
            }
            this.js.appendDeclaration(cgIsEqualExp);
            this.js.append(" = ");
            boolean isNull1 = cgSource.isNull();
            boolean isNull2 = cgArgument.isNull();
            if (isNull1 && isNull2) {
                this.js.appendBooleanString(isNull1 == isNull2);
            } else if (isNull1 && !isNull2) {
                if (cgArgument.isNonNull()) {
                    this.js.appendBooleanString(false);
                } else {
                    this.js.appendValueName(cgArgument);
                    this.js.append(" == ");
                    this.js.append("null");
                }
            } else if (isNull2 && !isNull1) {
                if (cgSource.isNonNull()) {
                    this.js.appendBooleanString(false);
                } else {
                    this.js.appendValueName(cgSource);
                    this.js.append(" == ");
                    this.js.append("null");
                }
            } else if (cgSource.isTrue()) {
                if (cgArgument.isTrue()) {
                    this.js.appendBooleanString(true);
                } else if (cgArgument.isFalse()) {
                    this.js.appendBooleanString(false);
                } else {
                    this.js.appendBooleanValueName(cgArgument, true);
                }
            } else if (cgSource.isFalse()) {
                if (cgArgument.isFalse()) {
                    this.js.appendBooleanString(true);
                } else if (cgArgument.isTrue()) {
                    this.js.appendBooleanString(false);
                } else {
                    this.js.appendBooleanValueName(cgArgument, false);
                }
            } else if (cgArgument.isTrue()) {
                this.js.appendBooleanValueName(cgSource, true);
            } else if (cgArgument.isFalse()) {
                this.js.appendBooleanValueName(cgSource, false);
            } else {
                TypeDescriptor sourceTypeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(cgSource);
                sourceTypeDescriptor.appendEqualsValue(this.js, cgSource, cgArgument, false);
            }
            this.js.append(";\n");
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGIsInvalidExp(@NonNull CGIsInvalidExp cgIsInvalidExp) {
        if (cgIsInvalidExp.isTrue()) {
            this.js.appendTrue();
        } else if (cgIsInvalidExp.isFalse()) {
            this.js.appendFalse();
        } else {
            CGValuedElement cgSource = this.getExpression(cgIsInvalidExp.getSource());
            if (!this.js.appendLocalStatements(cgSource)) {
                return false;
            }
            this.js.appendDeclaration(cgIsInvalidExp);
            this.js.append(" = ");
            this.js.appendValueName(cgSource);
            this.js.append(" instanceof ");
            this.js.appendClassReference(InvalidValueException.class);
            this.js.append(";\n");
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGIsKindOfExp(@NonNull CGIsKindOfExp cgIsKindOfExp) {
        CGValuedElement cgSource = this.getExpression(cgIsKindOfExp.getSource());
        CGExecutorType cgType = cgIsKindOfExp.getExecutorType();
        if (cgType != null) {
            TypeId asTypeId = cgType.getASTypeId();
            assert (asTypeId != null);
            BoxedDescriptor typeDescriptor = ((JavaCodeGenerator)this.context).getBoxedDescriptor((ElementId)asTypeId);
            this.js.appendDeclaration(cgIsKindOfExp);
            this.js.append(" = ");
            this.js.appendValueName(cgSource);
            this.js.append(" instanceof ");
            typeDescriptor.append(this.js, null);
            this.js.append(";\n");
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGIsUndefinedExp(@NonNull CGIsUndefinedExp cgIsUndefinedExp) {
        if (cgIsUndefinedExp.isTrue()) {
            this.js.appendTrue();
        } else if (cgIsUndefinedExp.isFalse()) {
            this.js.appendFalse();
        } else {
            CGValuedElement cgSource = this.getExpression(cgIsUndefinedExp.getSource());
            boolean sourceIsNonInvalid = cgSource.isNonInvalid();
            boolean sourceIsNonNull = cgSource.isNonNull();
            if (!this.js.appendLocalStatements(cgSource)) {
                return false;
            }
            this.js.appendDeclaration(cgIsUndefinedExp);
            this.js.append(" = ");
            if (!sourceIsNonNull && !sourceIsNonInvalid) {
                this.js.append("(");
                this.js.appendValueName(cgSource);
                this.js.append(" == null) || (");
                this.js.appendValueName(cgSource);
                this.js.append(" instanceof ");
                this.js.appendClassReference(InvalidValueException.class);
                this.js.append(")");
            } else if (!sourceIsNonNull && sourceIsNonInvalid) {
                this.js.appendValueName(cgSource);
                this.js.append(" == null");
            } else if (sourceIsNonNull && !sourceIsNonInvalid) {
                this.js.appendValueName(cgSource);
                this.js.append(" instanceof ");
                this.js.appendClassReference(InvalidValueException.class);
            }
            this.js.append(";\n");
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGLetExp(@NonNull CGLetExp cgLetExp) {
        cgLetExp.getInit().accept(this);
        CGValuedElement cgIn = cgLetExp.getIn();
        if (cgIn != null && !this.js.appendLocalStatements(cgIn)) {
            return false;
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGLibraryIterateCallExp(@NonNull CGLibraryIterateCallExp cgIterateCallExp) {
        return this.appendLoopCall(cgIterateCallExp, cgIterateCallExp.getResult());
    }

    @Override
    public @NonNull Boolean visitCGLibraryIterationCallExp(@NonNull CGLibraryIterationCallExp cgIterationCallExp) {
        return this.appendLoopCall(cgIterationCallExp, null);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Boolean visitCGLibraryOperation(@NonNull CGLibraryOperation cgOperation) {
        @NonNull LocalContext localContext2 = this.globalContext.getLocalContext(cgOperation);
        if (localContext2 != null) {
            this.localContext = localContext2;
            try {
                List<CGParameter> cgParameters = cgOperation.getParameters();
                String operationName = cgOperation.getName();
                assert (operationName != null);
                this.js.append("public static class ");
                this.js.append(operationName);
                this.js.append(" extends ");
                this.js.appendClassReference(this.genModelHelper.getAbstractOperationClass(cgParameters.size() - 3));
                this.js.pushClassBody(operationName);
                this.js.append("public static final ");
                this.js.appendIsRequired(true);
                this.js.append(" ");
                this.js.append(operationName);
                this.js.append(" ");
                this.js.append(this.globalContext.getInstanceName());
                this.js.append(" = new ");
                this.js.append(operationName);
                this.js.append("();\n");
                this.js.append("\n");
                CGValuedElement body = this.getExpression(cgOperation.getBody());
                Element ast = cgOperation.getAst();
                if (ast instanceof Operation) {
                    LanguageExpression expressionInOCL = ((Operation)ast).getBodyExpression();
                    if (ast instanceof Operation) {
                        String title = PrettyPrinter.printName((Element)ast);
                        this.js.appendCommentWithOCL(String.valueOf(title) + "\n", (Element)expressionInOCL);
                    }
                }
                this.js.append("@Override\n");
                this.js.append("public ");
                boolean cgOperationIsInvalid = cgOperation.getInvalidValue() != null;
                this.js.appendIsCaught(!cgOperationIsInvalid, cgOperationIsInvalid);
                this.js.append(" ");
                this.js.appendClassReference(cgOperation.isRequired() ? Boolean.valueOf(true) : null, cgOperation);
                this.js.append(" ");
                this.js.append(this.globalContext.getEvaluateName());
                this.js.append("(");
                boolean isFirst = true;
                for (CGParameter cgParameter : cgParameters) {
                    if (!isFirst) {
                        this.js.append(", ");
                    }
                    this.js.appendDeclaration(cgParameter);
                    isFirst = false;
                }
                this.js.append(") {\n");
                this.js.pushIndentation(null);
                this.appendReturn(body);
                this.js.popIndentation();
                this.js.append("}\n");
                this.js.popClassBody(false);
            }
            finally {
                this.localContext = null;
            }
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGLibraryOperationCallExp(@NonNull CGLibraryOperationCallExp cgOperationCallExp) {
        final CGValuedElement source = this.getExpression(cgOperationCallExp.getSource());
        final List<CGValuedElement> arguments = cgOperationCallExp.getArguments();
        final LibraryOperation libraryOperation = (LibraryOperation)ClassUtil.nonNullState((Object)cgOperationCallExp.getLibraryOperation());
        Method actualMethod = this.getJavaMethod(libraryOperation, arguments.size());
        java.lang.Class<?> actualReturnClass = actualMethod != null ? actualMethod.getReturnType() : null;
        boolean actualIsNonNull = actualMethod != null && ((JavaCodeGenerator)this.context).getIsNonNull(actualMethod) == Boolean.TRUE;
        boolean expectedIsNonNull = cgOperationCallExp.isNonNull();
        final CGTypeId resultType = cgOperationCallExp.getTypeId();
        if (!this.js.appendLocalStatements(source)) {
            return false;
        }
        for (CGValuedElement cgArgument : arguments) {
            if (this.js.appendLocalStatements(cgArgument)) continue;
            return false;
        }
        this.js.appendDeclaration(cgOperationCallExp);
        this.js.append(" = ");
        if (expectedIsNonNull && !actualIsNonNull) {
            this.js.appendClassReference(ClassUtil.class);
            this.js.append(".nonNullState(");
        }
        this.js.appendClassCast(cgOperationCallExp, actualReturnClass, new JavaStream.SubStream(){

            @Override
            public void append() {
                CG2JavaVisitor.this.js.appendClassReference(libraryOperation.getClass());
                CG2JavaVisitor.this.js.append("." + CG2JavaVisitor.this.globalContext.getInstanceName() + "." + CG2JavaVisitor.this.globalContext.getEvaluateName() + "(");
                if (!(libraryOperation instanceof LibrarySimpleOperation)) {
                    CG2JavaVisitor.this.js.append("executor");
                    CG2JavaVisitor.this.js.append(", ");
                    if (!(libraryOperation instanceof LibraryUntypedOperation)) {
                        CG2JavaVisitor.this.js.appendValueName(resultType);
                        CG2JavaVisitor.this.js.append(", ");
                    }
                }
                if (source.isNull()) {
                    CG2JavaVisitor.this.js.append("(Object)");
                }
                CG2JavaVisitor.this.js.appendValueName(source);
                for (CGValuedElement cgArgument : arguments) {
                    CG2JavaVisitor.this.js.append(", ");
                    if (cgArgument.isNull()) {
                        CG2JavaVisitor.this.js.append("(Object)");
                    }
                    CG2JavaVisitor.this.js.appendValueName(cgArgument);
                }
                CG2JavaVisitor.this.js.append(")");
            }
        });
        if (expectedIsNonNull && !actualIsNonNull) {
            this.js.append(")");
        }
        this.js.append(";\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGLibraryPropertyCallExp(@NonNull CGLibraryPropertyCallExp cgPropertyCallExp) {
        CGValuedElement source = this.getExpression(cgPropertyCallExp.getSource());
        LibraryProperty libraryProperty = (LibraryProperty)ClassUtil.nonNullState((Object)cgPropertyCallExp.getLibraryProperty());
        Method actualMethod = this.getJavaMethod(libraryProperty);
        java.lang.Class<?> actualReturnClass = actualMethod != null ? actualMethod.getReturnType() : null;
        boolean actualIsNonNull = actualMethod != null && ((JavaCodeGenerator)this.context).getIsNonNull(actualMethod) == Boolean.TRUE;
        boolean expectedIsNonNull = cgPropertyCallExp.isNonNull();
        CGTypeId resultType = cgPropertyCallExp.getTypeId();
        if (!this.js.appendLocalStatements(source)) {
            return false;
        }
        this.js.appendDeclaration(cgPropertyCallExp);
        this.js.append(" = ");
        if (expectedIsNonNull && !actualIsNonNull) {
            this.js.appendClassReference(ClassUtil.class);
            this.js.append(".nonNullState(");
        }
        this.js.appendClassCast(cgPropertyCallExp, actualReturnClass);
        this.js.appendClassReference(libraryProperty.getClass());
        this.js.append("." + this.globalContext.getInstanceName() + "." + this.globalContext.getEvaluateName() + "(");
        this.js.append("executor");
        this.js.append(", ");
        this.js.appendValueName(resultType);
        this.js.append(", ");
        this.js.appendValueName(source);
        if (expectedIsNonNull && !actualIsNonNull) {
            this.js.append(")");
        }
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGMapExp(@NonNull CGMapExp cgMapExp) {
        for (CGMapPart cgPart : cgMapExp.getParts()) {
            if (cgPart == null || this.js.appendLocalStatements(cgPart)) continue;
            return false;
        }
        this.js.appendDeclaration(cgMapExp);
        this.js.append(" = ");
        this.js.appendClassReference(ValueUtil.class);
        this.js.append(".createMapOfEach(");
        this.js.appendIdReference(cgMapExp.getTypeId().getElementId());
        for (CGMapPart cgPart : cgMapExp.getParts()) {
            this.js.append(", ");
            if (cgPart.isNull() && cgMapExp.getParts().size() == 1) {
                this.js.append("(Object)");
            }
            this.js.appendValueName(cgPart);
        }
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGMapPart(@NonNull CGMapPart cgMapPart) {
        CGValuedElement key = this.getExpression(cgMapPart.getKey());
        CGValuedElement value = this.getExpression(cgMapPart.getValue());
        if (!this.js.appendLocalStatements(key)) {
            return false;
        }
        if (!this.js.appendLocalStatements(value)) {
            return false;
        }
        this.js.appendDeclaration(cgMapPart);
        this.js.append(" = ");
        this.js.appendClassReference(ValueUtil.class);
        this.js.append(".createMapEntry(");
        this.js.appendValueName(key);
        this.js.append(", ");
        this.js.appendValueName(value);
        this.js.append(");\n");
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Boolean visitCGNativeOperation(@NonNull CGNativeOperation cgOperation) {
        Operation asOperation = (Operation)cgOperation.getAst();
        assert (asOperation != null);
        @NonNull LocalContext localContext2 = this.globalContext.getLocalContext(cgOperation);
        if (localContext2 != null) {
            this.localContext = localContext2;
            try {
                String operationClassName = this.getNativeOperationClassName(cgOperation);
                LanguageExpression expressionInOCL = asOperation.getBodyExpression();
                String title = PrettyPrinter.printName((Element)asOperation);
                this.js.appendCommentWithOCL(String.valueOf(title) + "\n", (Element)expressionInOCL);
                this.js.append("protected class ");
                this.js.append(operationClassName);
                this.js.append(" extends ");
                this.js.appendClassReference(AbstractEvaluationOperation.class);
                this.js.pushClassBody(operationClassName);
                this.doCachedOperationBasicEvaluate(cgOperation);
                this.js.append("\n");
                this.doCachedOperationEvaluate(cgOperation);
                this.js.popClassBody(false);
                this.js.append("\n");
                this.doCachedOperationClassInstance(cgOperation);
            }
            finally {
                this.localContext = null;
            }
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGNativeOperationCallExp(@NonNull CGNativeOperationCallExp cgOperationCallExp) {
        Operation pOperation = cgOperationCallExp.getReferredOperation();
        boolean thisIsSelf = cgOperationCallExp.isThisIsSelf();
        CGValuedElement source = this.getExpression(cgOperationCallExp.getSource());
        List<CGValuedElement> cgArguments = cgOperationCallExp.getArguments();
        List pParameters = pOperation.getOwnedParameters();
        if (!this.js.appendLocalStatements(source)) {
            return false;
        }
        for (CGValuedElement cgArgument : cgArguments) {
            CGValuedElement argument = this.getExpression(cgArgument);
            if (this.js.appendLocalStatements(argument)) continue;
            return false;
        }
        this.js.appendDeclaration(cgOperationCallExp);
        this.js.append(" = ");
        this.js.appendThis((String)ClassUtil.nonNullState((Object)cgOperationCallExp.getReferredOperation().getOwningClass().getName()));
        this.js.append(".");
        this.js.append(cgOperationCallExp.getReferredOperation().getName());
        this.js.append("(");
        if (!thisIsSelf) {
            this.js.appendValueName(source);
        }
        int iMax = Math.min(pParameters.size(), cgArguments.size());
        int i = 0;
        while (i < iMax) {
            if (i > 0 || !thisIsSelf) {
                this.js.append(", ");
            }
            CGValuedElement cgArgument = cgArguments.get(i);
            Parameter pParameter = (Parameter)pParameters.get(i);
            CGTypeId cgTypeId = this.analyzer.getTypeId(pParameter.getTypeId());
            UnboxedDescriptor parameterTypeDescriptor = ((JavaCodeGenerator)this.context).getUnboxedDescriptor((ElementId)ClassUtil.nonNullState((Object)cgTypeId.getElementId()));
            CGValuedElement argument = this.getExpression(cgArgument);
            this.js.appendReferenceTo(parameterTypeDescriptor, argument);
            ++i;
        }
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGNativeProperty(@NonNull CGNativeProperty cgNativeProperty) {
        this.localContext = this.globalContext.getLocalContext(cgNativeProperty);
        try {
            this.js.append("protected ");
            this.js.appendDeclaration(cgNativeProperty);
            this.js.append(";\n");
            Boolean bl = true;
            return bl;
        }
        finally {
            this.localContext = null;
        }
    }

    @Override
    public @NonNull Boolean visitCGNativePropertyCallExp(@NonNull CGNativePropertyCallExp cgPropertyCallExp) {
        CGValuedElement source = this.getExpression(cgPropertyCallExp.getSource());
        if (!this.js.appendLocalStatements(source)) {
            return false;
        }
        this.js.appendDeclaration(cgPropertyCallExp);
        this.js.append(" = ");
        this.js.appendClassCast(cgPropertyCallExp);
        this.js.appendValueName(source);
        this.js.append(".");
        this.js.append(cgPropertyCallExp.getReferredProperty().getName());
        this.js.append(";\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGNull(@NonNull CGNull object) {
        this.js.append("null");
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Boolean visitCGOperation(@NonNull CGOperation cgOperation) {
        @NonNull LocalContext localContext2 = this.globalContext.getLocalContext(cgOperation);
        if (localContext2 != null) {
            this.localContext = localContext2;
            try {
                List<CGParameter> cgParameters = cgOperation.getParameters();
                CGValuedElement body = this.getExpression(cgOperation.getBody());
                Element ast = cgOperation.getAst();
                if (ast instanceof Operation) {
                    LanguageExpression expressionInOCL = ((Operation)ast).getBodyExpression();
                    if (ast instanceof Operation) {
                        String title = PrettyPrinter.printName((Element)ast);
                        this.js.appendCommentWithOCL(String.valueOf(title) + "\n", (Element)expressionInOCL);
                    }
                }
                this.js.append("@Override\n");
                this.js.append("public ");
                boolean cgOperationIsInvalid = cgOperation.getInvalidValue() != null;
                this.js.appendIsCaught(!cgOperationIsInvalid, cgOperationIsInvalid);
                this.js.append(" ");
                this.js.appendClassReference(cgOperation.isRequired() ? Boolean.valueOf(true) : null, cgOperation);
                this.js.append(" ");
                this.js.append(cgOperation.getName());
                this.js.append("(");
                boolean isFirst = true;
                for (CGParameter cgParameter : cgParameters) {
                    if (!isFirst) {
                        this.js.append(", ");
                    }
                    this.js.appendDeclaration(cgParameter);
                    isFirst = false;
                }
                this.js.append(") {\n");
                this.js.pushIndentation(null);
                this.appendReturn(body);
                this.js.popIndentation();
                this.js.append("}\n");
            }
            finally {
                this.localContext = null;
            }
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGPackage(@NonNull CGPackage cgPackage) {
        for (CGPackage cgNestedPackage : cgPackage.getPackages()) {
            cgNestedPackage.accept(this);
        }
        for (CGClass cgClass : cgPackage.getClasses()) {
            cgClass.accept(this);
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGParameter(@NonNull CGParameter object) {
        return true;
    }

    @Override
    public @NonNull Boolean visitCGProperty(@NonNull CGProperty cgProperty) {
        this.localContext = this.globalContext.getLocalContext(cgProperty);
        try {
            Boolean flowContinues = (Boolean)super.visitCGProperty(cgProperty);
            assert (flowContinues != null);
            Boolean bl = flowContinues;
            return bl;
        }
        finally {
            this.localContext = null;
        }
    }

    @Override
    public @NonNull Boolean visitCGReal(@NonNull CGReal object) {
        this.js.appendDeclaration(object);
        this.js.append(" = ");
        this.js.appendClassReference(ValueUtil.class);
        this.js.append(".realValueOf(");
        Number realValue = object.getNumericValue();
        String valueString = realValue.toString();
        if (realValue instanceof Double) {
            this.js.append(String.valueOf(valueString) + "d");
        } else {
            this.js.append("\"" + valueString + "\"");
        }
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGShadowExp(@NonNull CGShadowExp cgShadowExp) {
        CGExecutorType cgExecutorType = cgShadowExp.getExecutorType();
        this.js.appendDeclaration(cgShadowExp);
        this.js.append(" = ");
        this.js.appendClassCast(cgShadowExp);
        this.js.appendValueName(cgExecutorType);
        this.js.append(".createInstance();\n");
        for (CGShadowPart part : cgShadowExp.getParts()) {
            part.accept(this);
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGShadowPart(@NonNull CGShadowPart cgShadowPart) {
        CGExecutorShadowPart cgExecutorShadowPart = cgShadowPart.getExecutorPart();
        CGValuedElement init = this.getExpression(cgShadowPart.getInit());
        if (!this.js.appendLocalStatements(init)) {
            return false;
        }
        this.js.appendValueName(cgExecutorShadowPart);
        this.js.append(".initValue(");
        this.js.appendValueName(cgShadowPart.getShadowExp());
        this.js.append(", ");
        this.js.appendValueName(init);
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGString(@NonNull CGString object) {
        this.js.appendDeclaration(object);
        this.js.append(" = ");
        this.js.appendString((String)ClassUtil.nonNullState((Object)object.getStringValue()));
        this.js.append(";\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGText(@NonNull CGText cgText) {
        this.js.appendDeclaration(cgText);
        this.js.append(" = ");
        this.js.append(cgText.getTextValue());
        this.js.append(";\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGThrowExp(@NonNull CGThrowExp cgThrowExp) {
        CGValuedElement cgSource = this.getExpression(cgThrowExp.getSource());
        if (cgSource.isNonInvalid()) {
            cgSource.accept(this);
        } else {
            CGInvalid cgInvalidValue = cgSource.getInvalidValue();
            if (cgInvalidValue != null) {
                this.js.append("throw ");
                this.js.appendReferenceTo(InvalidValueException.class, (CGValuedElement)cgInvalidValue);
                this.js.append(";\n");
                return false;
            }
            if (!this.js.appendLocalStatements(cgSource)) {
                return false;
            }
            if (cgSource.isCaught()) {
                this.js.append("if (");
                this.js.appendValueName(cgSource);
                this.js.append(" instanceof ");
                this.js.appendClassReference(InvalidValueException.class);
                this.js.append(") {\n");
                this.js.pushIndentation(null);
                this.js.append("throw ");
                this.js.appendReferenceTo(InvalidValueException.class, cgSource);
                this.js.append(";\n");
                this.js.popIndentation();
                this.js.append("}\n");
            }
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGTupleExp(@NonNull CGTupleExp cgTupleExp) {
        Iterable<@NonNull CGTuplePart> parts = CGUtil.getParts(cgTupleExp);
        for (CGTuplePart cgPart : parts) {
            if (this.js.appendLocalStatements(CGUtil.getInit(cgPart))) continue;
            return false;
        }
        this.js.appendDeclaration(cgTupleExp);
        this.js.append(" = ");
        this.js.appendClassReference(ValueUtil.class);
        this.js.append(".createTupleOfEach(");
        this.js.appendIdReference(cgTupleExp.getTypeId().getElementId());
        int iSize = Iterables.size(parts);
        for (CGTuplePart cgPart : parts) {
            CGValuedElement cgInit = CGUtil.getInit(cgPart);
            this.js.append(", ");
            if (cgInit.isNull() && iSize == 1) {
                this.js.append("(Object)");
            }
            this.js.appendValueName(cgInit);
        }
        this.js.append(");\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGTuplePartCallExp(@NonNull CGTuplePartCallExp cgTuplePartCallExp) {
        CGValuedElement source = this.getExpression(cgTuplePartCallExp.getSource());
        TuplePartId partId = cgTuplePartCallExp.getAstTuplePartId();
        if (!this.js.appendLocalStatements(source)) {
            return false;
        }
        boolean isRequired = cgTuplePartCallExp.isNonNull();
        boolean isPrimitive = this.js.isPrimitive(cgTuplePartCallExp);
        if (!isPrimitive && isRequired) {
            this.js.appendSuppressWarningsNull(true);
        }
        this.js.appendDeclaration(cgTuplePartCallExp);
        this.js.append(" = ");
        this.js.appendClassReference(ClassUtil.class);
        this.js.append(".nonNullState(");
        this.js.appendClassCast(cgTuplePartCallExp);
        this.js.appendAtomicReferenceTo(TupleValue.class, source);
        this.js.append(".getValue(" + partId.getIndex() + "/*" + partId.getName() + "*/));\n");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGTypeId(@NonNull CGTypeId cgTypeId) {
        if (cgTypeId.isInlined()) {
            this.js.appendIdReference(cgTypeId.getElementId());
        } else {
            super.visitCGTypeId(cgTypeId);
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGTypeExp(@NonNull CGTypeExp cgTypeExp) {
        return true;
    }

    @Override
    public @NonNull Boolean visitCGUnboxExp(@NonNull CGUnboxExp cgUnboxExp) {
        CGValuedElement boxedValue = this.getExpression(cgUnboxExp.getSource());
        TypeDescriptor boxedTypeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(boxedValue);
        JavaLocalContext<@NonNull ?> localContext2 = this.localContext;
        assert (localContext2 != null);
        if (!this.js.appendLocalStatements(boxedValue)) {
            return false;
        }
        return boxedTypeDescriptor.appendUnboxStatements(this.js, localContext2, cgUnboxExp, boxedValue);
    }

    @Override
    public @NonNull Boolean visitCGUnlimited(@NonNull CGUnlimited object) {
        this.js.appendClassReference(ValueUtil.class);
        this.js.append(".UNLIMITED_VALUE");
        return true;
    }

    @Override
    public @NonNull Boolean visitCGVariable(@NonNull CGVariable cgVariable) {
        CGValuedElement init = cgVariable.getInit();
        if (init != null && !this.js.appendLocalStatements(init)) {
            return false;
        }
        return true;
    }

    @Override
    public @NonNull Boolean visitCGVariableExp(@NonNull CGVariableExp cgVariableExp) {
        return true;
    }
}

