/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.configuration;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.dltk.internal.ui.typehierarchy.HierarchyInformationControl;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPHP;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IFormatterCommonPreferences;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.autoEdit.CloseTagAutoEditStrategyPHP;
import org.eclipse.php.internal.ui.autoEdit.MainAutoEditStrategy;
import org.eclipse.php.internal.ui.doubleclick.PHPDoubleClickStrategy;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.editor.configuration.PHPStructuredPresentationReconciler;
import org.eclipse.php.internal.ui.editor.configuration.StructuredDocumentDamagerRepairer;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProcessor;
import org.eclipse.php.internal.ui.editor.contentassist.PHPContentAssistant;
import org.eclipse.php.internal.ui.editor.highlighter.LineStyleProviderForPHP;
import org.eclipse.php.internal.ui.editor.hover.BestMatchHover;
import org.eclipse.php.internal.ui.editor.hover.PHPTextHoverProxy;
import org.eclipse.php.internal.ui.text.PHPElementProvider;
import org.eclipse.php.internal.ui.text.PHPInformationHierarchyProvider;
import org.eclipse.php.internal.ui.text.PHPOutlineInformationControl;
import org.eclipse.php.internal.ui.text.correction.PHPCorrectionAssistant;
import org.eclipse.php.internal.ui.text.hover.PHPEditorTextHoverDescriptor;
import org.eclipse.php.internal.ui.util.ElementCreationProxy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.css.ui.internal.contentassist.CSSStructuredContentAssistProcessor;
import org.eclipse.wst.html.core.internal.text.StructuredTextPartitionerForHTML;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.html.ui.internal.autoedit.AutoEditStrategyForTabs;
import org.eclipse.wst.sse.ui.internal.contentassist.StructuredContentAssistant;
import org.eclipse.wst.sse.ui.internal.correction.CompoundQuickAssistProcessor;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.ReconcilerHighlighter;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class PHPStructuredTextViewerConfiguration
extends StructuredTextViewerConfigurationHTML {
    private static final String EMPTY = "";
    private static final String[] DEFAULT_PREFIXES = new String[]{"//", "#", ""};
    private static final String COMPLETION_PROPOSAL_SIZE_SECTION = "completion_proposal_size";
    private static final String QUICK_OUTLINE_SIZE_SECTION = "quick_outline_size";
    private static final IAutoEditStrategy mainAutoEditStrategy = new MainAutoEditStrategy();
    private static final IAutoEditStrategy closeTagAutoEditStrategy = new CloseTagAutoEditStrategyPHP();
    private String[] configuredContentTypes;
    private LineStyleProvider fLineStyleProvider;
    private StructuredContentAssistant fContentAssistant;
    private IQuickAssistAssistant fQuickAssistant;
    private PHPCompletionProcessor phpCompletionProcessor;
    Map<String, IContentAssistProcessor[]> processorMap = new HashMap<String, IContentAssistProcessor[]>();
    private ReconcilerHighlighter fHighlighter = null;
    private ILabelProvider fStatusLineLabelProvider;

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        if (this.configuredContentTypes == null) {
            String[] phpTypes = PHPStructuredTextPartitioner.getConfiguredContentTypes();
            String[] xmlTypes = StructuredTextPartitionerForXML.getConfiguredContentTypes();
            String[] htmlTypes = StructuredTextPartitionerForHTML.getConfiguredContentTypes();
            this.configuredContentTypes = new String[2 + phpTypes.length + xmlTypes.length + htmlTypes.length];
            this.configuredContentTypes[0] = "org.eclipse.wst.sse.ST_DEFAULT";
            this.configuredContentTypes[1] = "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE";
            int index = 0;
            System.arraycopy(phpTypes, 0, this.configuredContentTypes, index += 2, phpTypes.length);
            System.arraycopy(xmlTypes, 0, this.configuredContentTypes, index += phpTypes.length, xmlTypes.length);
            System.arraycopy(htmlTypes, 0, this.configuredContentTypes, index += xmlTypes.length, htmlTypes.length);
        }
        return this.configuredContentTypes;
    }

    public LineStyleProvider getLineStyleProvider() {
        if (this.fLineStyleProvider == null) {
            this.fLineStyleProvider = new LineStyleProviderForPHP();
        }
        return this.fLineStyleProvider;
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        if (partitionType == "org.eclipse.php.PHP_DEFAULT") {
            return new LineStyleProvider[]{this.getLineStyleProvider()};
        }
        return super.getLineStyleProviders(sourceViewer, partitionType);
    }

    public ILabelProvider getStatusLineLabelProvider(ISourceViewer sourceViewer) {
        if (this.fStatusLineLabelProvider == null) {
            this.fStatusLineLabelProvider = new JFaceNodeLabelProvider(){

                public String getText(Object element) {
                    if (element == null) {
                        return null;
                    }
                    StringBuilder s = new StringBuilder();
                    Node node = (Node)element;
                    while (node != null) {
                        if (node.getNodeType() != 9) {
                            s.insert(0, super.getText((Object)node));
                        }
                        if ((node = node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode()) == null || node.getNodeType() == 9) continue;
                        s.insert(0, '/');
                    }
                    return s.toString();
                }

                public Image getImage(Object element) {
                    if (element instanceof ElementImplForPHP) {
                        return null;
                    }
                    return super.getImage(element);
                }
            };
        }
        return this.fStatusLineLabelProvider;
    }

    public IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] processors = null;
        if (sourceViewer instanceof PHPStructuredTextViewer) {
            ContentAssistant phpContentAssistant;
            ITextEditor textEditor = ((PHPStructuredTextViewer)sourceViewer).getTextEditor();
            if (this.phpCompletionProcessor == null) {
                phpContentAssistant = (ContentAssistant)this.getPHPContentAssistant(sourceViewer);
                if (this.phpCompletionProcessor == null) {
                    this.phpCompletionProcessor = new PHPCompletionProcessor((IEditorPart)textEditor, phpContentAssistant, "org.eclipse.php.PHP_DEFAULT");
                    this.addContentAssistProcessors(sourceViewer);
                }
            } else {
                phpContentAssistant = (ContentAssistant)this.getPHPContentAssistant(sourceViewer);
                if (this.phpCompletionProcessor.getAssistant() != phpContentAssistant) {
                    this.phpCompletionProcessor = new PHPCompletionProcessor((IEditorPart)textEditor, phpContentAssistant, "org.eclipse.php.PHP_DEFAULT");
                }
            }
            if (partitionType == "org.eclipse.php.PHP_DEFAULT") {
                processors = new IContentAssistProcessor[]{this.phpCompletionProcessor};
            } else {
                IContentAssistProcessor[] superProcessors;
                if (partitionType.equals("org.eclipse.wst.css.STYLE") || partitionType.equals("org.eclipse.wst.css.COMMENT")) {
                    CSSStructuredContentAssistProcessor processor = new CSSStructuredContentAssistProcessor((ContentAssistant)this.getContentAssistant(), partitionType, (ITextViewer)sourceViewer);
                    superProcessors = new IContentAssistProcessor[]{processor};
                } else {
                    superProcessors = super.getContentAssistProcessors(sourceViewer, partitionType);
                }
                this.processorMap.put(partitionType, superProcessors);
                if (superProcessors != null) {
                    processors = new IContentAssistProcessor[superProcessors.length + 1];
                    System.arraycopy(superProcessors, 0, processors, 0, superProcessors.length);
                    processors[superProcessors.length] = this.phpCompletionProcessor;
                } else {
                    processors = new IContentAssistProcessor[]{this.phpCompletionProcessor};
                }
            }
        } else {
            processors = new IContentAssistProcessor[]{};
        }
        return processors;
    }

    public IContentAssistant getPHPContentAssistant(ISourceViewer sourceViewer) {
        return this.getPHPContentAssistant(sourceViewer, false);
    }

    public IContentAssistant getPHPContentAssistant(ISourceViewer sourceViewer, boolean reSet) {
        if (this.fContentAssistant == null || reSet) {
            if (this.fContentAssistant != null) {
                this.fContentAssistant.uninstall();
            }
            this.fContentAssistant = new PHPContentAssistant();
            this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            this.fContentAssistant.setProposalPopupOrientation(10);
            this.fContentAssistant.setContextInformationPopupOrientation(20);
            this.fContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            IDialogSettings dialogSettings = PHPUiPlugin.getDefault().getDialogSettings();
            if (dialogSettings != null) {
                IDialogSettings section = dialogSettings.getSection(COMPLETION_PROPOSAL_SIZE_SECTION);
                if (section == null) {
                    section = dialogSettings.addNewSection(COMPLETION_PROPOSAL_SIZE_SECTION);
                }
                this.fContentAssistant.setRestoreCompletionProposalSize(section);
            }
            IPreferencesService preferencesService = Platform.getPreferencesService();
            this.fContentAssistant.enableAutoActivation(preferencesService.getBoolean("org.eclipse.php.core", "contentAssistAutoactivation", false, null));
            this.fContentAssistant.setAutoActivationDelay(preferencesService.getInt("org.eclipse.php.core", "contentAssistAutoactivationDelay", 0, null));
            this.fContentAssistant.enableAutoInsert(preferencesService.getBoolean("org.eclipse.php.core", "contentAssistAutoinsert", false, null));
            this.addContentAssistProcessors(sourceViewer);
        }
        return this.fContentAssistant;
    }

    private void addContentAssistProcessors(ISourceViewer sourceViewer) {
        String[] types = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            IContentAssistProcessor[] processors = this.getContentAssistProcessors(sourceViewer, type);
            if (processors != null) {
                int j = 0;
                while (j < processors.length) {
                    this.fContentAssistant.setContentAssistProcessor(processors[j], type);
                    ++j;
                }
            }
            ++i;
        }
        IPreferencesService preferencesService = Platform.getPreferencesService();
        int fAutoActivationDelay = preferencesService.getInt("org.eclipse.php.core", "contentAssistAutoactivationDelay", 200, null);
        this.fContentAssistant.setAutoActivationDelay(fAutoActivationDelay);
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return DEFAULT_PREFIXES;
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        PHPEditorTextHoverDescriptor[] hoverDescs = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = hoverDescs[i].getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        if (!PHPStructuredTextPartitioner.isPHPPartitionType((String)contentType)) {
            return super.getTextHover(sourceViewer, contentType, stateMask);
        }
        if (sourceViewer instanceof PHPStructuredTextViewer) {
            PHPEditorTextHoverDescriptor[] hoverDescs = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
            int i = 0;
            while (i < hoverDescs.length) {
                if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                    return new PHPTextHoverProxy(hoverDescs[i], (IEditorPart)((PHPStructuredTextViewer)sourceViewer).getTextEditor(), this.fPreferenceStore);
                }
                ++i;
            }
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        LinkedList<2> detectors = new LinkedList<2>();
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (inheritedDetectors != null) {
            IHyperlinkDetector[] iHyperlinkDetectorArray = inheritedDetectors;
            int n = inheritedDetectors.length;
            int n2 = 0;
            while (n2 < n) {
                final IHyperlinkDetector detector = iHyperlinkDetectorArray[n2];
                detectors.add(new IHyperlinkDetector(){

                    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
                        try {
                            return detector.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
                        }
                        catch (Throwable e) {
                            PHPUiPlugin.log(e);
                            return null;
                        }
                    }
                });
                ++n2;
            }
        }
        return detectors.toArray(new IHyperlinkDetector[detectors.size()]);
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        if (sourceViewer instanceof PHPStructuredTextViewer) {
            ITextEditor textEditor = ((PHPStructuredTextViewer)sourceViewer).getTextEditor();
            targets.put("org.eclipse.php.core.phpsource", textEditor);
        }
        return targets;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter usedFormatter = null;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.ui.phpFormatterProcessor");
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("processor")) {
                ElementCreationProxy ecProxy = new ElementCreationProxy(element, "org.eclipse.php.ui.phpFormatterProcessor");
                usedFormatter = (IContentFormatter)ecProxy.getObject();
            }
            ++i;
        }
        if (usedFormatter == null) {
            usedFormatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "org.eclipse.wst.html.HTML_DEFAULT");
        }
        return usedFormatter;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("org.eclipse.php.PHP_DEFAULT")) {
            IAutoEditStrategy[] autoEditStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
            LinkedList<IAutoEditStrategy> strategies = new LinkedList<IAutoEditStrategy>();
            strategies.add(mainAutoEditStrategy);
            IAutoEditStrategy[] iAutoEditStrategyArray = autoEditStrategies;
            int n = autoEditStrategies.length;
            int n2 = 0;
            while (n2 < n) {
                IAutoEditStrategy strategy = iAutoEditStrategyArray[n2];
                if (!(strategy instanceof AutoEditStrategyForTabs) && strategy instanceof IAutoEditStrategy && !(strategy instanceof DefaultIndentLineAutoEditStrategy)) {
                    strategies.add(strategy);
                }
                ++n2;
            }
            return strategies.toArray(new IAutoEditStrategy[strategies.size()]);
        }
        return this.getPHPAutoEditStrategy(sourceViewer, contentType);
    }

    private final IAutoEditStrategy[] getPHPAutoEditStrategy(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] autoEditStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
        int length = autoEditStrategies.length;
        IAutoEditStrategy[] augAutoEditStrategies = new IAutoEditStrategy[length + 1];
        System.arraycopy(autoEditStrategies, 0, augAutoEditStrategies, 0, length);
        augAutoEditStrategies[length] = closeTagAutoEditStrategy;
        return augAutoEditStrategies;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (contentType == "org.eclipse.php.PHP_DEFAULT") {
            return new PHPDoubleClickStrategy();
        }
        return super.getDoubleClickStrategy(sourceViewer, contentType);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        IFormatterCommonPreferences formatterCommonPreferences = FormatterUtils.getFormatterCommonPreferences();
        char indentCharPref = formatterCommonPreferences.getIndentationChar(sourceViewer.getDocument());
        int indentationSize = formatterCommonPreferences.getIndentationSize(sourceViewer.getDocument());
        int i = 0;
        while (i <= indentationSize) {
            StringBuilder prefix = new StringBuilder();
            boolean appendTab = false;
            int j = 0;
            while (j + i < indentationSize) {
                prefix.append(indentCharPref);
                ++j;
            }
            if (i != 0) {
                appendTab = true;
            }
            if (appendTab) {
                prefix.append('\t');
                vector.add(prefix.toString());
                prefix.deleteCharAt(prefix.length() - 1);
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add(EMPTY);
        return vector.toArray(new String[vector.size()]);
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = null;
        if (sourceViewer instanceof PHPStructuredTextViewer) {
            presenter = new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.eclipse.dltk.ui.edit.text.script.show.outline"));
            presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
            PHPElementProvider provider = new PHPElementProvider((IEditorPart)((PHPStructuredTextViewer)sourceViewer).getTextEditor());
            presenter.setInformationProvider((IInformationProvider)provider, "org.eclipse.php.PHP_DEFAULT");
            presenter.setSizeConstraints(60, 20, true, false);
            IDialogSettings dialogSettings = PHPUiPlugin.getDefault().getDialogSettings();
            if (dialogSettings != null) {
                IDialogSettings section = dialogSettings.getSection(QUICK_OUTLINE_SIZE_SECTION);
                if (section == null) {
                    section = dialogSettings.addNewSection(QUICK_OUTLINE_SIZE_SECTION);
                }
                presenter.setRestoreInformationControlBounds(dialogSettings, true, true);
            }
        }
        return presenter;
    }

    public IInformationPresenter getHierarchyPresenter(PHPStructuredTextViewer viewer, boolean doCodeResolve) {
        if (viewer.getTextEditor() == null || viewer.getTextEditor().getEditorInput() == null) {
            return null;
        }
        InformationPresenter presenter = new InformationPresenter(this.getHierarchyPresenterControlCreator());
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning((ISourceViewer)viewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        PHPInformationHierarchyProvider provider = new PHPInformationHierarchyProvider((IEditorPart)viewer.getTextEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "org.eclipse.php.PHP_DEFAULT");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    private IInformationControlCreator getHierarchyPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new HierarchyInformationControl(parent, shellStyle, treeStyle){

                    protected IPreferenceStore getPreferenceStore() {
                        return PHPUiPlugin.getDefault().getPreferenceStore();
                    }
                };
            }
        };
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new PHPOutlineInformationControl(parent, shellStyle, treeStyle, commandId);
            }
        };
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (this.fQuickAssistant == null) {
            PHPCorrectionAssistant assistant = new PHPCorrectionAssistant();
            assistant.setQuickAssistProcessor((IQuickAssistProcessor)new CompoundQuickAssistProcessor());
            this.fQuickAssistant = assistant;
        }
        return this.fQuickAssistant;
    }

    public Map<String, IContentAssistProcessor[]> getProcessorMap() {
        return this.processorMap;
    }

    protected IInformationProvider getInformationProvider(ISourceViewer sourceViewer, String partitionType) {
        if (!(sourceViewer instanceof PHPStructuredTextViewer)) {
            return super.getInformationProvider(sourceViewer, partitionType);
        }
        BestMatchHover bestMatchHover = new BestMatchHover((IEditorPart)((PHPStructuredTextViewer)sourceViewer).getTextEditor(), PHPUiPlugin.getDefault().getPreferenceStore());
        return new TextHoverInformationProvider((ITextHover)bestMatchHover);
    }

    protected StructuredContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PHPStructuredPresentationReconciler reconciler = new PHPStructuredPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        if (contentTypes != null) {
            StructuredDocumentDamagerRepairer dr = null;
            int i = 0;
            while (i < contentTypes.length) {
                LineStyleProvider provider;
                if (this.fHighlighter != null && (provider = this.fHighlighter.getProvider(contentTypes[i])) != null) {
                    dr = new StructuredDocumentDamagerRepairer(provider);
                    dr.setDocument(sourceViewer.getDocument());
                    reconciler.setDamager((IPresentationDamager)dr, contentTypes[i]);
                    reconciler.setRepairer((IPresentationRepairer)dr, contentTypes[i]);
                }
                ++i;
            }
        }
        return reconciler;
    }

    public void setHighlighter(ReconcilerHighlighter highlighter) {
        this.fHighlighter = highlighter;
        super.setHighlighter(highlighter);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        if (sourceViewer instanceof PHPStructuredTextViewer) {
            ITextEditor editor = ((PHPStructuredTextViewer)sourceViewer).getTextEditor();
            if (editor == null) {
                return super.getTabWidth(sourceViewer);
            }
            IDocument document = this.getDocument(editor);
            if (document == null) {
                return super.getTabWidth(sourceViewer);
            }
            IFormatterCommonPreferences formatterCommonPreferences = FormatterUtils.getFormatterCommonPreferences();
            int tabSize = formatterCommonPreferences.getTabSize(document);
            return tabSize;
        }
        return super.getTabWidth(sourceViewer);
    }

    private IDocument getDocument(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        IDocumentProvider provider = editor.getDocumentProvider();
        return provider.getDocument((Object)input);
    }

    class TextHoverInformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private ITextHover fTextHover;

        public TextHoverInformationProvider(ITextHover hover) {
            this.fTextHover = hover;
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return (String)this.getInformation2(textViewer, subject);
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            if (this.fTextHover instanceof ITextHoverExtension2) {
                return ((ITextHoverExtension2)this.fTextHover).getHoverInfo2(textViewer, subject);
            }
            return this.fTextHover.getHoverInfo(textViewer, subject);
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            if (this.fTextHover instanceof IInformationProviderExtension2) {
                return ((IInformationProviderExtension2)this.fTextHover).getInformationPresenterControlCreator();
            }
            return null;
        }

        public IRegion getSubject(ITextViewer textViewer, int offset) {
            return this.fTextHover.getHoverRegion(textViewer, offset);
        }
    }
}

