/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.RemoteServicesUtils;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.jsch.core.Activator;
import org.eclipse.remote.internal.jsch.core.JSchConnection;
import org.eclipse.remote.internal.jsch.core.JSchFileSystem;
import org.eclipse.remote.internal.jsch.core.commands.ChildInfosCommand;
import org.eclipse.remote.internal.jsch.core.commands.DeleteCommand;
import org.eclipse.remote.internal.jsch.core.commands.FetchInfoCommand;
import org.eclipse.remote.internal.jsch.core.commands.GetInputStreamCommand;
import org.eclipse.remote.internal.jsch.core.commands.GetOutputStreamCommand;
import org.eclipse.remote.internal.jsch.core.commands.MkdirCommand;
import org.eclipse.remote.internal.jsch.core.commands.PutInfoCommand;
import org.eclipse.remote.internal.jsch.core.messages.Messages;

public class JschFileStore
extends FileStore {
    private static Map<String, JschFileStore> instanceMap = new HashMap<String, JschFileStore>();
    private final IPath fRemotePath;
    private final URI fURI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JschFileStore getInstance(URI uri) {
        Map<String, JschFileStore> map = instanceMap;
        synchronized (map) {
            JschFileStore store = instanceMap.get(uri.toString());
            if (store == null) {
                store = new JschFileStore(uri);
                instanceMap.put(uri.toString(), store);
            }
            return store;
        }
    }

    private JschFileStore(URI uri) {
        this.fURI = uri;
        this.fRemotePath = RemoteServicesUtils.posixPath((String)uri.getPath());
    }

    private JSchConnection checkConnection(IProgressMonitor monitor) throws RemoteConnectionException {
        IRemoteServicesManager manager = Activator.getService(IRemoteServicesManager.class);
        IRemoteConnectionType connectionType = manager.getConnectionType(this.fURI);
        if (connectionType == null) {
            throw new RemoteConnectionException(NLS.bind((String)Messages.JschFileStore_No_remote_services_found_for_URI, (Object)this.fURI));
        }
        try {
            IRemoteConnection connection = connectionType.getConnection(this.fURI);
            if (connection == null) {
                throw new RemoteConnectionException(NLS.bind((String)Messages.JschFileStore_Invalid_connection_for_URI, (Object)this.fURI));
            }
            if (!connection.isOpen()) {
                connection.open(monitor);
                if (!connection.isOpen()) {
                    throw new RemoteConnectionException(Messages.JschFileStore_Connection_is_not_open);
                }
            }
            return (JSchConnection)connection.getService(JSchConnection.class);
        }
        catch (CoreException e) {
            throw new RemoteConnectionException((Throwable)e);
        }
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        JSchConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        ChildInfosCommand command = new ChildInfosCommand(connection, this.fRemotePath);
        return command.getResult((IProgressMonitor)subMon.newChild(9));
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IFileInfo[] infos = this.childInfos(options, (IProgressMonitor)subMon.newChild(10));
        String[] names = new String[infos.length];
        int i = 0;
        while (i < infos.length) {
            names[i] = infos[i].getName();
            ++i;
        }
        return names;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        JSchConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        IFileInfo info = this.fetchInfo(0, (IProgressMonitor)subMon.newChild(9));
        if (!subMon.isCanceled() && info.exists()) {
            DeleteCommand command = new DeleteCommand(connection, this.fRemotePath);
            command.getResult((IProgressMonitor)subMon.newChild(10));
        }
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        JSchConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        FetchInfoCommand command = new FetchInfoCommand(connection, this.fRemotePath);
        return command.getResult((IProgressMonitor)subMon.newChild(9));
    }

    public IFileStore getChild(String name) {
        URI uri = JSchFileSystem.getURIFor(JSchFileSystem.getConnectionNameFor(this.fURI), this.fRemotePath.append(name).toString());
        return JschFileStore.getInstance(uri);
    }

    public String getName() {
        return this.getNameFromPath(this.fRemotePath);
    }

    private String getNameFromPath(IPath path) {
        if (path.isRoot()) {
            return path.toString();
        }
        return path.lastSegment();
    }

    public IFileStore getParent() {
        if (this.fRemotePath.isRoot()) {
            return null;
        }
        String parentPath = this.fRemotePath.toString();
        if (this.fRemotePath.segmentCount() > 0) {
            parentPath = this.fRemotePath.removeLastSegments(1).toString();
        }
        return JschFileStore.getInstance(JSchFileSystem.getURIFor(JSchFileSystem.getConnectionNameFor(this.fURI), parentPath));
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        JSchConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        if ((options & 4) == 4) {
            IFileStore parent = this.getParent();
            if (parent != null && !parent.fetchInfo(0, (IProgressMonitor)subMon.newChild(9)).exists()) {
                throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 272, NLS.bind((String)Messages.JschFileStore_The_parent_of_directory_does_not_exist, (Object)this.fRemotePath.toString()), null));
            }
            if (subMon.isCanceled()) {
                return this;
            }
        }
        try {
            MkdirCommand command = new MkdirCommand(connection, this.fRemotePath);
            command.getResult((IProgressMonitor)subMon.newChild(10));
        }
        catch (Exception exception) {}
        if (!subMon.isCanceled()) {
            IFileInfo info = this.fetchInfo(0, (IProgressMonitor)subMon.newChild(10));
            if (!subMon.isCanceled()) {
                if (!info.exists()) {
                    throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 272, NLS.bind((String)Messages.JschFileStore_The_directory_could_not_be_created, (Object)this.fRemotePath.toString()), null));
                }
                if (!info.isDirectory()) {
                    throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 276, NLS.bind((String)Messages.JschFileStore_A_file_of_name_already_exists, (Object)this.fRemotePath.toString()), null));
                }
            }
        }
        return this;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
        JSchConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        IFileInfo info = this.fetchInfo(0, (IProgressMonitor)subMon.newChild(9));
        if (!subMon.isCanceled()) {
            if (!info.exists()) {
                throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 271, NLS.bind((String)Messages.JschFileStore_File_doesnt_exist, (Object)this.fRemotePath.toString()), null));
            }
            if (info.isDirectory()) {
                throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 276, NLS.bind((String)Messages.JschFileStore_Is_a_directory, (Object)this.fRemotePath.toString()), null));
            }
            GetInputStreamCommand command = new GetInputStreamCommand(connection, this.fRemotePath);
            return command.getResult((IProgressMonitor)subMon.newChild(10));
        }
        return null;
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
        JSchConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        IFileInfo info = this.fetchInfo(0, (IProgressMonitor)subMon.newChild(9));
        if (!subMon.isCanceled()) {
            if (info.isDirectory()) {
                throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 276, NLS.bind((String)Messages.JschFileStore_Is_a_directory, (Object)this.fRemotePath.toString()), null));
            }
            GetOutputStreamCommand command = new GetOutputStreamCommand(connection, options, this.fRemotePath);
            return command.getResult((IProgressMonitor)subMon.newChild(10));
        }
        return null;
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        JSchConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        PutInfoCommand command = new PutInfoCommand(connection, info, options, this.fRemotePath);
        command.getResult((IProgressMonitor)subMon.newChild(9));
    }

    public URI toURI() {
        return this.fURI;
    }
}

