/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.doc.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.help.IHelpContentProducer;
import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.ConversionService;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Filter;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ExtensionsLocator;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.UrlResourceStore;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.sdk.extensibility.ExtensionSummaryExportOp;
import org.eclipse.sapphire.sdk.extensibility.ExtensionSummarySectionColumnDef;
import org.eclipse.sapphire.sdk.extensibility.ExtensionSummarySectionDef;
import org.eclipse.sapphire.sdk.extensibility.FunctionDef;
import org.eclipse.sapphire.sdk.extensibility.SapphireExtensionDef;
import org.eclipse.sapphire.sdk.extensibility.ServiceDef;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.ui.IExportModelDocumentationOp;
import org.eclipse.sapphire.ui.def.ActionDef;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.def.ActionHandlerFactoryDef;
import org.eclipse.sapphire.ui.def.ActionHandlerFilterDef;

public class DynamicContentProducer
implements IHelpContentProducer {
    private List<SapphireExtensionDef> extensions;

    public InputStream getInputStream(String pluginID, String href, Locale locale) {
        String content = null;
        if (pluginID.equals("org.eclipse.sapphire.doc")) {
            if (href.startsWith("html/extensions/existing.html")) {
                ExtensionSummaryExportOp op = (ExtensionSummaryExportOp)ExtensionSummaryExportOp.TYPE.instantiate();
                op.setDocumentBodyTitle("Sapphire Extensions");
                content = op.execute(this.getExtensions(), null);
            } else if (href.startsWith("html/el/index.html")) {
                ExtensionSummaryExportOp op = (ExtensionSummaryExportOp)ExtensionSummaryExportOp.TYPE.instantiate();
                op.setCreateFinishedDocument(Boolean.valueOf(false));
                ExtensionSummarySectionDef section = (ExtensionSummarySectionDef)op.getSections().insert();
                section.setExtensionType(SapphireExtensionDef.PROP_FUNCTIONS.name());
                section.setIncludeSectionHeader(Boolean.valueOf(false));
                ExtensionSummarySectionColumnDef nameColumn = (ExtensionSummarySectionColumnDef)section.getColumns().insert();
                nameColumn.setName(FunctionDef.PROP_NAME.name());
                ExtensionSummarySectionColumnDef descColumn = (ExtensionSummarySectionColumnDef)section.getColumns().insert();
                descColumn.setName(FunctionDef.PROP_DESCRIPTION.name());
                String functions = op.execute(this.getExtensions(), null);
                content = DynamicContentProducer.loadResource("html/el/index.html");
                content = content.replace("##functions##", functions);
            } else if (href.startsWith("html/services/ConversionService.html")) {
                ExtensionSummaryExportOp op = (ExtensionSummaryExportOp)ExtensionSummaryExportOp.TYPE.instantiate();
                op.setCreateFinishedDocument(Boolean.valueOf(false));
                ExtensionSummarySectionDef section = (ExtensionSummarySectionDef)op.getSections().insert();
                section.setExtensionType(SapphireExtensionDef.PROP_SERVICES.name());
                section.setIncludeSectionHeader(Boolean.valueOf(false));
                ExtensionSummarySectionColumnDef idColumn = (ExtensionSummarySectionColumnDef)section.getColumns().insert();
                idColumn.setName(ServiceDef.PROP_ID.name());
                ExtensionSummarySectionColumnDef descColumn = (ExtensionSummarySectionColumnDef)section.getColumns().insert();
                descColumn.setName(ServiceDef.PROP_DESCRIPTION.name());
                Filter<Element> filter = new Filter<Element>(){

                    public boolean allows(Element element) {
                        if (element instanceof ServiceDef) {
                            Class cl;
                            ServiceDef def = (ServiceDef)element;
                            String id = def.getId().text();
                            JavaType type = (JavaType)def.getImplementation().target();
                            Class clazz = cl = type == null ? null : (Class)type.artifact();
                            if (id != null && id.startsWith("Sapphire.") && cl != null && ConversionService.class.isAssignableFrom(cl)) {
                                return true;
                            }
                        }
                        return false;
                    }
                };
                String functions = op.execute(this.getExtensions(), (Filter)filter);
                content = DynamicContentProducer.loadResource("html/services/ConversionService.html");
                content = content.replace("##servicess##", functions);
            } else if (href.startsWith("html/services/FactsService.html")) {
                ExtensionSummaryExportOp op = (ExtensionSummaryExportOp)ExtensionSummaryExportOp.TYPE.instantiate();
                op.setCreateFinishedDocument(Boolean.valueOf(false));
                ExtensionSummarySectionDef section = (ExtensionSummarySectionDef)op.getSections().insert();
                section.setExtensionType(SapphireExtensionDef.PROP_SERVICES.name());
                section.setIncludeSectionHeader(Boolean.valueOf(false));
                ExtensionSummarySectionColumnDef idColumn = (ExtensionSummarySectionColumnDef)section.getColumns().insert();
                idColumn.setName(ServiceDef.PROP_ID.name());
                ExtensionSummarySectionColumnDef descColumn = (ExtensionSummarySectionColumnDef)section.getColumns().insert();
                descColumn.setName(ServiceDef.PROP_DESCRIPTION.name());
                Filter<Element> filter = new Filter<Element>(){

                    public boolean allows(Element element) {
                        if (element instanceof ServiceDef) {
                            Class cl;
                            ServiceDef def = (ServiceDef)element;
                            String id = def.getId().text();
                            JavaType type = (JavaType)def.getImplementation().target();
                            Class clazz = cl = type == null ? null : (Class)type.artifact();
                            if (id != null && id.startsWith("Sapphire.") && cl != null && FactsService.class.isAssignableFrom(cl)) {
                                return true;
                            }
                        }
                        return false;
                    }
                };
                String functions = op.execute(this.getExtensions(), (Filter)filter);
                content = DynamicContentProducer.loadResource("html/services/FactsService.html");
                content = content.replace("##servicess##", functions);
            } else if (href.startsWith("html/actions/index.html")) {
                content = DynamicContentProducer.loadResource("html/actions/index.html");
                String docAction = DynamicContentProducer.exportModelDocumentation(ActionDef.TYPE);
                content = content.replace("##action-details##", docAction);
                String docActionHandler = DynamicContentProducer.exportModelDocumentation(ActionHandlerDef.TYPE);
                content = content.replace("##action-handler-details##", docActionHandler);
                String docActionHandlerFactory = DynamicContentProducer.exportModelDocumentation(ActionHandlerFactoryDef.TYPE);
                content = content.replace("##action-handler-factory-details##", docActionHandlerFactory);
                String docActionHandlerFilter = DynamicContentProducer.exportModelDocumentation(ActionHandlerFilterDef.TYPE);
                content = content.replace("##action-handler-filter-details##", docActionHandlerFilter);
            }
        }
        if (content != null) {
            return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    private static String exportModelDocumentation(ElementType type) {
        IExportModelDocumentationOp op = (IExportModelDocumentationOp)IExportModelDocumentationOp.TYPE.instantiate();
        op.setCreateFinishedDocument(Boolean.valueOf(false));
        return op.execute(type, (IProgressMonitor)new NullProgressMonitor());
    }

    private static String loadResource(String name) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = DynamicContentProducer.class.getClassLoader().getResourceAsStream(name);){
                if (in == null) {
                    throw new IllegalArgumentException(name);
                }
                BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                char[] chars = new char[1024];
                StringBuilder buf = new StringBuilder();
                int i = r.read(chars);
                while (i != -1) {
                    buf.append(chars, 0, i);
                    i = r.read(chars);
                }
                return buf.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized List<SapphireExtensionDef> getExtensions() {
        if (this.extensions == null) {
            ArrayList<SapphireExtensionDef> list = new ArrayList<SapphireExtensionDef>();
            for (final ExtensionsLocator.Handle handle : ExtensionsLocator.instance().find()) {
                try {
                    UrlResourceStore store = new UrlResourceStore(handle.extension()){

                        public <A> A adapt(Class<A> adapterType) {
                            if (adapterType == Context.class) {
                                return adapterType.cast(handle.context());
                            }
                            return (A)super.adapt(adapterType);
                        }
                    };
                    XmlResourceStore xmlResourceStore = new XmlResourceStore((ByteArrayResourceStore)store);
                    RootXmlResource resource = new RootXmlResource(xmlResourceStore);
                    SapphireExtensionDef extension = (SapphireExtensionDef)SapphireExtensionDef.TYPE.instantiate((Resource)resource);
                    list.add(extension);
                }
                catch (ResourceStoreException e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
            }
            this.extensions = Collections.unmodifiableList(list);
        }
        return this.extensions;
    }
}

