/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.importexport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.importexport.AbstractImportExportWizard;
import org.eclipse.scout.sdk.s2e.nls.importexport.WizardExtension;
import org.osgi.framework.Bundle;

public final class NlsExportImportExtensionPoints {
    public static final String EXTENSION_POINT_ID_NLS_EXPORTER = "nlsExporter";
    public static final String EXTENSION_POINT_ID_NLS_IMPORTER = "nlsImporter";
    private static Map<String, List<WizardExtension>> extensions = null;

    private NlsExportImportExtensionPoints() {
    }

    private static synchronized Map<String, List<WizardExtension>> getExtensions() {
        if (extensions == null) {
            HashMap<String, List<WizardExtension>> tmp = new HashMap<String, List<WizardExtension>>(2);
            tmp.put(EXTENSION_POINT_ID_NLS_EXPORTER, NlsExportImportExtensionPoints.loadExtensionPoints(EXTENSION_POINT_ID_NLS_EXPORTER));
            tmp.put(EXTENSION_POINT_ID_NLS_IMPORTER, NlsExportImportExtensionPoints.loadExtensionPoints(EXTENSION_POINT_ID_NLS_IMPORTER));
            extensions = tmp;
        }
        return extensions;
    }

    private static List<WizardExtension> loadExtensionPoints(String id) {
        IExtension[] exts;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        ArrayList<WizardExtension> wizardExtensions = new ArrayList<WizardExtension>();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.s2e.nls", id);
        IExtension[] iExtensionArray = exts = xp.getExtensions();
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    WizardExtension wizardExt = new WizardExtension();
                    String attWizard = element.getAttribute("wizard");
                    if (attWizard != null && attWizard.length() > 0) {
                        Bundle contributerBundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
                        Class wizard = contributerBundle.loadClass(attWizard);
                        if (!AbstractImportExportWizard.class.isAssignableFrom(wizard)) {
                            SdkLog.error((String)"extension '{}' has a wizard not instance of '{}'. Ignoring extension.", (Object[])new Object[]{extension.getExtensionPointUniqueIdentifier(), AbstractImportExportWizard.class.getName()});
                        } else {
                            wizardExt.setWizard(wizard);
                            String attName = element.getAttribute("name");
                            if (attName != null && attName.length() > 0) {
                                wizardExt.setName(attName);
                                wizardExtensions.add(wizardExt);
                            }
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    SdkLog.error((String)"could not create an executable extension of point '{}'.", (Object[])new Object[]{extension.getExtensionPointUniqueIdentifier(), e});
                }
                ++n4;
            }
            ++n2;
        }
        return new ArrayList<WizardExtension>(wizardExtensions);
    }

    public static List<WizardExtension> getExtensions(String extensionPointId) {
        return new ArrayList<WizardExtension>((Collection)NlsExportImportExtensionPoints.getExtensions().get(extensionPointId));
    }
}

