/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.wizard;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.common.ui.Messages;
import org.eclipse.sirius.common.ui.tools.api.wizard.CheckboxTreeAndListGroup;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.osgi.framework.Bundle;

public class SelectFilesWizardPage
extends WizardPage {
    private static final String JOKER = "*";
    private static final int SELECTION_WIDGET_WIDTH = 400;
    private static final int SELECTION_WIDGET_HEIGHT = 300;
    private CheckboxTreeAndListGroup checkboxGroup;
    private int lower;
    private int upper;
    private String[] extensions;
    private IResource initialResourceSelection;

    public SelectFilesWizardPage(String pageName, int lower, int upper, String[] extensions) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.SelectFilesWizardPage_title);
        this.lower = lower;
        this.upper = upper;
        this.extensions = extensions;
    }

    public void setInitialSelection(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof IResource) {
            this.initialResourceSelection = (IResource)element;
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout();
        containerLayout.numColumns = 1;
        containerLayout.marginTop = 14;
        containerLayout.verticalSpacing = 9;
        containerLayout.marginLeft = 7;
        containerLayout.marginRight = 7;
        container.setLayout((Layout)containerLayout);
        WorkbenchLabelProvider treeLabelProvider = new WorkbenchLabelProvider();
        WorkbenchLabelProvider listLabelProvider = new WorkbenchLabelProvider();
        this.checkboxGroup = new CheckboxTreeAndListGroup(container, ResourcesPlugin.getWorkspace().getRoot(), this.getContentProvider(14), (ILabelProvider)treeLabelProvider, (IStructuredContentProvider)this.getContentProvider(1), (ILabelProvider)listLabelProvider, 0, 400, 300);
        this.checkboxGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SelectFilesWizardPage.this.dialogChanged();
            }
        });
        this.checkboxGroup.getTreeViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && selection instanceof StructuredSelection) {
                    SelectFilesWizardPage.this.checkboxGroup.getTreeViewer().expandToLevel(((StructuredSelection)selection).getFirstElement(), -1);
                }
            }
        });
        if (this.initialResourceSelection != null) {
            this.checkboxGroup.initialCheckListItem(this.initialResourceSelection);
        }
        container.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TableColumn[] columns;
                TableColumn[] tableColumnArray = columns = SelectFilesWizardPage.this.checkboxGroup.getListTable().getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    column.pack();
                    ++n2;
                }
            }
        });
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private ITreeContentProvider getContentProvider(final int resourceType) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (resourceType != 1 && o instanceof IExtensionRegistry) {
                    TreeSet<Bundle> result = new TreeSet<Bundle>(new Comparator<Bundle>(){

                        @Override
                        public int compare(Bundle bundle0, Bundle bundle1) {
                            return bundle0.getSymbolicName().compareTo(bundle1.getSymbolicName());
                        }
                    });
                    return result.toArray();
                }
                if (resourceType == 1 && o instanceof Bundle) {
                    Bundle bundle = (Bundle)o;
                    ArrayList<IPath> result = new ArrayList<IPath>();
                    String[] stringArray = SelectFilesWizardPage.this.extensions;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child;
                        Enumeration enumeration;
                        String extension = stringArray[n2];
                        if (SelectFilesWizardPage.JOKER.equals(extension)) {
                            result.clear();
                            enumeration = bundle.findEntries("/", SelectFilesWizardPage.JOKER, true);
                            while (enumeration != null && enumeration.hasMoreElements()) {
                                child = enumeration.nextElement();
                                if (!(child instanceof URL)) continue;
                                result.add(new Path(bundle.getSymbolicName()).append(((URL)child).getPath()));
                            }
                            break;
                        }
                        enumeration = bundle.findEntries("/", "*." + extension, true);
                        while (enumeration != null && enumeration.hasMoreElements()) {
                            child = enumeration.nextElement();
                            if (!(child instanceof URL)) continue;
                            result.add(new Path(bundle.getSymbolicName()).append(((URL)child).getPath()));
                        }
                        ++n2;
                    }
                    return result.toArray();
                }
                if (resourceType == 1 && o instanceof IPath) {
                    return new Object[0];
                }
                if (o instanceof IContainer) {
                    IResource[] members = null;
                    try {
                        members = ((IContainer)o).members();
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    ArrayList<IResource> results = new ArrayList<IResource>();
                    IResource[] iResourceArray = members;
                    int n = members.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IResource member = iResourceArray[n3];
                        if ((member.getType() & resourceType) > 0 && SelectFilesWizardPage.this.isSignificant(member)) {
                            if (member instanceof IFile) {
                                String extension = member.getFileExtension();
                                if (extension == null) {
                                    extension = "";
                                }
                                String[] stringArray = SelectFilesWizardPage.this.extensions;
                                int n4 = stringArray.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    String extension2 = stringArray[n5];
                                    if (SelectFilesWizardPage.JOKER.equals(extension2) || extension.equals(extension2)) {
                                        results.add(member);
                                        break;
                                    }
                                    ++n5;
                                }
                            } else if (member instanceof IContainer && SelectFilesWizardPage.this.countMembers((IContainer)member) > 0) {
                                results.add(member);
                            }
                        }
                        ++n3;
                    }
                    return results.toArray();
                }
                if (o instanceof List) {
                    ArrayList result = Lists.newArrayList();
                    for (Object element : (List)o) {
                        if (element instanceof IContainer) {
                            if (!((IContainer)element).isAccessible() || SelectFilesWizardPage.this.countMembers((IContainer)element) <= 0) continue;
                            result.add(element);
                            continue;
                        }
                        result.add(element);
                    }
                    return result.toArray();
                }
                return new Object[0];
            }
        };
    }

    private int countMembers(IContainer container) {
        try {
            IResource[] members = container.members();
            int result = 0;
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (this.isSignificant(member)) {
                    if (member instanceof IFile) {
                        String extension = member.getFileExtension();
                        if (extension == null) {
                            extension = "";
                        }
                        String[] stringArray = this.extensions;
                        int n3 = this.extensions.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String extension2 = stringArray[n4];
                            if (JOKER.equals(extension2) || extension.equals(extension2)) {
                                ++result;
                                break;
                            }
                            ++n4;
                        }
                    } else if (member instanceof IContainer) {
                        result += this.countMembers((IContainer)member);
                    }
                }
                ++n2;
            }
            return result;
        }
        catch (CoreException coreException) {
            return 0;
        }
    }

    private boolean isSignificant(IResource resource) {
        return !(resource instanceof IFolder) || !resource.getName().startsWith(".");
    }

    private void dialogChanged() {
        List<IPath> items = this.getAllCheckedListItems();
        if (items.size() < this.lower) {
            this.updateStatus(Messages.SelectFilesWizardPage_notEnoughFiles);
            return;
        }
        if (items.size() > this.upper && this.upper != -1) {
            this.updateStatus(Messages.SelectFilesWizardPage_tooManyFiles);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setMessage(message);
        this.setPageComplete(message == null);
    }

    public IPath[] getSelection() {
        List<IPath> items = this.getAllCheckedListItems();
        return items.toArray(new IPath[items.size()]);
    }

    private List<IPath> getAllCheckedListItems() {
        ArrayList<IPath> items = new ArrayList<IPath>();
        Iterator resultEnum = this.checkboxGroup.getAllCheckedListItems();
        while (resultEnum.hasNext()) {
            Object member = resultEnum.next();
            if (member instanceof IFile) {
                items.add(((IFile)member).getFullPath());
                continue;
            }
            if (!(member instanceof IPath)) continue;
            items.add((IPath)member);
        }
        return items;
    }
}

