/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.print;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.PageBreakEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.printpreview.RenderedPrintPreviewHelper;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.part.DiagramEditPartService;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class SiriusDiagramPrintPreviewHelper
extends RenderedPrintPreviewHelper {
    private Shell vpTempShell;

    protected DiagramEditPart getDiagramEditPart() {
        Diagram diagram;
        if (this.diagramEditPart == null && this.getDiagramEditorPart() != null && (diagram = this.getDiagramEditorPart().getDiagram()) != null) {
            PreferencesHint preferencesHint = this.getPreferencesHint((IEditorPart)this.getDiagramEditorPart());
            DiagramEditPartService tool = new DiagramEditPartService();
            this.diagramEditPart = tool.createDiagramEditPart(diagram, this.getVpTempShell(), preferencesHint);
            SiriusDiagramPrintPreviewHelper.initializePreferences(this.diagramEditPart, preferencesHint);
        }
        return super.getDiagramEditPart();
    }

    private Shell getVpTempShell() {
        if (this.vpTempShell == null) {
            this.vpTempShell = new Shell();
        }
        return this.vpTempShell;
    }

    protected void dispose() {
        this.vpTempShell.dispose();
        this.vpTempShell = null;
        super.dispose();
    }

    private DiagramEditor getDiagramEditorPart() {
        IEditorPart editorPart = EclipseUIUtil.getActiveEditor();
        if (editorPart instanceof SiriusDiagramEditor) {
            return (SiriusDiagramEditor)editorPart;
        }
        return null;
    }

    public static boolean initializePreferences(DiagramEditPart diagramEditPart, PreferencesHint preferencesHint) {
        assert (diagramEditPart.getViewer() instanceof DiagramGraphicalViewer);
        DiagramGraphicalViewer viewer = (DiagramGraphicalViewer)diagramEditPart.getViewer();
        boolean loadedPreferences = true;
        IPreferenceStore fPreferences = SiriusDiagramPrintPreviewHelper.getPreferenceStoreForDiagram(diagramEditPart);
        if (fPreferences == null) {
            loadedPreferences = false;
            PreferenceStore defaults = new PreferenceStore();
            DiagramEditor.addDefaultPreferences((PreferenceStore)defaults, (PreferencesHint)preferencesHint);
            fPreferences = SiriusDiagramPrintPreviewHelper.getWorkspacePreferenceStore(preferencesHint);
        } else if (!fPreferences.getBoolean("print.useDiagramSettings")) {
            int x = fPreferences.getInt("pagebreak.x");
            int y = fPreferences.getInt("pagebreak.y");
            fPreferences = SiriusDiagramPrintPreviewHelper.getWorkspacePreferenceStore(preferencesHint);
            fPreferences.setValue("pagebreak.x", x);
            fPreferences.setValue("pagebreak.y", y);
        }
        viewer.hookWorkspacePreferenceStore(fPreferences);
        diagramEditPart.refreshPageBreaks();
        return loadedPreferences;
    }

    private static IPreferenceStore getPreferenceStoreForDiagram(DiagramEditPart diagramEP) {
        String id = ViewUtil.getIdStr((View)diagramEP.getDiagramView());
        IPreferenceStore fPreferences = SiriusDiagramPrintPreviewHelper.loadPreferencesFromOpenDiagram(id);
        if (fPreferences != null) {
            return fPreferences;
        }
        IPath path = DiagramUIPlugin.getInstance().getStateLocation();
        String fileName = String.valueOf(path.toString()) + "/" + id;
        File file = new File(fileName);
        fPreferences = new PreferenceStore(fileName);
        if (file.exists()) {
            try {
                ((PreferenceStore)fPreferences).load();
                return fPreferences;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private static IPreferenceStore getWorkspacePreferenceStore(PreferencesHint preferencesHint) {
        return (IPreferenceStore)preferencesHint.getPreferenceStore();
    }

    private static IPreferenceStore loadPreferencesFromOpenDiagram(String id) {
        List diagramEditors = EditorService.getInstance().getRegisteredEditorParts();
        for (Object obj : diagramEditors) {
            DiagramEditor diagramEditor;
            if (!(obj instanceof DiagramEditor) || !id.equals(ViewUtil.getIdStr((View)(diagramEditor = (DiagramEditor)obj).getDiagramEditPart().getDiagramView()))) continue;
            IDiagramGraphicalViewer viewer = diagramEditor.getDiagramGraphicalViewer();
            if (diagramEditor.getDiagramEditPart().getRoot() instanceof DiagramRootEditPart) {
                PageBreakEditPart pageBreakEditPart = ((DiagramRootEditPart)diagramEditor.getDiagramEditPart().getRoot()).getPageBreakEditPart();
                pageBreakEditPart.resize(diagramEditor.getDiagramEditPart().getChildrenBounds());
                pageBreakEditPart.updatePreferenceStore();
            }
            if (viewer instanceof DiagramGraphicalViewer) {
                DiagramGraphicalViewer diagramGraphicalViewer = (DiagramGraphicalViewer)viewer;
                return diagramGraphicalViewer.getWorkspaceViewerPreferenceStore();
            }
            return null;
        }
        return null;
    }
}

