/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSSubscriberMergeContext;
import org.eclipse.team.internal.ui.Utils;

public class MergeSubscriberContext
extends CVSSubscriberMergeContext {
    private boolean cancel = true;

    public static MergeSubscriberContext createContext(ISynchronizationScopeManager manager, Subscriber subscriber) {
        MergeSubscriberContext mergeContext = new MergeSubscriberContext(subscriber, manager);
        mergeContext.initialize();
        return mergeContext;
    }

    public MergeSubscriberContext(Subscriber subscriber, ISynchronizationScopeManager manager) {
        super(subscriber, manager);
    }

    public void markAsMerged(final IDiff diff, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        this.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ((CVSMergeSubscriber)MergeSubscriberContext.this.getSubscriber()).merged(new IResource[]{MergeSubscriberContext.this.getDiffTree().getResource(diff)});
            }
        }, this.getMergeRule(diff), 0, monitor);
    }

    public void markAsMerged(final IDiff[] diffs, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        this.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ArrayList<IResource> result = new ArrayList<IResource>();
                int i = 0;
                while (i < diffs.length) {
                    IDiff diff = diffs[i];
                    result.add(MergeSubscriberContext.this.getDiffTree().getResource(diff));
                    ++i;
                }
                ((CVSMergeSubscriber)MergeSubscriberContext.this.getSubscriber()).merged(result.toArray(new IResource[result.size()]));
            }
        }, this.getMergeRule(diffs), 0, monitor);
    }

    public void dispose() {
        if (this.cancel) {
            ((CVSMergeSubscriber)this.getSubscriber()).cancel();
        }
        super.dispose();
    }

    public void setCancelSubscriber(boolean b) {
        this.cancel = b;
    }

    public IStatus merge(final IDiff diff, final boolean ignoreLocalChanges, IProgressMonitor monitor) throws CoreException {
        final IStatus[] status = new IStatus[]{Status.OK_STATUS};
        this.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IThreeWayDiff twd;
                IResource resource;
                IThreeWayDiff currentDiff = (IThreeWayDiff)MergeSubscriberContext.this.getSubscriber().getDiff(MergeSubscriberContext.this.getDiffTree().getResource(diff));
                if (!MergeSubscriberContext.this.equals(currentDiff, (IThreeWayDiff)diff)) {
                    throw new CVSException(NLS.bind((String)CVSUIMessages.CVSMergeContext_1, (Object)diff.getPath()));
                }
                status[0] = MergeSubscriberContext.super.merge(diff, ignoreLocalChanges, monitor);
                if (status[0].isOK() && (resource = ResourceDiffTree.getResourceFor((IDiff)diff)).getType() == 1 && resource.exists() && diff instanceof IThreeWayDiff && (twd = (IThreeWayDiff)diff).getKind() == 1 && twd.getDirection() == 512) {
                    IFileRevision remote = Utils.getRemote((IDiff)diff);
                    IResourceVariant variant = (IResourceVariant)Adapters.adapt((Object)remote, IResourceVariant.class);
                    byte[] syncBytes = variant.asBytes();
                    MutableResourceSyncInfo info = new MutableResourceSyncInfo(resource.getName(), "0");
                    info.setKeywordMode(ResourceSyncInfo.getKeywordMode((byte[])syncBytes));
                    info.setTag(MergeSubscriberContext.this.getTag(resource.getParent()));
                    CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource)).setSyncInfo((ResourceSyncInfo)info, 2);
                }
            }
        }, this.getMergeRule(diff), 1, monitor);
        return status[0];
    }

    CVSTag getTag(IContainer parent) throws CVSException {
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)parent);
        FolderSyncInfo info = folder.getFolderSyncInfo();
        if (info != null) {
            return info.getTag();
        }
        return null;
    }

    boolean equals(IThreeWayDiff currentDiff, IThreeWayDiff diffTreeDiff) {
        return currentDiff != null && currentDiff.getKind() == diffTreeDiff.getKind() && currentDiff.getDirection() == diffTreeDiff.getDirection();
    }
}

