/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.extension.impl;

import java.util.HashMap;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.LocateProjectsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.remote.CheckoutAction;
import org.eclipse.team.svn.ui.extension.factory.ICheckoutFactory;

public class DefaultCheckoutFactory
implements ICheckoutFactory {
    public LocateProjectsOperation.ILocateFilter getLocateFilter() {
        return new EclipseProjectsFilter();
    }

    public IActionOperation getCheckoutOperation(Shell shell, IRepositoryResource[] remote, HashMap checkoutMap, boolean respectHierarchy, String location, SVNDepth recurseDepth, boolean ignoreExternals) {
        return CheckoutAction.getCheckoutOperation(shell, remote, checkoutMap, respectHierarchy, location, recurseDepth, ignoreExternals);
    }

    public ITableLabelProvider getLabelProvider(HashMap resources2names) {
        return new LabelProvider(resources2names);
    }

    public IRepositoryResourceProvider additionalProcessing(CompositeOperation op, IRepositoryResourceProvider provider) {
        return provider;
    }

    public HashMap prepareName2resources(HashMap name2resources) {
        return name2resources;
    }

    public boolean findProjectsOptionEnabled() {
        return false;
    }

    protected class EclipseProjectsFilter
    implements LocateProjectsOperation.ILocateFilter {
        protected EclipseProjectsFilter() {
        }

        public boolean isProject(IRepositoryResource remote, IRepositoryResource[] children) {
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IRepositoryFile && children[i].getName().equals(".project")) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    protected class LabelProvider
    implements ITableLabelProvider {
        protected HashMap resources2names;

        public LabelProvider(HashMap resources2names) {
            this.resources2names = resources2names;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public String getColumnText(Object element, int columnIndex) {
            IRepositoryResource resource = (IRepositoryResource)element;
            switch (columnIndex) {
                case 1: {
                    return resource.getUrl();
                }
                case 2: {
                    return FileUtility.formatResourceName((String)((String)this.resources2names.get(resource)));
                }
                case 3: {
                    return SVNUIMessages.DefaultCheckoutFactory_EclipseProject;
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

