/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.update.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.ClearLocalStatusesOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.ResourcesTraversalOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.RevertOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.UpdateOperation;
import org.eclipse.team.svn.core.operation.local.change.IResourceChangeVisitor;
import org.eclipse.team.svn.core.operation.local.change.visitors.RemoveNonVersionedVisitor;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.ClearUpdateStatusesOperation;
import org.eclipse.team.svn.ui.panel.local.OverrideResourcesPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.eclipse.team.svn.ui.synchronize.update.action.UpdateAction;
import org.eclipse.team.svn.ui.utility.UnacceptableOperationNotificator;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class OverrideAndUpdateAction
extends AbstractSynchronizeModelAction {
    public OverrideAndUpdateAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4, 8, 12});
    }

    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        OverrideResourcesPanel panel;
        IResource[][] resources = new IResource[1][];
        IResource[] obstructedResources = this.syncInfoSelector.getSelectedResourcesRecursive(IStateFilter.SF_OBSTRUCTED);
        obstructedResources = FileUtility.addOperableParents((IResource[])obstructedResources, (IStateFilter)IStateFilter.SF_OBSTRUCTED);
        HashSet<IResource> allResources = new HashSet<IResource>(Arrays.asList(obstructedResources));
        IResource[] changedResources = this.syncInfoSelector.getSelectedResourcesRecursive(ISyncStateFilter.SF_OVERRIDE);
        changedResources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(configuration.getSite().getShell(), changedResources);
        ArrayList<IResource> affected = new ArrayList<IResource>();
        if (changedResources != null) {
            IResource[] changedWithOperableParents = FileUtility.addOperableParents((IResource[])changedResources, (IStateFilter)IStateFilter.SF_NOTONREPOSITORY);
            ArrayList<IResource> changedList = new ArrayList<IResource>(Arrays.asList(changedResources));
            IResource[] iResourceArray = changedWithOperableParents;
            int n = changedWithOperableParents.length;
            int n2 = 0;
            while (n2 < n) {
                IResource current = iResourceArray[n2];
                if (!changedList.contains(current)) {
                    IResource[] currentAffectedArray;
                    changedList.add(current);
                    IResource[] iResourceArray2 = currentAffectedArray = FileUtility.getResourcesRecursive((IResource[])new IResource[]{current}, (IStateFilter)IStateFilter.SF_ANY_CHANGE);
                    int n3 = currentAffectedArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource currentAffected = iResourceArray2[n4];
                        if (!changedList.contains(currentAffected)) {
                            affected.add(currentAffected);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            changedResources = changedWithOperableParents;
            allResources.addAll(Arrays.asList(changedResources));
        }
        if (allResources.size() > 0) {
            IResource[] fullSet = allResources.toArray(new IResource[allResources.size()]);
            panel = new OverrideResourcesPanel(fullSet, fullSet, 1, affected.toArray(new IResource[affected.size()]));
            DefaultDialog dialog = new DefaultDialog(configuration.getSite().getShell(), panel);
            if (dialog.open() != 0) {
                return null;
            }
        } else {
            return null;
        }
        resources[0] = panel.getSelectedResources();
        CompositeOperation op = new CompositeOperation("Operation_UOverrideAndUpdate", SVNUIMessages.class);
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources[0]);
        op.add((IActionOperation)saveOp);
        ResourcesTraversalOperation removeNonVersionedResourcesOp = new ResourcesTraversalOperation("Operation_RemoveNonSVN", SVNMessages.class, resources[0], (IResourceChangeVisitor)new RemoveNonVersionedVisitor(true), 2);
        op.add((IActionOperation)removeNonVersionedResourcesOp);
        RevertOperation revertOp = new RevertOperation(FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)IStateFilter.SF_REVERTABLE, (int)0), true);
        op.add((IActionOperation)revertOp);
        op.add((IActionOperation)new ClearLocalStatusesOperation(resources[0]));
        RevertOperation revertOp1 = new RevertOperation(FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)IStateFilter.SF_OBSTRUCTED, (int)0), true);
        op.add((IActionOperation)revertOp1);
        op.add((IActionOperation)new ClearLocalStatusesOperation(resources[0]));
        Map<SVNRevision, Set<IResource>> splitted = UpdateAction.splitByPegRevision(this, resources[0]);
        for (Map.Entry<SVNRevision, Set<IResource>> entry : splitted.entrySet()) {
            final IResource[] toUpdate = entry.getValue().toArray(new IResource[0]);
            boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
            UpdateOperation mainOp = new UpdateOperation(new IResourceProvider(){

                public IResource[] getResources() {
                    return FileUtility.getResourcesRecursive((IResource[])toUpdate, (IStateFilter)new IStateFilter.AbstractStateFilter(){

                        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
                            return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) || IStateFilter.SF_NOTEXISTS.accept(resource, state, mask);
                        }

                        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
                            return true;
                        }
                    }, (int)0);
                }
            }, entry.getKey(), ignoreExternals);
            op.add((IActionOperation)mainOp, new IActionOperation[]{revertOp, revertOp1, removeNonVersionedResourcesOp});
            op.add((IActionOperation)new ClearUpdateStatusesOperation((IResourceProvider)mainOp), new IActionOperation[]{mainOp});
        }
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new RefreshResourcesOperation(resources[0]));
        return op;
    }
}

