/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.tracecompass.tmf.ui.project.wizards.Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class CopyTraceDialog
extends SelectionStatusDialog {
    private final TmfTraceElement fTrace;
    private Text fNewTraceName;
    private final IFolder fTraceFolder;

    public CopyTraceDialog(Shell shell, TmfTraceElement trace) {
        super(shell);
        this.fTrace = trace;
        TmfTraceFolder folder = (TmfTraceFolder)trace.getParent();
        this.fTraceFolder = folder.getResource();
        this.setTitle(Messages.CopyTraceDialog_DialogTitle);
        this.setStatusLineAboveButtons(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createNewTraceNameGroup(composite);
        return composite;
    }

    private void createNewTraceNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite folderGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        folderGroup.setLayout((Layout)layout);
        folderGroup.setLayoutData((Object)new GridData(768));
        String name = this.fTrace.getName();
        Label newTraceLabel = new Label(folderGroup, 0);
        newTraceLabel.setFont(font);
        newTraceLabel.setText(Messages.CopyTraceDialog_TraceNewName);
        this.fNewTraceName = new Text(folderGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fNewTraceName.setLayoutData((Object)data);
        this.fNewTraceName.setFont(font);
        this.fNewTraceName.setFocus();
        this.fNewTraceName.setText(name);
        this.fNewTraceName.setSelection(0, name.length());
        this.fNewTraceName.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CopyTraceDialog.this.validateNewTraceName();
            }
        });
    }

    private void validateNewTraceName() {
        String name = this.fNewTraceName.getText();
        IWorkspace workspace = this.fTraceFolder.getWorkspace();
        IStatus nameStatus = workspace.validateName(name, 2);
        if ("".equals(name)) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, Messages.Dialog_EmptyNameError, null));
            return;
        }
        if (!nameStatus.isOK()) {
            this.updateStatus(nameStatus);
            return;
        }
        Path path = new Path(name);
        if (this.fTraceFolder.getFolder((IPath)path).exists() || this.fTraceFolder.getFile((IPath)path).exists()) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, Messages.Dialog_ExistingNameError, null));
            return;
        }
        this.updateStatus((IStatus)new Status(0, "org.eclipse.tracecompass.tmf.ui", ""));
    }

    protected void computeResult() {
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        IResource trace = this.copyTrace(this.fNewTraceName.getText());
        if (trace == null) {
            return;
        }
        this.setSelectionResult(new IResource[]{trace});
        super.okPressed();
    }

    private IResource copyTrace(final String newName) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask("", 1000);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    CopyTraceDialog.this.fTrace.copy(newName, true);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InterruptedException exception) {
            return null;
        }
        catch (InvocationTargetException exception) {
            TraceUtils.displayErrorMsg("", NLS.bind((String)"", (Object)exception.getTargetException().getMessage()));
            return null;
        }
        catch (RuntimeException exception) {
            return null;
        }
        return this.fTrace.getResource();
    }
}

